/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.plan;

import com.intellij.database.dialects.base.plan.AbstractXmlPlanModelBuilder;
import com.intellij.database.dialects.sybase.plan.AseRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JavaXmlDocumentKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.CharSequenceSubSequence;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AsePlanModelBuilder
extends AbstractXmlPlanModelBuilder<AseRawPlanData, Element> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private final XPathExpression INDID_QUERY = this.compileXPath("Details/Indid");
    private final XPathExpression PLAN_ROWS_QUERY = this.compileXPath("est/rowCnt");
    private final XPathExpression ACT_ROWS_QUERY = this.compileXPath("act/rowCnt");
    private final XPathExpression DETAILS_QUERY = this.compileXPath("Details");
    private final XPathExpression OBJ_NAME_QUERY = this.compileXPath("objName");
    private final XPathExpression IND_NAME_QUERY = this.compileXPath("indName");
    private final XPathExpression ACT_EMIT_QUERY = this.compileXPath("/query/opTree/Emit");
    private static final Set<String> NONE_OP = Set.of("Details", "VA");
    private static final Set<String> HANDLED_KEYS = Set.of("rowCnt", "objName", "indName", "Vtuple", "Collection");
    private final Pattern RELATION_PATTERN = Pattern.compile(".*:(.*)");
    private final Pattern INDEX_PATTERN = Pattern.compile(".*\\((.*)\\)");

    public AsePlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.TOTAL_COST, PlanModel.Feature.STARTUP_COST));
    }

    @Override
    @NotNull
    public AseRawPlanData createData() {
        return new AseRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseXml(((AseRawPlanData)this.myData).xml);
    }

    private void parseXml(@NotNull String xml) {
        if (xml == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(0);
        }
        try {
            DocumentBuilder builder = JavaXmlDocumentKt.createDocumentBuilder();
            this.openNode(null);
            int from = 0;
            while (from < xml.length()) {
                int end = xml.indexOf("<?xml", from + 1);
                if (end == -1) {
                    end = xml.length();
                }
                Document doc = builder.parse(new InputSource((Reader)new CharSequenceReader((CharSequence)new CharSequenceSubSequence((CharSequence)xml, from, end))));
                this.parseStatement(doc.getDocumentElement());
                from = end;
            }
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (IOException | SAXException e2) {
            throw new PlanRetrievalException("Failed to parse XML", e2);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(final @NotNull Element element2) {
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(1);
        }
        String string = new Object(){
            final StringBuilder sb = new StringBuilder();
            {
                Element details;
                Element element3 = details = AsePlanModelBuilder.this.myActual ? element2 : AsePlanModelBuilder.queryElement(AsePlanModelBuilder.this.DETAILS_QUERY, element2);
                if (details != null) {
                    this.visit("", details);
                }
            }

            void visit(String prefix, Element el) {
                if (!prefix.isEmpty()) {
                    StringBuilder sub = new StringBuilder();
                    for (int i2 = 0; i2 < el.getChildNodes().getLength(); ++i2) {
                        String s2;
                        Text child = (Text)ObjectUtils.tryCast((Object)el.getChildNodes().item(i2), Text.class);
                        if (child == null || child.getNodeValue() == null || StringUtil.isEmpty((String)(s2 = child.getNodeValue().trim()))) continue;
                        sub.append(s2);
                    }
                    if (!sub.isEmpty()) {
                        this.sb.append(prefix).append(" = ").append((CharSequence)sub).append(";\n");
                    }
                }
                for (int i3 = 0; i3 < el.getChildNodes().getLength(); ++i3) {
                    String name2;
                    Element child = (Element)ObjectUtils.tryCast((Object)el.getChildNodes().item(i3), Element.class);
                    String string = name2 = child == null ? null : child.getTagName();
                    if (name2 == null || AsePlanModelBuilder.this.myActual && AsePlanModelBuilder.isSubPlan(child) || HANDLED_KEYS.contains(name2)) continue;
                    this.visit(prefix + (prefix.isEmpty() ? "" : ".") + name2, child);
                }
            }
        }.sb.toString();
        if (string == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Element element2) {
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(3);
        }
        if (this.myActual) {
            Element name2 = this.querySingleElement(this.OBJ_NAME_QUERY, element2);
            return name2 == null ? null : name2.getTextContent();
        }
        String relation = element2.getAttribute("Label");
        Matcher matcher = this.RELATION_PATTERN.matcher(relation);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return relation;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Element element2) {
        Element rn;
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(4);
        }
        return (rn = this.querySingleElement(this.PLAN_ROWS_QUERY, element2)) == null ? null : new BigDecimal(rn.getTextContent());
    }

    @Override
    @Nullable
    protected BigDecimal parseActualNumRows(@NotNull Element element2) {
        Element rn;
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(5);
        }
        return (rn = this.querySingleElement(this.ACT_ROWS_QUERY, element2)) == null ? null : new BigDecimal(rn.getTextContent());
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Element element2) {
        Matcher m;
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (this.myActual) {
            Element name2 = this.querySingleElement(this.IND_NAME_QUERY, element2);
            return name2 == null ? null : name2.getTextContent();
        }
        Element indid = AsePlanModelBuilder.queryElement(this.INDID_QUERY, element2);
        if (indid != null && (m = this.INDEX_PATTERN.matcher(indid.getTextContent())).matches()) {
            return m.group(1);
        }
        return indid == null ? null : indid.getTextContent();
    }

    @Override
    protected void parsePlan(@NotNull Element state) {
        if (state == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(7);
        }
        this.openNode(null);
        this.parseSubPlans(state);
        String name2 = state.getTagName();
        PlanModel.NodeType type2 = TYPE_MAPPING.get(name2);
        if (type2 == null) {
            type2 = PlanModel.NodeType.UNKNOWN;
        }
        if (type2 == PlanModel.NodeType.ACCESS) {
            Element indid = AsePlanModelBuilder.queryElement(this.INDID_QUERY, state);
            type2 = indid != null && !indid.getTextContent().equals("0") ? PlanModel.NodeType.INDEX_SCAN : PlanModel.NodeType.SEQ_SCAN;
        }
        PlanModel.GenericNode node2 = this.createNode(state, type2, name2);
        this.closeNode(node2);
    }

    @Override
    protected void parseSubPlans(@NotNull Element element2) {
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(8);
        }
        for (Element sub : AsePlanModelBuilder.getSubPlans(element2)) {
            this.parsePlan(sub);
        }
    }

    private static JBIterable<Element> getSubPlans(@NotNull Element element2) {
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(9);
        }
        return JBIterable.generate((Object)element2.getFirstChild(), Node::getNextSibling).filter(Element.class).filter(e2 -> AsePlanModelBuilder.isSubPlan(e2));
    }

    private static boolean isSubPlan(Element e2) {
        return Character.isUpperCase(e2.getTagName().charAt(0)) && !NONE_OP.contains(e2.getTagName());
    }

    @Override
    protected void parseStatement(@NotNull Element element2) {
        PlanModel.NodeType type2;
        Element startOp;
        Element emit;
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(10);
        }
        this.openNode(null);
        this.myActual = "query".equals(element2.getTagName());
        if (!this.myActual && !"Emit".equals(element2.getTagName())) {
            this.unsupportedFormat();
        }
        Element element3 = emit = this.myActual ? this.querySingleElement(this.ACT_EMIT_QUERY, element2) : element2;
        if (emit == null) {
            this.unsupportedFormat();
        }
        if ((startOp = (Element)AsePlanModelBuilder.getSubPlans(emit).single()) == null) {
            this.unsupportedFormat();
        }
        if ((type2 = STATEMENT_MAPPING.get(startOp.getTagName())) != null) {
            if ((startOp = (Element)AsePlanModelBuilder.getSubPlans(startOp).single()) == null) {
                this.unsupportedFormat();
            }
        } else {
            type2 = PlanModel.NodeType.SELECT;
        }
        this.parsePlan(startOp);
        this.closeNode(this.createNode(emit, type2, null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Element element2) {
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Element element2) {
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Element element2) {
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Element element2) {
        if (element2 == null) {
            AsePlanModelBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("Scan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("TableScan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("IndexScan", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("Scalar", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("HashUnion", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("MergeJoin", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("NLJOp", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("NestLoopJoin", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("NaryNLJoin", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("HashJoin", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("GroupSorted", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("HashDistinct", PlanModel.NodeType.HASH_UNIQUE);
        TYPE_MAPPING.put("HashVectAgg", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("UnionAll", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("MergeUnion", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("ScalarAgg", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("Restrict", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("Store", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("WorkTable", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("Sequencer", PlanModel.NodeType.SEQUENTIALLY);
        TYPE_MAPPING.put("RemoteScan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("Scroll", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("RidJoin", PlanModel.NodeType.JOIN);
        TYPE_MAPPING.put("FilterOp", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("SQFilter", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("Exchange", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("InsteadOf", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("InsteadOfTrigger", PlanModel.NodeType.OPERATION);
        TYPE_MAPPING.put("CursorScan", PlanModel.NodeType.ACCESS);
        STATEMENT_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("Delete", PlanModel.NodeType.DELETE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/sybase/plan/AsePlanModelBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/sybase/plan/AsePlanModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseXml";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseActualNumRows";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSubPlans";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

