/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.snowflake.model.SFlakeDatabase;
import com.intellij.database.dialects.snowflake.model.SFlakeSchema;
import com.intellij.database.dialects.snowflake.model.SFlakeStream;
import com.intellij.database.dialects.snowflake.model.SFlakeTable;
import com.intellij.database.dialects.snowflake.model.SFlakeTask;
import com.intellij.database.dialects.snowflake.model.SFlakeUser;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.types.DasUnresolvedTypeReference;
import icons.DatabaseIcons;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J!\u0010\u0016\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J4\u0010\u001c\u001a\u00020\u0004\"\b\b\u0000\u0010\u001d*\u00020\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u00192\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0!0 H\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/snowflake/model/SFlakeModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "", "modifyParent", "", "getCustomName", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/Nullable;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "getIcon", "Ljavax/swing/Icon;", "getTitle", "Lcom/intellij/openapi/util/NlsSafe;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "prop", "Lcom/intellij/database/model/meta/BasicMetaId;", "reorderProperties", "E", "Lcom/intellij/database/model/basic/BasicElement;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "intellij.database.dialects.snowflake"})
@SourceDebugExtension(value={"SMAP\nSFlakeModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SFlakeModelHelper.kt\ncom/intellij/database/dialects/snowflake/model/SFlakeModelHelper\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,75:1\n18#2:76\n*S KotlinDebug\n*F\n+ 1 SFlakeModelHelper.kt\ncom/intellij/database/dialects/snowflake/model/SFlakeModelHelper\n*L\n26#1:76\n*E\n"})
public final class SFlakeModelHelper
extends ModelHelper {
    @NotNull
    public static final SFlakeModelHelper INSTANCE = new SFlakeModelHelper();

    private SFlakeModelHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCHEDULED_EVENT)) {
            int _true_$iv;
            void $this$choose$iv;
            Object[] objectArray = new Object[1];
            boolean bl = plural;
            int n = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv != false ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message("CustomObjectKind.task", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e2, variant, vars, modifyParent);
        if (e2 instanceof SFlakeTask) {
            ((SFlakeTask)e2).setSchedule("1 minute");
            String string = ((SFlakeTask)e2).getSchedule();
            Intrinsics.checkNotNull((Object)string);
            vars.put("schedule", "schedule = " + ScriptGeneratorHelperKt.getSqlString(string));
        }
        if (e2 instanceof BasicModRoutine && ((BasicModRoutine)e2).getRoutineKind() == DasRoutine.Kind.PROCEDURE) {
            BasicModArgument basicModArgument = ((BasicModRoutine)e2).createOrGetReturnArgument();
            DataType dataType = DataTypeFactory.of("varchar");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            basicModArgument.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            vars.put("return", "varchar");
        }
        if (e2 instanceof SFlakeStream) {
            ((SFlakeStream)e2).setTargetRef(BasicNameReference.create("target_table", true));
        }
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind, @NotNull ModelHelper.ObjectKindVariant variant) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.STREAM) ? DatabaseIcons.Table : super.getIcon(kind, variant);
    }

    @Override
    @NotNull
    public String getTitle(@NotNull BasicMetaObject<?> meta, @NotNull BasicMetaId prop) {
        String string;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        BasicMetaId basicMetaId = prop;
        if (Intrinsics.areEqual((Object)basicMetaId, SFlakeSchema.TRANSIENT_SC)) {
            string = "Transient";
        } else if (Intrinsics.areEqual((Object)basicMetaId, SFlakeDatabase.TRANSIENT_DB)) {
            string = "Transient";
        } else if (Intrinsics.areEqual((Object)basicMetaId, SFlakeUser.DISPLAY)) {
            string = "Display Name";
        } else {
            String string2 = super.getTitle(meta, prop);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitle(...)");
        }
        return string;
    }

    @Override
    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super.reorderProperties(meta, fields);
        if (meta.kindOf(SFlakeUser.class)) {
            BasicMetaId[] basicMetaIdArray = new BasicMetaId[]{SFlakeUser.LOGIN_NAME, SFlakeUser.DISPLAY, SFlakeUser.FIRST_NAME, SFlakeUser.LAST_NAME, SFlakeUser.EMAIL, SFlakeUser.PASSWORD};
            ModelHelper.moveTo(fields, ModelHelper.indexOf(fields, SFlakeUser.NAME) + 1, basicMetaIdArray);
        } else if (meta.kindOf(SFlakeTable.class)) {
            ModelHelper.moveTo(fields, ModelHelper.indexOf(fields, SFlakeTable.COMMENT) + 1, (BasicMetaId)SFlakeTable.TABLE_KIND);
        }
    }
}

