/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.dialects.postgresbase.model.PgBaseDescriptionService;
import com.intellij.database.dialects.redshift.model.RsExternalSchema;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.RsExternalTableColumn;
import com.intellij.database.dialects.redshift.model.RsModelFunKt;
import com.intellij.database.dialects.redshift.model.RsSharedDatabase;
import com.intellij.database.dialects.redshift.model.RsTable;
import com.intellij.database.dialects.redshift.model.RsTableColumn;
import com.intellij.database.dialects.redshift.model.RsUser;
import com.intellij.database.dialects.redshift.model.properties.RsExternalTableStorageType;
import com.intellij.database.dialects.redshift.model.properties.RsTableBackupMode;
import com.intellij.database.dialects.redshift.model.properties.RsTableDistStyle;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.PositioningNamingFamily;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/redshift/model/RsDescriptionService;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeRedshiftColumn", "column", "Lcom/intellij/database/dialects/redshift/model/RsTableColumn;", "describeRedshiftExternalSchema", "schema", "Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;", "describeRedshiftExternalTable", "table", "Lcom/intellij/database/dialects/redshift/model/RsExternalTable;", "describeRedshiftExternalTableColumn", "Lcom/intellij/database/dialects/redshift/model/RsExternalTableColumn;", "describeRedshiftSharedDatabase", "database", "Lcom/intellij/database/dialects/redshift/model/RsSharedDatabase;", "describeRedshiftTable", "Lcom/intellij/database/dialects/redshift/model/RsTable;", "describeRedshiftUser", "user", "Lcom/intellij/database/dialects/redshift/model/RsUser;", "intellij.database.dialects.redshift"})
@SourceDebugExtension(value={"SMAP\nRsDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDescriptionService.kt\ncom/intellij/database/dialects/redshift/model/RsDescriptionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n857#2,2:124\n1002#2,2:126\n1864#2,3:128\n*S KotlinDebug\n*F\n+ 1 RsDescriptionService.kt\ncom/intellij/database/dialects/redshift/model/RsDescriptionService\n*L\n81#1:124,2\n82#1:126,2\n87#1:128,3\n*E\n"})
public final class RsDescriptionService
extends PgBaseDescriptionService {
    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof RsTable ? this.describeRedshiftTable((RsTable)e2, context) : (basicElement instanceof RsTableColumn ? this.describeRedshiftColumn((RsTableColumn)e2, context) : (basicElement instanceof RsExternalSchema ? this.describeRedshiftExternalSchema((RsExternalSchema)e2, context) : (basicElement instanceof RsExternalTable ? this.describeRedshiftExternalTable((RsExternalTable)e2, context) : (basicElement instanceof RsExternalTableColumn ? this.describeRedshiftExternalTableColumn((RsExternalTableColumn)e2, context) : (basicElement instanceof RsSharedDatabase ? this.describeRedshiftSharedDatabase((RsSharedDatabase)e2, context) : (basicElement instanceof RsUser ? this.describeRedshiftUser((RsUser)e2, context) : super.content(e2, context)))))));
    }

    private final String describeRedshiftColumn(RsTableColumn column2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(RsTableColumn.ENCODING);
        ((Collection)context.getDescribed()).add(RsTableColumn.SORT_KEY_ORDER);
        Object d2 = this.describeDistColumn(column2, context);
        if (column2.getEncoding() != null && !RsModelFunKt.isDefaultEncoding(column2)) {
            d2 = (String)d2 + " encode(" + column2.getEncoding() + ")";
        }
        return d2;
    }

    private final String describeRedshiftExternalSchema(RsExternalSchema schema2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(RsExternalSchema.DATABASE_NAME);
        ((Collection)context.getDescribed()).add(RsExternalSchema.IAM_ROLE);
        ((Collection)context.getDescribed()).add(RsExternalSchema.URI);
        ((Collection)context.getDescribed()).add(RsExternalSchema.PORT);
        ((Collection)context.getDescribed()).add(RsExternalSchema.REGION);
        ((Collection)context.getDescribed()).add(RsExternalSchema.SCHEMA_KIND);
        ArrayList<CallSite> attributes2 = new ArrayList<CallSite>();
        if (schema2.getDatabaseName() != null) {
            attributes2.add((CallSite)((Object)("database name: " + schema2.getDatabaseName())));
        }
        if (schema2.getIamRole() != null) {
            attributes2.add((CallSite)((Object)("iam role: " + schema2.getIamRole())));
        }
        if (schema2.getUri() != null) {
            attributes2.add((CallSite)((Object)("uri: " + schema2.getUri())));
        }
        if (schema2.getPort() != null) {
            attributes2.add((CallSite)((Object)("port: " + schema2.getPort())));
        }
        if (schema2.getRegion() != null) {
            attributes2.add((CallSite)((Object)("region: " + schema2.getRegion())));
        }
        if (schema2.getSchemaKind() != -1) {
            attributes2.add((CallSite)((Object)("kind: " + (schema2.getSchemaKind() == 2 ? "hive metastore" : "data catalog"))));
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String describeRedshiftExternalTable(RsExternalTable table, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(RsExternalTable.SERIALIZATION_LIB);
        ((Collection)context.getDescribed()).add(RsExternalTable.INPUT_FORMAT);
        ((Collection)context.getDescribed()).add(RsExternalTable.OUTPUT_FORMAT);
        ((Collection)context.getDescribed()).add(RsExternalTable.LOCATION);
        ((Collection)context.getDescribed()).add(RsExternalTable.SERDE_PROPERTIES);
        ((Collection)context.getDescribed()).add(RsExternalTable.PROPS);
        ((Collection)context.getDescribed()).add(RsExternalTable.STORAGE_TYPE);
        ArrayList<CallSite> attributes2 = new ArrayList<CallSite>();
        if (table.getSerializationLib() != null) {
            attributes2.add((CallSite)((Object)("serialization lib: " + table.getSerializationLib())));
        }
        if (table.getInputFormat() != null) {
            attributes2.add((CallSite)((Object)("input format: " + table.getInputFormat())));
        }
        if (table.getOutputFormat() != null) {
            attributes2.add((CallSite)((Object)("output fotmat: " + table.getOutputFormat())));
        }
        if (table.getLocation() != null) {
            attributes2.add((CallSite)((Object)("location: " + table.getLocation())));
        }
        List<String> list = table.getSerdeProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSerdeProperties(...)");
        if (!((Collection)list).isEmpty()) {
            List<String> list2 = table.getSerdeProperties();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSerdeProperties(...)");
            attributes2.add((CallSite)((Object)("serde properties: " + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null))));
        }
        List<String> list3 = table.getProps();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getProps(...)");
        if (!((Collection)list3).isEmpty()) {
            List<String> list4 = table.getProps();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getProps(...)");
            attributes2.add((CallSite)((Object)("properties: " + CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null))));
        }
        if (table.getStorageType() != RsExternalTableStorageType.UNKNOWN) {
            attributes2.add((CallSite)((Object)("stored as: " + table.getStorageType().getSqlDefinition())));
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String describeRedshiftExternalTableColumn(RsExternalTableColumn column2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(RsExternalTableColumn.PARTITION_KEY_ORDER);
        return DescriptionService.describeColumn$default(this, column2, context, null, 4, null) + " " + (String)(column2.getPartitionKeyOrder() == 0 ? "" : "partition key order: " + column2.getPartitionKeyOrder());
    }

    /*
     * WARNING - void declaration
     */
    private final String describeRedshiftTable(RsTable table, DescriptionService.Context context) {
        Collection $this$filterTo$iv;
        ((Collection)context.getDescribed()).add(RsTable.DIST_STYLE);
        ((Collection)context.getDescribed()).add(RsTable.BACKUP_MODE);
        Object d2 = null;
        d2 = this.describeTable(table, context);
        if (table.getDistStyle() != RsTableDistStyle.EVEN) {
            d2 = d2 + " diststyle(" + table.getDistStyle().name() + ")";
        }
        if (table.getBackupMode() != RsTableBackupMode.ON) {
            d2 = d2 + " backup(no)";
        }
        PositioningNamingFamily positioningNamingFamily = table.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
        Iterable iterable = positioningNamingFamily;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            RsTableColumn it2 = (RsTableColumn)element$iv;
            boolean bl2 = false;
            if (!(it2.getSortKeyOrder() != 0)) continue;
            destination$iv.add(element$iv);
        }
        $this$filterTo$iv = destination$iv;
        ArrayList $this$describeRedshiftTable_u24lambda_u242 = (ArrayList)$this$filterTo$iv;
        boolean bl = false;
        List $this$sortBy$iv = $this$describeRedshiftTable_u24lambda_u242;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    RsTableColumn it2 = (RsTableColumn)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(Math.abs(it2.getSortKeyOrder()));
                    it2 = (RsTableColumn)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(Math.abs(it2.getSortKeyOrder())));
                }
            });
        }
        ArrayList sorted = (ArrayList)$this$filterTo$iv;
        if (sorted.isEmpty()) {
            return d2;
        }
        if (RsModelFunKt.hasInterleavedSortKey(table)) {
            d2 = d2 + " interleaved";
        }
        d2 = d2 + " sortkey(";
        Iterable $this$forEachIndexed$iv = sorted;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void col;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RsTableColumn bl2 = (RsTableColumn)item$iv;
            int idx = n;
            boolean bl3 = false;
            if (idx != 0) {
                d2 = d2 + ", ";
            }
            d2 = d2 + col.getName();
        }
        d2 = d2 + ")";
        return d2;
    }

    private final String describeRedshiftSharedDatabase(RsSharedDatabase database, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(RsSharedDatabase.DATASHARE_NAME);
        ((Collection)context.getDescribed()).add(RsSharedDatabase.DATASHARE_ACCOUNT);
        ((Collection)context.getDescribed()).add(RsSharedDatabase.DATASHARE_NAMESPACE);
        ArrayList<CallSite> attributes2 = new ArrayList<CallSite>();
        if (database.getDatashareName() != null) {
            attributes2.add((CallSite)((Object)("datashare name: " + database.getDatashareName())));
        }
        if (database.getDatashareAccount() != null) {
            attributes2.add((CallSite)((Object)("datashare account: " + database.getDatashareAccount())));
        }
        if (database.getDatashareNamespace() != null) {
            attributes2.add((CallSite)((Object)("datashare namespace: " + database.getDatashareNamespace())));
        }
        return CollectionsKt.joinToString$default((Iterable)attributes2, null, null, null, (int)0, null, null, (int)63, null);
    }

    private final String describeRedshiftUser(RsUser user, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(RsUser.SUPER_ROLE);
        ((Collection)context.getDescribed()).add(RsUser.CREATE_DB);
        ((Collection)context.getDescribed()).add(RsUser.CONNECTION_LIMIT);
        ((Collection)context.getDescribed()).add(RsUser.VALID_UNTIL);
        ((Collection)context.getDescribed()).add(RsUser.CONFIG);
        ArrayList<Object> props = new ArrayList<Object>();
        if (user.isSuperRole()) {
            props.add("superuser");
        }
        if (user.isCreateDb()) {
            props.add("create db");
        }
        if (user.getConnectionLimit() != -1L) {
            props.add("connection limit: " + user.getConnectionLimit());
        }
        if (user.getValidUntil() != null) {
            props.add("valid until: " + user.getValidUntil());
        }
        props.addAll((Collection)user.getConfig());
        return CollectionsKt.joinToString$default((Iterable)props, null, null, null, (int)0, null, null, (int)63, null);
    }
}

