/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.types;

import com.intellij.database.dialects.oracle.types.OraRecordType;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasColumniationType;
import com.intellij.database.types.DasScope;
import com.intellij.database.types.DasSimpleScope;
import com.intellij.database.types.DasSimpleTypeClass;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u001a\u0010\u0013\u001a\f0\u0014\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraRecordType;", "Lcom/intellij/database/types/DasTableType;", "Lcom/intellij/database/types/DasColumniationType;", "columns", "", "Lcom/intellij/database/model/DasTypedObject;", "(Ljava/lang/Iterable;)V", "columnScope", "Lcom/intellij/database/types/DasScope;", "equals", "", "other", "", "getColumnCount", "", "getColumnDasType", "Lcom/intellij/database/types/DasType;", "Lorg/jetbrains/annotations/NotNull;", "i", "getColumnName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getColumnScope", "getDescription", "getSpecification", "getTypeClass", "Lcom/intellij/database/types/DasSimpleTypeClass;", "hashCode", "toDataType", "Lcom/intellij/database/model/DataType;", "Companion", "intellij.database.dialects.oracle"})
public final class OraRecordType
implements DasTableType,
DasColumniationType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DasScope<DasTypedObject> columnScope;
    @NotNull
    private static final DasSimpleTypeClass TYPE_CLASS = new DasSimpleTypeClass("<record>");

    public OraRecordType(@NotNull Iterable<? extends DasTypedObject> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        this.columnScope = new DasSimpleScope(CollectionsKt.toList(columns2), null, 2, null);
    }

    @Override
    @NotNull
    public DasScope<DasTypedObject> getColumnScope() {
        return this.columnScope;
    }

    @Override
    @NotNull
    public DasSimpleTypeClass getTypeClass() {
        return TYPE_CLASS;
    }

    @Override
    public int getColumnCount() {
        return this.columnScope.getAllElements().size();
    }

    @Override
    @NotNull
    public String getColumnName(int i2) {
        String string = this.columnScope.getAllElements().get(i2).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    public DasType getColumnDasType(int i2) {
        DasType dasType = this.columnScope.getAllElements().get(i2).getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        return dasType;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof OraRecordType && Intrinsics.areEqual(this.columnScope.getAllElements(), ((OraRecordType)other).columnScope.getAllElements());
    }

    public int hashCode() {
        return ((Object)this.columnScope.getAllElements()).hashCode();
    }

    @Override
    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$getDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDescription_u24lambda_u240.append("RECORD ");
        List<DasTypedObject> list = this.columnScope.getAllElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllElements(...)");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$getDescription_u24lambda_u240, null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)getDescription.1.1.INSTANCE, (int)50, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String getSpecification() {
        StringBuilder stringBuilder;
        StringBuilder $this$getSpecification_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getSpecification_u24lambda_u241.append("RECORD ");
        List<DasTypedObject> list = this.columnScope.getAllElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllElements(...)");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$getSpecification_u24lambda_u241, null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)getSpecification.1.1.INSTANCE, (int)50, null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public DataType toDataType() {
        List<DasTypedObject> list = this.columnScope.getAllElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllElements(...)");
        String spec2 = CollectionsKt.joinToString$default((Iterable)list, null, (CharSequence)"table(", (CharSequence)")", (int)0, null, (Function1)toDataType.spec.1.INSTANCE, (int)25, null);
        DataType dataType = DataTypeFactory.of(spec2);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        return dataType;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/oracle/types/OraRecordType$Companion;", "", "()V", "TYPE_CLASS", "Lcom/intellij/database/types/DasSimpleTypeClass;", "getTYPE_CLASS", "()Lcom/intellij/database/types/DasSimpleTypeClass;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DasSimpleTypeClass getTYPE_CLASS() {
            return TYPE_CLASS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

