/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator.producers;

import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.ScriptingFun;
import com.intellij.database.dialects.oracle.generator.OraNamingService;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorSourcesHelperKt;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.CodeTextBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"HEX_PATTERN_32p", "Lkotlin/text/Regex;", "produceCode", "", "producer", "Lcom/intellij/database/dialects/base/generator/BaseProducer;", "dbLink", "Lcom/intellij/database/dialects/oracle/model/OraDbLink;", "create", "", "quotePassword", "", "pwd", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraDbLinkProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraDbLinkProducers.kt\ncom/intellij/database/dialects/oracle/generator/producers/OraDbLinkProducersKt\n+ 2 ElementProducer.kt\ncom/intellij/database/dialects/base/generator/BaseProducer\n*L\n1#1,108:1\n98#2:109\n*S KotlinDebug\n*F\n+ 1 OraDbLinkProducers.kt\ncom/intellij/database/dialects/oracle/generator/producers/OraDbLinkProducersKt\n*L\n54#1:109\n*E\n"})
public final class OraDbLinkProducersKt {
    @NotNull
    private static final Regex HEX_PATTERN_32p = new Regex("^[0-9A-Fa-f]{32,}");

    /*
     * WARNING - void declaration
     */
    private static final void produceCode(BaseProducer producer, OraDbLink dbLink, boolean create2) {
        String string;
        String shared;
        BaseProducer baseProducer;
        BaseProducer $this$produceCode_u24lambda_u240 = baseProducer = producer;
        boolean bl = false;
        String keyword = create2 ? "create" : "alter";
        boolean isPublic = Intrinsics.areEqual((Object)dbLink.getSchemaName(), (Object)"PUBLIC");
        String string2 = isPublic ? "public" : null;
        String string3 = shared = dbLink.isShared() ? "shared" : null;
        if (isPublic) {
            void this_$iv;
            BaseProducer baseProducer2 = $this$produceCode_u24lambda_u240;
            String string4 = dbLink.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            String $this$scr$iv = string4;
            boolean $i$f$getScr = false;
            string = this_$iv.getContext().getNamingService().catToScript($this$scr$iv, null, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting(this_$iv.getContext()));
        } else {
            string = BaseProducer.currentScopeName$default($this$produceCode_u24lambda_u240, dbLink, null, false, 3, null);
        }
        String name2 = string;
        $this$produceCode_u24lambda_u240.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(keyword, shared, string2, name2, dbLink, create2){
            final /* synthetic */ String $keyword;
            final /* synthetic */ String $shared;
            final /* synthetic */ String $public;
            final /* synthetic */ String $name;
            final /* synthetic */ OraDbLink $dbLink;
            final /* synthetic */ boolean $create;
            {
                this.$keyword = $keyword;
                this.$shared = $shared;
                this.$public = $public;
                this.$name = $name;
                this.$dbLink = $dbLink;
                this.$create = $create;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                Object object = new CharSequence[]{this.$keyword, this.$shared, this.$public, "database link", this.$name};
                $this$newCoding.getBuilder().phrase((CharSequence)object);
                object = $this$newCoding.getBuilder();
                OraDbLink oraDbLink = this.$dbLink;
                boolean bl = this.$create;
                boolean $i$f$indenting = false;
                CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
                try {
                    boolean bl2 = false;
                    boolean nl$iv = true;
                    boolean $i$f$withNewLines = false;
                    boolean prev$iv = $this$newCoding.getStartWithNewLine();
                    $this$newCoding.setStartWithNewLine(nl$iv);
                    boolean bl3 = false;
                    String connectUserPassword = oraDbLink.getConnectUserPassword();
                    String string = connectUserPassword;
                    if (string == null) {
                        string = "?";
                    }
                    String identPhrase = "identified by " + OraDbLinkProducersKt.access$quotePassword(string);
                    String userName = oraDbLink.getConnectUserName();
                    if (oraDbLink.isShared() || userName != null) {
                        if (Intrinsics.areEqual((Object)userName, (Object)"CURRENT_USER")) {
                            $this$newCoding.unaryPlus("connect to current_user");
                        } else {
                            ScriptingContext.NewCodingAdapter this_$iv2 = $this$newCoding;
                            boolean $i$f$orError = false;
                            $this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("connect to"), (Function0<? extends Object>)((Function0)new Function0<Unit>(userName, this_$iv2){
                                final /* synthetic */ String $text;
                                final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
                                {
                                    this.$text = $text;
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    if (this.$text != null) {
                                        ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                    } else {
                                        CompositeText.Kind kind = null;
                                        CharSequence charSequence = "???";
                                        ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                                        boolean bl = false;
                                        String string = "user name must be specified";
                                        ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                    }
                                }
                            })), identPhrase);
                        }
                    }
                    if (oraDbLink.isShared()) {
                        String authUserPassword = oraDbLink.getAuthUserPassword();
                        String string2 = authUserPassword;
                        if (string2 == null) {
                            string2 = "?";
                        }
                        String identPhrase2 = "identified by " + OraDbLinkProducersKt.access$quotePassword(string2);
                        String userName2 = oraDbLink.getAuthUserName();
                        ScriptingContext.NewCodingAdapter this_$iv3 = $this$newCoding;
                        boolean $i$f$orError = false;
                        $this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("authenticated by"), (Function0<? extends Object>)((Function0)new Function0<Unit>(userName2, this_$iv3){
                            final /* synthetic */ String $text;
                            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
                            {
                                this.$text = $text;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                if (this.$text != null) {
                                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                } else {
                                    CompositeText.Kind kind = null;
                                    CharSequence charSequence = "???";
                                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                                    boolean bl = false;
                                    String string = "user name must be specified when the DB link is shared";
                                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                }
                            }
                        })), identPhrase2);
                    }
                    if (bl) {
                        String string3;
                        String identPhrase2;
                        String string4 = identPhrase2 = oraDbLink.getRemoteDatabaseString();
                        if (string4 != null) {
                            Intrinsics.checkNotNull((Object)string4);
                            string3 = OraIntrospectorSourcesHelperKt.quoteAsOraLiteral(identPhrase2);
                        } else {
                            string3 = null;
                        }
                        String remoteDatabaseString = string3;
                        ScriptingContext.NewCodingAdapter this_$iv4 = $this$newCoding;
                        boolean $i$f$orError = false;
                        $this$newCoding.plus($this$newCoding.unaryPlus("using"), (Function0<? extends Object>)((Function0)new Function0<Unit>(remoteDatabaseString, this_$iv4){
                            final /* synthetic */ String $text;
                            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
                            {
                                this.$text = $text;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                if (this.$text != null) {
                                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                                } else {
                                    CompositeText.Kind kind = null;
                                    CharSequence charSequence = "???";
                                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                                    boolean bl = false;
                                    String string = "a TNS alias of the remote database must be specified";
                                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                                }
                            }
                        }));
                    }
                    $this$newCoding.setStartWithNewLine(prev$iv);
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }));
    }

    private static final String quotePassword(String pwd) {
        CharSequence charSequence;
        return Intrinsics.areEqual((Object)pwd, (Object)"?") ? pwd : (StringsKt.startsWith$default((CharSequence)pwd, (char)':', (boolean)false, (int)2, null) ? pwd : (HEX_PATTERN_32p.matches(charSequence = (CharSequence)pwd) ? "values '" + pwd + "'" : (OraNamingService.INSTANCE.isPlain(pwd) ? pwd : OraIntrospectorSourcesHelperKt.quoteAsOraLiteral(pwd))));
    }

    public static final /* synthetic */ void access$produceCode(BaseProducer producer, OraDbLink dbLink, boolean create2) {
        OraDbLinkProducersKt.produceCode(producer, dbLink, create2);
    }

    public static final /* synthetic */ String access$quotePassword(String pwd) {
        return OraDbLinkProducersKt.quotePassword(pwd);
    }
}

