/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.types.OraAssociativeArrayType;
import com.intellij.database.dialects.oracle.types.OraNestedTableType;
import com.intellij.database.dialects.oracle.types.OraRefCursorType;
import com.intellij.database.dialects.oracle.types.OraVaryingArrayType;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 $2\u00020\u0001:\u0002$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00062\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0002R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer;", "", "routine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "(Lcom/intellij/database/dialects/oracle/model/OraRoutine;)V", "outs", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "getOuts", "()Ljava/util/List;", "outs$delegate", "Lkotlin/Lazy;", "isReturn", "", "Lcom/intellij/database/model/ArgumentDirection;", "(Lcom/intellij/database/model/ArgumentDirection;)Z", "unwrappedType", "Lcom/intellij/database/types/DasType;", "getUnwrappedType", "(Lcom/intellij/database/dialects/oracle/model/OraArgument;)Lcom/intellij/database/types/DasType;", "getAssociativeArrayArguments", "getCursorArguments", "getPlTypeArrayArguments", "getPlTypeNestedTableArguments", "getPrimitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "version", "Lcom/intellij/database/util/Version;", "getReturnArgument", "getSqlTypeArrayArguments", "getSqlTypeNestedTableArguments", "isArray", "argument", "isAssociativeArray", "isNestedTable", "isRefCursor", "Companion", "PrimitivesPack", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraRoutineArgumentsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraRoutineArgumentsAnalyzer.kt\ncom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n766#2:91\n857#2,2:92\n766#2:94\n857#2,2:95\n766#2:97\n857#2,2:98\n766#2:100\n857#2,2:101\n766#2:103\n857#2,2:104\n766#2:106\n857#2,2:107\n988#3:109\n1017#3,3:110\n1020#3,3:120\n372#4,7:113\n125#5:123\n152#5,3:124\n1#6:127\n*S KotlinDebug\n*F\n+ 1 OraRoutineArgumentsAnalyzer.kt\ncom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer\n*L\n36#1:91\n36#1:92,2\n40#1:94\n40#1:95,2\n44#1:97\n44#1:98,2\n48#1:100\n48#1:101,2\n52#1:103\n52#1:104,2\n56#1:106\n56#1:107,2\n62#1:109\n62#1:110,3\n62#1:120,3\n62#1:113,7\n63#1:123\n63#1:124,3\n*E\n"})
public final class OraRoutineArgumentsAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OraRoutine routine;
    @NotNull
    private final Lazy outs$delegate;

    public OraRoutineArgumentsAnalyzer(@NotNull OraRoutine routine2) {
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        this.routine = routine2;
        this.outs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends OraArgument>>(this){
            final /* synthetic */ OraRoutineArgumentsAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<OraArgument> invoke() {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                PositioningNamingFamily positioningNamingFamily = OraRoutineArgumentsAnalyzer.access$getRoutine$p(this.this$0).getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                Iterable iterable = positioningNamingFamily;
                OraRoutineArgumentsAnalyzer oraRoutineArgumentsAnalyzer = this.this$0;
                boolean $i$f$filter = false;
                void var4_4 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ArgumentDirection direction;
                    OraArgument it2 = (OraArgument)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)it2.getArgumentDirection()), (String)"getArgumentDirection(...)");
                    if (!(direction.isOut() || OraRoutineArgumentsAnalyzer.access$isReturn(oraRoutineArgumentsAnalyzer, direction))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    private final List<OraArgument> getOuts() {
        Lazy lazy = this.outs$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getCursorArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it2 = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!this.isRefCursor(it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getAssociativeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it2 = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it2) && this.isAssociativeArray(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getSqlTypeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it2 = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it2) && Companion.isSqlTypeArgument(it2) && this.isArray(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getPlTypeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it2 = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it2) && !Companion.isSqlTypeArgument(it2) && this.isArray(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getSqlTypeNestedTableArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it2 = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it2) && Companion.isSqlTypeArgument(it2) && this.isNestedTable(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getPlTypeNestedTableArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it2 = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it2) && !Companion.isSqlTypeArgument(it2) && this.isNestedTable(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PrimitivesPack> getPrimitives(@NotNull Version version) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        OraArgument it2;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Sequence $this$groupBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getOuts()), (Function1)((Function1)new Function1<OraArgument, Boolean>(this){
            final /* synthetic */ OraRoutineArgumentsAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull OraArgument it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return !OraRoutineArgumentsAnalyzer.access$isRefCursor(this.this$0, it2) && !OraRoutineArgumentsAnalyzer.access$isArray(this.this$0, it2) && !OraRoutineArgumentsAnalyzer.access$isAssociativeArray(this.this$0, it2) && !OraRoutineArgumentsAnalyzer.access$isNestedTable(this.this$0, it2);
            }
        }));
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            it2 = (OraArgument)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = Companion.isSqlTypeArgument(it2);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            list$iv$iv = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(new PrimitivesPack((Boolean)it2.getKey() != false || Companion.supportPlTypesInSql(version), (List)it2.getValue()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final OraArgument getReturnArgument() {
        Object v1;
        block1: {
            Iterable iterable = this.getOuts();
            for (Object t : iterable) {
                OraArgument it2 = (OraArgument)t;
                boolean bl = false;
                ArgumentDirection argumentDirection = it2.getArgumentDirection();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)argumentDirection), (String)"getArgumentDirection(...)");
                if (!this.isReturn(argumentDirection)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final boolean isReturn(ArgumentDirection $this$isReturn) {
        return $this$isReturn == ArgumentDirection.RETURN;
    }

    private final DasType getUnwrappedType(OraArgument $this$unwrappedType) {
        DasType dasType = $this$unwrappedType.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        return DasTypeUtilsKt.unwrap$default(dasType, false, $this$unwrappedType, 1, null);
    }

    private final boolean isRefCursor(OraArgument argument) {
        return this.getUnwrappedType(argument) instanceof OraRefCursorType;
    }

    private final boolean isAssociativeArray(OraArgument argument) {
        DasType dasType = this.getUnwrappedType(argument);
        OraAssociativeArrayType oraAssociativeArrayType = dasType instanceof OraAssociativeArrayType ? (OraAssociativeArrayType)dasType : null;
        return (oraAssociativeArrayType != null ? oraAssociativeArrayType.getIndexType() : null) != null;
    }

    private final boolean isArray(OraArgument argument) {
        return this.getUnwrappedType(argument) instanceof OraVaryingArrayType;
    }

    private final boolean isNestedTable(OraArgument argument) {
        return this.getUnwrappedType(argument) instanceof OraNestedTableType;
    }

    @JvmStatic
    public static final boolean supportPlTypesInSql(@NotNull Version version) {
        return Companion.supportPlTypesInSql(version);
    }

    @JvmStatic
    public static final boolean isSqlTypeArgument(@NotNull OraArgument argument) {
        return Companion.isSqlTypeArgument(argument);
    }

    public static final /* synthetic */ boolean access$isRefCursor(OraRoutineArgumentsAnalyzer $this, OraArgument argument) {
        return $this.isRefCursor(argument);
    }

    public static final /* synthetic */ boolean access$isArray(OraRoutineArgumentsAnalyzer $this, OraArgument argument) {
        return $this.isArray(argument);
    }

    public static final /* synthetic */ boolean access$isAssociativeArray(OraRoutineArgumentsAnalyzer $this, OraArgument argument) {
        return $this.isAssociativeArray(argument);
    }

    public static final /* synthetic */ boolean access$isNestedTable(OraRoutineArgumentsAnalyzer $this, OraArgument argument) {
        return $this.isNestedTable(argument);
    }

    public static final /* synthetic */ OraRoutine access$getRoutine$p(OraRoutineArgumentsAnalyzer $this) {
        return $this.routine;
    }

    public static final /* synthetic */ boolean access$isReturn(OraRoutineArgumentsAnalyzer $this, ArgumentDirection $receiver) {
        return $this.isReturn($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$Companion;", "", "()V", "isSqlTypeArgument", "", "argument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "supportPlTypesInSql", "version", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean supportPlTypesInSql(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{12, 1};
            return version.isOrGreater(nArray);
        }

        @JvmStatic
        public final boolean isSqlTypeArgument(@NotNull OraArgument argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            DasType dasType = argument.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasType dasType2 = DasTypeUtilsKt.resolve(dasType, argument);
            Object object = dasType2 instanceof DasDefinedType ? (DasDefinedType)dasType2 : null;
            return (object != null && (object = object.getTypeClass()) != null ? object.getPackageName() : null) == null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "", "enabled", "", "arguments", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "(ZLjava/util/List;)V", "getArguments", "()Ljava/util/List;", "getEnabled", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.database.dialects.oracle"})
    public static final class PrimitivesPack {
        private final boolean enabled;
        @NotNull
        private final List<OraArgument> arguments;

        public PrimitivesPack(boolean enabled, @NotNull List<? extends OraArgument> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            this.enabled = enabled;
            this.arguments = arguments;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final List<OraArgument> getArguments() {
            return this.arguments;
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final List<OraArgument> component2() {
            return this.arguments;
        }

        @NotNull
        public final PrimitivesPack copy(boolean enabled, @NotNull List<? extends OraArgument> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            return new PrimitivesPack(enabled, arguments);
        }

        public static /* synthetic */ PrimitivesPack copy$default(PrimitivesPack primitivesPack, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = primitivesPack.enabled;
            }
            if ((n & 2) != 0) {
                list = primitivesPack.arguments;
            }
            return primitivesPack.copy(bl, list);
        }

        @NotNull
        public String toString() {
            return "PrimitivesPack(enabled=" + this.enabled + ", arguments=" + this.arguments + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.enabled);
            result2 = result2 * 31 + ((Object)this.arguments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrimitivesPack)) {
                return false;
            }
            PrimitivesPack primitivesPack = (PrimitivesPack)other;
            if (this.enabled != primitivesPack.enabled) {
                return false;
            }
            return Intrinsics.areEqual(this.arguments, primitivesPack.arguments);
        }
    }
}

