/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.debugger.SqlVariable;
import com.intellij.database.debugger.SqlVariableKind;
import com.intellij.database.dialects.oracle.debugger.OraProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramSources;
import com.intellij.database.dialects.oracle.debugger.OraVariableFinderFun;
import com.intellij.database.dialects.oracle.debugger.OracleDebugHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraVariableFinder;", "", "project", "Lcom/intellij/openapi/project/Project;", "sources", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramSources;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dialects/oracle/debugger/OraProgramSources;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "findVariables", "", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "position", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramPosition;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "", "intellij.database.dialects.oracle.ex"})
public final class OraVariableFinder {
    @NotNull
    private final OraProgramSources sources;
    @NotNull
    private final PsiManager psiManager;

    public OraVariableFinder(@NotNull Project project, @NotNull OraProgramSources sources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        this.sources = sources;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
    }

    @Nullable
    public final List<SqlVariable> findVariables(@NotNull OraProgramPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        SqlProgramSource sqlProgramSource = this.sources.getProgramSource(position.getProgram());
        if (sqlProgramSource == null) {
            return null;
        }
        SqlProgramSource ps = sqlProgramSource;
        return OraVariableFinderFun.findVariables(ps, position.getProgram(), position.getLineNr());
    }

    @Nullable
    public final List<SqlVariable> findVariables(@NotNull VirtualFile virtualFile, int offset) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return (List)OracleDebugHelper.inReadAction((Function0)new Function0<List<SqlVariable>>(this, virtualFile, offset){
            final /* synthetic */ OraVariableFinder this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ int $offset;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                this.$offset = $offset;
                super(0);
            }

            @Nullable
            public final List<SqlVariable> invoke() {
                PsiFile psiFile = OraVariableFinder.access$getPsiManager$p(this.this$0).findFile(this.$virtualFile);
                if (psiFile == null) {
                    return null;
                }
                PsiFile psiFile2 = psiFile;
                SqlFile sqlFile = psiFile2 instanceof SqlFile ? (SqlFile)psiFile2 : null;
                if (sqlFile == null) {
                    return null;
                }
                SqlFile sqlFile2 = sqlFile;
                PsiElement psiElement = sqlFile2.findElementAt(this.$offset);
                if (psiElement == null) {
                    return null;
                }
                PsiElement positionElement = psiElement;
                List blocks = OraVariableFinderFun.access$findEnclosingBlocks(positionElement = OraVariableFinderFun.access$glueRight(positionElement));
                if (blocks.isEmpty()) {
                    return null;
                }
                List list = new ArrayList<E>();
                for (SqlBlockStatement block : blocks) {
                    OraVariableFinderFun.access$peekVariablesFromBlock((PsiElement)block, SqlVariableKind.LOCAL, list);
                }
                return list;
            }
        });
    }

    public static final /* synthetic */ PsiManager access$getPsiManager$p(OraVariableFinder $this) {
        return $this.psiManager;
    }
}

