/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import com.intellij.database.dialects.oracle.debugger.OraDebugController;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerFacade;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerSettings;
import com.intellij.database.dialects.oracle.model.OraObjectTypeRoutine;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.psi.SqlStatement;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0017J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerFacade;", "Lcom/intellij/database/debugger/SqlDebuggerFacade;", "()V", "canDebug", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "createController", "Lcom/intellij/database/debugger/SqlDebugController;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "consoleRequestOwner", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "scriptIsMeaningful", "scriptVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "virtualFile", "rangeMarker", "isApplicableToDebugRoutine", "routine", "Lcom/intellij/database/model/basic/BasicSourceAware;", "isApplicableToDebugStatement", "statement", "Lcom/intellij/sql/psi/SqlStatement;", "Companion", "intellij.database.dialects.oracle.ex"})
public final class OraDebuggerFacade
implements SqlDebuggerFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Set<IElementType>> applicableStatements$delegate = LazyKt.lazy((Function0)Companion.applicableStatements.2.INSTANCE);
    @NotNull
    private static final OraDebuggerSettings settings = new OraDebuggerSettings();

    @Override
    public boolean isApplicableToDebugStatement(@NotNull SqlStatement statement2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        return OraDebuggerFacade.Companion.getApplicableStatements().contains(PsiUtilBase.getElementType((PsiElement)((PsiElement)statement2)));
    }

    @Override
    public boolean isApplicableToDebugRoutine(@NotNull BasicSourceAware routine2) {
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        return routine2 instanceof OraRoutine && !(routine2 instanceof OraObjectTypeRoutine);
    }

    @Override
    public boolean canDebug(@NotNull LocalDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        String problem = OraConnectionHelperKt.checkForProblems(dataSource2);
        return problem == null;
    }

    @Override
    @NotNull
    public SqlDebugController createController(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseSessionClient consoleRequestOwner, boolean scriptIsMeaningful, @Nullable VirtualFile scriptVirtualFile, @Nullable RangeMarker scriptRangeMarker, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)consoleRequestOwner, (String)"consoleRequestOwner");
        return new OraDebugController(project, connectionPoint, consoleRequestOwner, scriptIsMeaningful, scriptVirtualFile, scriptRangeMarker, searchPath);
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    @NotNull
    public SqlDebugController createController(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DataRequest.OwnerEx consoleRequestOwner, boolean scriptIsMeaningful, @Nullable VirtualFile virtualFile, @Nullable RangeMarker rangeMarker, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)consoleRequestOwner, (String)"consoleRequestOwner");
        throw new AssertionError((Object)"Deprecated");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerFacade$Companion;", "", "()V", "applicableStatements", "", "Lcom/intellij/psi/tree/IElementType;", "getApplicableStatements", "()Ljava/util/Set;", "applicableStatements$delegate", "Lkotlin/Lazy;", "settings", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings;", "getSettings$intellij_database_dialects_oracle_ex", "()Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings;", "intellij.database.dialects.oracle.ex"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<IElementType> getApplicableStatements() {
            Lazy lazy = applicableStatements$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final OraDebuggerSettings getSettings$intellij_database_dialects_oracle_ex() {
            return settings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

