/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebugProcess;
import com.intellij.database.debugger.SqlDebuggerEditorsProvider;
import com.intellij.database.debugger.SqlProgramPosition;
import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.debugger.SqlProgramSourceKt;
import com.intellij.database.dialects.oracle.debugger.CodeFlowFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.ColumnFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.DebugCommand;
import com.intellij.database.dialects.oracle.debugger.DebuggerUnableException;
import com.intellij.database.dialects.oracle.debugger.DeregisterBreakpointCommand;
import com.intellij.database.dialects.oracle.debugger.EvaluateExpressionCommand;
import com.intellij.database.dialects.oracle.debugger.ExecuteFragmentCommand;
import com.intellij.database.dialects.oracle.debugger.FragmentInfo;
import com.intellij.database.dialects.oracle.debugger.GracefulResumeCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulRunToPositionInProgramCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulRunToPositionInScriptCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulStepOutCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulStepOverCommand;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import com.intellij.database.dialects.oracle.debugger.OraDebugController;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerFacade;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerUsageCollector;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingAbortedException;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingSession;
import com.intellij.database.dialects.oracle.debugger.OraExecutingSession;
import com.intellij.database.dialects.oracle.debugger.OraFragmentAnalyzer;
import com.intellij.database.dialects.oracle.debugger.OraLineBreakpointProperties;
import com.intellij.database.dialects.oracle.debugger.OraLineBreakpointType;
import com.intellij.database.dialects.oracle.debugger.OraPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramLineMapper;
import com.intellij.database.dialects.oracle.debugger.OraProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramPositionFile;
import com.intellij.database.dialects.oracle.debugger.OraProgramSources;
import com.intellij.database.dialects.oracle.debugger.OraRealLineBreakpoint;
import com.intellij.database.dialects.oracle.debugger.OraScriptPosition;
import com.intellij.database.dialects.oracle.debugger.OraStack;
import com.intellij.database.dialects.oracle.debugger.OraUnknownPosition;
import com.intellij.database.dialects.oracle.debugger.OraVariableFinder;
import com.intellij.database.dialects.oracle.debugger.OracleDebugHelper;
import com.intellij.database.dialects.oracle.debugger.PauseCommand;
import com.intellij.database.dialects.oracle.debugger.PauseReason;
import com.intellij.database.dialects.oracle.debugger.ProblematicResult;
import com.intellij.database.dialects.oracle.debugger.ProcessState;
import com.intellij.database.dialects.oracle.debugger.RegisterBreakpointCommand;
import com.intellij.database.dialects.oracle.debugger.Result;
import com.intellij.database.dialects.oracle.debugger.ResumeCommand;
import com.intellij.database.dialects.oracle.debugger.RunToPositionCommand;
import com.intellij.database.dialects.oracle.debugger.ScalarExpressionFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.StepIntoCommand;
import com.intellij.database.dialects.oracle.debugger.StepOutCommand;
import com.intellij.database.dialects.oracle.debugger.StepOverCommand;
import com.intellij.database.dialects.oracle.debugger.SteppingMode;
import com.intellij.database.dialects.oracle.debugger.StopCommand;
import com.intellij.database.dialects.oracle.debugger.SuccessfulResult;
import com.intellij.database.dialects.oracle.debugger.UnknownFragmentInfo;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 s2\u00020\u0001:\tstuvwxyz{BE\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020BH\u0016J\b\u0010D\u001a\u00020BH\u0016J\u001a\u0010E\u001a\u00020B2\u0010\u0010F\u001a\f\u0012\u0004\u0012\u00020*0)j\u0002`GH\u0002J\b\u0010H\u001a\u00020BH\u0002J\u0010\u0010I\u001a\u00020B2\u0006\u00107\u001a\u000208H\u0002J\u0016\u0010J\u001a\u00020B2\f\u00104\u001a\b\u0012\u0004\u0012\u00020$0KH\u0002J\b\u0010L\u001a\u00020BH\u0016J\u0016\u0010M\u001a\u00020B2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020B0OH\u0002J\u0010\u0010P\u001a\u00020Q2\u0006\u0010?\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020B2\u0006\u0010T\u001a\u00020\u0014H\u0016J\u000e\u0010U\u001a\u00020B2\u0006\u0010V\u001a\u00020WJ\b\u0010X\u001a\u00020BH\u0002J\b\u0010Y\u001a\u00020BH\u0002J\u0010\u0010Z\u001a\u00020B2\u0006\u00107\u001a\u000208H\u0002J\u001e\u0010[\u001a\u00020B2\f\u00104\u001a\b\u0012\u0004\u0012\u00020$0K2\u0006\u00107\u001a\u000208H\u0002J\b\u0010\\\u001a\u00020\u0014H\u0002J\u0016\u0010]\u001a\u00020^2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020$0KH\u0002J\b\u0010`\u001a\u00020BH\u0002J\b\u0010a\u001a\u00020BH\u0002J\"\u0010b\u001a\u00020B2\u0006\u0010c\u001a\u00020!2\u0006\u0010d\u001a\u00020e2\b\b\u0002\u0010f\u001a\u00020\tH\u0002J\u0018\u0010g\u001a\u00020B2\u0006\u0010h\u001a\u00020!2\u0006\u0010i\u001a\u00020!H\u0002J\u001a\u0010j\u001a\u00020B2\u0010\u0010F\u001a\f\u0012\u0004\u0012\u00020*0)j\u0002`GH\u0002J\u0010\u0010k\u001a\u00020B2\u0006\u00107\u001a\u000208H\u0002J\b\u0010l\u001a\u00020BH\u0002J\b\u0010m\u001a\u00020BH\u0002J\b\u0010n\u001a\u00020BH\u0002J\u0018\u0010o\u001a\u00020B2\u0006\u0010p\u001a\u0002082\u0006\u0010q\u001a\u000208H\u0002J\u0010\u0010r\u001a\u00020B2\u0006\u0010i\u001a\u00020!H\u0002R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u00060&R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010'\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)\u0012\u0004\u0012\u00020+0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u0002088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController;", "Lcom/intellij/database/debugger/SqlDebugController;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "consoleRequestOwner", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "scriptIsMeaningful", "", "scriptVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/console/client/DatabaseSessionClient;ZLcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/database/util/SearchPath;)V", "beginning", "debuggingConnectionRef", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "debuggingSession", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession;", "debuggingThread", "Ljava/lang/Thread;", "evaluator", "Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$Evaluator;", "executingSession", "Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;", "fragmentAnalyzer", "Lcom/intellij/database/dialects/oracle/debugger/OraFragmentAnalyzer;", "fusFinishSent", "initializationProblem", "", "initialized", "lastPosition", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "lineBreakpointHandler", "Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$OraLineBreakpointHandler;", "lineBreakpoints", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointProperties;", "Lcom/intellij/database/dialects/oracle/debugger/OraRealLineBreakpoint;", "lineMapper", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramLineMapper;", "pauseAtBegin", "requestOwner", "scriptFirstLineNr", "", "sources", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramSources;", "stack", "Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "startingUp", "state", "Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "getState", "()Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "steppingMode", "Lcom/intellij/database/dialects/oracle/debugger/SteppingMode;", "variableFinder", "Lcom/intellij/database/dialects/oracle/debugger/OraVariableFinder;", "xSession", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "close", "", "debugBegin", "debugEnd", "deregisterLineBreakpoint", "xbp", "Lcom/intellij/database/dialects/oracle/debugger/OraXLineBreakpoint;", "doOnStart", "doStateTransition", "doUpdateUI", "", "getReady", "inUI", "what", "Lkotlin/Function0;", "initLocal", "Lcom/intellij/xdebugger/XDebugProcess;", "Lcom/intellij/xdebugger/XDebugSession;", "initRemote", "executingConnection", "issueCommand", "command", "Lcom/intellij/database/dialects/oracle/debugger/DebugCommand;", "kickOffFinishing", "kickOffMainLoop", "mainLoopIteration", "notifyUpdateUI", "obtainDebuggingConnection", "obtainSuspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "stackPositions", "performFinishing", "performMainLoop", "print", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "eoln", "printTrace", "sourceName", "message", "registerLineBreakpoint", "reportFinished", "reset", "retrieveAdditionalData", "retrieveVariables", "stateTransition", "oldState", "newState", "trace", "Companion", "EmptySuspendedContext", "ErrorValue", "Evaluator", "OkValue", "OraDebugProcess", "OraLineBreakpointHandler", "ScalarValue", "SuspendedContext", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraDebugController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraDebugController.kt\ncom/intellij/database/dialects/oracle/debugger/OraDebugController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,722:1\n1#2:723\n*E\n"})
public final class OraDebugController
extends SqlDebugController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean fusFinishSent;
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseConnectionPoint connectionPoint;
    @NotNull
    private final DatabaseSessionClient requestOwner;
    @NotNull
    private final OraProgramLineMapper lineMapper;
    @NotNull
    private final SteppingMode steppingMode;
    private final boolean scriptIsMeaningful;
    @Nullable
    private final VirtualFile scriptVirtualFile;
    @Nullable
    private final RangeMarker scriptRangeMarker;
    private XDebugSessionImpl xSession;
    private OraExecutingSession executingSession;
    private OraDebuggingSession debuggingSession;
    private Thread debuggingThread;
    private boolean initialized;
    @Nullable
    private String initializationProblem;
    @Nullable
    private GuardedRef<DatabaseConnection> debuggingConnectionRef;
    private int scriptFirstLineNr;
    @NotNull
    private final OraLineBreakpointHandler lineBreakpointHandler;
    @NotNull
    private final Map<XLineBreakpoint<OraLineBreakpointProperties>, OraRealLineBreakpoint> lineBreakpoints;
    @NotNull
    private final OraProgramSources sources;
    @NotNull
    private final OraVariableFinder variableFinder;
    @NotNull
    private final OraFragmentAnalyzer fragmentAnalyzer;
    @Nullable
    private OraStack stack;
    @Nullable
    private OraPosition lastPosition;
    private boolean startingUp;
    private boolean beginning;
    private boolean pauseAtBegin;
    @NotNull
    private final Evaluator evaluator;
    @NotNull
    private static final OraLineBreakpointType xbpType;
    @NotNull
    private static final SqlDebuggerEditorsProvider myEditorsProvider;

    private final ProcessState getState() {
        ProcessState processState;
        if (this.debuggingSession != null) {
            OraDebuggingSession oraDebuggingSession = this.debuggingSession;
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession = null;
            }
            processState = oraDebuggingSession.getState();
        } else {
            processState = ProcessState.STATE_ASLEEP;
        }
        return processState;
    }

    public OraDebugController(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseSessionClient consoleRequestOwner, boolean scriptIsMeaningful, @Nullable VirtualFile scriptVirtualFile, @Nullable RangeMarker scriptRangeMarker, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)consoleRequestOwner, (String)"consoleRequestOwner");
        this.lineBreakpointHandler = new OraLineBreakpointHandler();
        this.lineBreakpoints = new ConcurrentHashMap();
        this.evaluator = new Evaluator();
        this.project = project;
        this.connectionPoint = connectionPoint;
        this.requestOwner = consoleRequestOwner;
        this.lineMapper = new OraProgramLineMapper();
        this.scriptIsMeaningful = scriptIsMeaningful;
        this.scriptVirtualFile = scriptVirtualFile;
        this.scriptRangeMarker = scriptRangeMarker;
        LocalDataSource localDataSource = connectionPoint.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        this.sources = new OraProgramSources(project, localDataSource);
        this.variableFinder = new OraVariableFinder(project, this.sources);
        this.fragmentAnalyzer = new OraFragmentAnalyzer(project, connectionPoint.getDataSource(), searchPath);
        this.steppingMode = scriptIsMeaningful ? OraDebuggerFacade.Companion.getSettings$intellij_database_dialects_oracle_ex().getSteppingMode() : SteppingMode.STEPPING_GRACEFUL;
    }

    private final void reset() {
        this.stack = null;
        this.startingUp = false;
        this.fusFinishSent = false;
        this.pauseAtBegin = OraDebuggerFacade.Companion.getSettings$intellij_database_dialects_oracle_ex().getSteppingPauseAtBegin();
        this.lastPosition = null;
    }

    @Override
    public void getReady() {
        boolean bl;
        OraDebuggerUsageCollector.INSTANCE.logStarted(this.project, this.steppingMode);
        boolean bl2 = bl = this.xSession != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.reset();
    }

    @Override
    @NotNull
    public XDebugProcess initLocal(@NotNull XDebugSession xSession) {
        Intrinsics.checkNotNullParameter((Object)xSession, (String)"xSession");
        boolean bl = xSession instanceof XDebugSessionImpl;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.xSession = (XDebugSessionImpl)xSession;
        XDebuggerManager.getInstance((Project)this.project).getBreakpointManager().addBreakpointListener((XBreakpointType)xbpType, (XBreakpointListener)this.lineBreakpointHandler);
        xSession.setPauseActionSupported(this.steppingMode == SteppingMode.STEPPING_GRACEFUL);
        RangeMarker rangeMarker = this.scriptRangeMarker;
        this.scriptFirstLineNr = rangeMarker != null && (rangeMarker = rangeMarker.getDocument()) != null ? rangeMarker.getLineNumber(this.scriptRangeMarker.getStartOffset()) : 0;
        return new OraDebugProcess(xSession);
    }

    @Override
    public void initRemote(@NotNull DatabaseConnection executingConnection) {
        OraDebuggingSession oraDebuggingSession;
        Intrinsics.checkNotNullParameter((Object)executingConnection, (String)"executingConnection");
        if (this.initialized) {
            return;
        }
        try {
            OraDebuggingSession oraDebuggingSession2;
            this.executingSession = new OraExecutingSession(executingConnection, this.requestOwner);
            OraExecutingSession oraExecutingSession = this.executingSession;
            if (oraExecutingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
                oraExecutingSession = null;
            }
            oraExecutingSession.setTraceConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ OraDebugController this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String message2) {
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    OraDebugController.access$printTrace(this.this$0, "Executing", message2);
                }
            }));
            OraExecutingSession oraExecutingSession2 = this.executingSession;
            if (oraExecutingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
                oraExecutingSession2 = null;
            }
            oraExecutingSession2.initRemote();
            OraExecutingSession oraExecutingSession3 = this.executingSession;
            if (oraExecutingSession3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
                oraExecutingSession3 = null;
            }
            oraExecutingSession3.makeSessionDebuggable();
            DatabaseConnection debuggingConnection = this.obtainDebuggingConnection();
            OraExecutingSession oraExecutingSession4 = this.executingSession;
            if (oraExecutingSession4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
                oraExecutingSession4 = null;
            }
            if ((oraDebuggingSession2 = (this.debuggingSession = new OraDebuggingSession(debuggingConnection, oraExecutingSession4, this.scriptIsMeaningful))) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession2 = null;
            }
            oraDebuggingSession2.setDbmsOutputConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ OraDebugController this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String s2) {
                    Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                    ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                    Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
                    OraDebugController.print$default(this.this$0, s2, consoleViewContentType, false, 4, null);
                }
            }));
            OraDebuggingSession oraDebuggingSession3 = this.debuggingSession;
            if (oraDebuggingSession3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession3 = null;
            }
            oraDebuggingSession3.setTraceConsumer((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ OraDebugController this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String message2) {
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    OraDebugController.access$printTrace(this.this$0, "Debugging", message2);
                }
            }));
            OraDebuggingSession oraDebuggingSession4 = this.debuggingSession;
            if (oraDebuggingSession4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession4 = null;
            }
            oraDebuggingSession4.initRemote();
            OraDebuggingSession oraDebuggingSession5 = this.debuggingSession;
            if (oraDebuggingSession5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession5 = null;
            }
            oraDebuggingSession5.setOnMainLoopIteration$intellij_database_dialects_oracle_ex((Function1<? super ProcessState, Unit>)((Function1)new Function1<ProcessState, Unit>((Object)this){

                public final void invoke(@NotNull ProcessState p0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                    OraDebugController.access$mainLoopIteration((OraDebugController)this.receiver, p0);
                }
            }));
            OraDebuggingSession oraDebuggingSession6 = this.debuggingSession;
            if (oraDebuggingSession6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession6 = null;
            }
            oraDebuggingSession6.setOnStateTransition$intellij_database_dialects_oracle_ex((Function2<? super ProcessState, ? super ProcessState, Unit>)((Function2)new Function2<ProcessState, ProcessState, Unit>((Object)this){

                public final void invoke(@NotNull ProcessState p0, @NotNull ProcessState p1) {
                    Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                    OraDebugController.access$stateTransition((OraDebugController)this.receiver, p0, p1);
                }
            }));
            OraDebuggingSession oraDebuggingSession7 = this.debuggingSession;
            if (oraDebuggingSession7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession7 = null;
            }
            oraDebuggingSession7.setOnEventInfo$intellij_database_dialects_oracle_ex((Function2<? super List<? extends OraPosition>, ? super ProcessState, Unit>)((Function2)new Function2<List<? extends OraPosition>, ProcessState, Unit>((Object)this){

                public final void invoke(@NotNull List<? extends OraPosition> p0, @NotNull ProcessState p1) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                    OraDebugController.access$notifyUpdateUI((OraDebugController)this.receiver, p0, p1);
                }
            }));
            OraDebuggingSession oraDebuggingSession8 = this.debuggingSession;
            if (oraDebuggingSession8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession8 = null;
            }
            oraDebuggingSession8.setOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle_ex((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    OraDebugController.access$retrieveAdditionalData((OraDebugController)this.receiver);
                }
            }));
        }
        catch (DebuggerUnableException due) {
            this.initializationProblem = due.getMessage();
            this.initialized = false;
        }
        catch (Throwable e2) {
            this.initializationProblem = e2.getMessage();
            this.initialized = false;
            if (this.xSession != null) {
                XDebugSessionImpl xDebugSessionImpl = this.xSession;
                if (xDebugSessionImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                    xDebugSessionImpl = null;
                }
                xDebugSessionImpl.stop();
            }
            throw e2;
        }
        if ((oraDebuggingSession = this.debuggingSession) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        this.initialized = oraDebuggingSession.getAttached();
        this.initializationProblem = null;
    }

    private final DatabaseConnection obtainDebuggingConnection() {
        GuardedRef<DatabaseConnection> connectionRef = OraConnectionHelperKt.obtainGuardedConnection(this.project, this.connectionPoint, DGDepartment.DEBUGGER);
        this.debuggingConnectionRef = connectionRef;
        DatabaseConnection databaseConnection = connectionRef.get();
        Intrinsics.checkNotNullExpressionValue((Object)databaseConnection, (String)"get(...)");
        return databaseConnection;
    }

    @Override
    public void debugBegin() {
        if (!this.initialized) {
            Throwable throwable;
            String string = this.initializationProblem;
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                throwable = new OraDebuggingAbortedException(p0);
            } else {
                throwable = new IllegalStateException("OracleDebugController is not initialized");
            }
            throw throwable;
        }
        if (this.xSession == null) {
            throw new IllegalStateException("An XDebugSession instance was not assigned");
        }
        this.startingUp = true;
        if (this.getState() == ProcessState.STATE_ASLEEP) {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
            OraDebugController.print$default(this, "Starting Debugger\u2026", consoleViewContentType, false, 4, null);
            this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ OraDebugController this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    XDebugSessionImpl xDebugSessionImpl = OraDebugController.access$getXSession$p(this.this$0);
                    if (xDebugSessionImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                        xDebugSessionImpl = null;
                    }
                    xDebugSessionImpl.getConsoleView();
                }
            }));
        } else {
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
            OraDebugController.print$default(this, "Restarting Debugger\u2026", consoleViewContentType, false, 4, null);
            OraDebuggingSession oraDebuggingSession = this.debuggingSession;
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession = null;
            }
            oraDebuggingSession.resetState();
            XDebugSessionImpl xDebugSessionImpl = this.xSession;
            if (xDebugSessionImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                xDebugSessionImpl = null;
            }
            xDebugSessionImpl.reset();
            this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ OraDebugController this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    XDebugSessionImpl xDebugSessionImpl = OraDebugController.access$getXSession$p(this.this$0);
                    if (xDebugSessionImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                        xDebugSessionImpl = null;
                    }
                    xDebugSessionImpl.rebuildViews();
                }
            }));
        }
        this.kickOffMainLoop();
        OraExecutingSession oraExecutingSession = this.executingSession;
        if (oraExecutingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            oraExecutingSession = null;
        }
        oraExecutingSession.turnDebugON(false);
        OraExecutingSession oraExecutingSession2 = this.executingSession;
        if (oraExecutingSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            oraExecutingSession2 = null;
        }
        oraExecutingSession2.executionBegin$intellij_database_dialects_oracle_ex();
    }

    @Override
    public void debugEnd() {
        OraExecutingSession oraExecutingSession = this.executingSession;
        if (oraExecutingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            oraExecutingSession = null;
        }
        boolean executionWasActive = oraExecutingSession.getExecuting();
        OraExecutingSession oraExecutingSession2 = this.executingSession;
        if (oraExecutingSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
            oraExecutingSession2 = null;
        }
        oraExecutingSession2.executionEnded$intellij_database_dialects_oracle_ex();
        if (executionWasActive) {
            this.trace("Waiting the debugging thread to complete");
            OraDebuggingSession oraDebuggingSession = this.debuggingSession;
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession = null;
            }
            oraDebuggingSession.completeTheProcess();
            Thread thread = this.debuggingThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                thread = null;
            }
            thread.join();
        }
        this.trace("Stopping the debugger");
        if (this.initialized) {
            OraExecutingSession oraExecutingSession3 = this.executingSession;
            if (oraExecutingSession3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
                oraExecutingSession3 = null;
            }
            if (oraExecutingSession3.getUnderDebug()) {
                this.kickOffFinishing();
                OraExecutingSession oraExecutingSession4 = this.executingSession;
                if (oraExecutingSession4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
                    oraExecutingSession4 = null;
                }
                oraExecutingSession4.turnDebugOFF();
            }
        }
        if (this.debuggingThread != null) {
            Thread thread = this.debuggingThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                thread = null;
            }
            thread.join();
        }
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        OraDebugController.print$default(this, "Debugger is stopped.", consoleViewContentType, false, 4, null);
    }

    @Override
    public void close() {
        GuardedRef<DatabaseConnection> connectionRef;
        this.trace("Closing the debugger");
        if (this.xSession != null) {
            XDebugSessionImpl xDebugSessionImpl = this.xSession;
            if (xDebugSessionImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                xDebugSessionImpl = null;
            }
            xDebugSessionImpl.stop();
        }
        XDebuggerManager.getInstance((Project)this.project).getBreakpointManager().removeBreakpointListener((XBreakpointType)xbpType, (XBreakpointListener)this.lineBreakpointHandler);
        if (this.debuggingThread != null) {
            Thread thread = this.debuggingThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                thread = null;
            }
            if (thread.isAlive()) {
                this.issueCommand(StopCommand.INSTANCE);
                Thread thread2 = this.debuggingThread;
                if (thread2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                    thread2 = null;
                }
                thread2.join(5000L);
                Thread thread3 = this.debuggingThread;
                if (thread3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
                    thread3 = null;
                }
                if (thread3.isAlive()) {
                    throw new RuntimeException("Failed to stop the debugging process (current state: " + this.getState() + ")");
                }
            }
        }
        this.initialized = false;
        if (this.debuggingSession != null) {
            OraDebuggingSession oraDebuggingSession = this.debuggingSession;
            if (oraDebuggingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession = null;
            }
            oraDebuggingSession.close();
        }
        if (this.executingSession != null) {
            OraExecutingSession oraExecutingSession = this.executingSession;
            if (oraExecutingSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executingSession");
                oraExecutingSession = null;
            }
            oraExecutingSession.close();
        }
        if ((connectionRef = this.debuggingConnectionRef) != null) {
            connectionRef.close();
            this.debuggingConnectionRef = null;
        }
        this.trace("Debugger is closed.");
    }

    private final void kickOffMainLoop() {
        boolean bl;
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        boolean bl2 = bl = !oraDebuggingSession.getProcessIsActive();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            OraDebuggingSession oraDebuggingSession2 = this.debuggingSession;
            if (oraDebuggingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession2 = null;
            }
            String string = "Attempting start debugging when already is active (state: " + oraDebuggingSession2.getState() + ")";
            throw new AssertionError((Object)string);
        }
        this.debuggingThread = new Thread(this::performMainLoop, "Oracle Debugging");
        Thread thread = this.debuggingThread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
            thread = null;
        }
        thread.start();
        Thread.sleep(10L);
    }

    private final void performMainLoop() {
        this.beginning = true;
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        oraDebuggingSession.performMainLoop();
    }

    private final void kickOffFinishing() {
        Thread thread;
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        if (oraDebuggingSession.getProcessIsActive()) {
            OraDebuggingSession oraDebuggingSession2 = this.debuggingSession;
            if (oraDebuggingSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession2 = null;
            }
            oraDebuggingSession2.abortTheProcess();
        }
        if ((thread = (this.debuggingThread = new Thread(this::performFinishing, "Oracle Debugging (finishing)"))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingThread");
            thread = null;
        }
        thread.start();
        Thread.sleep(10L);
    }

    private final void performFinishing() {
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        oraDebuggingSession.performFinishLoop();
    }

    public final void issueCommand(@NotNull DebugCommand command2) {
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        oraDebuggingSession.issueCommand(command2);
    }

    private final void mainLoopIteration(ProcessState state) {
        OraDebuggingSession oraDebuggingSession;
        OraDebuggingSession oraDebuggingSession2;
        boolean working;
        boolean bl = working = state.compareTo((Enum)ProcessState.STATE_STARTING_UP) >= 0 && state.compareTo((Enum)ProcessState.STATE_COMPLETING) < 0;
        if (this.startingUp && working) {
            this.doOnStart();
        }
        if ((oraDebuggingSession2 = this.debuggingSession) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession2 = null;
        }
        int stackDepth = oraDebuggingSession2.getStackDepth();
        if (!this.scriptIsMeaningful && stackDepth < 2) {
            this.issueCommand(StepIntoCommand.INSTANCE);
        }
        if ((oraDebuggingSession = this.debuggingSession) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        if (oraDebuggingSession.getReason() == PauseReason.REASON_BREAKPOINT) {
            this.beginning = false;
        }
        if (this.beginning) {
            OraDebuggingSession oraDebuggingSession3 = this.debuggingSession;
            if (oraDebuggingSession3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                oraDebuggingSession3 = null;
            }
            if (oraDebuggingSession3.goingToRelax() && stackDepth > 0) {
                if (this.pauseAtBegin) {
                    this.pauseAtBegin = false;
                } else {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.steppingMode.ordinal()]) {
                        case 1: {
                            this.issueCommand(GracefulResumeCommand.INSTANCE);
                            break;
                        }
                        case 2: {
                            this.issueCommand(ResumeCommand.INSTANCE);
                        }
                    }
                }
                this.beginning = false;
            }
        }
    }

    private final void doOnStart() {
        ApplicationManager.getApplication().runReadAction(() -> OraDebugController.doOnStart$lambda$1(this));
        String string = this.steppingMode.getDisplayName().get();
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        String string2 = "Debugger started in " + string + " mode. Probe version: " + oraDebuggingSession.getProbeVersion();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.SYSTEM_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"SYSTEM_OUTPUT");
        OraDebugController.print$default(this, string2, consoleViewContentType, false, 4, null);
        this.startingUp = false;
    }

    private final void registerLineBreakpoint(XLineBreakpoint<OraLineBreakpointProperties> xbp) {
        Ref.ObjectRef bp = new Ref.ObjectRef();
        bp.element = this.lineBreakpoints.get(xbp);
        if (bp.element == null) {
            Result<OraRealLineBreakpoint> r;
            VirtualFile virtualFile = this.scriptVirtualFile;
            Result<OraRealLineBreakpoint> result2 = r = Intrinsics.areEqual((Object)xbp.getFileUrl(), (Object)(virtualFile != null ? virtualFile.getUrl() : null)) ? OracleDebugHelper.prepareScriptLineBreakpoint(xbp, this.scriptFirstLineNr) : OracleDebugHelper.prepareProgramLineBreakpoint(xbp, this.project, this.lineMapper);
            if (!(r instanceof SuccessfulResult)) {
                this.trace("Failed to prepare line breakpoint: " + r.getProblem());
                return;
            }
            bp.element = ((SuccessfulResult)r).getValue();
            this.lineBreakpoints.put(xbp, (OraRealLineBreakpoint)bp.element);
        }
        try {
            RegisterBreakpointCommand command2 = new RegisterBreakpointCommand((OraRealLineBreakpoint)bp.element, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<OraRealLineBreakpoint>)bp, this){
                final /* synthetic */ Ref.ObjectRef<OraRealLineBreakpoint> $bp;
                final /* synthetic */ OraDebugController this$0;
                {
                    this.$bp = $bp;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (((OraRealLineBreakpoint)this.$bp.element).getActive()) {
                        XDebugSessionImpl xDebugSessionImpl = OraDebugController.access$getXSession$p(this.this$0);
                        if (xDebugSessionImpl == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                            xDebugSessionImpl = null;
                        }
                        xDebugSessionImpl.setBreakpointVerified(((OraRealLineBreakpoint)this.$bp.element).getXBreakpoint());
                    } else if (!((OraRealLineBreakpoint)this.$bp.element).getAppropriate()) {
                        XDebugSessionImpl xDebugSessionImpl = OraDebugController.access$getXSession$p(this.this$0);
                        if (xDebugSessionImpl == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                            xDebugSessionImpl = null;
                        }
                        xDebugSessionImpl.setBreakpointInvalid(((OraRealLineBreakpoint)this.$bp.element).getXBreakpoint(), ((OraRealLineBreakpoint)this.$bp.element).getProblem());
                    }
                }
            }));
            this.issueCommand(command2);
        }
        catch (Exception e2) {
            String problemMessage = "Problem preparing breakpoint " + bp.element + ": " + e2.getClass().getSimpleName() + ": " + e2.getMessage();
            this.trace(problemMessage);
            XDebugSessionImpl xDebugSessionImpl = this.xSession;
            if (xDebugSessionImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                xDebugSessionImpl = null;
            }
            xDebugSessionImpl.setBreakpointInvalid(((OraRealLineBreakpoint)bp.element).getXBreakpoint(), problemMessage);
        }
    }

    private final void deregisterLineBreakpoint(XLineBreakpoint<OraLineBreakpointProperties> xbp) {
        OraRealLineBreakpoint oraRealLineBreakpoint = this.lineBreakpoints.get(xbp);
        if (oraRealLineBreakpoint == null) {
            return;
        }
        OraRealLineBreakpoint bp = oraRealLineBreakpoint;
        DeregisterBreakpointCommand command2 = new DeregisterBreakpointCommand(bp, (Function0<Unit>)((Function0)deregisterLineBreakpoint.command.1.INSTANCE));
        this.issueCommand(command2);
    }

    private final void retrieveAdditionalData() {
        this.retrieveVariables();
    }

    private final void retrieveVariables() {
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        if (oraDebuggingSession.getStackDepth() == 0) {
            return;
        }
        OraStack oraStack = this.stack;
        if (oraStack == null || (oraStack = oraStack.getTopFrame()) == null) {
            return;
        }
        OraStack topFrame = oraStack;
    }

    private final void inUI(Function0<Unit> what) {
        ApplicationManager.getApplication().invokeLater(() -> OraDebugController.inUI$lambda$2(what));
    }

    private final void trace(String message2) {
        this.printTrace("Controller", message2);
    }

    private final void printTrace(String sourceName, String message2) {
        if (Registry.is((String)"database.debug.trace")) {
            String string = sourceName + ": ";
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"LOG_DEBUG_OUTPUT");
            this.print(string, consoleViewContentType, false);
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.LOG_VERBOSE_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"LOG_VERBOSE_OUTPUT");
            this.print(message2, consoleViewContentType2, true);
        }
    }

    private final void print(String text2, ConsoleViewContentType contentType, boolean eoln) {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this, text2, contentType, eoln){
            final /* synthetic */ OraDebugController this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ ConsoleViewContentType $contentType;
            final /* synthetic */ boolean $eoln;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                this.$contentType = $contentType;
                this.$eoln = $eoln;
                super(0);
            }

            public final void invoke() {
                ConsoleView consoleView;
                if (OraDebugController.access$getXSession$p(this.this$0) != null) {
                    XDebugSessionImpl xDebugSessionImpl = OraDebugController.access$getXSession$p(this.this$0);
                    if (xDebugSessionImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                        xDebugSessionImpl = null;
                    }
                    v1 = xDebugSessionImpl.getConsoleView();
                } else {
                    v1 = consoleView = null;
                }
                if (consoleView != null) {
                    consoleView.print(this.$text, this.$contentType);
                    if (this.$eoln) {
                        consoleView.print("\n", this.$contentType);
                    }
                } else {
                    System.out.print((Object)(this.$text + (this.$eoln ? "\n" : "")));
                }
            }
        }));
    }

    static /* synthetic */ void print$default(OraDebugController oraDebugController, String string, ConsoleViewContentType consoleViewContentType, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        oraDebugController.print(string, consoleViewContentType, bl);
    }

    private final void stateTransition(ProcessState oldState, ProcessState newState) {
        this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this, newState){
            final /* synthetic */ OraDebugController this$0;
            final /* synthetic */ ProcessState $newState;
            {
                this.this$0 = $receiver;
                this.$newState = $newState;
                super(0);
            }

            public final void invoke() {
                OraDebugController.access$doStateTransition(this.this$0, this.$newState);
            }
        }));
    }

    private final void doStateTransition(ProcessState state) {
        XDebugSessionImpl xDebugSessionImpl;
        switch (WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                XDebugSessionImpl xDebugSessionImpl2 = this.xSession;
                if (xDebugSessionImpl2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                    xDebugSessionImpl2 = null;
                }
                xDebugSessionImpl2.sessionResumed();
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                XDebugSessionImpl xDebugSessionImpl3 = this.xSession;
                if (xDebugSessionImpl3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                    xDebugSessionImpl3 = null;
                }
                xDebugSessionImpl3.sessionResumed();
                break;
            }
            case 6: 
            case 7: {
                XDebugSessionImpl xDebugSessionImpl4 = this.xSession;
                if (xDebugSessionImpl4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                    xDebugSessionImpl4 = null;
                }
                xDebugSessionImpl4.sessionResumed();
                break;
            }
            case 8: 
            case 9: {
                XDebugSessionImpl xDebugSessionImpl5 = this.xSession;
                if (xDebugSessionImpl5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                    xDebugSessionImpl5 = null;
                }
                xDebugSessionImpl5.sessionResumed();
                this.reportFinished(state);
                break;
            }
            case 10: 
            case 11: {
                this.reportFinished(state);
            }
        }
        if ((xDebugSessionImpl = this.xSession) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
            xDebugSessionImpl = null;
        }
        xDebugSessionImpl.setPauseActionSupported(this.steppingMode == SteppingMode.STEPPING_GRACEFUL && state == ProcessState.STATE_RUNNING);
    }

    private final void reportFinished(ProcessState state) {
        if (!this.fusFinishSent) {
            OraDebuggerUsageCollector.INSTANCE.logFinished(this.project, state);
            this.fusFinishSent = true;
        }
    }

    private final void notifyUpdateUI(List<? extends OraPosition> stack, ProcessState state) {
        OraPosition currentPosition;
        if (state.isInteractive() && !Intrinsics.areEqual((Object)(currentPosition = (OraPosition)CollectionsKt.firstOrNull(stack)), (Object)this.lastPosition)) {
            this.lastPosition = currentPosition;
            this.inUI((Function0<Unit>)((Function0)new Function0<Unit>(this, stack){
                final /* synthetic */ OraDebugController this$0;
                final /* synthetic */ List<OraPosition> $stack;
                {
                    this.this$0 = $receiver;
                    this.$stack = $stack;
                    super(0);
                }

                public final void invoke() {
                    OraDebugController.access$doUpdateUI(this.this$0, this.$stack);
                }
            }));
        }
    }

    private final void doUpdateUI(List<? extends OraPosition> stack) {
        XSuspendContext suspendContext = this.obtainSuspendContext(stack);
        XDebugSessionImpl xDebugSessionImpl = this.xSession;
        if (xDebugSessionImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
            xDebugSessionImpl = null;
        }
        xDebugSessionImpl.positionReached(suspendContext);
        if (!Intrinsics.areEqual((Object)suspendContext, (Object)((Object)EmptySuspendedContext.INSTANCE))) {
            XDebugSessionImpl xDebugSessionImpl2 = this.xSession;
            if (xDebugSessionImpl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
                xDebugSessionImpl2 = null;
            }
            xDebugSessionImpl2.showExecutionPoint();
        }
    }

    private final XSuspendContext obtainSuspendContext(List<? extends OraPosition> stackPositions) {
        OraDebuggingSession oraDebuggingSession = this.debuggingSession;
        if (oraDebuggingSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
            oraDebuggingSession = null;
        }
        OraStack stack = new OraStack(this.variableFinder, oraDebuggingSession, this.evaluator);
        int k = stackPositions.size();
        for (OraPosition oraPosition : stackPositions) {
            OraPosition oraPosition2 = oraPosition;
            if (oraPosition2 instanceof OraScriptPosition) {
                VirtualFile svf = this.scriptVirtualFile;
                if (svf != null) {
                    XSourcePosition x = SqlProgramSourceKt.createVirtualFilePosition(svf, this.scriptFirstLineNr + oraPosition.getLineNr() - 1);
                    stack.makeScriptFrame(k, (OraScriptPosition)oraPosition, x);
                } else {
                    stack.makeRoutineWrapperFrame(k, oraPosition);
                }
            } else if (oraPosition2 instanceof OraProgramPosition) {
                SqlProgramPosition programPosition;
                SqlProgramSource source;
                SqlProgramSource sqlProgramSource = source = this.sources.getProgramSource(((OraProgramPosition)oraPosition).getProgram());
                int fileLine = this.lineMapper.mapOraToFile(sqlProgramSource != null ? sqlProgramSource.getModelElement() : null, oraPosition.getLineNr());
                SqlProgramPosition sqlProgramPosition = programPosition = source != null ? new SqlProgramPosition(source, fileLine) : null;
                if (programPosition != null) {
                    stack.makeProgramFrame(k, (OraProgramPosition)oraPosition, programPosition);
                } else {
                    stack.makeUnknownFrame(k, oraPosition);
                }
            } else if (oraPosition2 instanceof OraUnknownPosition) {
                stack.makeUnknownFrame(k, oraPosition);
            }
            --k;
        }
        this.stack = stack;
        return new SuspendedContext(stack);
    }

    private static final void doOnStart$lambda$1(OraDebugController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        XDebugSessionImpl xDebugSessionImpl = this$0.xSession;
        if (xDebugSessionImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"xSession");
            xDebugSessionImpl = null;
        }
        xDebugSessionImpl.initBreakpoints();
    }

    private static final void inUI$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ void access$printTrace(OraDebugController $this, String sourceName, String message2) {
        $this.printTrace(sourceName, message2);
    }

    public static final /* synthetic */ void access$mainLoopIteration(OraDebugController $this, ProcessState state) {
        $this.mainLoopIteration(state);
    }

    public static final /* synthetic */ void access$stateTransition(OraDebugController $this, ProcessState oldState, ProcessState newState) {
        $this.stateTransition(oldState, newState);
    }

    public static final /* synthetic */ void access$notifyUpdateUI(OraDebugController $this, List stack, ProcessState state) {
        $this.notifyUpdateUI(stack, state);
    }

    public static final /* synthetic */ void access$retrieveAdditionalData(OraDebugController $this) {
        $this.retrieveAdditionalData();
    }

    public static final /* synthetic */ XDebugSessionImpl access$getXSession$p(OraDebugController $this) {
        return $this.xSession;
    }

    public static final /* synthetic */ void access$doStateTransition(OraDebugController $this, ProcessState state) {
        $this.doStateTransition(state);
    }

    public static final /* synthetic */ void access$doUpdateUI(OraDebugController $this, List stack) {
        $this.doUpdateUI(stack);
    }

    static {
        OraLineBreakpointType oraLineBreakpointType = (OraLineBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(OraLineBreakpointType.class));
        if (oraLineBreakpointType == null) {
            throw new IllegalStateException(("Cannot get the breakpoint type (class: " + OraLineBreakpointType.class.getSimpleName() + ")").toString());
        }
        xbpType = oraLineBreakpointType;
        myEditorsProvider = new SqlDebuggerEditorsProvider(OraDialect.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$Companion;", "", "()V", "myEditorsProvider", "Lcom/intellij/database/debugger/SqlDebuggerEditorsProvider;", "xbpType", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointType;", "intellij.database.dialects.oracle.ex"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$EmptySuspendedContext;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "()V", "intellij.database.dialects.oracle.ex"})
    private static final class EmptySuspendedContext
    extends XSuspendContext {
        @NotNull
        public static final EmptySuspendedContext INSTANCE = new EmptySuspendedContext();

        private EmptySuspendedContext() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$ErrorValue;", "Lcom/intellij/xdebugger/frame/XValue;", "problem", "", "(Ljava/lang/String;)V", "getProblem", "()Ljava/lang/String;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.database.dialects.oracle.ex"})
    private static final class ErrorValue
    extends XValue {
        @NotNull
        private final String problem;

        public ErrorValue(@NotNull String problem) {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            this.problem = problem;
        }

        @NotNull
        public final String getProblem() {
            return this.problem;
        }

        public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node2.setPresentation(null, null, this.problem, false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$Evaluator;", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "(Lcom/intellij/database/dialects/oracle/debugger/OraDebugController;)V", "evaluate", "", "fragment", "", "callback", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "isCodeFragmentEvaluationSupported", "", "intellij.database.dialects.oracle.ex"})
    private final class Evaluator
    extends XDebuggerEvaluator {
        public void evaluate(@NotNull String fragment, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
            FragmentInfo info2;
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            FragmentInfo fragmentInfo = info2 = OraDebugController.this.fragmentAnalyzer.analyze(fragment);
            if (fragmentInfo instanceof ScalarExpressionFragmentInfo) {
                OraDebugController.this.trace("Asked to evaluate: " + fragment + " at position " + expressionPosition + ", type " + info2);
                EvaluateExpressionCommand command2 = new EvaluateExpressionCommand(fragment, info2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(callback){
                    final /* synthetic */ XDebuggerEvaluator.XEvaluationCallback $callback;
                    {
                        this.$callback = $callback;
                        super(1);
                    }

                    public final void invoke(@NotNull String it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        this.$callback.evaluated((XValue)new ScalarValue(it2));
                    }
                }));
                OraDebuggingSession oraDebuggingSession = OraDebugController.this.debuggingSession;
                if (oraDebuggingSession == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                    oraDebuggingSession = null;
                }
                oraDebuggingSession.issueCommand(command2);
            } else if (fragmentInfo instanceof ColumnFragmentInfo) {
                callback.evaluated((XValue)new ErrorValue("ColumnFragment: not implemented yet"));
            } else if (fragmentInfo instanceof CodeFlowFragmentInfo) {
                ExecuteFragmentCommand command3 = new ExecuteFragmentCommand(fragment, info2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(callback){
                    final /* synthetic */ XDebuggerEvaluator.XEvaluationCallback $callback;
                    {
                        this.$callback = $callback;
                        super(1);
                    }

                    public final void invoke(@NotNull String it2) {
                        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                        this.$callback.evaluated((XValue)new OkValue(it2));
                    }
                }));
                OraDebuggingSession oraDebuggingSession = OraDebugController.this.debuggingSession;
                if (oraDebuggingSession == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                    oraDebuggingSession = null;
                }
                oraDebuggingSession.issueCommand(command3);
            } else if (fragmentInfo instanceof UnknownFragmentInfo) {
                String problem = "Unknown how to parse this expression.";
                callback.evaluated((XValue)new ErrorValue(problem));
            }
        }

        public boolean isCodeFragmentEvaluationSupported() {
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$OkValue;", "Lcom/intellij/xdebugger/frame/XValue;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.database.dialects.oracle.ex"})
    private static final class OkValue
    extends XValue {
        @NotNull
        private final String message;

        public OkValue(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.message = message2;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node2.setPresentation(null, null, this.message, false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0017\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u001c\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\u0012\u0010\u001e\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u001f\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010 \u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010!\u001a\u00020\u0011H\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$OraDebugProcess;", "Lcom/intellij/database/debugger/SqlDebugProcess;", "xSession", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/database/dialects/oracle/debugger/OraDebugController;Lcom/intellij/xdebugger/XDebugSession;)V", "checkCanInitBreakpoints", "", "checkCanPerformCommands", "getBreakpointHandlers", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "getEditorsProvider", "Lcom/intellij/database/debugger/SqlDebuggerEditorsProvider;", "getEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "registerAdditionalActions", "", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "resume", "context", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "runToPosition", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "startForceStepInto", "startPausing", "startStepInto", "startStepOut", "startStepOver", "stop", "intellij.database.dialects.oracle.ex"})
    @SourceDebugExtension(value={"SMAP\nOraDebugController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraDebugController.kt\ncom/intellij/database/dialects/oracle/debugger/OraDebugController$OraDebugProcess\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,722:1\n14#2:723\n*S KotlinDebug\n*F\n+ 1 OraDebugController.kt\ncom/intellij/database/dialects/oracle/debugger/OraDebugController$OraDebugProcess\n*L\n482#1:723\n*E\n"})
    public final class OraDebugProcess
    extends SqlDebugProcess {
        public OraDebugProcess(XDebugSession xSession) {
            Intrinsics.checkNotNullParameter((Object)xSession, (String)"xSession");
            super(xSession);
        }

        public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
            Intrinsics.checkNotNullParameter((Object)leftToolbar, (String)"leftToolbar");
            Intrinsics.checkNotNullParameter((Object)topToolbar, (String)"topToolbar");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        }

        @NotNull
        public SqlDebuggerEditorsProvider getEditorsProvider() {
            return myEditorsProvider;
        }

        public void startStepInto(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OraDebugController.this.issueCommand(StepIntoCommand.INSTANCE);
            }
        }

        public void startForceStepInto(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                OraDebugController.this.issueCommand(StepIntoCommand.INSTANCE);
            }
        }

        public void startStepOver(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                switch (WhenMappings.$EnumSwitchMapping$0[OraDebugController.this.steppingMode.ordinal()]) {
                    case 1: {
                        OraPosition firstStackPosition;
                        OraDebuggingSession oraDebuggingSession = OraDebugController.this.debuggingSession;
                        if (oraDebuggingSession == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                            oraDebuggingSession = null;
                        }
                        if ((firstStackPosition = (OraPosition)CollectionsKt.firstOrNull(oraDebuggingSession.getStack())) != null) {
                            OraDebuggingSession oraDebuggingSession2 = OraDebugController.this.debuggingSession;
                            if (oraDebuggingSession2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                                oraDebuggingSession2 = null;
                            }
                            OraDebugController.this.issueCommand(new GracefulStepOverCommand(oraDebuggingSession2.getStackDepth(), firstStackPosition.getLineNr()));
                            break;
                        }
                        OraDebugController.this.issueCommand(StepIntoCommand.INSTANCE);
                        break;
                    }
                    case 2: {
                        OraDebugController.this.issueCommand(StepOverCommand.INSTANCE);
                    }
                }
            }
        }

        public void startStepOut(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                switch (WhenMappings.$EnumSwitchMapping$0[OraDebugController.this.steppingMode.ordinal()]) {
                    case 1: {
                        OraDebuggingSession oraDebuggingSession = OraDebugController.this.debuggingSession;
                        if (oraDebuggingSession == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                            oraDebuggingSession = null;
                        }
                        OraDebugController.this.issueCommand(new GracefulStepOutCommand(oraDebuggingSession.getStackDepth()));
                        break;
                    }
                    case 2: {
                        OraDebuggingSession oraDebuggingSession = OraDebugController.this.debuggingSession;
                        if (oraDebuggingSession == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggingSession");
                            oraDebuggingSession = null;
                        }
                        OraDebugController.this.issueCommand(new StepOutCommand(oraDebuggingSession.getStackDepth()));
                    }
                }
            }
        }

        public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile virtualFile2 = virtualFile;
            int xLine = position.getLine();
            if (Intrinsics.areEqual((Object)virtualFile2, (Object)OraDebugController.this.scriptVirtualFile)) {
                int lineNr = xLine - OraDebugController.this.scriptFirstLineNr + 1;
                switch (WhenMappings.$EnumSwitchMapping$0[OraDebugController.this.steppingMode.ordinal()]) {
                    case 1: {
                        OraDebugController.this.issueCommand(new GracefulRunToPositionInScriptCommand(lineNr));
                        break;
                    }
                    case 2: {
                        OraScriptPosition p2 = new OraScriptPosition(lineNr);
                        OraDebugController.this.issueCommand(new RunToPositionCommand(p2));
                    }
                }
            } else {
                Result<OraProgramPositionFile> pr = OracleDebugHelper.findOraPositionByVirtualFileLine(virtualFile2, xLine, OraDebugController.this.project, OraDebugController.this.lineMapper);
                Result<OraProgramPositionFile> result2 = pr;
                if (result2 instanceof SuccessfulResult) {
                    switch (WhenMappings.$EnumSwitchMapping$0[OraDebugController.this.steppingMode.ordinal()]) {
                        case 1: {
                            OraDebugController.this.issueCommand(new GracefulRunToPositionInProgramCommand(((OraProgramPositionFile)((SuccessfulResult)pr).getValue()).getPosition()));
                            break;
                        }
                        case 2: {
                            OraDebugController.this.issueCommand(new RunToPositionCommand(((OraProgramPositionFile)((SuccessfulResult)pr).getValue()).getPosition()));
                        }
                    }
                } else if (result2 instanceof ProblematicResult) {
                    OraDebugController.this.trace("Cannot run to position " + virtualFile2.getPresentableUrl() + ":" + (xLine + 1) + ": " + ((ProblematicResult)pr).getProblem());
                }
            }
        }

        public void startPausing() {
            if (OraDebugController.this.getState() == ProcessState.STATE_RESUMING || OraDebugController.this.getState() == ProcessState.STATE_RUNNING || OraDebugController.this.getState() == ProcessState.STATE_STARTING_UP) {
                OraDebugController.this.issueCommand(PauseCommand.INSTANCE);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void resume(@Nullable XSuspendContext context) {
            if (OraDebugController.this.getState() == ProcessState.STATE_RELAXING) {
                void _true_$iv;
                void $this$choose$iv;
                boolean bl = OraDebugController.this.steppingMode == SteppingMode.STEPPING_GRACEFUL;
                GracefulResumeCommand gracefulResumeCommand = GracefulResumeCommand.INSTANCE;
                ResumeCommand _false_$iv = ResumeCommand.INSTANCE;
                boolean $i$f$choose = false;
                OraDebugController.this.issueCommand((DebugCommand)($this$choose$iv != false ? _true_$iv : _false_$iv));
            }
        }

        @Override
        public void stop() {
            if (OraDebugController.this.getState().compareTo((Enum)ProcessState.STATE_ASLEEP) > 0 && OraDebugController.this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) < 0) {
                OraDebugController.this.issueCommand(StopCommand.INSTANCE);
            }
        }

        public boolean checkCanPerformCommands() {
            return OraDebugController.this.getState().isInteractive() || OraDebugController.this.steppingMode == SteppingMode.STEPPING_GRACEFUL;
        }

        @NotNull
        public XBreakpointHandler<?>[] getBreakpointHandlers() {
            XBreakpointHandler[] xBreakpointHandlerArray = new XBreakpointHandler[]{OraDebugController.this.lineBreakpointHandler};
            return xBreakpointHandlerArray;
        }

        public boolean checkCanInitBreakpoints() {
            return OraDebugController.this.debuggingSession != null && OraDebugController.this.getState().compareTo((Enum)ProcessState.STATE_STARTING_UP) >= 0 && OraDebugController.this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) < 0;
        }

        @NotNull
        public XDebuggerEvaluator getEvaluator() {
            return OraDebugController.this.evaluator;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SteppingMode.values().length];
                try {
                    nArray[SteppingMode.STEPPING_GRACEFUL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SteppingMode.STEPPING_NATIVE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u00012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0016J\u001a\u0010\n\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0016J\"\u0010\u000b\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00042\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$OraLineBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointProperties;", "Lcom/intellij/database/dialects/oracle/debugger/OraXLineBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointListener;", "(Lcom/intellij/database/dialects/oracle/debugger/OraDebugController;)V", "breakpointChanged", "", "breakpoint", "registerBreakpoint", "unregisterBreakpoint", "temporary", "", "intellij.database.dialects.oracle.ex"})
    private final class OraLineBreakpointHandler
    extends XBreakpointHandler<XLineBreakpoint<OraLineBreakpointProperties>>
    implements XBreakpointListener<XLineBreakpoint<OraLineBreakpointProperties>> {
        public OraLineBreakpointHandler() {
            super(OraLineBreakpointType.class);
        }

        public void registerBreakpoint(@NotNull XLineBreakpoint<OraLineBreakpointProperties> breakpoint) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            if (breakpoint.isEnabled()) {
                OraDebugController.this.registerLineBreakpoint((XLineBreakpoint<OraLineBreakpointProperties>)breakpoint);
            }
        }

        public void unregisterBreakpoint(@NotNull XLineBreakpoint<OraLineBreakpointProperties> breakpoint, boolean temporary) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            OraRealLineBreakpoint bp = (OraRealLineBreakpoint)OraDebugController.this.lineBreakpoints.get(breakpoint);
            if (bp != null && bp.getId() > 0) {
                OraDebugController.this.deregisterLineBreakpoint((XLineBreakpoint<OraLineBreakpointProperties>)breakpoint);
            }
        }

        public void breakpointChanged(@NotNull XLineBreakpoint<OraLineBreakpointProperties> breakpoint) {
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            OraRealLineBreakpoint bp = (OraRealLineBreakpoint)OraDebugController.this.lineBreakpoints.get(breakpoint);
            if (bp != null && bp.getId() > 0) {
                OraDebugController.this.deregisterLineBreakpoint((XLineBreakpoint<OraLineBreakpointProperties>)breakpoint);
            }
            if (breakpoint.isEnabled()) {
                OraDebugController.this.registerLineBreakpoint((XLineBreakpoint<OraLineBreakpointProperties>)breakpoint);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$ScalarValue;", "Lcom/intellij/xdebugger/frame/XValue;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.database.dialects.oracle.ex"})
    private static final class ScalarValue
    extends XValue {
        @NotNull
        private final String value;

        public ScalarValue(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.value = value2;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node2.setPresentation(null, null, this.value, false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0016\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebugController$SuspendedContext;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "stack", "Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "(Lcom/intellij/database/dialects/oracle/debugger/OraStack;)V", "getActiveExecutionStack", "getExecutionStacks", "", "()[Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "intellij.database.dialects.oracle.ex"})
    private static final class SuspendedContext
    extends XSuspendContext {
        @NotNull
        private final OraStack stack;

        public SuspendedContext(@NotNull OraStack stack) {
            Intrinsics.checkNotNullParameter((Object)((Object)stack), (String)"stack");
            this.stack = stack;
        }

        @NotNull
        public OraStack getActiveExecutionStack() {
            return this.stack;
        }

        @NotNull
        public OraStack[] getExecutionStacks() {
            OraStack[] oraStackArray = new OraStack[]{this.stack};
            return oraStackArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SteppingMode.values().length];
            try {
                nArray[SteppingMode.STEPPING_GRACEFUL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SteppingMode.STEPPING_NATIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProcessState.values().length];
            try {
                nArray[ProcessState.STATE_ASLEEP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_STARTING_UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_RELAXING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_RESUMING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_RUNNING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_COMPLETING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_FINISHING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_COMPLETED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_FAIL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_FINISHED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_BROKEN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessState.STATE_KICKED_OFF.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

