/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LinkedDataSourceHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/oracle/OraLinkedDataSourceHelper;", "Lcom/intellij/database/dataSource/LinkedDataSourceHelper;", "()V", "createLinkedDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "link", "Lcom/intellij/database/model/DasObject;", "linkDs", "project", "Lcom/intellij/openapi/project/Project;", "getLinkedDataSourceKind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.oracle.ex"})
@SourceDebugExtension(value={"SMAP\nOraLinkedDataSourceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraLinkedDataSourceHelper.kt\ncom/intellij/database/dialects/oracle/OraLinkedDataSourceHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n288#2,2:36\n*S KotlinDebug\n*F\n+ 1 OraLinkedDataSourceHelper.kt\ncom/intellij/database/dialects/oracle/OraLinkedDataSourceHelper\n*L\n22#1:36,2\n*E\n"})
public final class OraLinkedDataSourceHelper
extends LinkedDataSourceHelper {
    @Override
    @NotNull
    public ObjectKind getLinkedDataSourceKind() {
        ObjectKind objectKind = ObjectKind.DB_LINK;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DB_LINK");
        return objectKind;
    }

    @Override
    @NotNull
    public LocalDataSource createLinkedDataSource(@NotNull DasObject link, @NotNull LocalDataSource linkDs, @NotNull Project project) {
        LocalDataSource ds;
        block6: {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            Intrinsics.checkNotNullParameter((Object)linkDs, (String)"linkDs");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LocalDataSource localDataSource = super.createLinkedDataSource(link, linkDs, project);
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"createLinkedDataSource(...)");
            ds = localDataSource;
            OraDbLink oraDbLink = link instanceof OraDbLink ? (OraDbLink)link : null;
            if (oraDbLink == null) {
                return ds;
            }
            OraDbLink dbLink = oraDbLink;
            DatabaseDriver databaseDriver = linkDs.getDatabaseDriver();
            List<StatelessJdbcUrlParser> list = databaseDriver != null ? databaseDriver.getJDBCUrlParsers() : null;
            UrlEditorModel model2 = new UrlEditorModel(list == null ? (Collection)CollectionsKt.emptyList() : (Collection)list);
            String string = linkDs.getUrl();
            if (string == null) {
                string = "";
            }
            model2.setUrl(string);
            model2.commit(true);
            String string2 = dbLink.getRemoteDatabaseString();
            if (string2 != null) {
                Object v8;
                String connectString;
                block5: {
                    connectString = string2;
                    boolean bl = false;
                    Collection<String> collection2 = model2.getParameterNames();
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"getParameterNames(...)");
                    Iterable $this$firstOrNull$iv = collection2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it2 = (String)element$iv;
                        boolean bl2 = false;
                        StatelessParametersHolder.ParameterInfo parameterInfo = model2.getParameterInfo(it2);
                        if (!Intrinsics.areEqual((Object)(parameterInfo != null ? parameterInfo.getType() : null), (Object)"identifier")) continue;
                        v8 = element$iv;
                        break block5;
                    }
                    v8 = null;
                }
                String string3 = v8;
                if (string3 != null) {
                    String idKey = string3;
                    boolean bl = false;
                    model2.setParameter(idKey, connectString);
                }
            }
            model2.commit(true);
            ds.setUrl(model2.getUrl());
            String string4 = dbLink.getConnectUserName();
            if (string4 == null) break block6;
            String userName = string4;
            boolean bl = false;
            LocalDataSource.setUsername(ds, userName);
        }
        return ds;
    }
}

