/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraImportManager
extends ImportManager {
    public OraImportManager() {
        super(Dbms.ORACLE, "CLOB", 1, true, true, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INTEGER"), new TypeMerger.DoubleMerger("NUMBER")});
    }

    @Override
    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info2) {
        if (info2 == null) {
            OraImportManager.$$$reportNull$$$0(0);
        }
        List<String> queries = this.getQueries(info2.getContext(), info2.cache().getBasicTable(), true, "UNUSABLE");
        queries.add(this.getLockQuery(info2));
        List<String> list = queries;
        if (list == null) {
            OraImportManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info2) {
        if (info2 == null) {
            OraImportManager.$$$reportNull$$$0(2);
        }
        return this.getQueries(info2.getContext(), info2.cache().getBasicTable(), false, "REBUILD");
    }

    @NotNull
    private List<String> getQueries(@NotNull DatabaseEditorContext context, @NotNull DasTable table, boolean isBeforeImport, @NotNull String whatToDoWithIndices) {
        if (context == null) {
            OraImportManager.$$$reportNull$$$0(3);
        }
        if (table == null) {
            OraImportManager.$$$reportNull$$$0(4);
        }
        if (whatToDoWithIndices == null) {
            OraImportManager.$$$reportNull$$$0(5);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(this.triggers(this.alter(OraImportManager.createBuilder(context), "TABLE", table).space(), !isBeforeImport).getStatement());
        result2.add(OraImportManager.skipUnusable(context, isBeforeImport));
        this.alterIndices(context, table, result2, whatToDoWithIndices);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            OraImportManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
        if (builder == null) {
            OraImportManager.$$$reportNull$$$0(7);
        }
        DdlBuilder ddlBuilder = builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("ALL").space().keyword("TRIGGERS");
        if (ddlBuilder == null) {
            OraImportManager.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public String getLockQuery(@NotNull ImportInfo info2) {
        if (info2 == null) {
            OraImportManager.$$$reportNull$$$0(9);
        }
        return OraImportManager.createBuilder(info2.getContext()).space().keyword("LOCK").space().keyword("TABLE").space().qualifiedRef(info2.cache().getBasicTable()).space().keyword("IN").space().keyword("EXCLUSIVE").space().keyword("MODE").getStatement();
    }

    private static String skipUnusable(@NotNull DatabaseEditorContext context, boolean value2) {
        if (context == null) {
            OraImportManager.$$$reportNull$$$0(10);
        }
        return OraImportManager.createBuilder(context).keyword("ALTER").space().keyword("SESSION").space().keyword("SET").space().literal("skip_unusable_indexes=").space().literal(StringUtil.toLowerCase((String)String.valueOf(value2))).getStatement();
    }

    private void alterIndices(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull List<String> result2, @NotNull String whatToDo) {
        if (context == null) {
            OraImportManager.$$$reportNull$$$0(11);
        }
        if (table == null) {
            OraImportManager.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            OraImportManager.$$$reportNull$$$0(13);
        }
        if (whatToDo == null) {
            OraImportManager.$$$reportNull$$$0(14);
        }
        for (DasIndex index2 : table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class)) {
            result2.add(this.alterIndex(context, index2, whatToDo));
        }
    }

    private String alterIndex(@NotNull DatabaseEditorContext context, @NotNull DasIndex index2, @NotNull String whatToDo) {
        if (context == null) {
            OraImportManager.$$$reportNull$$$0(15);
        }
        if (index2 == null) {
            OraImportManager.$$$reportNull$$$0(16);
        }
        if (whatToDo == null) {
            OraImportManager.$$$reportNull$$$0(17);
        }
        return this.alter(OraImportManager.createBuilder(context), "INDEX", index2).space().keyword(whatToDo).getStatement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraImportManager";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDoWithIndices";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraImportManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "triggers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "triggers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLockQuery";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "skipUnusable";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "alterIndices";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "alterIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 8 -> new IllegalStateException(string);
        };
    }
}

