/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MysqlTreeRawPlanData
extends RawPlanData {
    public final List<String> rows = new ArrayList<String>();
    public final IntList indents = new IntArrayList();

    @Override
    public void load(@NotNull DatabaseConnectionCore connection2, final @NotNull String statement2, final boolean run2) {
        if (connection2 == null) {
            MysqlTreeRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            MysqlTreeRawPlanData.$$$reportNull$$$0(1);
        }
        MysqlTreeRawPlanData.useStatementWithPreserved(connection2, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s2) throws PlanRetrievalException, SQLException {
                String tree2 = s2.noisy().execute("EXPLAIN " + (run2 ? "ANALYZE " : "FORMAT=TREE ") + statement2, StandardResultsProcessors.firstString(1));
                MysqlTreeRawPlanData.this.load(tree2);
            }
        }, new RawPlanData.StateSaver[0]);
    }

    @Override
    public void load(@NotNull String dump2) {
        if (dump2 == null) {
            MysqlTreeRawPlanData.$$$reportNull$$$0(2);
        }
        this.rows.clear();
        this.rows.addAll(StringUtil.split((String)dump2, (String)"\n"));
        this.indents.clear();
        for (String row : this.rows) {
            this.indents.add(row.indexOf(45));
        }
    }

    @Override
    public String dump() {
        return StringUtil.join(this.rows, (String)"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/mysql/plan/MysqlTreeRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

