/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MsRawPlanData
extends RawPlanData {
    public List<String> xmls = new ArrayList<String>();

    @Override
    public void load(@NotNull DatabaseConnectionCore connection2, final @NotNull String statement2, final boolean run2) {
        if (connection2 == null) {
            MsRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            MsRawPlanData.$$$reportNull$$$0(1);
        }
        this.xmls.clear();
        MsRawPlanData.useStatementWithPreserved(connection2, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s2) throws PlanRetrievalException, SQLException {
                String option = run2 ? "STATISTICS XML" : "SHOWPLAN_XML";
                try {
                    s2.barren().execute((CallSite)((Object)("SET " + option + " ON")));
                    if (!run2) {
                        s2.barren().execute("SET NOEXEC ON");
                    }
                    s2.noisy().execute(statement2, SmartStatementsUtil.consumer(MsRawPlanData.processingAll((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                        String res2;
                        if (rs.getMetaData().getColumnCount() != 1) {
                            return;
                        }
                        String name2 = rs.getMetaData().getColumnName(1);
                        if (name2 == null || !name2.endsWith("XML Showplan")) {
                            return;
                        }
                        if (!rs.next()) {
                            MsRawPlanData.failWithEmptyResultSetError();
                        }
                        if ((res2 = rs.getString(1)) == null) {
                            throw new PlanRetrievalException("Database returned null plan");
                        }
                        if (rs.next()) {
                            throw new PlanRetrievalException("Database returned too many data");
                        }
                        MsRawPlanData.this.xmls.add(res2);
                    })));
                }
                finally {
                    if (!run2) {
                        s2.barren().quiet().execute("SET NOEXEC OFF");
                    }
                    s2.barren().quiet().execute((CallSite)((Object)("SET " + option + " OFF")));
                }
            }
        }, MsRawPlanData.setAutoCommit(false));
    }

    @Override
    public void load(@NotNull String dump2) {
        if (dump2 == null) {
            MsRawPlanData.$$$reportNull$$$0(2);
        }
        this.xmls = StringUtil.split((String)dump2, (String)MsRawPlanData.getSep());
    }

    @Override
    public String dump() {
        return StringUtil.join(this.xmls, (String)("\n" + MsRawPlanData.getSep() + "\n"));
    }

    @NotNull
    private static String getSep() {
        String string = StringUtil.repeatSymbol((char)'-', (int)20);
        if (string == null) {
            MsRawPlanData.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/plan/MsRawPlanData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/plan/MsRawPlanData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

