/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsDescriptionService;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsLikeTable;
import com.intellij.database.dialects.mssql.model.MsRole;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsSecurityPredicate;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.MsSourceAware;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateOperationType;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u00103\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u00069"}, d2={"Lcom/intellij/database/dialects/mssql/model/MsDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExtProps", "Lcom/intellij/database/dialects/mssql/model/MsExtendedPropertiesHolder;", "describeMsAliasType", "type", "Lcom/intellij/database/dialects/mssql/model/MsAliasType;", "describeMsDatabase", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "database", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "describeMsDefaultConstraint", "def", "Lcom/intellij/database/dialects/mssql/model/MsDefaultConstraint;", "describeMsLikeIndex", "index", "Lcom/intellij/database/dialects/mssql/model/MsLikeIndex;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "describeMsRole", "role", "Lcom/intellij/database/dialects/mssql/model/MsRole;", "describeMsRoutine", "routine", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "describeMsSecurityPredicate", "predicate", "Lcom/intellij/database/dialects/mssql/model/MsSecurityPredicate;", "describeMsSequence", "sequence", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "describeMsStoredColumn", "col", "Lcom/intellij/database/dialects/mssql/model/MsStoredColumn;", "describeMsTable", "table", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "describeMsTableType", "Lcom/intellij/database/dialects/mssql/model/MsTableType;", "describeMsTrigger", "trigger", "Lcom/intellij/database/dialects/mssql/model/MsTrigger;", "options", "updatePresentation", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsDescriptionService.kt\ncom/intellij/database/dialects/mssql/model/MsDescriptionService\n+ 2 DescriptionService.kt\ncom/intellij/database/model/DescriptionService$Context\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n73#2:187\n73#2:188\n73#2:189\n1#3:190\n*S KotlinDebug\n*F\n+ 1 MsDescriptionService.kt\ncom/intellij/database/dialects/mssql/model/MsDescriptionService\n*L\n50#1:187\n57#1:188\n62#1:189\n*E\n"})
public final class MsDescriptionService
extends DescriptionService {
    @Override
    @NotNull
    public String options(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ((Collection)context.getDescribed()).add(MsSourceAware.ENCRYPTED);
        ((Collection)context.getDescribed()).add(MsTableColumn.HIDDEN);
        return super.options(e2, context) + (e2 instanceof MsSourceAware && ((MsSourceAware)e2).isEncrypted() ? " [encrypted]" : "") + (e2 instanceof MsTableColumn && ((MsTableColumn)e2).isHidden() ? " [hidden]" : "");
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return (basicElement instanceof MsSequence ? this.describeMsSequence((MsSequence)e2, context) : (basicElement instanceof MsAliasType ? this.describeMsAliasType((MsAliasType)e2, context) : (basicElement instanceof MsTableType ? this.describeMsTableType((MsTableType)e2, context) : (basicElement instanceof MsTable ? this.describeMsTable((MsTable)e2, context) : (basicElement instanceof MsStoredColumn ? this.describeMsStoredColumn((MsStoredColumn)e2, context) : (basicElement instanceof MsDefaultConstraint ? this.describeMsDefaultConstraint((MsDefaultConstraint)e2, context) : (basicElement instanceof MsLikeIndex ? this.describeMsLikeIndex((MsLikeIndex)e2, context) : (basicElement instanceof MsTrigger ? this.describeMsTrigger((MsTrigger)e2, context) : (basicElement instanceof MsRoutine ? this.describeMsRoutine((MsRoutine)e2, context) : (basicElement instanceof MsRole ? this.describeMsRole((MsRole)e2, context) : super.content(e2, context))))))))))) + (e2 instanceof MsExtendedPropertiesHolder ? this.describeExtProps((MsExtendedPropertiesHolder)e2) : "");
    }

    private final String describeMsSequence(MsSequence sequence, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsSequence.CYCLED);
        ((Collection)context.getDescribed()).add(MsSequence.CACHE_SIZE);
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        if (!this_$iv.getOptions().getWithSurrogates()) {
            ((Collection)context.getDescribed()).add(MsSequence.STORED_TYPE);
        }
        return super.content(sequence, context);
    }

    private final String describeMsAliasType(MsAliasType type2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsAliasType.STORED_TYPE);
        ((Collection)context.getDescribed()).add(MsAliasType.NOT_NULL);
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        if (!this_$iv.getOptions().getWithSurrogates()) {
            ((Collection)context.getDescribed()).add(MsAliasType.TYPE_ID);
        }
        return type2.getDasType().getSpecification() + (type2.isNotNull() ? " NN" : "");
    }

    private final String describeMsTableType(MsTableType type2, DescriptionService.Context context) {
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        if (!this_$iv.getOptions().getWithSurrogates()) {
            ((Collection)context.getDescribed()).add(MsTableType.TYPE_ID);
        }
        return super.content(type2, context);
    }

    private final String describeMsTable(MsTable table, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsTable.EXTENDED_PROPERTIES);
        return super.content(table, context);
    }

    private final String describeMsLikeIndex(MsLikeIndex index2, DescriptionService.Context context) {
        String condition2;
        ((Collection)context.getDescribed()).add(MsLikeIndex.CLUSTERING);
        ((Collection)context.getDescribed()).add(MsLikeIndex.FULLTEXT);
        ((Collection)context.getDescribed()).add(MsLikeIndex.CONDITION);
        ((Collection)context.getDescribed()).add(MsLikeIndex.UNIQUE);
        ((Collection)context.getDescribed()).add(MsLikeIndex.INCLUDED_COL_NAMES);
        ((Collection)context.getDescribed()).add(MsLikeIndex.COL_NAMES);
        ((Collection)context.getDescribed()).add(MsLikeIndex.REVERSE_COL_NAMES);
        String prefix = index2.isClustering() ? "clustered " : (index2.isFulltext() ? "fulltext " : "");
        Object d2 = index2.isUnique() ? "unique" : "index";
        String inner = this.describeIndexingItems(index2);
        if (inner != null) {
            d2 = (String)d2 + " (" + inner + ")";
        }
        List<String> list = index2.getIncludedColNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getIncludedColNames(...)");
        if (!((Collection)list).isEmpty()) {
            List<String> list2 = index2.getIncludedColNames();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getIncludedColNames(...)");
            d2 = (String)d2 + " include (" + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")";
        }
        if ((condition2 = index2.getCondition()) != null) {
            d2 = (String)d2 + " when " + condition2;
        }
        return prefix + (String)d2;
    }

    private final String describeMsDefaultConstraint(MsDefaultConstraint def, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsDefaultConstraint.COL_NAMES);
        ((Collection)context.getDescribed()).add(MsDefaultConstraint.DEFAULT_EXPRESSION);
        String string = StringUtil.join((Collection)def.getColNames(), (String)",");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String columnName = string;
        String string2 = def.getDefaultExpression();
        if (string2 == null) {
            string2 = "???";
        }
        String defaultExpression = string2;
        return columnName + " = " + defaultExpression;
    }

    private final String describeMsStoredColumn(MsStoredColumn col, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsTableColumn.SPARSE);
        ((Collection)context.getDescribed()).add(MsTableColumn.COLUMN_SET);
        ((Collection)context.getDescribed()).add(MsTableColumn.DEFAULT_CONSTRAINT_REF);
        String s2 = super.content(col, context);
        return col instanceof MsTableColumn && ((MsTableColumn)col).isSparse() ? s2 + " sparse" : (col instanceof MsTableColumn && ((MsTableColumn)col).isColumnSet() ? s2 + " column_set for all_sparse_columns" : s2);
    }

    private final String describeMsTrigger(MsTrigger trigger2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsTrigger.DISABLED);
        ((Collection)context.getDescribed()).add(MsTrigger.NOT_FOR_REPLICATION);
        return super.content(trigger2, context);
    }

    private final String describeMsRoutine(MsRoutine routine2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsRoutine.ROUTINE_TYPE);
        return super.content(routine2, context);
    }

    private final String describeMsRole(MsRole role, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(MsRole.OWNER_REF);
        ((Collection)context.getDescribed()).add(MsRole.TYPE);
        ((Collection)context.getDescribed()).add(MsRole.AUTH_TYPE);
        return super.content(role, context);
    }

    @Override
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o2, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o2;
        if (dasObject instanceof MsLikeIndex) {
            this.describeMsLikeIndex(presentation, (MsLikeIndex)o2, viewOptions);
        } else if (dasObject instanceof MsSecurityPredicate) {
            this.describeMsSecurityPredicate(presentation, (MsSecurityPredicate)o2);
        } else if (dasObject instanceof MsDatabase) {
            this.describeMsDatabase(presentation, (MsDatabase)o2);
        } else {
            super.updatePresentation(project, o2, viewOptions, presentation);
        }
    }

    private final void describeMsLikeIndex(PresentationData presentation, MsLikeIndex index2, DvViewOptions viewOptions) {
        String indexingItems;
        Object text2 = " ";
        if (DvViewOptionsFun.getUnnestTableSubObjectsAndGroupSchemaObjects(viewOptions)) {
            MsLikeTable msLikeTable = index2.getLikeTable();
            String tableName = StringKt.nullize((String)(msLikeTable != null ? msLikeTable.getName() : null), (boolean)true);
            if (tableName != null) {
                text2 = (String)text2 + "on " + tableName + " ";
            }
        }
        if ((indexingItems = this.describeIndexingItems(index2)) != null) {
            text2 = (String)text2 + "(" + indexingItems + ")";
        }
        String unique = index2.isUnique() ? " UNIQUE" : "";
        text2 = (String)text2 + unique;
        List<String> list = index2.getIncludedColNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getIncludedColNames(...)");
        List<String> includingColNames = list;
        if (!((Collection)includingColNames).isEmpty()) {
            String string = StringUtil.join((Collection)includingColNames, (String)", ");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            String icn = string;
            text2 = (String)text2 + " include (" + icn + ")";
        }
        presentation.addText((String)text2, DbPresentationCore.INFO_ATTRS);
        String condition2 = index2.getCondition();
        if (condition2 != null) {
            String conditionClause = " where " + condition2;
            presentation.addText(conditionClause, DbPresentationCore.INFO_ATTRS);
        }
    }

    private final void describeMsSecurityPredicate(PresentationData presentation, MsSecurityPredicate predicate) {
        String string;
        Enum it2;
        StringBuilder stringBuilder;
        StringBuilder $this$describeMsSecurityPredicate_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        MsSecurityPredicateType msSecurityPredicateType = predicate.getPredicateType();
        if (msSecurityPredicateType != null) {
            it2 = msSecurityPredicateType;
            boolean bl2 = false;
            string = it2.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            $this$describeMsSecurityPredicate_u24lambda_u242.append(string2).append(" ");
        }
        MsSecurityPredicateOperationType msSecurityPredicateOperationType = predicate.getOperationType();
        if (msSecurityPredicateOperationType != null) {
            it2 = msSecurityPredicateOperationType;
            boolean bl3 = false;
            StringBuilder stringBuilder2 = $this$describeMsSecurityPredicate_u24lambda_u242.append(" ");
            string = it2.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            stringBuilder2.append(StringsKt.replace$default((String)string3, (char)'_', (char)' ', (boolean)false, (int)4, null));
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String text2 = string4;
        presentation.addText(text2, DbPresentationCore.INFO_ATTRS);
    }

    private final void describeMsDatabase(PresentationData presentation, MsDatabase database) {
        if (!database.isOnline()) {
            Icon icon = DatabaseIcons.Database;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Database");
            presentation.setIcon(IconLoader.getDisabledIcon((Icon)icon));
        }
    }

    private final String describeExtProps(MsExtendedPropertiesHolder e2) {
        Object object;
        if (e2.getExtendedProperties().isEmpty()) {
            object = "";
        } else {
            List<NameValueType> list = e2.getExtendedProperties();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExtendedProperties(...)");
            object = " [" + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)describeExtProps.1.INSTANCE, (int)31, null) + "]";
        }
        return object;
    }
}

