/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.Dbms;
import com.intellij.database.HSet;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IdCache;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.IntrospectorSqlHelper;
import com.intellij.database.dialects.mssql.generator.MsNamingService;
import com.intellij.database.dialects.mssql.introspector.ExtPropId;
import com.intellij.database.dialects.mssql.introspector.ForeignKeyInfo;
import com.intellij.database.dialects.mssql.introspector.MsIntroQueries;
import com.intellij.database.dialects.mssql.introspector.MsIntrospector;
import com.intellij.database.dialects.mssql.introspector.MsIntrospectorHelper;
import com.intellij.database.dialects.mssql.introspector.MsIntrospectorKt;
import com.intellij.database.dialects.mssql.introspector.MsMinorIdentity;
import com.intellij.database.dialects.mssql.introspector.MsRoutineTypes;
import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsArgument;
import com.intellij.database.dialects.mssql.model.MsAssembly;
import com.intellij.database.dialects.mssql.model.MsCollation;
import com.intellij.database.dialects.mssql.model.MsColumnEncryptionKey;
import com.intellij.database.dialects.mssql.model.MsColumnMasterKey;
import com.intellij.database.dialects.mssql.model.MsCustomType;
import com.intellij.database.dialects.mssql.model.MsDatabase;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsFileGroup;
import com.intellij.database.dialects.mssql.model.MsForeignKey;
import com.intellij.database.dialects.mssql.model.MsGeneratedModelUtil;
import com.intellij.database.dialects.mssql.model.MsGrantsHolder;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsIndexableTable;
import com.intellij.database.dialects.mssql.model.MsLikeColumn;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsLikeTable;
import com.intellij.database.dialects.mssql.model.MsLinkedServer;
import com.intellij.database.dialects.mssql.model.MsLogin;
import com.intellij.database.dialects.mssql.model.MsPartition;
import com.intellij.database.dialects.mssql.model.MsPartitionFunction;
import com.intellij.database.dialects.mssql.model.MsPartitionScheme;
import com.intellij.database.dialects.mssql.model.MsRole;
import com.intellij.database.dialects.mssql.model.MsRoot;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsRule;
import com.intellij.database.dialects.mssql.model.MsSchema;
import com.intellij.database.dialects.mssql.model.MsSchemaObject;
import com.intellij.database.dialects.mssql.model.MsSecurityPolicy;
import com.intellij.database.dialects.mssql.model.MsSecurityPredicate;
import com.intellij.database.dialects.mssql.model.MsSequence;
import com.intellij.database.dialects.mssql.model.MsSourceAware;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsStoredTable;
import com.intellij.database.dialects.mssql.model.MsSynonym;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTableOrView;
import com.intellij.database.dialects.mssql.model.MsTablePartition;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.MsView;
import com.intellij.database.dialects.mssql.model.properties.MsAuthType;
import com.intellij.database.dialects.mssql.model.properties.MsColumnEncryptionKind;
import com.intellij.database.dialects.mssql.model.properties.MsDataCompressionKind;
import com.intellij.database.dialects.mssql.model.properties.MsDataSpaceKind;
import com.intellij.database.dialects.mssql.model.properties.MsDatabasePrincipalType;
import com.intellij.database.dialects.mssql.model.properties.MsGeneratedColumnKind;
import com.intellij.database.dialects.mssql.model.properties.MsLedgerKind;
import com.intellij.database.dialects.mssql.model.properties.MsRoutineType;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateOperationType;
import com.intellij.database.dialects.mssql.model.properties.MsSecurityPredicateType;
import com.intellij.database.dialects.mssql.model.properties.MsServerPrincipalType;
import com.intellij.database.dialects.mssql.model.properties.MsTemporalTableKind;
import com.intellij.database.dialects.mssql.model.properties.MsTimeUnit;
import com.intellij.database.introspection.CollectionAggregator;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.FamilyFragment;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.model.properties.references.BasicPositionReference;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.CalendarFun;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\f\u0018\u0000 J2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004JKLMB\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00110\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J&\u0010\"\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030#R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J\u001c\u0010$\u001a\u00060%R\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J\u001c\u0010(\u001a\u00060)R\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0004H\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020,H\u0014J&\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030!2\u0006\u0010/\u001a\u00020'2\u000e\u00100\u001a\n\u0012\u0004\u0012\u000202\u0018\u000101H\u0014J\b\u00103\u001a\u00020,H\u0014J.\u00104\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u00105\u001a\b\u0012\u0004\u0012\u000206012\u0006\u00107\u001a\u00020\u0011H\u0014J.\u00108\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u00109\u001a\u00020\u001a2\f\u00105\u001a\b\u0012\u0004\u0012\u000206012\u0006\u00107\u001a\u00020\u0011H\u0014J6\u0010:\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00182\f\u00105\u001a\b\u0012\u0004\u0012\u000206012\u0006\u00107\u001a\u00020\u0011H\u0014J\u0010\u0010;\u001a\u00020,2\u0006\u0010/\u001a\u00020'H\u0014J\b\u0010<\u001a\u00020\u0011H\u0002J\b\u0010=\u001a\u00020\u0011H\u0002J\b\u0010>\u001a\u00020\u0011H\u0002J)\u0010?\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020B0AH\u0000\u00a2\u0006\u0002\bCJ!\u0010?\u001a\u00020,2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020B0AH\u0000\u00a2\u0006\u0002\bCJ\u0010\u0010D\u001a\u00020,2\u0006\u0010/\u001a\u00020'H\u0002J\u0010\u0010E\u001a\u00020,2\u0006\u0010/\u001a\u00020'H\u0002J\u0010\u0010F\u001a\u00020,2\u0006\u0010/\u001a\u00020'H\u0002J\u0010\u0010G\u001a\u00020,2\u0006\u0010/\u001a\u00020'H\u0002J\u0010\u0010H\u001a\u00020,2\u0006\u0010I\u001a\u00020\bH\u0014R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "currentSessionInfo", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$CurrentSessionInfo;", "helper", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospectorHelper;", "isAzure", "", "isNotAzure", "myQueries", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries;", "myVer10", "schemasWhereDroppedObjectsDetected", "", "Lcom/intellij/database/model/basic/BasicSchema;", "catalogPrefix", "", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "checkElementsUptodate", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "createSchemaRetriever", "Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever;", "schema", "deinitConnectionRelatedState", "", "dropSpecificSessionInfo", "getDatabasesToIntrospect", "tran", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "initConnectionRelatedState", "introspectDatabaseFragments", "fragments", "Lcom/intellij/database/introspection/FamilyFragment;", "checkForDroppedObjects", "introspectRootFragments", "databaseName", "introspectSchemaFragments", "introspectTheServerObjects", "isAnySynapse", "isSynapse", "isSynapseMaster", "prepareQueryParameters", "parameters", "", "", "prepareQueryParameters$intellij_database_dialects_mssql", "retrieveCollations", "retrieveLinkedServers", "retrieveLogins", "retrievePermissions", "validateDbms", "connectionDbms", "Companion", "Factory", "MsDatabaseRetriever", "MsSchemaRetriever", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector\n+ 2 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 3 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,2209:1\n981#2:2210\n968#2,2:2211\n982#2:2214\n14#3:2213\n1#4:2215\n1855#5,2:2216\n215#6,2:2218\n37#7,2:2220\n*S KotlinDebug\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector\n*L\n115#1:2210\n115#1:2211,2\n115#1:2214\n119#1:2213\n268#1:2216,2\n277#1:2218,2\n312#1:2220,2\n*E\n"})
public final class MsIntrospector
extends BaseMultiDatabaseIntrospector<MsRoot, MsDatabase, MsSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MsIntroQueries myQueries;
    private final boolean isAzure;
    private final boolean isNotAzure;
    private boolean myVer10;
    @NotNull
    private final MsIntrospectorHelper helper;
    @Nullable
    private MsIntroQueries.CurrentSessionInfo currentSessionInfo;
    @NotNull
    private final Set<BasicSchema> schemasWhereDroppedObjectsDetected;
    @NotNull
    private static final Set<ObjectKind> supportFragmentKinds;

    public MsIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, Companion, dbms, modelFactory);
        this.myQueries = MsIntroQueries.INSTANCE;
        HSet hSet = Dbms.AZURE_LIKE;
        Intrinsics.checkNotNullExpressionValue((Object)hSet, (String)"AZURE_LIKE");
        this.isAzure = ModelFun.contains(hSet, dbms);
        this.isNotAzure = !this.isAzure;
        this.helper = new MsIntrospectorHelper(context.getProject(), dbms);
        this.schemasWhereDroppedObjectsDetected = new HashSet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initConnectionRelatedState() {
        MsIntroQueries.CurrentSessionInfo csi;
        super.initConnectionRelatedState();
        int[] nArray = new int[]{10};
        this.myVer10 = this.getServerVersion().isOrGreater(nArray);
        this.currentSessionInfo = csi = (MsIntroQueries.CurrentSessionInfo)BaseNativeIntrospector.performQuery$default(this, this.myQueries.getQueryCurrentSessionInfo(), null, 2, null);
        if (csi != null) {
            BaseIntrospector this_$iv = this;
            boolean $i$f$trace = false;
            BaseIntrospector this_$iv$iv = this_$iv;
            boolean $i$f$getTracing = false;
            Logger logger2 = BaseIntrospector.access$getDbLogger(this_$iv$iv);
            Level level$iv$iv = logger2 != null ? BaseIntrospector.Companion.access$getEffectiveLevel(BaseIntrospector.Companion, logger2) : null;
            if (level$iv$iv != null && level$iv$iv.intValue() <= BaseIntrospector.access$getTRACE_LEVEL_VALUE$cp()) {
                void _true_$iv;
                void $this$choose$iv;
                BaseIntrospector baseIntrospector = this_$iv;
                boolean bl = false;
                boolean bl2 = csi.is_azure;
                String string = "yes";
                String _false_$iv = "no";
                boolean $i$f$choose = false;
                BaseIntrospector.access$trace(baseIntrospector, StringsKt.trimMargin$default((String)("|CurrentSessionInfo:\n           |    current database: " + csi.db_name + " (" + csi.db_id + ")\n           |    current schema:   " + csi.schema_name + " (" + csi.schema_id + ")\n           |    is it Azure:      " + ($this$choose$iv != false ? _true_$iv : _false_$iv) + "\n        "), null, (int)1, null));
            }
        } else {
            this.logWarn("Failed to obtain CurrentSessionInfo.");
        }
    }

    @Override
    protected void deinitConnectionRelatedState() {
        this.currentSessionInfo = null;
        super.deinitConnectionRelatedState();
    }

    @Override
    @NotNull
    protected Iterable<MsDatabase> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        Object theCurrentlyAccessibleDatabase;
        Object object;
        block6: {
            MsIntroQueries.CurrentSessionInfo csi;
            block5: {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                if (this.isNotAzure) {
                    return super.getDatabasesToIntrospect(tran, namespaces2);
                }
                MsIntroQueries.CurrentSessionInfo currentSessionInfo = this.currentSessionInfo;
                if (currentSessionInfo == null) {
                    return CollectionsKt.emptyList();
                }
                csi = currentSessionInfo;
                String dbName = csi.db_name;
                object = dbName;
                if (object == null) break block5;
                String it2 = object;
                boolean bl = false;
                MsDatabase msDatabase = (MsDatabase)((MsRoot)this.getRoot()).getDatabases().get(it2);
                object = msDatabase;
                if (msDatabase != null) break block6;
            }
            object = (MsDatabase)((MsRoot)this.getRoot()).getDatabases().getByObjectId(csi.db_id);
        }
        Object object2 = theCurrentlyAccessibleDatabase = object;
        return object2 != null ? (Iterable)CollectionsKt.listOf((Object)object2) : (Iterable)CollectionsKt.emptyList();
    }

    public final void prepareQueryParameters$intellij_database_dialects_mssql(@NotNull Map<String, Object> parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        if (this.isAzure) {
            parameters2.put("AZURE", true);
        }
    }

    public final void prepareQueryParameters$intellij_database_dialects_mssql(@NotNull BasicDatabase database, @NotNull Map<String, Object> parameters2) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        this.prepareQueryParameters$intellij_database_dialects_mssql(parameters2);
        parameters2.put("CAT", this.catalogPrefix(database));
        Map<String, Object> map2 = parameters2;
        String string = "ISTABLETYPE";
        Object object = new int[]{10};
        object = this.getServerVersion().isOrGreater((int)object) ? "is_table_type" : "0";
        map2.put(string, object);
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 10, parameters2);
    }

    private final String catalogPrefix(BasicDatabase database) {
        MsIntroQueries.CurrentSessionInfo currentSessionInfo = this.currentSessionInfo;
        if (Intrinsics.areEqual((Object)database.getName(), (Object)(currentSessionInfo != null ? currentSessionInfo.db_name : null))) {
            return "sys";
        }
        String string = database.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return MsNamingService.INSTANCE.catToScript(string, database.getKind()) + ".sys";
    }

    @Override
    protected void validateDbms(@NotNull Dbms connectionDbms) {
        Intrinsics.checkNotNullParameter((Object)connectionDbms, (String)"connectionDbms");
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.AZURE) && Intrinsics.areEqual((Object)connectionDbms, (Object)Dbms.SYNAPSE) || Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.SYNAPSE) && Intrinsics.areEqual((Object)connectionDbms, (Object)Dbms.AZURE)) {
            return;
        }
        super.validateDbms(connectionDbms);
    }

    @NotNull
    protected MsDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull MsDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MsDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected MsSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull MsSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new MsSchemaRetriever(transaction, schema2);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<MsIntroQueries.DbInfo, MsDatabase>(this){
            final /* synthetic */ MsIntrospector this$0;
            {
                this.this$0 = $receiver;
            }

            protected void prepareParameters() {
                this.this$0.prepareQueryParameters$intellij_database_dialects_mssql(MsIntrospector.access$getParametersMap(this.this$0));
            }

            @NotNull
            protected List<MsIntroQueries.DbInfo> listDatabases(@NotNull DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                List<MsIntroQueries.DbInfo> list = this.this$0.performQuery(tran, MsIntrospector.access$getMyQueries$p(this.this$0).getListDatabases());
                Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
                return list;
            }

            @NotNull
            protected MsDatabase applyDatabase(@NotNull ModNamingFamily<?> databases2, @NotNull MsIntroQueries.DbInfo db2) {
                Intrinsics.checkNotNullParameter(databases2, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                MD MD = this.renew(databases2, db2.id, db2.name);
                MsDatabase $this$applyDatabase_u24lambda_u240 = (MsDatabase)MD;
                boolean bl = false;
                String string = db2.collation_name;
                $this$applyDatabase_u24lambda_u240.setCollationRef(BasicNameReference.create(string != null ? ((Object)StringsKt.trimEnd((CharSequence)string)).toString() : null));
                $this$applyDatabase_u24lambda_u240.setOnline(db2.state == 0);
                return (MsDatabase)MD;
            }
        };
    }

    @Override
    protected void introspectTheServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.trace("Introspecting server objects");
        this.retrieveLogins(tran);
        this.retrievePermissions(tran);
        if (!this.isSynapse()) {
            this.retrieveCollations(tran);
        }
        if (Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.MSSQL)) {
            this.retrieveLinkedServers(tran);
        }
    }

    private final void retrievePermissions(DBTransaction tran) {
        this.reportRetrieving("objects' permissions", "introspection.retrieve.objectPermissions");
        this.inModel((Function1)new Function1<MsRoot, Unit>(this, tran){
            final /* synthetic */ MsIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                super(1);
            }

            public final void invoke(@NotNull MsRoot r) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                this.this$0.setQueryParameter("CAT", "sys");
                boolean isAzure = this.this$0.dbms.in(Dbms.AZURE_LIKE);
                SqlQuery<Long> sqlQuery = object = MsIntrospector.access$getMyQueries$p(this.this$0).getCalculateServerPermissionsChecksum();
                DBTransaction dBTransaction = this.$tran;
                MsGrantsHolder msGrantsHolder = r;
                IntrospectionQueryContext introspectionQueryContext = this.this$0;
                boolean bl = false;
                boolean bl2 = isAzure;
                Object object2 = !bl2 ? object : null;
                Object it2 = object = MsIntrospector.access$getMyQueries$p(this.this$0).getRetrieveServerPermissions();
                SqlQuery<Long> sqlQuery2 = object2;
                boolean bl3 = false;
                boolean bl4 = isAzure;
                MsIntrospectorKt.access$retrievePermissions(introspectionQueryContext, msGrantsHolder, dBTransaction, sqlQuery2, !bl4 ? object : null);
            }
        });
    }

    private final void retrieveLogins(DBTransaction tran) {
        ObjectKind objectKind = ObjectKind.LOGIN;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"LOGIN");
        this.reportRetrieving(objectKind);
        this.inModel((Function1)new Function1<MsRoot, Unit>(this, tran){
            final /* synthetic */ MsIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                super(1);
            }

            public final void invoke(@NotNull MsRoot r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                IntrospectionQueryContext.performQueryHandleEachRow$default(this.this$0, this.$tran, MsIntrospector.access$getMyQueries$p(this.this$0).getRetrieveLogins(), 0, (Function1)new Function1<MsIntroQueries.OneLogin, Unit>(r){
                    final /* synthetic */ MsRoot $r;
                    {
                        this.$r = $r;
                        super(1);
                    }

                    public final void invoke(@NotNull MsIntroQueries.OneLogin l) {
                        MsServerPrincipalType msServerPrincipalType;
                        MsServerPrincipalType msServerPrincipalType2;
                        MsLogin msLogin;
                        block2: {
                            MsLogin msLogin2;
                            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
                            MsLogin $this$invoke_u24lambda_u241 = msLogin2 = this.$r.getLogins().renew(l.principal_id, l.name);
                            boolean bl = false;
                            $this$invoke_u24lambda_u241.setDefaultDatabase(l.default_database_name);
                            $this$invoke_u24lambda_u241.setOwnerRef(BasicIdReference.create(l.owning_principal_id));
                            $this$invoke_u24lambda_u241.setEnabled(!l.is_disabled);
                            MsServerPrincipalType[] msServerPrincipalTypeArray = MsServerPrincipalType.values();
                            msLogin = $this$invoke_u24lambda_u241;
                            MsServerPrincipalType[] msServerPrincipalTypeArray2 = msServerPrincipalTypeArray;
                            int n = msServerPrincipalTypeArray2.length;
                            for (int j = 0; j < n; ++j) {
                                MsServerPrincipalType msServerPrincipalType3;
                                MsServerPrincipalType it2 = msServerPrincipalType3 = msServerPrincipalTypeArray2[j];
                                boolean bl2 = false;
                                if (!(it2.getCode() == l.type)) continue;
                                msServerPrincipalType2 = msServerPrincipalType3;
                                break block2;
                            }
                            msServerPrincipalType2 = msServerPrincipalType = null;
                        }
                        if (msServerPrincipalType2 == null) {
                            msServerPrincipalType = MsServerPrincipalType.SQL_LOGIN;
                        }
                        msLogin.setType(msServerPrincipalType);
                    }
                }, 2, null);
            }
        });
    }

    private final void retrieveCollations(DBTransaction tran) {
        ObjectKind objectKind = ObjectKind.COLLATION;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLLATION");
        this.reportRetrieving(objectKind);
        this.inModel((Function1)new Function1<MsRoot, Unit>(this, tran){
            final /* synthetic */ MsIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MsRoot root2) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                ModFamily modFamily = root2.getCollations();
                MsIntrospector msIntrospector = this.this$0;
                DBTransaction dBTransaction = this.$tran;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily collations = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                IntrospectionQueryContext.performQueryHandleEachRow$default(msIntrospector, dBTransaction, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrieveCollations(), 0, (Function1)new Function1<MsIntroQueries.OneCollation, Unit>((ModNamingFamily<? extends MsCollation>)collations){
                    final /* synthetic */ ModNamingFamily<? extends MsCollation> $collations;
                    {
                        this.$collations = $collations;
                        super(1);
                    }

                    public final void invoke(@NotNull MsIntroQueries.OneCollation collation) {
                        Intrinsics.checkNotNullParameter((Object)collation, (String)"collation");
                        String collationName = collation.name;
                        if (collationName != null) {
                            this.$collations.createOrGet(collationName).setDescription(collation.description);
                        }
                    }
                }, 2, null);
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    private final void retrieveLinkedServers(DBTransaction tran) {
        ObjectKind objectKind = ObjectKind.LINKED_SERVER;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"LINKED_SERVER");
        this.reportRetrieving(objectKind);
        this.inModel((Function1)new Function1<MsRoot, Unit>(this, tran){
            final /* synthetic */ MsIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MsRoot root2) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                ModFamily modFamily = root2.getLinkedServers();
                MsIntrospector msIntrospector = this.this$0;
                DBTransaction dBTransaction = this.$tran;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily linkedServers = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                IntrospectionQueryContext.performQueryHandleEachRow$default(msIntrospector, dBTransaction, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrieveLinkedServers(), 0, (Function1)new Function1<MsIntroQueries.OneLinkedServer, Unit>((ModNamingFamily<? extends MsLinkedServer>)linkedServers){
                    final /* synthetic */ ModNamingFamily<? extends MsLinkedServer> $linkedServers;
                    {
                        this.$linkedServers = $linkedServers;
                        super(1);
                    }

                    public final void invoke(@NotNull MsIntroQueries.OneLinkedServer ls) {
                        MsLinkedServer msLinkedServer;
                        Intrinsics.checkNotNullParameter((Object)ls, (String)"ls");
                        String string = ls.srv_name;
                        if (string == null) {
                            return;
                        }
                        String srvName = string;
                        MsLinkedServer $this$invoke_u24lambda_u240 = msLinkedServer = this.$linkedServers.createOrGet(srvName);
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setProviderName(ls.srv_providername);
                        $this$invoke_u24lambda_u240.setProduct(ls.srv_product);
                        $this$invoke_u24lambda_u240.setDataSource(ls.srv_datasource);
                        $this$invoke_u24lambda_u240.setProviderString(ls.srv_providerstring);
                        $this$invoke_u24lambda_u240.setLocation(ls.srv_location);
                        $this$invoke_u24lambda_u240.setCatalog(ls.srv_cat);
                    }
                }, 2, null);
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        LinkedHashMap<BasicElement, Boolean> res2 = new LinkedHashMap<BasicElement, Boolean>();
        for (BasicDatabase database : JBIterable.from(elements2).transform(arg_0 -> MsIntrospector.checkElementsUptodate$lambda$2(checkElementsUptodate.1.INSTANCE, arg_0)).toSet()) {
            Object element$iv;
            LinkedHashMap<Long, MsSchemaObject> ids = new LinkedHashMap<Long, MsSchemaObject>();
            Object $this$forEach$iv = elements2;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                BasicElement it2 = element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getDatabase(), (Object)database) || !MsIntrospectorKt.access$canCheckOutdated(it2)) continue;
                Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type com.intellij.database.dialects.mssql.model.MsSchemaObject");
                MsSchemaObject cfr_ignored_0 = (MsSchemaObject)it2;
                ((Map)ids).put(((MsSchemaObject)it2).getObjectId(), it2);
            }
            if (ids.isEmpty()) continue;
            BasicDatabase basicDatabase = database;
            Intrinsics.checkNotNull((Object)basicDatabase);
            this.prepareQueryParameters$intellij_database_dialects_mssql(basicDatabase, this.getParametersMap());
            Set set = ids.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            this.setQueryParameter("OBJECT_IDS", CollectionsKt.toLongArray((Collection)set));
            $this$forEach$iv = ids;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = element$iv = (Map.Entry)iterator.next();
                boolean bl = false;
                MsSchemaObject v2 = (MsSchemaObject)object.getValue();
                ((Map)res2).put(v2, false);
            }
            BaseNativeIntrospector.performQueryHandleEachRow$default(this, MsIntroQueries.INSTANCE.getRetrieveStates(), 0, (Function1)new Function1<MsIntroQueries.OneState, Unit>(ids, res2){
                final /* synthetic */ LinkedHashMap<Long, MsSchemaObject> $ids;
                final /* synthetic */ LinkedHashMap<BasicElement, Boolean> $res;
                {
                    this.$ids = $ids;
                    this.$res = $res;
                    super(1);
                }

                public final void invoke(@NotNull MsIntroQueries.OneState s2) {
                    Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                    MsSchemaObject msSchemaObject = this.$ids.get(s2.object_id);
                    if (msSchemaObject == null) {
                        return;
                    }
                    MsSchemaObject obj2 = msSchemaObject;
                    ((Map)this.$res).put(obj2, Intrinsics.areEqual((Object)obj2.getModifiedTimestamp(), (Object)s2.modify_date));
                }
            }, 2, null);
        }
        this.inModel((Function1)new Function1<MsRoot, Unit>(res2){
            final /* synthetic */ LinkedHashMap<BasicElement, Boolean> $res;
            {
                this.$res = $res;
                super(1);
            }

            public final void invoke(@NotNull MsRoot it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Set<Map.Entry<BasicElement, Boolean>> set = this.$res.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    BasicElement obj2 = (BasicElement)entry.getKey();
                    Boolean ok2 = (Boolean)entry.getValue();
                    Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
                    ((BasicModElement)obj2).setOutdated(ok2 == false);
                }
            }
        });
        return res2;
    }

    @Override
    protected void introspectRootFragments(@NotNull DBTransaction transaction, @NotNull String databaseName, @NotNull Collection<FamilyFragment> fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        this.introspectTheServerObjects(transaction);
        this.listAndApplyDatabasesIfNotYet(transaction);
    }

    @Override
    protected void introspectDatabaseFragments(@NotNull DBTransaction transaction, @NotNull BasicDatabase database, @NotNull Collection<FamilyFragment> fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        MsDatabaseRetriever retriever = new MsDatabaseRetriever(transaction, (MsDatabase)database);
        retriever.retrieveServerAndDatabaseObjects();
    }

    @Override
    protected void introspectSchemaFragments(@NotNull DBTransaction transaction, @NotNull BasicDatabase database, @NotNull BasicSchema schema2, @NotNull Collection<FamilyFragment> fragments2, boolean checkForDroppedObjects) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        if (((MsRoot)this.getRoot()).getCollations().isEmpty()) {
            this.introspectTheServerObjects(transaction);
            this.listAndApplyDatabasesIfNotYet(transaction);
        }
        MsSchemaRetriever retriever = new MsSchemaRetriever(transaction, (MsSchema)schema2);
        retriever.prepareForFragments$intellij_database_dialects_mssql(checkForDroppedObjects);
        for (FamilyFragment fragment : fragments2) {
            Collection $this$toTypedArray$iv = fragment.getNames();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            retriever.retrieveNamedFragments(fragment.getKind(), thisCollection$iv.toArray(new String[0]));
        }
    }

    @Override
    protected void dropSpecificSessionInfo() {
        super.dropSpecificSessionInfo();
        this.schemasWhereDroppedObjectsDetected.clear();
        this.currentSessionInfo = null;
    }

    private final boolean isSynapse() {
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        return Intrinsics.areEqual((Object)(databaseConnectionCore != null && (databaseConnectionCore = databaseConnectionCore.getRemoteConnection()) != null ? databaseConnectionCore.getDetectedDbmsName() : null), (Object)"SYNAPSE");
    }

    private final boolean isSynapseMaster() {
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        return Intrinsics.areEqual((Object)(databaseConnectionCore != null && (databaseConnectionCore = databaseConnectionCore.getRemoteConnection()) != null ? databaseConnectionCore.getDetectedDbmsName() : null), (Object)"SYNAPSE_MASTER");
    }

    private final boolean isAnySynapse() {
        return this.isSynapse() || this.isSynapseMaster();
    }

    private static final BasicDatabase checkElementsUptodate$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BasicDatabase)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getParametersMap(MsIntrospector $this) {
        return $this.getParametersMap();
    }

    public static final /* synthetic */ boolean access$isAnySynapse(MsIntrospector $this) {
        return $this.isAnySynapse();
    }

    public static final /* synthetic */ void access$retrieveCollations(MsIntrospector $this, DBTransaction tran) {
        $this.retrieveCollations(tran);
    }

    public static final /* synthetic */ MsIntrospectorHelper access$getHelper$p(MsIntrospector $this) {
        return $this.helper;
    }

    static {
        Object[] objectArray = new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE, ObjectKind.RULE, ObjectKind.SEQUENCE, ObjectKind.SYNONYM, ObjectKind.SECURITY_POLICY};
        supportFragmentKinds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$Companion;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "()V", "supportFragmentIntrospection", "", "getSupportFragmentIntrospection", "()Z", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "supportServerObjects", "getSupportServerObjects", "intellij.database.dialects.mssql"})
    public static final class Companion
    implements BaseIntrospector.Nature {
        private Companion() {
        }

        @Override
        public boolean getSupportServerObjects() {
            return true;
        }

        @Override
        public boolean getSupportFragmentIntrospection() {
            return true;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return supportFragmentKinds;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "supportsFragmentIntrospection", "", "getSupportsFragmentIntrospection", "()Z", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isIncremental", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.mssql"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @NotNull
        private final Dbms dbms;
        private final boolean supportsFragmentIntrospection;

        public Factory(@NotNull Dbms dbms) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            this.dbms = dbms;
            this.supportsFragmentIntrospection = true;
        }

        @NotNull
        public final Dbms getDbms() {
            return this.dbms;
        }

        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{9};
            return version.isOrGreater(nArray);
        }

        @Override
        public boolean isIncremental() {
            return true;
        }

        public boolean getSupportsFragmentIntrospection() {
            return this.supportsFragmentIntrospection;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new MsIntrospector(context, dbms, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return MsIntrospectorKt.access$canCheckOutdated(e2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.mssql"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mssql/model/MsDatabase;)V", "beforeSchemasRetrieval", "", "beforeServerAndDatabaseObjectsRetrieval", "checkAzureDatabaseSelectedCorrectly", "checkFingerprint", "retrieveAssemblies", "retrieveColumnEncryptionKeyValues", "retrieveColumnEncryptionKeys", "retrieveColumnMasterKeys", "retrieveExtProperties", "retrieveFileGroups", "retrievePartitionFunctions", "retrievePartitionSchemes", "retrievePermissions", "retrieveRoles", "retrieveSchemas", "retrieveServerAndDatabaseObjects", "retrieveSynapseCollations", "intellij.database.dialects.mssql"})
    protected final class MsDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<MsDatabase> {
        public MsDatabaseRetriever(@NotNull DBTransaction transaction, MsDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)MsIntrospector.this, transaction, (BasicModMateDatabase)database);
        }

        @Override
        protected void beforeServerAndDatabaseObjectsRetrieval() {
            super.beforeServerAndDatabaseObjectsRetrieval();
            this.checkFingerprint();
        }

        @Override
        public void retrieveServerAndDatabaseObjects() {
            if (MsIntrospector.this.isSynapseMaster()) {
                this.retrieveSynapseCollations();
            }
            if (((MsDatabase)this.getDatabase()).getSchemas().isEmpty()) {
                return;
            }
            super.retrieveServerAndDatabaseObjects();
            this.retrieveExtProperties();
            this.retrieveRoles();
            this.retrievePermissions();
            this.retrieveColumnMasterKeys();
            this.retrieveColumnEncryptionKeys();
            this.retrieveColumnEncryptionKeyValues();
            this.retrieveAssemblies();
            this.retrievePartitionFunctions();
            this.retrieveFileGroups();
            this.retrievePartitionSchemes();
        }

        private final void retrieveRoles() {
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(this, MsIntrospector.this){
                final /* synthetic */ MsDatabaseRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull MsDatabase db2) {
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    if (db2.isOnline()) {
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, MsIntrospector.access$getMyQueries$p(this.this$1).getRetrieveRoles(), 0, (Function1)new Function1<MsIntroQueries.OneRole, Unit>(db2){
                            final /* synthetic */ MsDatabase $db;
                            {
                                this.$db = $db;
                                super(1);
                            }

                            public final void invoke(@NotNull MsIntroQueries.OneRole r) {
                                MsAuthType msAuthType;
                                Enum enum_;
                                MsRole msRole;
                                MsRole $this$invoke_u24lambda_u242;
                                block5: {
                                    MsDatabasePrincipalType msDatabasePrincipalType;
                                    MsDatabasePrincipalType msDatabasePrincipalType2;
                                    Enum it2;
                                    Enum enum_2;
                                    int n;
                                    int n3;
                                    Enum[] enumArray;
                                    Enum[] enumArray2;
                                    block4: {
                                        MsRole msRole2;
                                        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                                        $this$invoke_u24lambda_u242 = msRole2 = this.$db.getRoles().renew(r.principal_id, r.name);
                                        boolean bl = false;
                                        $this$invoke_u24lambda_u242.setDefaultSchema(r.default_schema_name);
                                        enumArray2 = MsDatabasePrincipalType.values();
                                        msRole = $this$invoke_u24lambda_u242;
                                        enumArray = enumArray2;
                                        n3 = enumArray.length;
                                        for (n = 0; n < n3; ++n) {
                                            it2 = enum_2 = enumArray[n];
                                            boolean bl2 = false;
                                            if (!(((MsDatabasePrincipalType)it2).getCode() == r.type)) continue;
                                            msDatabasePrincipalType2 = enum_2;
                                            break block4;
                                        }
                                        msDatabasePrincipalType2 = msDatabasePrincipalType = null;
                                    }
                                    if (msDatabasePrincipalType2 == null) {
                                        msDatabasePrincipalType = MsDatabasePrincipalType.SQL_USER;
                                    }
                                    msRole.setType(msDatabasePrincipalType);
                                    enumArray2 = MsAuthType.values();
                                    msRole = $this$invoke_u24lambda_u242;
                                    enumArray = enumArray2;
                                    n3 = enumArray.length;
                                    for (n = 0; n < n3; ++n) {
                                        it2 = enum_2 = enumArray[n];
                                        boolean bl = false;
                                        if (!(((MsAuthType)it2).getCode() == r.authentication_type)) continue;
                                        enum_ = enum_2;
                                        break block5;
                                    }
                                    enum_ = msAuthType = null;
                                }
                                if (enum_ == null) {
                                    msAuthType = MsAuthType.DATABASE;
                                }
                                msRole.setAuthType(msAuthType);
                                $this$invoke_u24lambda_u242.setOwnerRef(BasicIdReference.create(r.owning_principal_id));
                            }
                        }, 2, null);
                    } else {
                        db2.getRoles().clear();
                    }
                }
            });
        }

        private final void retrieveColumnMasterKeys() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN_MASTER_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN_MASTER_KEY");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(this, MsIntrospector.this){
                final /* synthetic */ MsDatabaseRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsDatabase db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    ModFamily modFamily = db2.getColumnMasterKeys();
                    MsDatabaseRetriever msDatabaseRetriever = this.this$0;
                    MsIntrospector msIntrospector = this.this$1;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily mks = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(msDatabaseRetriever, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrieveColumnMasterKeys(), 0, (Function1)new Function1<MsIntroQueries.OneColumnMasterKey, Unit>((ModNamingIdentifyingFamily<? extends MsColumnMasterKey>)mks){
                        final /* synthetic */ ModNamingIdentifyingFamily<? extends MsColumnMasterKey> $mks;
                        {
                            this.$mks = $mks;
                            super(1);
                        }

                        public final void invoke(@NotNull MsIntroQueries.OneColumnMasterKey k) {
                            MsColumnMasterKey msColumnMasterKey;
                            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                            MsColumnMasterKey $this$invoke_u24lambda_u240 = msColumnMasterKey = this.$mks.renew(k.column_master_key_id, k.name);
                            boolean bl = false;
                            $this$invoke_u24lambda_u240.setKeyStoreProviderName(k.key_store_provider_name);
                            $this$invoke_u24lambda_u240.setKeyPath(k.key_path);
                            $this$invoke_u24lambda_u240.setSignature(k.signature);
                        }
                    }, 2, null);
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void retrieveColumnEncryptionKeys() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN_ENCRYPTION_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN_ENCRYPTION_KEY");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(this, MsIntrospector.this){
                final /* synthetic */ MsDatabaseRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsDatabase db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    ModFamily modFamily = db2.getColumnEncryptionKeys();
                    MsDatabaseRetriever msDatabaseRetriever = this.this$0;
                    MsIntrospector msIntrospector = this.this$1;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily eks = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(msDatabaseRetriever, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrieveColumnEncryptionKeys(), 0, (Function1)new Function1<MsIntroQueries.OneColumnEncryptionKey, Unit>((ModNamingIdentifyingFamily<? extends MsColumnEncryptionKey>)eks){
                        final /* synthetic */ ModNamingIdentifyingFamily<? extends MsColumnEncryptionKey> $eks;
                        {
                            this.$eks = $eks;
                            super(1);
                        }

                        public final void invoke(@NotNull MsIntroQueries.OneColumnEncryptionKey k) {
                            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                            this.$eks.renew(k.column_encryption_key_id, k.name);
                        }
                    }, 2, null);
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void retrieveColumnEncryptionKeyValues() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN_ENCRYPTION_KEY_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN_ENCRYPTION_KEY_VALUE");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(this, MsIntrospector.this){
                final /* synthetic */ MsDatabaseRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsDatabase db2) {
                    void families$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    IdCache<MsColumnEncryptionKey> keyCache = new IdCache<MsColumnEncryptionKey>();
                    ModNamingIdentifyingFamily<? extends MsColumnEncryptionKey> modNamingIdentifyingFamily = db2.getColumnEncryptionKeys();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getColumnEncryptionKeys(...)");
                    Iterable $this$map$iv = modNamingIdentifyingFamily;
                    boolean $i$f$map = false;
                    Object object = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        MsColumnEncryptionKey msColumnEncryptionKey = (MsColumnEncryptionKey)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(it2.getValues());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    object = this.this$0;
                    MsIntrospector msIntrospector = this.this$1;
                    boolean inc$iv = true;
                    boolean $i$f$modifyFamiliesAndCleanup = false;
                    void $this$toTypedArray$iv$iv = families$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                    ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
                    ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                    boolean $i$f$modifyFamiliesAndCleanup2 = false;
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.markChildrenAsSyncPending();
                    }
                    boolean bl = false;
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default((BaseNativeIntrospector.AbstractRetriever)object, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrieveColumnEncryptionKeyValues(), 0, (Function1)new Function1<MsIntroQueries.OneColumnEncryptionKeyValue, Unit>(keyCache, db2){
                        final /* synthetic */ IdCache<MsColumnEncryptionKey> $keyCache;
                        final /* synthetic */ MsDatabase $db;
                        {
                            this.$keyCache = $keyCache;
                            this.$db = $db;
                            super(1);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final void invoke(@NotNull MsIntroQueries.OneColumnEncryptionKeyValue v) {
                            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                            var4_2 = this.$keyCache;
                            var5_3 = v.column_encryption_key_id;
                            var7_5 = this.$db;
                            $i$f$getOrCache = false;
                            if (this_$iv.getV() == null) ** GOTO lbl-1000
                            v0 = this_$iv.getV();
                            Intrinsics.checkNotNull(v0);
                            if (v0.getObjectId() == id$iv) {
                                v1 = this_$iv.getV();
                            } else lbl-1000:
                            // 2 sources

                            {
                                var9_7 = id$iv;
                                var11_8 = this_$iv;
                                var13_9 = this_$iv;
                                $i$a$-getOrCache-MsIntrospector$MsDatabaseRetriever$retrieveColumnEncryptionKeyValues$1$2$1$key$1 = false;
                                var13_9.setV((BasicModIdentifiedElement)((MsColumnEncryptionKey)var7_5.getColumnEncryptionKeys().getByObjectId((long)it)));
                                v1 = this_$iv.getV();
                            }
                            v2 = (MsColumnEncryptionKey)v1;
                            if (v2 == null) {
                                return;
                            }
                            key = v2;
                            $this$invoke_u24lambda_u241 = var3_12 = key.getValues().renew(v.column_master_key_id, "");
                            $i$a$-apply-MsIntrospector$MsDatabaseRetriever$retrieveColumnEncryptionKeyValues$1$2$1$1 = false;
                            $this$invoke_u24lambda_u241.setNameSurrogate(true);
                            $this$invoke_u24lambda_u241.setMasterKeyRef(BasicIdReference.create(v.column_master_key_id));
                            $this$invoke_u24lambda_u241.setEncryptedValue(v.encrypted_value);
                            $this$invoke_u24lambda_u241.setAlgorithm(v.encryption_algorithm_name);
                        }
                    }, 2, null);
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.removeSyncPendingChildren();
                        f$iv$iv.sort();
                    }
                }
            });
        }

        private final void retrieveAssemblies() {
            ObjectKind objectKind = ObjectKind.ASSEMBLY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ASSEMBLY");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(this, MsIntrospector.this){
                final /* synthetic */ MsDatabaseRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsDatabase db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    ModFamily modFamily = db2.getAssemblies();
                    MsDatabaseRetriever msDatabaseRetriever = this.this$0;
                    MsIntrospector msIntrospector = this.this$1;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily assemblies = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(msDatabaseRetriever, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrieveAssemblies(), 0, (Function1)new Function1<MsIntroQueries.OneAssembly, Unit>((ModNamingIdentifyingFamily<? extends MsAssembly>)assemblies){
                        final /* synthetic */ ModNamingIdentifyingFamily<? extends MsAssembly> $assemblies;
                        {
                            this.$assemblies = $assemblies;
                            super(1);
                        }

                        public final void invoke(@NotNull MsIntroQueries.OneAssembly a) {
                            MsAssembly msAssembly;
                            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                            MsAssembly $this$invoke_u24lambda_u240 = msAssembly = this.$assemblies.renew(a.assembly_id, a.name);
                            boolean bl = false;
                            $this$invoke_u24lambda_u240.setVisible(a.is_visible);
                        }
                    }, 2, null);
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void retrievePartitionFunctions() {
            ObjectKind objectKind = ObjectKind.PARTITION_FUNCTION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PARTITION_FUNCTION");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(this, MsIntrospector.this){
                final /* synthetic */ MsDatabaseRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsDatabase db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    ModFamily modFamily = db2.getPartitionFunctions();
                    MsDatabaseRetriever msDatabaseRetriever = this.this$0;
                    MsIntrospector msIntrospector = this.this$1;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily partitionFunctions = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(msDatabaseRetriever, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrievePartitionFunctions(), 0, (Function1)new Function1<MsIntroQueries.OnePartitionFunction, Unit>((ModNamingIdentifyingFamily<? extends MsPartitionFunction>)partitionFunctions){
                        final /* synthetic */ ModNamingIdentifyingFamily<? extends MsPartitionFunction> $partitionFunctions;
                        {
                            this.$partitionFunctions = $partitionFunctions;
                            super(1);
                        }

                        public final void invoke(@NotNull MsIntroQueries.OnePartitionFunction pf) {
                            MsPartitionFunction msPartitionFunction;
                            Intrinsics.checkNotNullParameter((Object)pf, (String)"pf");
                            MsPartitionFunction $this$invoke_u24lambda_u240 = msPartitionFunction = this.$partitionFunctions.renew(pf.function_id, pf.name);
                            boolean bl = false;
                            $this$invoke_u24lambda_u240.setParameterStoredType(MsIntrospectorKt.access$makeDasType(pf.type_name, pf.max_length, pf.precision, pf.scale));
                            $this$invoke_u24lambda_u240.setRight(pf.boundary_value_on_right);
                        }
                    }, 2, null);
                    MultiMap rangeValues = new MultiMap();
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(msDatabaseRetriever, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrievePartitionFunctionRanges(), 0, (Function1)new Function1<MsIntroQueries.OnePartitionFunctionRange, Unit>((ModNamingIdentifyingFamily<? extends MsPartitionFunction>)partitionFunctions, (MultiMap<MsPartitionFunction, String>)rangeValues){
                        final /* synthetic */ ModNamingIdentifyingFamily<? extends MsPartitionFunction> $partitionFunctions;
                        final /* synthetic */ MultiMap<MsPartitionFunction, String> $rangeValues;
                        {
                            this.$partitionFunctions = $partitionFunctions;
                            this.$rangeValues = $rangeValues;
                            super(1);
                        }

                        public final void invoke(@NotNull MsIntroQueries.OnePartitionFunctionRange pfr) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)pfr, (String)"pfr");
                                MsPartitionFunction msPartitionFunction = (MsPartitionFunction)this.$partitionFunctions.getByObjectId(pfr.function_id);
                                if (msPartitionFunction == null) break block0;
                                MsPartitionFunction msPartitionFunction2 = msPartitionFunction;
                                MultiMap<MsPartitionFunction, String> multiMap = this.$rangeValues;
                                MsPartitionFunction it2 = msPartitionFunction2;
                                boolean bl = false;
                                Object value2 = pfr.boundary_value;
                                String text2 = value2 instanceof byte[] ? "0x" + StringUtil.toHexString((byte[])((byte[])value2)) : String.valueOf(value2);
                                multiMap.putValue((Object)it2, (Object)text2);
                            }
                        }
                    }, 2, null);
                    for (Map.Entry entry : rangeValues.entrySet()) {
                        Intrinsics.checkNotNull((Object)entry);
                        MsPartitionFunction pf = (MsPartitionFunction)entry.getKey();
                        Collection v2 = (Collection)entry.getValue();
                        Intrinsics.checkNotNull((Object)v2);
                        pf.setBoundaryValues(CollectionsKt.toList((Iterable)v2));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void retrieveFileGroups() {
            ObjectKind objectKind = ObjectKind.FILEGROUP;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FILEGROUP");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(this, MsIntrospector.this){
                final /* synthetic */ MsDatabaseRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsDatabase db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    ModFamily modFamily = db2.getFileGroups();
                    MsDatabaseRetriever msDatabaseRetriever = this.this$0;
                    MsIntrospector msIntrospector = this.this$1;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily fileGroups = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(msDatabaseRetriever, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrieveFileGroups(), 0, (Function1)new Function1<MsIntroQueries.OneFileGroup, Unit>((ModNamingIdentifyingFamily<? extends MsFileGroup>)fileGroups){
                        final /* synthetic */ ModNamingIdentifyingFamily<? extends MsFileGroup> $fileGroups;
                        {
                            this.$fileGroups = $fileGroups;
                            super(1);
                        }

                        public final void invoke(@NotNull MsIntroQueries.OneFileGroup fg) {
                            MsFileGroup msFileGroup;
                            Intrinsics.checkNotNullParameter((Object)fg, (String)"fg");
                            MsFileGroup $this$invoke_u24lambda_u240 = msFileGroup = this.$fileGroups.renew(fg.data_space_id, fg.name);
                            boolean bl = false;
                            $this$invoke_u24lambda_u240.setDataSpaceKind(MsDataSpaceKind.Companion.valueFor(fg.type));
                            $this$invoke_u24lambda_u240.setDefaultGroup(fg.is_default);
                            $this$invoke_u24lambda_u240.setSystem(fg.is_system);
                            $this$invoke_u24lambda_u240.setReadOnly(fg.is_read_only);
                            $this$invoke_u24lambda_u240.setAutoGrowAllFiles(fg.is_autogrow_all_files);
                        }
                    }, 2, null);
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void retrievePartitionSchemes() {
            ObjectKind objectKind = ObjectKind.PARTITION_SCHEME;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PARTITION_SCHEME");
            MsIntrospector.this.reportRetrieving(objectKind);
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(this, MsIntrospector.this){
                final /* synthetic */ MsDatabaseRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsDatabase db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    ModFamily modFamily = db2.getPartitionSchemes();
                    MsDatabaseRetriever msDatabaseRetriever = this.this$0;
                    MsIntrospector msIntrospector = this.this$1;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily partitionSchemes = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(msDatabaseRetriever, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrievePartitionSchemes(), 0, (Function1)new Function1<MsIntroQueries.OnePartitionScheme, Unit>((ModNamingIdentifyingFamily<? extends MsPartitionScheme>)partitionSchemes){
                        final /* synthetic */ ModNamingIdentifyingFamily<? extends MsPartitionScheme> $partitionSchemes;
                        {
                            this.$partitionSchemes = $partitionSchemes;
                            super(1);
                        }

                        public final void invoke(@NotNull MsIntroQueries.OnePartitionScheme ps) {
                            MsPartitionScheme msPartitionScheme;
                            Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
                            MsPartitionScheme $this$invoke_u24lambda_u240 = msPartitionScheme = this.$partitionSchemes.renew(ps.data_space_id, ps.name);
                            boolean bl = false;
                            $this$invoke_u24lambda_u240.setDataSpaceKind(MsDataSpaceKind.PARTITION_SCHEME);
                            $this$invoke_u24lambda_u240.setPartitionFunctionRef(BasicIdReference.create(ps.function_id));
                        }
                    }, 2, null);
                    if (!MsIntrospector.access$isAnySynapse(msIntrospector)) {
                        MultiMap fileGroupRefs = new MultiMap();
                        BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(msDatabaseRetriever, MsIntrospector.access$getMyQueries$p(msIntrospector).getRetrievePartitionSchemeMappings(), 0, (Function1)new Function1<MsIntroQueries.OnePartitionSchemeMapping, Unit>((ModNamingIdentifyingFamily<? extends MsPartitionScheme>)partitionSchemes, (MultiMap<MsPartitionScheme, BasicReference>)fileGroupRefs){
                            final /* synthetic */ ModNamingIdentifyingFamily<? extends MsPartitionScheme> $partitionSchemes;
                            final /* synthetic */ MultiMap<MsPartitionScheme, BasicReference> $fileGroupRefs;
                            {
                                this.$partitionSchemes = $partitionSchemes;
                                this.$fileGroupRefs = $fileGroupRefs;
                                super(1);
                            }

                            public final void invoke(@NotNull MsIntroQueries.OnePartitionSchemeMapping psm) {
                                Intrinsics.checkNotNullParameter((Object)psm, (String)"psm");
                                MsPartitionScheme msPartitionScheme = (MsPartitionScheme)this.$partitionSchemes.getByObjectId(psm.partition_scheme_id);
                                if (msPartitionScheme == null) {
                                    return;
                                }
                                MsPartitionScheme partitionScheme = msPartitionScheme;
                                this.$fileGroupRefs.putValue((Object)partitionScheme, (Object)BasicIdReference.create(psm.data_space_id));
                            }
                        }, 2, null);
                        for (Map.Entry entry : fileGroupRefs.entrySet()) {
                            Intrinsics.checkNotNull((Object)entry);
                            MsPartitionScheme ps = (MsPartitionScheme)entry.getKey();
                            Collection refs = (Collection)entry.getValue();
                            Intrinsics.checkNotNull((Object)refs);
                            ps.setFileGroupRefs(CollectionsKt.toList((Iterable)refs));
                        }
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void retrievePermissions() {
            MsIntrospector.this.reportRetrieving("objects' permissions", "introspection.retrieve.objectPermissions");
            if (((MsDatabase)this.getDatabase()).isOnline()) {
                MsIntrospectorKt.access$retrievePermissions(this, (MsGrantsHolder)this.getDatabase(), this.getTransaction(), MsIntrospector.this.myQueries.getCalculateDbPermissionsChecksum(), MsIntrospector.this.myQueries.getRetrieveDbPermissions());
            } else {
                MsIntrospectorKt.access$retrievePermissions(this, (MsGrantsHolder)this.getDatabase(), this.getTransaction(), null, null);
            }
        }

        private final void retrieveSynapseCollations() {
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>(MsIntrospector.this, this){
                final /* synthetic */ MsIntrospector this$0;
                final /* synthetic */ MsDatabaseRetriever this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull MsDatabase it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    MsIntrospector.access$retrieveCollations(this.this$0, MsDatabaseRetriever.access$getTransaction(this.this$1));
                }
            });
        }

        private final void retrieveExtProperties() {
            List<MsIntroQueries.OneProperty> props = ((MsDatabase)this.getDatabase()).isOnline() ? this.performQuery(MsIntrospector.this.myQueries.getRetrieveDbExtendedProperties()) : null;
            MsIntrospectorKt.access$setExtProps((MsExtendedPropertiesHolder)this.getDatabase(), props);
        }

        private final void checkFingerprint() {
            String oldFingerprint;
            String newFingerprint;
            String string;
            if (!((MsDatabase)this.getDatabase()).isOnline()) {
                this.inDatabase(checkFingerprint.1.INSTANCE);
                return;
            }
            String string2 = ((MsDatabase)this.getDatabase()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String databaseName = string2;
            String calculatedFingerprint = this.performQuery(MsIntrospector.this.myQueries.getQueryFingerprint());
            if (calculatedFingerprint == null) {
                this.log.warn("Failed to calculate the fingerprint for the database " + databaseName);
            }
            if ((string = calculatedFingerprint) == null) {
                string = newFingerprint = "failed-to-calculate";
            }
            if ((oldFingerprint = ((MsDatabase)this.getDatabase()).getFingerprint()) == null) {
                this.log.info("Setting the fingerprint for the database " + databaseName + ": " + newFingerprint);
                this.inDatabase((Function1)new Function1<MsDatabase, Unit>(newFingerprint){
                    final /* synthetic */ String $newFingerprint;
                    {
                        this.$newFingerprint = $newFingerprint;
                        super(1);
                    }

                    public final void invoke(@NotNull MsDatabase db2) {
                        Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                        db2.setFingerprint(this.$newFingerprint);
                    }
                });
                return;
            }
            if (!Intrinsics.areEqual((Object)newFingerprint, (Object)oldFingerprint)) {
                this.log.info("Database replacement for database " + databaseName + " detected: \n\told fingerprint: " + oldFingerprint + " \n\tnew fingerprint: " + newFingerprint + " ");
                this.inDatabase((Function1)new Function1<MsDatabase, Unit>(newFingerprint){
                    final /* synthetic */ String $newFingerprint;
                    {
                        this.$newFingerprint = $newFingerprint;
                        super(1);
                    }

                    public final void invoke(@NotNull MsDatabase db2) {
                        Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                        for (MsSchema schema2 : db2.getSchemas()) {
                            schema2.setIntrospectionTimestamp(null);
                            schema2.setComment(null);
                            schema2.setExtendedProperties(CollectionsKt.emptyList());
                            schema2.setAliasTypesCheckSum(0L);
                            schema2.setDescriptionsCheckSum(0L);
                        }
                        db2.setFingerprint(this.$newFingerprint);
                    }
                });
            }
        }

        @Override
        protected void beforeSchemasRetrieval() {
            if (MsIntrospector.this.dbms.in(Dbms.AZURE_LIKE)) {
                this.checkAzureDatabaseSelectedCorrectly();
            }
            MsIntrospector.this.prepareQueryParameters$intellij_database_dialects_mssql((BasicDatabase)this.getDatabase(), this.getParametersMap());
        }

        private final void checkAzureDatabaseSelectedCorrectly() {
            String connectionDbName = ((MsIntrospector)MsIntrospector.this).getDbConnectionInfo().databaseName;
            String requestedDbName = ((MsDatabase)this.getDatabase()).getCatalogName();
            if (!Intrinsics.areEqual((Object)connectionDbName, (Object)requestedDbName)) {
                MsIntrospector.this.getErrorSink().consume((Object)("Azure limitation: Attempted to introspect database [" + requestedDbName + "] with connection to database [" + connectionDbName + "] might ends with Azure error [40515]"), null);
            }
        }

        @Override
        public void retrieveSchemas() {
            MsIntrospector.this.trace("Listing schemas of database " + ((MsDatabase)this.getDatabase()).getName());
            super.retrieveSchemas();
            Ref.ObjectRef scs = new Ref.ObjectRef();
            try {
                List<MsIntroQueries.OneSchema> list;
                if (((MsDatabase)this.getDatabase()).isOnline()) {
                    List<MsIntroQueries.OneSchema> list2 = this.performQuery(MsIntrospector.this.myQueries.getListSchemas());
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"performQuery(...)");
                    list = list2;
                } else {
                    list = CollectionsKt.emptyList();
                }
                scs.element = list;
            }
            catch (DBException e2) {
                int vendorCode = e2.vendorErrorCode;
                switch (vendorCode) {
                    case 916: 
                    case 40515: {
                        MsIntrospector.this.trace("Error " + vendorCode + ": " + e2.getMessage());
                        scs.element = CollectionsKt.emptyList();
                        break;
                    }
                    default: {
                        MsIntrospector.this.getErrorSink().consume(null, (Object)e2);
                        throw e2;
                    }
                }
            }
            this.inDatabase((Function1)new Function1<MsDatabase, Unit>((Ref.ObjectRef<List<MsIntroQueries.OneSchema>>)scs){
                final /* synthetic */ Ref.ObjectRef<List<MsIntroQueries.OneSchema>> $scs;
                {
                    this.$scs = $scs;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsDatabase db2) {
                    void $this$applySchemasImpl$iv;
                    Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
                    NamingFamily namingFamily = db2.getSchemas();
                    Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
                    NamingFamily schemas2 = namingFamily;
                    ModNamingFamily modNamingFamily = (ModNamingFamily)schemas2;
                    List scs$iv = (List)this.$scs.element;
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv = scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void sc2;
                        T element$iv$iv;
                        T sc$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        MsIntroQueries.OneSchema oneSchema = (MsIntroQueries.OneSchema)sc$iv;
                        void $this$invoke_u24lambda_u241 = $this$applySchemasImpl$iv;
                        boolean bl2 = false;
                        E e2 = schemas2.renew(sc2.id, sc2.name);
                        MsSchema $this$invoke_u24lambda_u241_u24lambda_u240 = (MsSchema)e2;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setCurrent(sc2.curr);
                    }
                    $this$applySchemasImpl$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv.sort();
                }
            });
        }

        public static final /* synthetic */ DBTransaction access$getTransaction(MsDatabaseRetriever $this) {
            return $this.getTransaction();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\b\u0010 \u001a\u00020\u001eH\u0002J\u001a\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\"\u0010!\u001a\u0012\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010$\u0018\u00010%2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\b\u0010&\u001a\u00020\u001eH\u0014J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016JH\u0010*\u001a\b\u0012\u0004\u0012\u0002H,0+\"\u0004\b\u0000\u0010,2\u0014\u0010-\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H,0/0.2\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u000201\u0018\u00010%2\u0006\u00102\u001a\u000203H\u0014J\u0015\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020(H\u0000\u00a2\u0006\u0002\b6J\b\u00107\u001a\u00020\u001eH\u0016J\u0010\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020:H\u0002J\u0016\u0010;\u001a\u00020\u001e2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020=0+H\u0002J\u0016\u0010>\u001a\u00020\u001e2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0+H\u0002JU\u0010A\u001a\u00020\u001e\"\b\b\u0000\u0010B*\u00020C\"\u0004\b\u0001\u0010,2\u0006\u0010D\u001a\u0002HB2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u0002H,0%2\u001a\u0010G\u001a\u0016\u0012\u0004\u0012\u00020I\u0012\u0006\u0012\u0004\u0018\u0001H,\u0012\u0004\u0012\u00020\u001e0HH\u0002\u00a2\u0006\u0002\u0010JJV\u0010A\u001a\u00020\u001e\"\b\b\u0000\u0010B*\u00020C\"\u0004\b\u0001\u0010,2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HB0L2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u0002H,0%2\u001a\u0010G\u001a\u0016\u0012\u0004\u0012\u00020I\u0012\u0006\u0012\u0004\u0018\u0001H,\u0012\u0004\u0012\u00020\u001e0HH\u0002JU\u0010M\u001a\u00020\u001e\"\b\b\u0000\u0010B*\u00020N\"\u0004\b\u0001\u0010,2\u0006\u0010O\u001a\u0002HB2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u0002H,0%2\u001a\u0010G\u001a\u0016\u0012\u0004\u0012\u00020I\u0012\u0006\u0012\u0004\u0018\u0001H,\u0012\u0004\u0012\u00020\u001e0HH\u0002\u00a2\u0006\u0002\u0010PJ$\u0010Q\u001a\u00020\u001e2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0+2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U0+H\u0002J$\u0010V\u001a\u00020\u001e2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020W0+2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020X0+H\u0002J\u0016\u0010Y\u001a\u00020\u001e2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0+H\u0002J\u0010\u0010\\\u001a\u00020\u001e2\u0006\u0010]\u001a\u00020:H\u0002J \u0010^\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`H\u0002J \u0010^\u001a\u00020\u001e2\u0006\u0010b\u001a\u00020c2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`H\u0002J\u0018\u0010d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010e\u001a\u00020fH\u0002J\b\u0010g\u001a\u00020\u001eH\u0002J\b\u0010h\u001a\u00020\u001eH\u0002J\b\u0010i\u001a\u00020\u001eH\u0002J\b\u0010j\u001a\u00020\u001eH\u0002J\b\u0010k\u001a\u00020\u001eH\u0002J\b\u0010l\u001a\u00020\u001eH\u0002J\b\u0010m\u001a\u00020\u001eH\u0002J\b\u0010n\u001a\u00020\u001eH\u0002J\b\u0010o\u001a\u00020\u001eH\u0002J\b\u0010p\u001a\u00020\u001eH\u0014J\b\u0010q\u001a\u00020\u001eH\u0014J\b\u0010r\u001a\u00020\u001eH\u0002J#\u0010s\u001a\u00020\u001e2\u0006\u0010t\u001a\u00020u2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020$0wH\u0016\u00a2\u0006\u0002\u0010xJ\b\u0010y\u001a\u00020\u001eH\u0002J\b\u0010z\u001a\u00020\u001eH\u0002J\b\u0010{\u001a\u00020\u001eH\u0002J\b\u0010|\u001a\u00020\u001eH\u0002J\b\u0010}\u001a\u00020\u001eH\u0002J\b\u0010~\u001a\u00020\u001eH\u0002J\b\u0010\u007f\u001a\u00020\u001eH\u0002J\t\u0010\u0080\u0001\u001a\u00020\u001eH\u0002J\t\u0010\u0081\u0001\u001a\u00020\u001eH\u0002J\t\u0010\u0082\u0001\u001a\u00020\u001eH\u0002J\t\u0010\u0083\u0001\u001a\u00020\u001eH\u0002J\t\u0010\u0084\u0001\u001a\u00020\u001eH\u0002J\t\u0010\u0085\u0001\u001a\u00020\u001eH\u0002J\t\u0010\u0086\u0001\u001a\u00020\u001eH\u0002J\t\u0010\u0087\u0001\u001a\u00020\u001eH\u0002J\u0015\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\u0007\u0010O\u001a\u00030\u008a\u0001H\u0002J\u0015\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u0089\u00012\u0007\u0010O\u001a\u00030\u008a\u0001H\u0002J\u0011\u0010\u008c\u0001\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u0089\u0001*\u000201H\u0002J\u0018\u0010\u008e\u0001\u001a\u00030\u008a\u0001*\u00030\u008f\u00012\u0007\u0010\u0090\u0001\u001a\u00020(H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0091\u0001"}, d2={"Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/mssql/model/MsSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/mssql/model/MsRoot;", "Lcom/intellij/database/dialects/mssql/model/MsDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/mssql/introspector/MsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/mssql/model/MsSchema;)V", "myFromTimestamp", "Ljava/sql/Timestamp;", "myIntrospectionBeginTimestamp", "myTouchedMajorSourceAware", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/mssql/model/MsSourceAware;", "myTouchedRoutines", "Ljava/util/HashSet;", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "myTouchedRules", "Lcom/intellij/database/dialects/mssql/model/MsRule;", "myTouchedSequences", "Lcom/intellij/database/dialects/mssql/model/MsSequence;", "myTouchedSynonyms", "Lcom/intellij/database/dialects/mssql/model/MsSynonym;", "myTouchedTableWithTriggers", "Lcom/intellij/database/dialects/mssql/model/MsTableOrView;", "myTouchedTables", "Lcom/intellij/database/dialects/mssql/model/MsLikeTable;", "analyzeBriefInfo", "", "analyzeCurrentContent", "determineDroppedObjects", "extractDefaults", "r", "text", "", "", "finishSchema", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "performQueryForList", "", "X", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "", "namedParameters", "", "packSize", "", "prepareForFragments", "checkForDroppedObjects", "prepareForFragments$intellij_database_dialects_mssql", "prepareParameters", "processAliasTypes", "aliasTypesCheckSum", "", "processCheckConstraints", "cs", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneCheckConstraints;", "processColumns", "cols", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneColumn;", "processExtendedPropertiesForObjects", "T", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "obj", "values", "Lcom/intellij/database/dialects/mssql/introspector/ExtPropId;", "processor", "Lkotlin/Function2;", "Lcom/intellij/database/model/basic/BasicModElement;", "(Lcom/intellij/database/model/basic/BasicModIdentifiedElement;Ljava/util/Map;Lkotlin/jvm/functions/Function2;)V", "family", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "processExtendedPropertiesForType", "Lcom/intellij/database/dialects/mssql/model/MsCustomType;", "type", "(Lcom/intellij/database/dialects/mssql/model/MsCustomType;Ljava/util/Map;Lkotlin/jvm/functions/Function2;)V", "processFulltextIndices", "inds", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneFulltextIndex;", "ics", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneFulltextIndexColumn;", "processIndices", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneIndex;", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneIndexColumn;", "processKeys", "ks", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneKey;", "processTableTypes", "tableTypesCheckSum", "removeUnexistentIndices", "existentIndicesCombies", "Lit/unimi/dsi/fastutil/longs/LongSet;", "tablesWithFulltextIndices", "table", "Lcom/intellij/database/dialects/mssql/model/MsStoredTable;", "removeUnexistentSchemaObjects", "existentObjectIds", "Lit/unimi/dsi/fastutil/ints/AbstractIntSet;", "retrieveArguments", "retrieveCheckConstraints", "retrieveColumns", "retrieveCustomTypes", "retrieveDescription", "retrieveForeignKeys", "retrieveFulltextIndices", "retrieveIndices", "retrieveKeys", "retrieveMainContent", "retrieveMajorNames", "retrieveMajorObjects", "retrieveNamedFragments", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "fragmentNames", "", "(Lcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "retrievePartitions", "retrievePermissions", "retrieveRules", "retrieveSecurityPolicies", "retrieveSecurityPredicates", "retrieveSequences", "retrieveSources", "retrieveSynonyms", "retrieveTablesExtra", "retrieveTriggers", "retrieveTypeCheckConstraints", "retrieveTypeColumns", "retrieveTypeIndices", "retrieveTypeKeys", "retrieveViewsExtra", "sequenceUnlimitedMaximumDefault", "Ljava/math/BigInteger;", "Lcom/intellij/database/types/DasType;", "sequenceUnlimitedMinimumDefault", "whetherSourcesActual", "asBigInteger", "getDasType", "Lcom/intellij/database/dialects/mssql/introspector/MsIntroQueries$OneSequence;", "isUnderlying", "intellij.database.dialects.mssql"})
    @SourceDebugExtension(value={"SMAP\nMsIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 7 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n*L\n1#1,2209:1\n1#2:2210\n981#3:2211\n968#3,2:2212\n982#3:2214\n766#4:2215\n857#4,2:2216\n288#4,2:2218\n288#4,2:2220\n1477#4:2222\n1502#4,3:2223\n1505#4,3:2233\n1855#4,2:2236\n1855#4,2:2238\n1855#4,2:2241\n1238#4,4:2244\n372#5,7:2226\n391#6:2240\n26#7:2243\n*S KotlinDebug\n*F\n+ 1 MsIntrospector.kt\ncom/intellij/database/dialects/mssql/introspector/MsIntrospector$MsSchemaRetriever\n*L\n696#1:2211\n696#1:2212,2\n696#1:2214\n773#1:2215\n773#1:2216,2\n914#1:2218,2\n918#1:2220,2\n1773#1:2222\n1773#1:2223,3\n1773#1:2233,3\n1803#1:2236,2\n1804#1:2238,2\n1867#1:2241,2\n1876#1:2244,4\n1773#1:2226,7\n1844#1:2240\n1874#1:2243\n*E\n"})
    protected final class MsSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<MsSchema> {
        @NotNull
        private Timestamp myFromTimestamp;
        @NotNull
        private Timestamp myIntrospectionBeginTimestamp;
        @NotNull
        private final ArrayList<MsLikeTable> myTouchedTables;
        @NotNull
        private final ArrayList<MsSourceAware> myTouchedMajorSourceAware;
        @NotNull
        private final ArrayList<MsRule> myTouchedRules;
        @NotNull
        private final HashSet<MsRoutine> myTouchedRoutines;
        @NotNull
        private final HashSet<MsTableOrView> myTouchedTableWithTriggers;
        @NotNull
        private final HashSet<MsSequence> myTouchedSequences;
        @NotNull
        private final HashSet<MsSynonym> myTouchedSynonyms;

        public MsSchemaRetriever(@NotNull DBTransaction transaction, MsSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((BaseNativeIntrospector)MsIntrospector.this, transaction, (BasicModSchema)schema2);
            this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.myIntrospectionBeginTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.myTouchedTables = new ArrayList();
            this.myTouchedMajorSourceAware = new ArrayList();
            this.myTouchedRules = new ArrayList();
            this.myTouchedRoutines = new HashSet();
            this.myTouchedTableWithTriggers = new HashSet();
            this.myTouchedSequences = new HashSet();
            this.myTouchedSynonyms = new HashSet();
        }

        public final void prepareForFragments$intellij_database_dialects_mssql(boolean checkForDroppedObjects) {
            this.setMode(IntrospectionMode.FRAGMENT);
            this.prepareParameters();
            this.analyzeBriefInfo();
            if (checkForDroppedObjects) {
                this.determineDroppedObjects();
            }
        }

        @Override
        public void prepareParameters() {
            boolean bl;
            MsDatabase database = ((MsSchema)this.getSchema()).getDatabase();
            boolean bl2 = bl = database != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            MsDatabase msDatabase = database;
            Intrinsics.checkNotNull((Object)msDatabase);
            MsIntrospector.this.prepareQueryParameters$intellij_database_dialects_mssql(msDatabase, this.getParametersMap());
            super.prepareParameters();
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull MsSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            return schema2.getIntrospectionTimestamp() != null && (MsIntrospector.this.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.NO_SOURCES || this.whetherSourcesActual(schema2));
        }

        private final boolean whetherSourcesActual(MsSchema schema2) {
            Date date = schema2.getIntrospectionTimestamp();
            return Intrinsics.areEqual((Object)this.getModel().getSchemaSourcesVersion(schema2), (Object)(date != null ? Long.valueOf(date.getTime()) : null));
        }

        @NotNull
        protected <X> List<X> performQueryForList(@NotNull SqlQuery<? extends Iterable<? extends X>> query, @Nullable Map<String, ? extends Object> namedParameters, int packSize) {
            Intrinsics.checkNotNullParameter(query, (String)"query");
            try {
                return super.performQueryForList(query, namedParameters, packSize);
            }
            catch (DBException e2) {
                if (e2.vendorErrorCode == 916) {
                    return CollectionsKt.emptyList();
                }
                this.log.error("Error occurred during introspection, query " + query.getDisplayName() + ":\n" + e2.getMessage() + "\nSQL statement:\n" + e2.statementText);
                return CollectionsKt.emptyList();
            }
        }

        @Override
        protected void analyzeBriefInfo() {
            if (this.getMode() != IntrospectionMode.FRAGMENT) {
                IntrospectionQueryContext introspectionQueryContext = this;
                DBTransaction dBTransaction = this.getTransaction();
                ResultLayout resultLayout = Layouts.singleOf(Timestamp.class);
                Intrinsics.checkNotNullExpressionValue((Object)resultLayout, (String)"singleOf(...)");
                Object object = IntrospectionQueryContext.runQuery$default(introspectionQueryContext, dBTransaction, "select current_timestamp", resultLayout, null, 4, null);
                Intrinsics.checkNotNull((Object)object);
                this.myIntrospectionBeginTimestamp = (Timestamp)object;
                MsIntrospector.this.trace("Server timestamp: " + this.myIntrospectionBeginTimestamp);
            }
            Date lastIntrospectionTimestamp = ((MsSchema)this.getSchema()).getIntrospectionTimestamp();
            boolean schemaHasObjects = ModelFun.isNotEmpty((BasicSchema)this.getSchema());
            Date it2 = lastIntrospectionTimestamp;
            boolean bl = false;
            boolean schemaWasIntrospected = it2 != null && it2.compareTo(BaseIntrospectionFunctions.AGES_AGO) > 0;
            if (this.getMode() != IntrospectionMode.FRAGMENT) {
                this.setMode(schemaHasObjects && schemaWasIntrospected ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL);
            }
            this.myFromTimestamp = this.getMode().increment && lastIntrospectionTimestamp != null ? CalendarFun.toTimestamp(lastIntrospectionTimestamp) : BaseIntrospectionFunctions.AGES_AGO;
            Long existentSourcesVersion = this.getModel().getSchemaSourcesVersion((BasicSchema)this.getSchema());
            Timestamp existentSourcesTimestamp = existentSourcesVersion != null && existentSourcesVersion > 0L ? new Timestamp(existentSourcesVersion) : null;
            Timestamp sourcesSince = this.getMode().increment && existentSourcesTimestamp != null ? existentSourcesTimestamp : BaseIntrospectionFunctions.AGES_AGO;
            BaseIntrospector this_$iv = MsIntrospector.this;
            boolean $i$f$trace = false;
            BaseIntrospector this_$iv$iv = this_$iv;
            boolean $i$f$getTracing = false;
            Logger logger2 = BaseIntrospector.access$getDbLogger(this_$iv$iv);
            Level level$iv$iv = logger2 != null ? BaseIntrospector.Companion.access$getEffectiveLevel(BaseIntrospector.Companion, logger2) : null;
            if (level$iv$iv != null && level$iv$iv.intValue() <= BaseIntrospector.access$getTRACE_LEVEL_VALUE$cp()) {
                BaseIntrospector baseIntrospector = this_$iv;
                boolean bl2 = false;
                BaseIntrospector.access$trace(baseIntrospector, StringsKt.trimMargin$default((String)("|Analysing schema briefly:\n           |\\tSchema has objects:      " + schemaHasObjects + "\n           |\\tLast introspection time: " + lastIntrospectionTimestamp + "\n           |\\tExistent sources time:   " + existentSourcesTimestamp + "\n           |\\tDecided mode:            " + this.getMode() + "\n        "), null, (int)1, null));
            }
            this.setQueryParameter("since", this.myFromTimestamp);
            this.setQueryParameter("src_since", sourcesSince);
        }

        @Override
        protected void analyzeCurrentContent() {
            super.analyzeCurrentContent();
            this.determineDroppedObjects();
        }

        private final void determineDroppedObjects() {
            if (MsIntrospector.this.schemasWhereDroppedObjectsDetected.contains(this.getSchema())) {
                MsIntrospector.this.trace("Dropped objects are already determined.");
                return;
            }
            MsIntrospector.this.reportStatusDetails("Determining dropped objects", "introspection.retrieve.droppedObjects");
            int[] existentObjectsArray = this.performQuery(MsIntrospector.this.myQueries.getListExistentObjects());
            int n = existentObjectsArray.length;
            MsIntrospector.this.trace("The schema on the server contains " + n + " regular major object identifiers");
            IntOpenHashSet existentObjectIds = new IntOpenHashSet(existentObjectsArray);
            int n12 = existentObjectIds.size();
            if (n12 != n) {
                MsIntrospector.this.logWarn("It's strange: got " + n + " regular major identifiers, but there are " + n12 + " unique of them");
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, existentObjectIds){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ IntOpenHashSet $existentObjectIds;
                {
                    this.this$0 = $receiver;
                    this.$existentObjectIds = $existentObjectIds;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    MsSchemaRetriever.access$removeUnexistentSchemaObjects(this.this$0, schema2, (AbstractIntSet)this.$existentObjectIds);
                }
            });
            if (((MsSchema)this.getSchema()).getTableTypes().isEmpty() && ((MsSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            long[] existentIndicesArray = this.performQuery(MsIntrospector.this.myQueries.getListExistentIndices());
            long[] tablesWithFulltextIndicesArray = MsIntrospector.this.isSynapse() ? ArrayUtil.EMPTY_LONG_ARRAY : this.performQuery(MsIntrospector.this.myQueries.getListExistentFulltextIndices());
            LongOpenHashSet existentIndicesCombies = new LongOpenHashSet(existentIndicesArray);
            LongOpenHashSet tablesWithFulltextIndices = new LongOpenHashSet(tablesWithFulltextIndicesArray);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, existentIndicesCombies, tablesWithFulltextIndices){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ LongOpenHashSet $existentIndicesCombies;
                final /* synthetic */ LongOpenHashSet $tablesWithFulltextIndices;
                {
                    this.this$0 = $receiver;
                    this.$existentIndicesCombies = $existentIndicesCombies;
                    this.$tablesWithFulltextIndices = $tablesWithFulltextIndices;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    MsSchemaRetriever.access$removeUnexistentIndices(this.this$0, schema2, (LongSet)this.$existentIndicesCombies, (LongSet)this.$tablesWithFulltextIndices);
                }
            });
            ((Collection)MsIntrospector.this.schemasWhereDroppedObjectsDetected).add(this.getSchema());
        }

        private final void removeUnexistentSchemaObjects(MsSchema schema2, AbstractIntSet existentObjectIds) {
            ModNamingIdentifyingFamily<? extends MsSynonym> modNamingIdentifyingFamily = schema2.getSynonyms();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSynonyms(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsRoutine> modNamingIdentifyingFamily2 = schema2.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getRoutines(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily2, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsView> modNamingIdentifyingFamily3 = schema2.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getViews(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily3, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily4 = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getTables(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily4, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsRule> modNamingIdentifyingFamily5 = schema2.getRules();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getRules(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily5, existentObjectIds);
            ModNamingIdentifyingFamily<? extends MsSequence> modNamingIdentifyingFamily6 = schema2.getSequences();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getSequences(...)");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily6, existentObjectIds);
            for (MsTable msTable : schema2.getTables()) {
                NamingFamily<? extends BasicKey> namingFamily = msTable.getKeys();
                Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getKeys(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily)), existentObjectIds);
                NamingFamily namingFamily2 = msTable.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily2, (String)"getForeignKeys(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily2)), existentObjectIds);
                NamingFamily<? extends BasicCheck> namingFamily3 = msTable.getChecks();
                Intrinsics.checkNotNullExpressionValue(namingFamily3, (String)"getChecks(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingFamily3)), existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsDefaultConstraint> modNamingIdentifyingFamily7 = msTable.getDefaultConstraints();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getDefaultConstraints(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily7, existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsTrigger> modNamingIdentifyingFamily8 = msTable.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getTriggers(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily8, existentObjectIds);
                ModNamingIdentifyingFamily<? extends MsTablePartition> modNamingIdentifyingFamily9 = msTable.getPartitions();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily9, (String)"getPartitions(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily9, existentObjectIds);
            }
            for (MsView msView : schema2.getViews()) {
                ModNamingIdentifyingFamily<? extends MsTrigger> modNamingIdentifyingFamily10 = msView.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily10, (String)"getTriggers(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily10, existentObjectIds);
            }
        }

        private final void removeUnexistentIndices(MsSchema schema2, LongSet existentIndicesCombies, LongSet tablesWithFulltextIndices) {
            for (MsTableType msTableType : schema2.getTableTypes()) {
                Intrinsics.checkNotNull((Object)msTableType);
                this.removeUnexistentIndices(msTableType, existentIndicesCombies, tablesWithFulltextIndices);
            }
            for (MsTable msTable : schema2.getTables()) {
                Intrinsics.checkNotNull((Object)msTable);
                this.removeUnexistentIndices(msTable, existentIndicesCombies, tablesWithFulltextIndices);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void removeUnexistentIndices(MsStoredTable table, LongSet existentIndicesCombies, LongSet tablesWithFulltextIndices) {
            void $this$filterTo$iv$iv;
            ModPositioningNamingFamily<? extends MsLikeIndex> modPositioningNamingFamily = table.getIndices();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getIndices(...)");
            Iterable $this$filter$iv = modPositioningNamingFamily;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MsLikeIndex it2 = (MsLikeIndex)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it2.isFulltext() ? !tablesWithFulltextIndices.contains(table.getObjectId()) : !existentIndicesCombies.contains(table.getObjectId() * 100000L + (long)it2.getPosition());
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List droppedIndices = (List)destination$iv$iv;
            for (int i2 = droppedIndices.size() - 1; -1 < i2; --i2) {
                ((MsLikeIndex)droppedIndices.get(i2)).drop();
            }
        }

        @Override
        protected void retrieveMajorNames() {
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveCustomTypes();
            this.retrieveMajorObjects();
            this.retrieveTablesExtra();
            this.retrieveViewsExtra();
            this.retrieveRules();
            this.retrieveColumns();
            this.retrieveIndices();
            this.retrievePartitions();
            this.retrieveFulltextIndices();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveArguments();
            this.retrieveTriggers();
            this.retrieveSynonyms();
            this.retrieveSequences();
            this.retrievePermissions();
            this.retrieveSecurityPolicies();
            this.retrieveSecurityPredicates();
            this.retrieveDescription();
            this.retrieveSources();
        }

        @Override
        public void retrieveNamedFragments(@NotNull ObjectKind fragmentKind, @NotNull String[] fragmentNames) {
            Intrinsics.checkNotNullParameter((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkNotNullParameter((Object)fragmentNames, (String)"fragmentNames");
            this.setMode(IntrospectionMode.FRAGMENT);
            this.setFragmentKind(fragmentKind);
            this.setFragmentNames(fragmentNames);
            this.setWithSources(true);
            BaseIntrospectionFunctions.setupModeParameters(this.getMode(), this.getParametersMap());
            this.getParametersMap().put("f_names", fragmentNames);
            ObjectKind objectKind = fragmentKind;
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                this.retrieveMajorObjects();
                this.retrieveColumns();
                this.retrieveTablesExtra();
                this.retrieveViewsExtra();
                this.retrieveIndices();
                this.retrievePartitions();
                this.retrieveFulltextIndices();
                this.retrieveKeys();
                this.retrieveForeignKeys();
                this.retrieveCheckConstraints();
                this.retrieveTriggers();
                this.retrieveDescription();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                this.retrieveMajorObjects();
                this.retrieveTablesExtra();
                this.retrieveViewsExtra();
                this.retrieveColumns();
                this.retrieveIndices();
                this.retrievePartitions();
                this.retrieveTriggers();
                this.retrieveDescription();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
                this.retrieveMajorObjects();
                this.retrieveArguments();
                this.retrieveColumns();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ALIAS_TYPE)) {
                this.retrieveCustomTypes();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE_TYPE)) {
                this.retrieveCustomTypes();
                this.retrieveMajorObjects();
                this.retrieveColumns();
                this.retrieveIndices();
                this.retrieveFulltextIndices();
                this.retrieveKeys();
                this.retrieveForeignKeys();
                this.retrieveCheckConstraints();
                this.retrieveTriggers();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.RULE)) {
                this.retrieveMajorObjects();
                this.retrieveRules();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE)) {
                this.retrieveMajorObjects();
                this.retrieveSequences();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SYNONYM)) {
                this.retrieveMajorObjects();
                this.retrieveSynonyms();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SECURITY_POLICY)) {
                this.retrievePermissions();
                this.retrieveSecurityPolicies();
                this.retrieveSecurityPredicates();
            }
        }

        private final void retrieveRules() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            if (this.myTouchedRules.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.RULE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"RULE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List rs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveRules(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneRule>)rs){
                final /* synthetic */ List<MsIntroQueries.OneRule> $rs;
                {
                    this.$rs = $rs;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsSchema schema2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModFamily modFamily = schema2.getRules();
                    List<MsIntroQueries.OneRule> list = this.$rs;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily rules = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    for (MsIntroQueries.OneRule r : list) {
                        E e2 = rules.renew(r.object_id, r.name);
                        MsRule it2 = (MsRule)e2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it2);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(it2, r.create_date, r.modify_date);
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void retrieveCustomTypes() {
            Object v0;
            List<MsIntroQueries.OneCustomTypesCheckSum> checkSums;
            block4: {
                if (Intrinsics.areEqual((Object)((MsSchema)this.getSchema()).getName(), (Object)"sys") && this.getMode().increment) {
                    return;
                }
                MsIntrospector.this.reportRetrieving("user defined types", "introspection.retrieve.userDefinedTypes");
                checkSums = this.performQuery(MsIntrospector.this.myQueries.getCalculateCustomTypesCheckSums());
                Intrinsics.checkNotNull(checkSums);
                Iterable $this$firstOrNull$iv = checkSums;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MsIntroQueries.OneCustomTypesCheckSum it2 = (MsIntroQueries.OneCustomTypesCheckSum)element$iv;
                    boolean bl = false;
                    if (!(it2.type_kind == 1)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            MsIntroQueries.OneCustomTypesCheckSum oneCustomTypesCheckSum = v0;
            long aliasTypesCheckSum = oneCustomTypesCheckSum != null ? oneCustomTypesCheckSum.check_sum : 0L;
            this.processAliasTypes(aliasTypesCheckSum);
            if (MsIntrospector.this.myVer10) {
                Object v2;
                block5: {
                    Iterable $this$firstOrNull$iv = checkSums;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        MsIntroQueries.OneCustomTypesCheckSum it3 = (MsIntroQueries.OneCustomTypesCheckSum)element$iv;
                        boolean bl = false;
                        if (!(it3.type_kind == 2)) continue;
                        v2 = element$iv;
                        break block5;
                    }
                    v2 = null;
                }
                MsIntroQueries.OneCustomTypesCheckSum oneCustomTypesCheckSum2 = v2;
                long tableTypesCheckSum = oneCustomTypesCheckSum2 != null ? oneCustomTypesCheckSum2.check_sum : 0L;
                this.processTableTypes(tableTypesCheckSum);
            }
        }

        private final void processAliasTypes(long aliasTypesCheckSum) {
            if (aliasTypesCheckSum == 0L) {
                this.inSchema(processAliasTypes.1.INSTANCE);
                return;
            }
            if (((MsSchema)this.getSchema()).getAliasTypesCheckSum() == aliasTypesCheckSum) {
                return;
            }
            List cas = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveAliasTypes(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneAliasType>)cas){
                final /* synthetic */ List<MsIntroQueries.OneAliasType> $cas;
                {
                    this.$cas = $cas;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsSchema schema2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModFamily modFamily = schema2.getAliasTypes();
                    List<MsIntroQueries.OneAliasType> list = this.$cas;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingFamily aliasTypes = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    for (MsIntroQueries.OneAliasType at : list) {
                        int typeId = at.type_id;
                        Object object = at.name;
                        if (object == null) {
                            object = "<unnamed_" + typeId + ">";
                        }
                        String typeName = object;
                        Intrinsics.checkNotNull((Object)aliasTypes);
                        MsAliasType aliasType = (MsAliasType)MsIntrospectorKt.access$renewType(aliasTypes, typeId, typeName);
                        aliasType.setNotNull(!at.is_nullable);
                        if (at.base_name != null) {
                            aliasType.setStoredType(MsIntrospectorKt.access$makeDasType(at.base_name, at.max_length, at.precision, at.scale));
                            continue;
                        }
                        aliasType.setStoredType(DasTypeSystemBase.UNKNOWN);
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void processTableTypes(long tableTypesCheckSum) {
            if (tableTypesCheckSum == 0L) {
                this.inSchema(processTableTypes.1.INSTANCE);
                return;
            }
            if (((MsSchema)this.getSchema()).getTableTypesCheckSum() == tableTypesCheckSum) {
                return;
            }
            List tts = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTableTypes(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneTableType>)tts){
                final /* synthetic */ List<MsIntroQueries.OneTableType> $tts;
                {
                    this.$tts = $tts;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsSchema schema2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModFamily modFamily = schema2.getTableTypes();
                    List<MsIntroQueries.OneTableType> list = this.$tts;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily tableTypes = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    for (MsIntroQueries.OneTableType tt2 : list) {
                        int ttId = tt2.type_id;
                        Object object = tt2.name;
                        if (object == null) {
                            object = "<unnamed_" + ttId + ">";
                        }
                        String ttName = object;
                        Intrinsics.checkNotNull((Object)tableTypes);
                        MsTableType tableType2 = (MsTableType)MsIntrospectorKt.access$renewType(tableTypes, ttId, ttName);
                        tableType2.setObjectId(tt2.object_id);
                        Intrinsics.checkNotNull((Object)tableType2);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(tableType2, tt2.create_date, tt2.modify_date);
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
            this.retrieveTypeColumns();
            this.retrieveTypeIndices();
            this.retrieveTypeKeys();
            this.retrieveTypeCheckConstraints();
        }

        private final void retrieveMajorObjects() {
            MsIntrospector.this.reportRetrieving("tables, views, procedures and functions", "introspection.retrieve.tablesViewsRoutines");
            List os = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveObjects(), null, 0, 6, null);
            if (os.isEmpty()) {
                return;
            }
            Ref.BooleanRef tablesWereTouched = new Ref.BooleanRef();
            Ref.BooleanRef viewsWereTouched = new Ref.BooleanRef();
            Ref.BooleanRef tableTypesWereTouched = new Ref.BooleanRef();
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneObject>)os, tablesWereTouched, viewsWereTouched, tableTypesWereTouched, this){
                final /* synthetic */ List<MsIntroQueries.OneObject> $os;
                final /* synthetic */ Ref.BooleanRef $tablesWereTouched;
                final /* synthetic */ Ref.BooleanRef $viewsWereTouched;
                final /* synthetic */ Ref.BooleanRef $tableTypesWereTouched;
                final /* synthetic */ MsSchemaRetriever this$0;
                {
                    this.$os = $os;
                    this.$tablesWereTouched = $tablesWereTouched;
                    this.$viewsWereTouched = $viewsWereTouched;
                    this.$tableTypesWereTouched = $tableTypesWereTouched;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    for (MsIntroQueries.OneObject o2 : this.$os) {
                        MsSchemaObject obj2 = null;
                        if (o2.type == null) continue;
                        if (Intrinsics.areEqual((Object)o2.type, (Object)"U") || Intrinsics.areEqual((Object)o2.type, (Object)"S") || Intrinsics.areEqual((Object)o2.type, (Object)"IT")) {
                            MsTable msTable = schema2.getTables().renew(o2.object_id, o2.name);
                            Intrinsics.checkNotNullExpressionValue((Object)msTable, (String)"renew(...)");
                            obj2 = msTable;
                            this.$tablesWereTouched.element = true;
                        } else if (Intrinsics.areEqual((Object)o2.type, (Object)"V")) {
                            MsView msView = schema2.getViews().renew(o2.object_id, o2.name);
                            Intrinsics.checkNotNullExpressionValue((Object)msView, (String)"renew(...)");
                            obj2 = msView;
                            this.$viewsWereTouched.element = true;
                        } else if (Intrinsics.areEqual((Object)o2.type, (Object)"TT")) {
                            MsTableType msTableType = schema2.getTableTypes().renew(o2.object_id, o2.name);
                            Intrinsics.checkNotNullExpressionValue((Object)msTableType, (String)"renew(...)");
                            obj2 = msTableType;
                            this.$tableTypesWereTouched.element = true;
                        } else if (Intrinsics.areEqual((Object)o2.type, (Object)"R")) {
                            MsRule msRule = schema2.getRules().renew(o2.object_id, o2.name);
                            Intrinsics.checkNotNullExpressionValue((Object)msRule, (String)"renew(...)");
                            obj2 = msRule;
                            ((Collection)MsSchemaRetriever.access$getMyTouchedRules$p(this.this$0)).add(obj2);
                            ((Collection)MsSchemaRetriever.access$getMyTouchedMajorSourceAware$p(this.this$0)).add(obj2);
                        } else if (CollectionsKt.contains((Iterable)MsRoutineTypes.MS_ROUTINE_TYPES.keySet(), (Object)o2.type)) {
                            MsRoutine routine2 = schema2.getRoutines().renew(o2.object_id, o2.name);
                            MsRoutineType routineType = MsRoutineTypes.MS_ROUTINE_TYPES.get(o2.type);
                            routine2.setRoutineType(routineType);
                            Intrinsics.checkNotNull((Object)routine2);
                            obj2 = routine2;
                            routine2.getArguments().markChildrenAsSyncPending();
                            ((Collection)MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0)).add(routine2);
                        } else if (Intrinsics.areEqual((Object)o2.type, (Object)"SO")) {
                            MsSequence sequence = schema2.getSequences().renew(o2.object_id, o2.name);
                            ((Collection)MsSchemaRetriever.access$getMyTouchedSequences$p(this.this$0)).add(sequence);
                            Intrinsics.checkNotNull((Object)sequence);
                            obj2 = sequence;
                        } else {
                            if (!Intrinsics.areEqual((Object)o2.type, (Object)"SN")) continue;
                            MsSynonym synonym2 = schema2.getSynonyms().renew(o2.object_id, o2.name);
                            ((Collection)MsSchemaRetriever.access$getMyTouchedSynonyms$p(this.this$0)).add(synonym2);
                            Intrinsics.checkNotNull((Object)synonym2);
                            obj2 = synonym2;
                        }
                        boolean nameIsSurrogate = MsIntrospectorKt.access$detectSurrogateName(o2.name);
                        obj2.setNameSurrogate(nameIsSurrogate);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(obj2, o2.create_date, o2.modify_date);
                        if (obj2 instanceof MsLikeTable) {
                            MsSchemaRetriever.access$getMyTouchedTables$p(this.this$0).add(obj2);
                            ((MsLikeTable)((Object)obj2)).getColumns().markChildrenAsSyncPending();
                        }
                        if (!(obj2 instanceof MsSourceAware)) continue;
                        ((Collection)MsSchemaRetriever.access$getMyTouchedMajorSourceAware$p(this.this$0)).add(obj2);
                    }
                    if (this.$tablesWereTouched.element) {
                        schema2.getTables().sort();
                    }
                    if (this.$viewsWereTouched.element) {
                        schema2.getViews().sort();
                    }
                    if (this.$tableTypesWereTouched.element) {
                        schema2.getTableTypes().sort();
                    }
                    if (!((Collection)MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0)).isEmpty()) {
                        schema2.getRoutines().sort();
                    }
                }
            });
        }

        private final void retrieveColumns() {
            if (this.myTouchedTables.isEmpty() && this.myTouchedRoutines.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            MsIntrospector.this.reportRetrieving(objectKind);
            List cols2 = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveColumns(), null, 0, 6, null);
            this.processColumns(cols2);
        }

        private final void retrieveTablesExtra() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List tables2 = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTablesExtra(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneTable>)tables2){
                final /* synthetic */ List<MsIntroQueries.OneTable> $tables;
                {
                    this.$tables = $tables;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (MsIntroQueries.OneTable t : this.$tables) {
                        block4: {
                            if ((MsTable)schema.getTables().getByObjectId(t.object_id) == null) continue;
                            table.setPeriodStartColumnRef(BasicPositionReference.create((short)t.start_column_id));
                            table.setPeriodEndColumnRef(BasicPositionReference.create((short)t.end_column_id));
                            table.setTemporalKind(MsTemporalTableKind.Companion.valueFor(t.temporal_type));
                            table.setHistoryTableRef(BasicIdReference.create(t.history_table_id));
                            table.setLedgerKind(MsLedgerKind.Companion.valueFor(t.ledger_type));
                            table.setLedgerViewRef(BasicIdReference.create(t.ledger_view_id));
                            table.setDroppedLedger(t.is_dropped_ledger_table);
                            v0 = table.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
                            if (StringsKt.startsWith$default((String)v0, (String)"MSSQL_DroppedLedgerHistory_", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                            if (table.getTemporalKind() != MsTemporalTableKind.HISTORY_TABLE) break block4;
                            v1 = table.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                            if (StringsKt.startsWith$default((String)v1, (String)"MSSQL_TemporalHistoryFor_", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                        }
                        if (table.getLedgerKind() == MsLedgerKind.HISTORY_TABLE) {
                            v2 = table.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                            ** if (!StringsKt.startsWith$default((String)v2, (String)"MSSQL_LedgerHistoryFor_", (boolean)false, (int)2, null)) goto lbl-1000
                        }
                        ** GOTO lbl-1000
lbl-1000:
                        // 3 sources

                        {
                            v3 = true;
                            ** GOTO lbl27
                        }
lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
lbl27:
                        // 2 sources

                        table.setNameSurrogate(v3);
                        table.setDataRetentionPeriod(t.history_retention_period);
                        table.setDataRetentionUnit(MsTimeUnit.Companion.valueFor(t.history_retention_period_unit));
                        table.setLobDataSpaceRef(BasicIdReference.create(t.lob_data_space_id));
                        table.setFileStreamDataSpaceRef(BasicIdReference.create(t.filestream_data_space_id));
                    }
                }
            });
        }

        private final void retrieveViewsExtra() {
            int[] nArray = new int[]{16};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"VIEW");
            MsIntrospector.this.reportRetrieving(objectKind);
            List views2 = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveViewsExtra(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneView>)views2){
                final /* synthetic */ List<MsIntroQueries.OneView> $views;
                {
                    this.$views = $views;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    for (MsIntroQueries.OneView v2 : this.$views) {
                        MsView view2;
                        if ((MsView)schema2.getViews().getByObjectId(v2.object_id) == null) continue;
                        view2.setLedgerView(v2.is_ledger_view);
                        view2.setDroppedLedger(v2.is_dropped_ledger_view);
                    }
                }
            });
        }

        private final void retrievePartitions() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.PARTITION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"PARTITION");
            MsIntrospector.this.reportRetrieving(objectKind);
            List ps = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrievePartitions(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OnePartition>)ps){
                final /* synthetic */ List<MsIntroQueries.OnePartition> $ps;
                {
                    this.$ps = $ps;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (MsIntroQueries.OnePartition p : this.$ps) {
                        var6_6 = schema;
                        objectId$iv = p.object_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findAllById$iv$iv = v0;
                        $i$f$findAllById = false;
                        v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(MsTable.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                        v0 = v1;
                        if (v1 != null && (v0 = v0.filter(new Condition(var11_11 = (Function1)new Function1<MsTable, Boolean>((BasicSchema)$this$findById$iv){
                            final /* synthetic */ BasicSchema $this_findById;
                            {
                                this.$this_findById = $receiver;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @NotNull
                            public final Boolean invoke(BasicIdentifiedElement it2) {
                                return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                            }
                        }){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                this.function = function2;
                            }

                            public final /* synthetic */ boolean value(Object p0) {
                                return (Boolean)this.function.invoke(p0);
                            }
                        })) != null) {
                            v2 = (BasicIdentifiedElement)v0.first();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = null;
                        }
                        if ((MsTable)v2 == null) continue;
                        if (p.index_id == 0) {
                            v3 = table;
                        } else {
                            v4 = (MsIndex)table.getIndices().getByNaturalPosition(p.index_id);
                            if (v4 == null) continue;
                            v3 = v4;
                        }
                        if (!((partitionOwner = v3).getPartitionDataSpace() instanceof MsPartitionScheme)) continue;
                        partition = (MsPartition)partitionOwner.getPartitions().createOrGet(p.partition_id);
                        partition.setPosition(p.partition_number);
                        partition.setCompression(MsDataCompressionKind.Companion.valueFor(p.data_compression));
                        partition.setXmlCompression(p.xml_compression);
                    }
                }
            });
        }

        private final void retrieveTypeColumns() {
            MsIntrospector.this.reportRetrieving("columns of custom table types", "introspection.retrieve.columnsOfCustomTableTypes");
            List cols2 = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeColumns(), null, 0, 6, null);
            this.processColumns(cols2);
        }

        private final void processColumns(List<MsIntroQueries.OneColumn> cols2) {
            HashSet<MsLikeTable> affectedCursors = new HashSet<MsLikeTable>(cols2.size() / 3);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(cols2, affectedCursors, MsIntrospector.this, this){
                final /* synthetic */ List<MsIntroQueries.OneColumn> $cols;
                final /* synthetic */ HashSet<MsLikeTable> $affectedCursors;
                final /* synthetic */ MsIntrospector this$0;
                final /* synthetic */ MsSchemaRetriever this$1;
                {
                    this.$cols = $cols;
                    this.$affectedCursors = $affectedCursors;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    cursor = null;
                    object_id = 0;
                    v0 = schema.getDatabase();
                    defaultCollation = v0 != null && (v0 = v0.getCollationRef()) != null ? v0.getName() : null;
                    for (MsIntroQueries.OneColumn col : this.$cols) {
                        block20: {
                            if (object_id == col.object_id && cursor != null) break block20;
                            object_id = col.object_id;
                            var7_7 = schema;
                            objectId$iv = object_id;
                            $i$f$findById = false;
                            v1 = $this$findById$iv.getDatabase();
                            if (v1 == null) ** GOTO lbl-1000
                            $this$findAllById$iv$iv = v1;
                            $i$f$findAllById = false;
                            v2 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(MsLikeTable.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"filter(...)");
                            v1 = v2;
                            if (v2 != null && (v1 = v1.filter(new Condition($i$f$findAllById = (Function1)new Function1<MsLikeTable, Boolean>((BasicSchema)$this$findById$iv){
                                final /* synthetic */ BasicSchema $this_findById;
                                {
                                    this.$this_findById = $receiver;
                                    super(1);
                                }

                                /*
                                 * Ignored method signature, as it can't be verified against descriptor
                                 */
                                @NotNull
                                public final Boolean invoke(BasicIdentifiedElement it2) {
                                    return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                                }
                            }){
                                private final /* synthetic */ Function1 function;
                                {
                                    Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                    this.function = function2;
                                }

                                public final /* synthetic */ boolean value(Object p0) {
                                    return (Boolean)this.function.invoke(p0);
                                }
                            })) != null) {
                                v3 = (BasicIdentifiedElement)v1.first();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = null;
                            }
                            if ((cursor = (MsLikeTable)v3) == null) continue;
                            if (col.column_position == 1) {
                                cursor.getColumns().markChildrenAsSyncPending();
                                if (cursor instanceof MsStoredTable) {
                                    ((MsStoredTable)cursor).getDefaultConstraints().markChildrenAsSyncPending();
                                }
                            }
                            this.$affectedCursors.add(cursor);
                        }
                        if ((v4 = col.name) == null) {
                            v4 = "<unnamed_" + col.column_position + ">";
                        }
                        columnName = v4;
                        column = (MsLikeColumn)cursor.getColumns().createOrGet(columnName);
                        column.setPosition(col.column_position);
                        column.setNotNull(col.is_nullable == false);
                        column.setStoredType(MsIntrospectorKt.access$makeDasType(col.type_name, col.max_length, col.precision, col.scale));
                        isTimestamp = Intrinsics.areEqual((Object)col.type_name, (Object)"timestamp");
                        defaultExpression = MsIntrospectorHelper.normalizeExpression$default(MsIntrospector.access$getHelper$p(this.this$0), col.default_expression, false, 2, null);
                        if (column instanceof MsStoredColumn) {
                            ((MsStoredColumn)column).setComputed(col.is_computed != false || isTimestamp != false);
                            if (column instanceof MsTableColumn) {
                                ((MsTableColumn)column).setHidden(col.is_hidden);
                                ((MsTableColumn)column).setSparse(col.is_sparse);
                                ((MsTableColumn)column).setColumnSet(col.is_column_set);
                                if (col.is_data_deletion_filter_column) {
                                    v5 = ((MsTableColumn)column).getTable();
                                    if (v5 != null) {
                                        v5.setDataRetentionFilterColumnRef(BasicPositionReference.create(((MsTableColumn)column).getPosition()));
                                    }
                                }
                            }
                            identitySeed = ($i$f$findAllById = col.identity_seed_value) != null ? MsSchemaRetriever.access$asBigInteger(this.this$1, $i$f$findAllById) : null;
                            var13_18 = col.identity_increment_value;
                            identityIncrement = var13_18 != null ? MsSchemaRetriever.access$asBigInteger(this.this$1, var13_18) : null;
                            var14_19 = col.identity_last_value;
                            v6 = identityLastValue = var14_19 != null ? MsSchemaRetriever.access$asBigInteger(this.this$1, var14_19) : null;
                            if (identitySeed != null || identityIncrement != null || identityLastValue != null) {
                                if (identityLastValue != null) {
                                    v7 = BigInteger.ONE;
                                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"ONE");
                                    v8 = var15_21.add(v7);
                                    v9 = v8;
                                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"add(...)");
                                } else {
                                    v9 = null;
                                }
                                next = v9;
                                ((MsStoredColumn)column).setSequenceIdentity(SequenceIdentity.of(identitySeed, next, identityIncrement, null));
                            } else {
                                ((MsStoredColumn)column).setSequenceIdentity(null);
                            }
                            collationName = col.collation_name;
                            $this$isNotNullOrEmpty$iv = (CharSequence)collationName;
                            $i$f$isNotNullOrEmpty = false;
                            ((MsStoredColumn)column).setCollationRef(($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) != false && Intrinsics.areEqual((Object)collationName, (Object)defaultCollation) == false ? (BasicReference)BasicNameReference.create((String)collationName) : null);
                        } else {
                            column.setDefaultExpression(defaultExpression);
                        }
                        collationName = (long)col.default_constraint_object_id;
                        it = ((Number)collationName).longValue();
                        $i$a$-takeIf-MsIntrospector$MsSchemaRetriever$processColumns$1$defaultConstraintObjectId$1 = false;
                        v10 = it != 0L != false ? collationName : null;
                        defaultConstraintObjectId = v10 != null ? v10.longValue() : -9223372036854775808L;
                        defaultConstraintName = col.default_constraint_name;
                        if (defaultConstraintName != null && defaultConstraintObjectId != -9223372036854775808L && cursor instanceof MsStoredTable) {
                            dc = ((MsStoredTable)cursor).getDefaultConstraints().renew(defaultConstraintObjectId, defaultConstraintName);
                            dc.setModifiedTimestamp(col.default_constraint_modify_date);
                            dc.setNameSurrogate(col.default_constraint_name_is_surrogate);
                            dc.setDefaultExpression(defaultExpression);
                            dc.setColNames(Collections.singletonList(column.getName()));
                        }
                        if (column instanceof MsStoredColumn) {
                            if (defaultConstraintObjectId != -9223372036854775808L) {
                                ((MsStoredColumn)column).setDefaultConstraintRef(BasicIdOrNameReference.create(defaultConstraintObjectId, defaultConstraintName));
                            } else {
                                MsGeneratedModelUtil.setDefaultExpressionInline((MsStoredColumn)column, defaultExpression);
                            }
                        }
                        if (!(column instanceof MsTableColumn)) continue;
                        ((MsTableColumn)column).setGeneratedKind(MsGeneratedColumnKind.Companion.valueFor(col.generated_always_type));
                        ((MsTableColumn)column).setFilestream(col.is_filestream);
                        ((MsTableColumn)column).setRowGuid(col.is_rowguidcol);
                        ((MsTableColumn)column).setMaskFunction(col.masking_function);
                        ((MsTableColumn)column).setEncryptionKind(MsColumnEncryptionKind.Companion.valueFor(col.encryption_type));
                        ((MsTableColumn)column).setEncryptionAlgorithm(col.encryption_algorithm_name);
                        ((MsTableColumn)column).setEncryptionKeyRef(BasicParentReference.create(col.column_encryption_key_database_name, BasicIdReference.create(col.column_encryption_key_id)));
                    }
                    for (MsLikeTable t : this.$affectedCursors) {
                        t.getColumns().removeSyncPendingChildren();
                        t.getColumns().sort();
                    }
                }
            });
        }

        private final void retrieveIndices() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            MsIntrospector.this.reportRetrieving(objectKind);
            List inds = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveIndices(), null, 0, 6, null);
            List ics = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveIndexColumns(), null, 0, 6, null);
            this.processIndices(inds, ics);
        }

        private final void retrieveFulltextIndices() {
            if (MsIntrospector.this.isSynapse()) {
                return;
            }
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            MsIntrospector.this.reportRetrieving("fulltext indices", "introspection.retrieve.fulltextIndices");
            List inds = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveFulltextIndices(), null, 0, 6, null);
            List ics = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveFulltextIndexColumns(), null, 0, 6, null);
            this.processFulltextIndices(inds, ics);
        }

        private final void retrieveTypeIndices() {
            MsIntrospector.this.reportRetrieving("indices of custom table types", "introspection.retrieve.customTableTypeIndices");
            List inds = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeIndices(), null, 0, 6, null);
            List ics = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeIndexColumns(), null, 0, 6, null);
            this.processIndices(inds, ics);
        }

        private final void processIndices(List<MsIntroQueries.OneIndex> inds, List<MsIntroQueries.OneIndexColumn> ics) {
            HashMap<MsMinorIdentity, MsLikeIndex> indices = new HashMap<MsMinorIdentity, MsLikeIndex>(inds.size());
            HashMap<MsMinorIdentity, MsTable> tableByHeapIndex = new HashMap<MsMinorIdentity, MsTable>();
            this.inSchema((Function1)new Function1<MsSchema, Unit>(inds, tableByHeapIndex, MsIntrospector.this, indices){
                final /* synthetic */ List<MsIntroQueries.OneIndex> $inds;
                final /* synthetic */ HashMap<MsMinorIdentity, MsTable> $tableByHeapIndex;
                final /* synthetic */ MsIntrospector this$0;
                final /* synthetic */ HashMap<MsMinorIdentity, MsLikeIndex> $indices;
                {
                    this.$inds = $inds;
                    this.$tableByHeapIndex = $tableByHeapIndex;
                    this.this$0 = $receiver;
                    this.$indices = $indices;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (MsIntroQueries.OneIndex ind : this.$inds) {
                        var6_6 = schema;
                        objectId$iv = ind.object_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findAllById$iv$iv = v0;
                        $i$f$findAllById = false;
                        v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(MsIndexableTable.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                        v0 = v1;
                        if (v1 != null && (v0 = v0.filter(new Condition(var11_11 = (Function1)new Function1<MsIndexableTable, Boolean>((BasicSchema)$this$findById$iv){
                            final /* synthetic */ BasicSchema $this_findById;
                            {
                                this.$this_findById = $receiver;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @NotNull
                            public final Boolean invoke(BasicIdentifiedElement it2) {
                                return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                            }
                        }){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                this.function = function2;
                            }

                            public final /* synthetic */ boolean value(Object p0) {
                                return (Boolean)this.function.invoke(p0);
                            }
                        })) != null) {
                            v2 = (BasicIdentifiedElement)v0.first();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = null;
                        }
                        if ((MsIndexableTable)v2 == null) continue;
                        identity = new MsMinorIdentity(ind.object_id, ind.position);
                        if (ind.type == 0 && table instanceof MsTable) {
                            ((Map)this.$tableByHeapIndex).put(identity, table);
                            ((MsTable)table).setPartitionDataSpaceRef(BasicIdReference.create(ind.data_space_id));
                            continue;
                        }
                        v3 = table.getIndices().createOrGetAt(ind.position);
                        Intrinsics.checkNotNullExpressionValue(v3, (String)"createOrGetAt(...)");
                        index = (MsLikeIndex)v3;
                        v4 = ind.name;
                        if (v4 == null) {
                            v4 = "<unnamed_" + ind.position + ">";
                        }
                        index.setName((String)v4);
                        index.setNameSurrogate(table.isNameSurrogate() != false || MsIntrospectorKt.access$detectSurrogateName(ind.name) != false);
                        index.setClustering(ind.type == 1);
                        index.setUnique(ind.is_unique);
                        index.setOptionPad(ind.is_padded);
                        index.setOptionIgnoreDup(ind.ignore_dup_key);
                        if (index instanceof MsIndex) {
                            ((MsIndex)index).setOptionAllowRowLocks(ind.allow_row_locks);
                            ((MsIndex)index).setOptionAllowPageLocks(ind.allow_page_locks);
                            ((MsIndex)index).setDisabled(ind.is_disabled);
                        }
                        index.setFillFactor(ind.fill_factor);
                        index.setCondition(MsIntrospectorHelper.normalizeExpression$default(MsIntrospector.access$getHelper$p(this.this$0), ind.filter_definition, false, 2, null));
                        index.setPartitionDataSpaceRef(BasicIdReference.create(ind.data_space_id));
                        ((Map)this.$indices).put(identity, index);
                    }
                }
            });
            CollectionAggregator colsA2 = new CollectionAggregator(processIndices.colsA.1.INSTANCE);
            CollectionAggregator colsI2 = new CollectionAggregator(processIndices.colsI.1.INSTANCE);
            CollectionAggregator colsR2 = new CollectionAggregator(processIndices.colsR.1.INSTANCE);
            for (MsIntroQueries.OneIndexColumn ic : ics) {
                String indexName;
                Object object;
                MsMinorIdentity key2 = new MsMinorIdentity(ic.object_id, ic.index_position);
                if (ic.partition_ordinal > 0) {
                    BasicPositionReference columnRef = BasicPositionReference.create((short)ic.column_id);
                    MsTable table = tableByHeapIndex.get(key2);
                    if (table != null) {
                        table.setPartitionColumnRef(columnRef);
                    } else {
                        MsLikeIndex msLikeIndex = indices.get(key2);
                        if (msLikeIndex != null) {
                            msLikeIndex.setPartitionColumnRef(columnRef);
                        }
                    }
                }
                if ((object = ic.name) == null) {
                    object = indexName = "<unnamed_" + ic.object_id + ">";
                }
                if (!ic.is_included_column) {
                    colsA2.add(key2, indexName);
                    if (!ic.is_desc) continue;
                    colsR2.add(key2, indexName);
                    continue;
                }
                colsI2.add(key2, indexName);
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>(colsA2, indices, colsI2, colsR2){
                final /* synthetic */ CollectionAggregator<MsMinorIdentity, String, List<String>> $colsA;
                final /* synthetic */ HashMap<MsMinorIdentity, MsLikeIndex> $indices;
                final /* synthetic */ CollectionAggregator<MsMinorIdentity, String, List<String>> $colsI;
                final /* synthetic */ CollectionAggregator<MsMinorIdentity, String, Set<String>> $colsR;
                {
                    this.$colsA = $colsA;
                    this.$indices = $indices;
                    this.$colsI = $colsI;
                    this.$colsR = $colsR;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    for (Map.Entry<MsMinorIdentity, List<String>> entry : this.$colsA.getResult().entrySet()) {
                        MsLikeIndex index2;
                        MsMinorIdentity key2 = entry.getKey();
                        List<String> names2 = entry.getValue();
                        if (this.$indices.get(key2) == null) continue;
                        index2.setColNames(names2);
                        List list = this.$colsI.get(key2);
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        index2.setIncludedColNames(list);
                        Set set = this.$colsR.get(key2);
                        if (set == null) {
                            set = SetsKt.emptySet();
                        }
                        index2.setReverseColNames(set);
                    }
                }
            });
        }

        private final void processFulltextIndices(List<MsIntroQueries.OneFulltextIndex> inds, List<MsIntroQueries.OneFulltextIndexColumn> ics) {
            HashMap<Integer, MsLikeIndex> indices = new HashMap<Integer, MsLikeIndex>(inds.size());
            this.inSchema((Function1)new Function1<MsSchema, Unit>(inds, indices){
                final /* synthetic */ List<MsIntroQueries.OneFulltextIndex> $inds;
                final /* synthetic */ HashMap<Integer, MsLikeIndex> $indices;
                {
                    this.$inds = $inds;
                    this.$indices = $indices;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (MsIntroQueries.OneFulltextIndex ind : this.$inds) {
                        var6_6 = schema;
                        objectId$iv = ind.object_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findAllById$iv$iv = v0;
                        $i$f$findAllById = false;
                        v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(MsStoredTable.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                        v0 = v1;
                        if (v1 != null && (v0 = v0.filter(new Condition(var11_11 = (Function1)new Function1<MsStoredTable, Boolean>((BasicSchema)$this$findById$iv){
                            final /* synthetic */ BasicSchema $this_findById;
                            {
                                this.$this_findById = $receiver;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @NotNull
                            public final Boolean invoke(BasicIdentifiedElement it2) {
                                return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                            }
                        }){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                this.function = function2;
                            }

                            public final /* synthetic */ boolean value(Object p0) {
                                return (Boolean)this.function.invoke(p0);
                            }
                        })) != null) {
                            v2 = (BasicIdentifiedElement)v0.first();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = null;
                        }
                        if ((MsStoredTable)v2 == null) continue;
                        index = (MsLikeIndex)t.getIndices().createOrGetAt((short)32767);
                        index.setName("");
                        index.setFulltext(true);
                        index.setFulltextUniqueIndexRef(BasicPositionReference.create((short)ind.unique_index_id));
                        v3 = this.$indices;
                        v4 = ind.object_id;
                        Intrinsics.checkNotNull((Object)index);
                        v3.put(v4, index);
                    }
                }
            });
            CollectionAggregator cols2 = new CollectionAggregator(processFulltextIndices.cols.1.INSTANCE);
            for (MsIntroQueries.OneFulltextIndexColumn ic : ics) {
                int objectId = ic.object_id;
                Object object = ic.name;
                if (object == null) {
                    object = "<unnamed_" + objectId + ">";
                }
                String indexName = object;
                cols2.add(objectId, indexName);
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>(cols2, indices){
                final /* synthetic */ CollectionAggregator<Integer, String, List<String>> $cols;
                final /* synthetic */ HashMap<Integer, MsLikeIndex> $indices;
                {
                    this.$cols = $cols;
                    this.$indices = $indices;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    for (Map.Entry<Integer, List<String>> entry : this.$cols.getResult().entrySet()) {
                        MsLikeIndex index2;
                        int key2 = ((Number)entry.getKey()).intValue();
                        List<String> names2 = entry.getValue();
                        if (this.$indices.get(key2) == null) continue;
                        index2.setColNames(names2);
                    }
                }
            });
        }

        private final void retrieveKeys() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"KEY");
            MsIntrospector.this.reportRetrieving(objectKind);
            List ks = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveKeys(), null, 0, 6, null);
            this.processKeys(ks);
        }

        private final void retrieveTypeKeys() {
            MsIntrospector.this.reportRetrieving("of custom table types", "introspection.retrieve.customTableTypeKeys");
            List ks = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeKeys(), null, 0, 6, null);
            this.processKeys(ks);
        }

        private final void processKeys(List<MsIntroQueries.OneKey> ks) {
            this.inSchema((Function1)new Function1<MsSchema, Unit>(ks){
                final /* synthetic */ List<MsIntroQueries.OneKey> $ks;
                {
                    this.$ks = $ks;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    tables = new HashSet<MsStoredTable>(this.$ks.size());
                    for (MsIntroQueries.OneKey k : this.$ks) {
                        block7: {
                            var7_7 = schema;
                            objectId$iv = k.table_id;
                            $i$f$findById = false;
                            v0 = $this$findById$iv.getDatabase();
                            if (v0 == null) ** GOTO lbl-1000
                            $this$findAllById$iv$iv = v0;
                            $i$f$findAllById = false;
                            v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(MsStoredTable.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                            v0 = v1;
                            if (v1 != null && (v0 = v0.filter(new Condition($i$f$findAllById = (Function1)new Function1<MsStoredTable, Boolean>((BasicSchema)$this$findById$iv){
                                final /* synthetic */ BasicSchema $this_findById;
                                {
                                    this.$this_findById = $receiver;
                                    super(1);
                                }

                                /*
                                 * Ignored method signature, as it can't be verified against descriptor
                                 */
                                @NotNull
                                public final Boolean invoke(BasicIdentifiedElement it2) {
                                    return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                                }
                            }){
                                private final /* synthetic */ Function1 function;
                                {
                                    Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                    this.function = function2;
                                }

                                public final /* synthetic */ boolean value(Object p0) {
                                    return (Boolean)this.function.invoke(p0);
                                }
                            })) != null) {
                                v2 = (BasicIdentifiedElement)v0.first();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = null;
                            }
                            if ((MsStoredTable)v2 == null) continue;
                            key = table.getKeys().renew(k.key_id, k.name);
                            key.setNameSurrogate(k.is_system_named);
                            key.setPrimary(k.is_primary);
                            Intrinsics.checkNotNull((Object)key);
                            MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(key, k.create_date, k.modify_date);
                            v3 = table.getIndices();
                            Intrinsics.checkNotNullExpressionValue(v3, (String)"getIndices(...)");
                            $this$firstOrNull$iv = v3;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                ind = (MsLikeIndex)element$iv;
                                $i$a$-firstOrNull-MsIntrospector$MsSchemaRetriever$processKeys$1$index$1 = false;
                                if (!(ind.getPosition() == k.index_position)) continue;
                                v4 = element$iv;
                                break block7;
                            }
                            v4 = null;
                        }
                        index = v4;
                        if (index != null) {
                            key.setUnderlyingIndexRef(BasicNameReference.create(index.getRealName()));
                            index.setNameSurrogate(k.is_system_named);
                        } else {
                            key.setUnderlyingIndexRef(null);
                            key.setColNames(CollectionsKt.emptyList());
                        }
                        tables.add(table);
                    }
                    for (MsStoredTable table : tables) {
                        table.getKeys().sort();
                    }
                }
            });
        }

        private final void retrieveForeignKeys() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FOREIGN_KEY");
            MsIntrospector.this.reportRetrieving(objectKind);
            List fks = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveForeignKeys(), null, 0, 6, null);
            if (fks.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneForeignKey>)fks, this, MsIntrospector.this){
                final /* synthetic */ List<MsIntroQueries.OneForeignKey> $fks;
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ MsIntrospector this$1;
                {
                    this.$fks = $fks;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    ForeignKeyInfo fki;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    HashSet<MsTable> affectedTables = new HashSet<MsTable>(this.$fks.size());
                    Long2ObjectOpenHashMap infos = new Long2ObjectOpenHashMap(this.$fks.size());
                    for (MsIntroQueries.OneForeignKey fk : this.$fks) {
                        MsTable table;
                        if ((MsTable)schema2.getTables().getByObjectId(fk.table_id) == null) continue;
                        MsForeignKey fkey = (MsForeignKey)table.getForeignKeys().renew(fk.constraint_id, fk.name);
                        Family family = schema2.getParentFamily();
                        Intrinsics.checkNotNull((Object)family);
                        MsSchema refSchema = (MsSchema)family.getByObjectId(fk.referenced_schema_id);
                        fkey.setNameSurrogate(fk.is_system_named);
                        fkey.setDisabled(fk.is_disabled);
                        MsSchema msSchema = refSchema;
                        fkey.setRefTableRef(BasicIdOrNameReference.create(BasicIdReference.create(fk.referenced_object_id), BasicParentReference.create(msSchema != null ? msSchema.getName() : null, BasicNameReference.create(fk.referenced_object_name))));
                        Intrinsics.checkNotNull((Object)fkey);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(fkey, fk.create_date, fk.modify_date);
                        fkey.setOnUpdate(MsIntrospectorKt.access$makeCascadeRule(fk.update_referential_action));
                        fkey.setOnDelete(MsIntrospectorKt.access$makeCascadeRule(fk.delete_referential_action));
                        ForeignKeyInfo fki2 = new ForeignKeyInfo(fkey, refSchema);
                        fki2.setDomTableId(fk.table_id);
                        fki2.setRefTableId(fk.referenced_object_id);
                        infos.put(fk.constraint_id, (Object)fki2);
                        affectedTables.add(table);
                    }
                    List fcs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this.this$0, MsIntrospector.access$getMyQueries$p(this.this$1).getRetrieveForeignKeyColumns(), null, 0, 6, null);
                    for (MsIntroQueries.OneForeignKeyColumn fc : fcs) {
                        String referenceColumnName;
                        String domesticColumnName;
                        fki = (ForeignKeyInfo)infos.get(fc.constraint_id);
                        if (fc.domestic_column_name == null || fc.reference_column_name == null || fki == null) continue;
                        fki.getDomColumnNames().add((Object)domesticColumnName);
                        fki.getRefColumnNames().add((Object)referenceColumnName);
                    }
                    for (ForeignKeyInfo o2 : (ObjectCollection)infos.values()) {
                        Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type com.intellij.database.dialects.mssql.introspector.ForeignKeyInfo");
                        fki = o2;
                        fki.getFkey().setColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getDomColumnNames())));
                        fki.getFkey().setRefColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getRefColumnNames())));
                    }
                    for (MsTable table : affectedTables) {
                        table.getForeignKeys().sort();
                    }
                }
            });
        }

        private final void retrieveCheckConstraints() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CHECK");
            MsIntrospector.this.reportRetrieving(objectKind);
            List cs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveCheckConstraints(), null, 0, 6, null);
            this.processCheckConstraints(cs);
        }

        private final void retrieveTypeCheckConstraints() {
            ObjectKind objectKind = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CHECK");
            MsIntrospector.this.reportRetrieving(objectKind);
            List cs = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTypeCheckConstraints(), null, 0, 6, null);
            this.processCheckConstraints(cs);
        }

        private final void processCheckConstraints(List<MsIntroQueries.OneCheckConstraints> cs) {
            this.inSchema((Function1)new Function1<MsSchema, Unit>(cs, MsIntrospector.this){
                final /* synthetic */ List<MsIntroQueries.OneCheckConstraints> $cs;
                final /* synthetic */ MsIntrospector this$0;
                {
                    this.$cs = $cs;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    affectedTables = new HashSet<MsStoredTable>(this.$cs.size());
                    for (MsIntroQueries.OneCheckConstraints c : this.$cs) {
                        var7_7 = schema;
                        objectId$iv = c.table_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findAllById$iv$iv = v0;
                        $i$f$findAllById = false;
                        v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(MsStoredTable.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                        v0 = v1;
                        if (v1 != null && (v0 = v0.filter(new Condition(var12_12 = (Function1)new Function1<MsStoredTable, Boolean>((BasicSchema)$this$findById$iv){
                            final /* synthetic */ BasicSchema $this_findById;
                            {
                                this.$this_findById = $receiver;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @NotNull
                            public final Boolean invoke(BasicIdentifiedElement it2) {
                                return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                            }
                        }){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                this.function = function2;
                            }

                            public final /* synthetic */ boolean value(Object p0) {
                                return (Boolean)this.function.invoke(p0);
                            }
                        })) != null) {
                            v2 = (BasicIdentifiedElement)v0.first();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = null;
                        }
                        if ((MsStoredTable)v2 == null) continue;
                        check = table.getChecks().renew(c.constraint_id, c.name);
                        check.setNameSurrogate(c.is_system_named);
                        check.setDisabled(c.is_disabled);
                        Intrinsics.checkNotNull((Object)check);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(check, c.create_date, c.modify_date);
                        if (c.column_name != null) {
                            check.setColNames(Collections.singletonList(c.column_name));
                        } else {
                            check.setColNames(CollectionsKt.emptyList());
                        }
                        check.setPredicate(MsIntrospectorHelper.normalizeExpression$default(MsIntrospector.access$getHelper$p(this.this$0), c.definition, false, 2, null));
                        affectedTables.add(table);
                    }
                    for (MsStoredTable table : affectedTables) {
                        table.getChecks().sort();
                    }
                }
            });
        }

        private final void retrieveSynonyms() {
            if (this.myTouchedSynonyms.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
            MsIntrospector.this.reportRetrieving(objectKind);
            List ss2 = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveSynonyms(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneSynonym>)ss2){
                final /* synthetic */ List<MsIntroQueries.OneSynonym> $ss;
                {
                    this.$ss = $ss;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    for (MsIntroQueries.OneSynonym s2 : this.$ss) {
                        MsSynonym synonym2 = schema2.getSynonyms().renew(s2.object_id, s2.name);
                        synonym2.setTargetObjectRef(BasicParentReference.create(s2.origin_db_name, BasicParentReference.create(s2.origin_schema_name, BasicNameReference.create(s2.origin_object_name))));
                        Intrinsics.checkNotNull((Object)synonym2);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(synonym2, s2.create_date, s2.modify_date);
                    }
                    schema2.getSynonyms().sort();
                }
            });
        }

        private final void retrieveSecurityPolicies() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SECURITY_POLICY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SECURITY_POLICY");
            MsIntrospector.this.reportRetrieving(objectKind);
            List infos = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveSecurityPolicies(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneSecurityPolicy>)infos){
                final /* synthetic */ List<MsIntroQueries.OneSecurityPolicy> $infos;
                {
                    this.$infos = $infos;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MsSchema schema2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    ModFamily modFamily = schema2.getSecurityPolicies();
                    List<MsIntroQueries.OneSecurityPolicy> list = this.$infos;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily securityPolicies = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl = false;
                    for (MsIntroQueries.OneSecurityPolicy info2 : list) {
                        E e2 = securityPolicies.renew(info2.object_id, info2.name);
                        MsSecurityPolicy $this$invoke_u24lambda_u241_u24lambda_u240 = (MsSecurityPolicy)e2;
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setEnabled(info2.is_enabled);
                        $this$invoke_u24lambda_u241_u24lambda_u240.setNotForReplication(info2.is_not_for_replication);
                        $this$invoke_u24lambda_u241_u24lambda_u240.setSchemaBinding(info2.is_schema_bound);
                        Intrinsics.checkNotNull((Object)$this$invoke_u24lambda_u241_u24lambda_u240);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps($this$invoke_u24lambda_u241_u24lambda_u240, info2.create_date, info2.modify_date);
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        private final void retrieveSecurityPredicates() {
            int[] nArray = new int[]{13};
            if (MsIntrospector.this.getServerVersion().less(nArray)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SECURITY_PREDICATE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SECURITY_PREDICATE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List infos = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveSecurityPredicates(), null, 0, 6, null);
            IdCache<MsSecurityPolicy> policyCache = new IdCache<MsSecurityPolicy>();
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneSecurityPredicate>)infos, policyCache, MsIntrospector.this){
                final /* synthetic */ List<MsIntroQueries.OneSecurityPredicate> $infos;
                final /* synthetic */ IdCache<MsSecurityPolicy> $policyCache;
                final /* synthetic */ MsIntrospector this$0;
                {
                    this.$infos = $infos;
                    this.$policyCache = $policyCache;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    v0 = schema.getSecurityPolicies();
                    Intrinsics.checkNotNullExpressionValue(v0, (String)"getSecurityPolicies(...)");
                    $this$map$iv = (List<MsIntroQueries.OneSecurityPredicate>)v0;
                    $i$f$map = false;
                    var4_4 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var9_11 = (MsSecurityPolicy)item$iv$iv;
                        var29_16 = destination$iv$iv;
                        $i$a$-map-MsIntrospector$MsSchemaRetriever$retrieveSecurityPredicates$1$1 = false;
                        var29_16.add(it.getPredicates());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    var4_4 = this.$infos;
                    var5_5 = this.$policyCache;
                    var6_7 = this.this$0;
                    inc$iv = true;
                    $i$f$modifyFamiliesAndCleanup = false;
                    $this$toTypedArray$iv$iv = families$iv;
                    $i$f$toTypedArray = false;
                    thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                    fs$iv = thisCollection$iv$iv.toArray(new ModNamingIdentifyingFamily[0]);
                    families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                    $i$f$modifyFamiliesAndCleanup = false;
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.markChildrenAsSyncPending();
                    }
                    $i$a$-modifyFamiliesAndCleanup$default-MsIntrospector$MsSchemaRetriever$retrieveSecurityPredicates$1$2 = false;
                    for (MsIntroQueries.OneSecurityPredicate info : var4_4) {
                        var17_23 = var5_5;
                        id$iv = info.object_id;
                        $i$f$getOrCache = false;
                        if (this_$iv.getV() == null) ** GOTO lbl-1000
                        v1 = this_$iv.getV();
                        Intrinsics.checkNotNull(v1);
                        if (v1.getObjectId() == id$iv) {
                            v2 = this_$iv.getV();
                        } else lbl-1000:
                        // 2 sources

                        {
                            var21_26 = id$iv;
                            var23_27 = this_$iv;
                            var24_28 = this_$iv;
                            $i$a$-getOrCache-MsIntrospector$MsSchemaRetriever$retrieveSecurityPredicates$1$2$policy$1 = false;
                            var24_28.setV((BasicModIdentifiedElement)((MsSecurityPolicy)schema.getSecurityPolicies().getByObjectId((long)id)));
                            v2 = this_$iv.getV();
                        }
                        if ((MsSecurityPolicy)v2 == null) continue;
                        var27_31 = policy.getPredicates().createOrGet(info.security_predicate_id);
                        $this$invoke_u24lambda_u243_u24lambda_u242 = (MsSecurityPredicate)var27_31;
                        $i$a$-apply-MsIntrospector$MsSchemaRetriever$retrieveSecurityPredicates$1$2$1 = false;
                        switch (info.predicate_type) {
                            case 0: {
                                v3 = MsSecurityPredicateType.FILTER;
                                break;
                            }
                            case 1: {
                                v3 = MsSecurityPredicateType.BLOCK;
                                break;
                            }
                            default: {
                                v3 = null;
                            }
                        }
                        $this$invoke_u24lambda_u243_u24lambda_u242.setPredicateType(v3);
                        switch (info.operation) {
                            case 1: {
                                v4 = MsSecurityPredicateOperationType.AFTER_INSERT;
                                break;
                            }
                            case 2: {
                                v4 = MsSecurityPredicateOperationType.AFTER_UPDATE;
                                break;
                            }
                            case 3: {
                                v4 = MsSecurityPredicateOperationType.BEFORE_UPDATE;
                                break;
                            }
                            case 4: {
                                v4 = MsSecurityPredicateOperationType.BEFORE_DELETE;
                                break;
                            }
                            default: {
                                v4 = MsSecurityPredicateOperationType.ALL;
                            }
                        }
                        $this$invoke_u24lambda_u243_u24lambda_u242.setOperationType(v4);
                        $this$invoke_u24lambda_u243_u24lambda_u242.setDefinition(MsIntrospector.access$getHelper$p(var6_7).normalizeExpression(info.predicate_definition, true));
                        $this$invoke_u24lambda_u243_u24lambda_u242.setTargetTableRef(BasicIdReference.create(info.target_object_id));
                    }
                    for (ModFamily f$iv$iv : families$iv$iv) {
                        f$iv$iv.removeSyncPendingChildren();
                        f$iv$iv.sort();
                    }
                }
            });
        }

        private final void retrieveSequences() {
            block5: {
                block4: {
                    if (MsIntrospector.this.isSynapse()) break block4;
                    int[] nArray = new int[]{11};
                    if (!MsIntrospector.this.getServerVersion().less(nArray)) break block5;
                }
                return;
            }
            if (this.myTouchedSequences.isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SEQUENCE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SEQUENCE");
            MsIntrospector.this.reportRetrieving(objectKind);
            List sequences = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveSequences(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneSequence>)sequences, this){
                final /* synthetic */ List<MsIntroQueries.OneSequence> $sequences;
                final /* synthetic */ MsSchemaRetriever this$0;
                {
                    this.$sequences = $sequences;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    for (MsIntroQueries.OneSequence s2 : this.$sequences) {
                        long l;
                        MsSequence sequence = schema2.getSequences().renew(s2.object_id, s2.name);
                        Object object = s2.start_value;
                        BigInteger start2 = object != null ? MsSchemaRetriever.access$asBigInteger(this.this$0, object) : null;
                        Object object2 = s2.last_value;
                        BigInteger last2 = object2 != null ? MsSchemaRetriever.access$asBigInteger(this.this$0, object2) : null;
                        Object object3 = s2.minimum_value;
                        BigInteger minimum = object3 != null ? MsSchemaRetriever.access$asBigInteger(this.this$0, object3) : null;
                        Object object4 = s2.maximum_value;
                        BigInteger maximum = object4 != null ? MsSchemaRetriever.access$asBigInteger(this.this$0, object4) : null;
                        Object object5 = s2.increment;
                        BigInteger increment = object5 != null ? MsSchemaRetriever.access$asBigInteger(this.this$0, object5) : null;
                        object5 = sequence;
                        MsSchemaRetriever msSchemaRetriever = this.this$0;
                        Object $this$invoke_u24lambda_u240 = object5;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setStoredType(MsSchemaRetriever.access$getDasType(msSchemaRetriever, s2, false));
                        $this$invoke_u24lambda_u240.setUnderlyingStoredType(MsSchemaRetriever.access$getDasType(msSchemaRetriever, s2, true));
                        $this$invoke_u24lambda_u240.setStartValue(start2);
                        DasType dasType = $this$invoke_u24lambda_u240.getUnderlyingStoredType();
                        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getUnderlyingStoredType(...)");
                        BigInteger bigInteger = BaseIntrospectionFunctions.nextByLast(last2, increment, start2);
                        DasType dasType2 = $this$invoke_u24lambda_u240.getUnderlyingStoredType();
                        Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getUnderlyingStoredType(...)");
                        $this$invoke_u24lambda_u240.setSequenceIdentity(SequenceIdentity.of(BaseIntrospectionFunctions.nullize(minimum, MsSchemaRetriever.access$sequenceUnlimitedMinimumDefault(msSchemaRetriever, dasType)), bigInteger, increment, BaseIntrospectionFunctions.nullize(maximum, MsSchemaRetriever.access$sequenceUnlimitedMaximumDefault(msSchemaRetriever, dasType2))));
                        if (s2.is_cached) {
                            Long l2 = s2.cache_size;
                            l = l2 != null ? l2 : 0L;
                        } else {
                            l = -1L;
                        }
                        $this$invoke_u24lambda_u240.setCacheSize(l);
                        $this$invoke_u24lambda_u240.setCycled(s2.is_cycling);
                        Intrinsics.checkNotNull((Object)$this$invoke_u24lambda_u240);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps((MsSchemaObject)$this$invoke_u24lambda_u240, s2.create_date, s2.modify_date);
                    }
                }
            });
        }

        private final BigInteger asBigInteger(Object $this$asBigInteger) {
            BigInteger bigInteger;
            Object object = $this$asBigInteger;
            if (object instanceof BigInteger) {
                bigInteger = (BigInteger)$this$asBigInteger;
            } else if (object instanceof BigDecimal) {
                bigInteger = ((BigDecimal)$this$asBigInteger).toBigInteger();
            } else if (object instanceof Number) {
                BigInteger bigInteger2 = BigInteger.valueOf(((Number)$this$asBigInteger).longValue());
                bigInteger = bigInteger2;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
            } else {
                bigInteger = null;
            }
            return bigInteger;
        }

        private final DasType getDasType(MsIntroQueries.OneSequence $this$getDasType, boolean isUnderlying) {
            String typeName;
            String string;
            String schemaName;
            if (isUnderlying) {
                String string2 = $this$getDasType.type_schema_name;
                if (string2 != null) {
                    String string3;
                    String it2 = string3 = string2;
                    boolean bl = false;
                    v1 = !StringsKt.equals((String)it2, (String)"sys", (boolean)true) ? string3 : null;
                } else {
                    v1 = null;
                }
            } else {
                v1 = schemaName = null;
            }
            if ((string = isUnderlying ? $this$getDasType.system_type_name : $this$getDasType.type_name) == null) {
                string = "bigint";
            }
            int length = StringsKt.equals((String)(typeName = string), (String)"numeric", (boolean)true) || StringsKt.equals((String)typeName, (String)"decimal", (boolean)true) ? $this$getDasType.precision : -1;
            DataType dataType = DataTypeFactory.of(schemaName, typeName, length, 0, null, null, false, false);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            DataType dataType2 = dataType;
            return DasUnresolvedTypeReference.Companion.of(dataType2);
        }

        private final BigInteger sequenceUnlimitedMinimumDefault(DasType type2) {
            return DasTypeUtilsKt.getMinValue(type2);
        }

        private final BigInteger sequenceUnlimitedMaximumDefault(DasType type2) {
            return DasTypeUtilsKt.getMaxValue(type2);
        }

        private final void retrieveArguments() {
            if (this.myTouchedRoutines.isEmpty()) {
                return;
            }
            MsIntrospector.this.reportRetrieving("procedures' and functions' parameters", "introspection.retrieve.singleRoutinesArguments");
            List args2 = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveArguments(), null, 0, 6, null);
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, (List<MsIntroQueries.OneArguments>)args2){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List<MsIntroQueries.OneArguments> $args;
                {
                    this.this$0 = $receiver;
                    this.$args = $args;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    for (MsRoutine routine2 : MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0)) {
                        routine2.getArguments().markChildrenAsSyncPending();
                    }
                    for (MsIntroQueries.OneArguments a : this.$args) {
                        ArgumentDirection d2;
                        MsRoutine routine3;
                        if ((MsRoutine)schema2.getRoutines().getByObjectId((long)a.object_id) == null) continue;
                        Object object = a.name;
                        if (object == null) {
                            object = "unnamed_" + a.position;
                        }
                        String argName = object;
                        MsArgument argument = (MsArgument)routine3.getArguments().createOrGet(argName);
                        argument.setPosition(a.position);
                        ArgumentDirection argumentDirection = a.is_cursor_ref ? ArgumentDirection.RESULT : (d2 = a.is_output ? ArgumentDirection.OUT : ArgumentDirection.IN);
                        if (d2 == ArgumentDirection.OUT && (a.name == null || ((CharSequence)argName).length() == 0)) {
                            d2 = ArgumentDirection.RETURN;
                        }
                        argument.setArgumentDirection(d2);
                        argument.setStoredType(MsIntrospectorKt.access$makeDasType(a.type_name, a.max_length, a.precision, a.scale));
                        argument.resetSyncPending();
                        ((Collection)MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0)).add(routine3);
                    }
                    for (MsRoutine routine2 : MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0)) {
                        routine2.getArguments().removeSyncPendingChildren();
                    }
                }
            });
        }

        private final void retrieveTriggers() {
            List ts2;
            if (((MsSchema)this.getSchema()).getTables().isEmpty() & ((MsSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            MsIntrospector.this.reportRetrieving(objectKind);
            List list = ts2 = MsIntrospector.this.isSynapse() ? CollectionsKt.emptyList() : BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveTriggers(), null, 0, 6, null);
            if (ts2.isEmpty()) {
                return;
            }
            HashSet<MsTableOrView> affectedTables = new HashSet<MsTableOrView>(ts2.size());
            this.inSchema((Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneTrigger>)ts2, affectedTables){
                final /* synthetic */ List<MsIntroQueries.OneTrigger> $ts;
                final /* synthetic */ HashSet<MsTableOrView> $affectedTables;
                {
                    this.$ts = $ts;
                    this.$affectedTables = $affectedTables;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull MsSchema schema) {
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    for (MsIntroQueries.OneTrigger t : this.$ts) {
                        var6_6 = schema;
                        objectId$iv = t.table_id;
                        $i$f$findById = false;
                        v0 = $this$findById$iv.getDatabase();
                        if (v0 == null) ** GOTO lbl-1000
                        $this$findAllById$iv$iv = v0;
                        $i$f$findAllById = false;
                        v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(MsTableOrView.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                        v0 = v1;
                        if (v1 != null && (v0 = v0.filter(new Condition(var11_11 = (Function1)new Function1<MsTableOrView, Boolean>((BasicSchema)$this$findById$iv){
                            final /* synthetic */ BasicSchema $this_findById;
                            {
                                this.$this_findById = $receiver;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @NotNull
                            public final Boolean invoke(BasicIdentifiedElement it2) {
                                return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                            }
                        }){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                this.function = function2;
                            }

                            public final /* synthetic */ boolean value(Object p0) {
                                return (Boolean)this.function.invoke(p0);
                            }
                        })) != null) {
                            v2 = (BasicIdentifiedElement)v0.first();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = null;
                        }
                        if ((MsTableOrView)v2 == null) continue;
                        trigger = table.getTriggers().renew(t.trigger_id, t.name);
                        trigger.setEvents(MsIntrospectorKt.access$unpackEvents(t.events));
                        trigger.setFirstEvents(MsIntrospectorKt.access$unpackEvents(t.first_events));
                        trigger.setLastEvents(MsIntrospectorKt.access$unpackEvents(t.last_events));
                        trigger.setTurn(t.is_instead_of_trigger != false ? TrigTurn.INSTEAD_OF : TrigTurn.AFTER_STMT);
                        trigger.setNotForReplication(t.is_not_for_replication);
                        trigger.setDisabled(t.is_disabled);
                        trigger.setEncrypted(t.encrypted);
                        trigger.setCreatedTimestamp(t.create_date);
                        trigger.setModifiedTimestamp(t.modify_date);
                        this.$affectedTables.add(table);
                    }
                    for (MsTableOrView table : this.$affectedTables) {
                        table.getTriggers().sort();
                    }
                }
            });
            this.myTouchedTableWithTriggers.addAll((Collection<MsTableOrView>)affectedTables);
        }

        private final void retrievePermissions() {
            MsIntrospector.this.reportRetrieving("objects' permissions", "introspection.retrieve.objectPermissions");
            MsIntrospectorKt.access$retrievePermissions(this, (MsGrantsHolder)this.getSchema(), this.getTransaction(), MsIntrospector.this.myQueries.getCalculateSchemaPermissionsChecksum(), MsIntrospector.this.myQueries.getRetrieveSchemaPermissions());
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDescription() {
            void $this$groupByTo$iv$iv;
            MsIntrospector.this.reportRetrieving("table descriptions", "introspection.retrieve.tableDescriptions");
            long checksum = 0L;
            try {
                Long checksumOrNull;
                Long l = checksumOrNull = this.performQuery(MsIntrospector.this.myQueries.getCalculateExtendedPropertiesChecksum());
                checksum = l == null ? 0L : l;
            }
            catch (Exception e2) {
                String message2 = "Failed to calculate checksum of descriptions in schema " + ((MsSchema)this.getSchema()).getName() + ": exception " + e2.getClass().getSimpleName() + ": " + e2.getMessage();
                if (this.log.isDebugEnabled()) {
                    this.log.warn(message2, (Throwable)e2);
                } else {
                    this.log.warn(message2);
                }
                return;
            }
            if (checksum == ((MsSchema)this.getSchema()).getDescriptionsCheckSum()) {
                return;
            }
            List ds = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, MsIntrospector.this.myQueries.getRetrieveExtendedProperties(), null, 0, 6, null);
            Iterable $this$groupBy$iv = ds;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                MsIntroQueries.OneProperty d2 = (MsIntroQueries.OneProperty)element$iv$iv;
                boolean bl = false;
                ExtPropId key$iv$iv = new ExtPropId(d2.object_class, d2.object_id, d2.position);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map descriptions = destination$iv$iv;
            this.inSchema((Function1)new Function1<MsSchema, Unit>(this, (Map<ExtPropId, ? extends List<MsIntroQueries.OneProperty>>)descriptions, checksum){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ Map<ExtPropId, List<MsIntroQueries.OneProperty>> $descriptions;
                final /* synthetic */ long $checksum;
                {
                    this.this$0 = $receiver;
                    this.$descriptions = $descriptions;
                    this.$checksum = $checksum;
                    super(1);
                }

                public final void invoke(@NotNull MsSchema schema2) {
                    Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
                    MsSchemaRetriever.access$processExtendedPropertiesForObjects(this.this$0, schema2, this.$descriptions, retrieveDescription.1.INSTANCE);
                    if (this.this$0.getMode().full || this.this$0.getMode().increment) {
                        schema2.setDescriptionsCheckSum(this.$checksum);
                    }
                }
            });
        }

        private final <T extends BasicModIdentifiedElement, X> void processExtendedPropertiesForObjects(ModIdentifyingFamily<T> family, Map<ExtPropId, ? extends X> values2, Function2<? super BasicModElement, ? super X, Unit> processor2) {
            for (BasicModIdentifiedElement obj2 : family) {
                Intrinsics.checkNotNull((Object)obj2);
                this.processExtendedPropertiesForObjects(obj2, values2, processor2);
            }
        }

        private final <T extends MsCustomType, X> void processExtendedPropertiesForType(T type2, Map<ExtPropId, ? extends X> values2, Function2<? super BasicModElement, ? super X, Unit> processor2) {
            processor2.invoke(type2, values2.get(MsIntrospectorKt.access$getExtendedPropertyId(type2)));
        }

        private final <T extends BasicModIdentifiedElement, X> void processExtendedPropertiesForObjects(T obj2, Map<ExtPropId, ? extends X> values2, Function2<? super BasicModElement, ? super X, Unit> processor2) {
            processor2.invoke(obj2, values2.get(MsIntrospectorKt.access$getExtendedPropertyId(obj2)));
            if (obj2 instanceof MsLikeTable) {
                for (MsLikeColumn column2 : ((MsLikeTable)obj2).getColumns()) {
                    Intrinsics.checkNotNull((Object)column2);
                    processor2.invoke((Object)column2, values2.get(MsIntrospectorKt.access$getExtendedPropertyId(column2)));
                }
            }
            if (obj2 instanceof MsSchema) {
                MsExtendedPropertiesHolder it2;
                ModNamingIdentifyingFamily<? extends MsSequence> modNamingIdentifyingFamily = ((MsSchema)obj2).getSequences();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSequences(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily), (Map<ExtPropId, ? extends X>)values2, processor2);
                ModNamingFamily<? extends MsAliasType> modNamingFamily = ((MsSchema)obj2).getAliasTypes();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getAliasTypes(...)");
                Iterable $this$forEach$iv = modNamingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (MsAliasType)element$iv;
                    boolean bl = false;
                    this.processExtendedPropertiesForType((MsCustomType)((Object)it2), values2, processor2);
                }
                ModNamingIdentifyingFamily<? extends MsTableType> modNamingIdentifyingFamily2 = ((MsSchema)obj2).getTableTypes();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTableTypes(...)");
                $this$forEach$iv = modNamingIdentifyingFamily2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it2 = (MsTableType)element$iv;
                    boolean bl = false;
                    this.processExtendedPropertiesForType((MsCustomType)((Object)it2), values2, processor2);
                }
                ModNamingIdentifyingFamily<? extends MsRoutine> modNamingIdentifyingFamily3 = ((MsSchema)obj2).getRoutines();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getRoutines(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily3), (Map<ExtPropId, ? extends X>)values2, processor2);
                ModNamingIdentifyingFamily<? extends MsSynonym> modNamingIdentifyingFamily4 = ((MsSchema)obj2).getSynonyms();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getSynonyms(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily4), (Map<ExtPropId, ? extends X>)values2, processor2);
                ModNamingIdentifyingFamily<? extends MsTable> modNamingIdentifyingFamily5 = ((MsSchema)obj2).getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getTables(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily5), (Map<ExtPropId, ? extends X>)values2, processor2);
                ModNamingIdentifyingFamily<? extends MsView> modNamingIdentifyingFamily6 = ((MsSchema)obj2).getViews();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getViews(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily6), (Map<ExtPropId, ? extends X>)values2, processor2);
                ModNamingIdentifyingFamily<? extends MsRule> modNamingIdentifyingFamily7 = ((MsSchema)obj2).getRules();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getRules(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily7), (Map<ExtPropId, ? extends X>)values2, processor2);
                processor2.invoke(obj2, values2.get(MsIntrospectorKt.access$getExtendedPropertyId((BasicElement)this.getSchema())));
            }
            if (obj2 instanceof MsTable) {
                for (MsIndex index2 : ((MsTable)obj2).getIndices()) {
                    Intrinsics.checkNotNull((Object)index2);
                    processor2.invoke((Object)index2, values2.get(MsIntrospectorKt.access$getExtendedPropertyId(index2)));
                }
                NamingFamily<? extends BasicCheck> namingFamily = ((MsTable)obj2).getChecks();
                Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getChecks(...)");
                this.processExtendedPropertiesForObjects((T)((Object)((ModIdentifyingFamily)((Object)namingFamily))), (Map<ExtPropId, ? extends X>)values2, processor2);
                NamingFamily<? extends BasicKey> namingFamily2 = ((MsTable)obj2).getKeys();
                Intrinsics.checkNotNullExpressionValue(namingFamily2, (String)"getKeys(...)");
                this.processExtendedPropertiesForObjects((T)((Object)((ModIdentifyingFamily)((Object)namingFamily2))), (Map<ExtPropId, ? extends X>)values2, processor2);
                NamingFamily namingFamily3 = ((MsTable)obj2).getForeignKeys();
                Intrinsics.checkNotNullExpressionValue((Object)namingFamily3, (String)"getForeignKeys(...)");
                this.processExtendedPropertiesForObjects((T)((Object)((ModIdentifyingFamily)((Object)namingFamily3))), (Map<ExtPropId, ? extends X>)values2, processor2);
                ModNamingIdentifyingFamily<? extends MsTrigger> modNamingIdentifyingFamily = ((MsTable)obj2).getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTriggers(...)");
                this.processExtendedPropertiesForObjects((T)((Object)modNamingIdentifyingFamily), (Map<ExtPropId, ? extends X>)values2, processor2);
            }
            if (obj2 instanceof MsRoutine) {
                for (MsArgument argument : ((MsRoutine)obj2).getArguments()) {
                    Intrinsics.checkNotNull((Object)argument);
                    processor2.invoke((Object)argument, values2.get(MsIntrospectorKt.access$getExtendedPropertyId(argument)));
                }
            }
        }

        private final void retrieveSources() {
            boolean withSysSources;
            if (!this.getWithSources()) {
                return;
            }
            boolean bl = withSysSources = MsIntrospector.this.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES;
            if (Intrinsics.areEqual((Object)((MsSchema)this.getSchema()).getName(), (Object)"sys") && !withSysSources) {
                return;
            }
            if (this.myTouchedMajorSourceAware.isEmpty() && this.myTouchedTableWithTriggers.isEmpty()) {
                return;
            }
            MsIntrospector.this.reportRetrieving("source texts", "introspection.retrieve.sources");
            SqlQuery<List<MsIntroQueries.OneSource>> query = withSysSources ? MsIntrospector.this.myQueries.getRetrieveSourcesWithSys() : MsIntrospector.this.myQueries.getRetrieveSources();
            List ss2 = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, query, null, 0, 6, null);
            if (ss2.isEmpty()) {
                return;
            }
            BaseNativeIntrospector this_$iv = MsIntrospector.this;
            boolean $i$f$writeSources = false;
            this_$iv.getModel().writeSources(new Runnable(this, ss2){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $ss$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$ss$inlined = list;
                }

                public final void run() {
                    boolean bl = false;
                    MsSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<MsSchema, Unit>((List<MsIntroQueries.OneSource>)this.$ss$inlined, this.this$0){
                        final /* synthetic */ List<MsIntroQueries.OneSource> $ss;
                        final /* synthetic */ MsSchemaRetriever this$0;
                        {
                            this.$ss = $ss;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final void invoke(@NotNull MsSchema schema) {
                            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                            for (MsIntroQueries.OneSource s : this.$ss) {
                                block5: {
                                    if (s.object_id == 0L || s.text == null) continue;
                                    if (s.is_trigger) break block5;
                                    var5_5 = schema;
                                    objectId$iv = s.object_id;
                                    $i$f$findById = false;
                                    v0 = $this$findById$iv.getDatabase();
                                    if (v0 == null) ** GOTO lbl-1000
                                    $this$findAllById$iv$iv = v0;
                                    $i$f$findAllById = false;
                                    v1 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(BasicModIdentifiedElement.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filter(...)");
                                    v0 = v1;
                                    if (v1 != null && (v0 = v0.filter(new Condition($i$f$findAllById = (Function1)new Function1<BasicModIdentifiedElement, Boolean>((BasicSchema)$this$findById$iv){
                                        final /* synthetic */ BasicSchema $this_findById;
                                        {
                                            this.$this_findById = $receiver;
                                            super(1);
                                        }

                                        /*
                                         * Ignored method signature, as it can't be verified against descriptor
                                         */
                                        @NotNull
                                        public final Boolean invoke(BasicIdentifiedElement it2) {
                                            return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                                        }
                                    }){
                                        private final /* synthetic */ Function1 function;
                                        {
                                            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                                            this.function = function2;
                                        }

                                        public final /* synthetic */ boolean value(Object p0) {
                                            return (Boolean)this.function.invoke(p0);
                                        }
                                    })) != null) {
                                        v2 = (BasicIdentifiedElement)v0.first();
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v2 = null;
                                    }
                                    if (!((element = (BasicModIdentifiedElement)v2) instanceof MsSourceAware)) continue;
                                    v3 = s.text;
                                    ((MsSourceAware)element).setSourceText(v3 != null ? BaseIntrospectionFunctions.toCompositeText(v3, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                    if (!(element instanceof MsRoutine)) continue;
                                    MsSchemaRetriever.access$extractDefaults(this.this$0, (MsRoutine)element, s.text);
                                    continue;
                                }
                                objectId$iv = schema;
                                objectId$iv = s.parent_id;
                                $i$f$findById = false;
                                v4 = $this$findById$iv.getDatabase();
                                if (v4 == null) ** GOTO lbl-1000
                                $this$findAllById$iv$iv = v4;
                                $i$f$findAllById = false;
                                v5 = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(MsTableOrView.class);
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"filter(...)");
                                v4 = v5;
                                if (v5 != null && (v4 = v4.filter(new /* invalid duplicate definition of identical inner class */)) != null) {
                                    v6 = (BasicIdentifiedElement)v4.first();
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v6 = null;
                                }
                                if ((MsTableOrView)v6 == null || (MsTrigger)table.getTriggers().getByObjectId(s.object_id) == null) continue;
                                v7 = s.text;
                                trigger.setSourceText(v7 != null ? BaseIntrospectionFunctions.toCompositeText(v7, CompositeText.Kind.ORIGINAL_TEXT) : null);
                            }
                        }
                    });
                }
            });
        }

        private final void extractDefaults(MsRoutine r, String text2) {
            Map map2 = this.extractDefaults(text2);
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map defs = map2;
            PositioningNamingFamily positioningNamingFamily = r.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
            Iterable $this$forEach$iv = positioningNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MsArgument it2 = (MsArgument)element$iv;
                boolean bl = false;
                it2.setDefaultExpression((String)defs.get(it2.getName()));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, String> extractDefaults(String text2) {
            Map map2;
            try {
                Map map3;
                SqlProcedureDefinitionImpl stmt2;
                Object object;
                Object object2;
                String string = text2;
                if (string != null) {
                    object2 = string;
                    object = MsIntrospector.this;
                    String it2 = object2;
                    boolean bl = false;
                    IntrospectorSqlHelper this_$iv = ((MsIntrospector)object).getSqlHelper();
                    boolean $i$f$statements = false;
                    v1 = (SqlProcedureDefinitionImpl)((Object)this_$iv.statements(it2, SqlProcedureDefinitionImpl.class).first());
                } else {
                    v1 = stmt2 = null;
                }
                if (stmt2 != null && (object2 = stmt2.getArguments()) != null) {
                    void $this$associateByTo$iv;
                    object = object2;
                    Map destination$iv = CollectionFactory.createCaseInsensitiveStringMap();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv : $this$associateByTo$iv) {
                        SqlParameterDefinition sqlParameterDefinition = (SqlParameterDefinition)element$iv;
                        Map map4 = destination$iv;
                        boolean bl = false;
                        SqlParameterDefinition it3 = (SqlParameterDefinition)element$iv;
                        String string2 = it3.getName();
                        boolean bl2 = false;
                        String string3 = it3.getDefault();
                        map4.put(string2, string3);
                    }
                    map3 = destination$iv;
                } else {
                    map3 = null;
                }
                map2 = map3;
            }
            catch (Throwable th) {
                this.log.warn(th);
                map2 = null;
            }
            return map2;
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            ((MsSchema)this.getSchema()).setIntrospectionTimestamp(this.myIntrospectionBeginTimestamp);
        }

        public static final /* synthetic */ void access$removeUnexistentSchemaObjects(MsSchemaRetriever $this, MsSchema schema2, AbstractIntSet existentObjectIds) {
            $this.removeUnexistentSchemaObjects(schema2, existentObjectIds);
        }

        public static final /* synthetic */ void access$removeUnexistentIndices(MsSchemaRetriever $this, MsSchema schema2, LongSet existentIndicesCombies, LongSet tablesWithFulltextIndices) {
            $this.removeUnexistentIndices(schema2, existentIndicesCombies, tablesWithFulltextIndices);
        }

        public static final /* synthetic */ ArrayList access$getMyTouchedRules$p(MsSchemaRetriever $this) {
            return $this.myTouchedRules;
        }

        public static final /* synthetic */ ArrayList access$getMyTouchedMajorSourceAware$p(MsSchemaRetriever $this) {
            return $this.myTouchedMajorSourceAware;
        }

        public static final /* synthetic */ HashSet access$getMyTouchedRoutines$p(MsSchemaRetriever $this) {
            return $this.myTouchedRoutines;
        }

        public static final /* synthetic */ HashSet access$getMyTouchedSequences$p(MsSchemaRetriever $this) {
            return $this.myTouchedSequences;
        }

        public static final /* synthetic */ HashSet access$getMyTouchedSynonyms$p(MsSchemaRetriever $this) {
            return $this.myTouchedSynonyms;
        }

        public static final /* synthetic */ ArrayList access$getMyTouchedTables$p(MsSchemaRetriever $this) {
            return $this.myTouchedTables;
        }

        public static final /* synthetic */ BigInteger access$asBigInteger(MsSchemaRetriever $this, Object $receiver) {
            return $this.asBigInteger($receiver);
        }

        public static final /* synthetic */ DasType access$getDasType(MsSchemaRetriever $this, MsIntroQueries.OneSequence $receiver, boolean isUnderlying) {
            return $this.getDasType($receiver, isUnderlying);
        }

        public static final /* synthetic */ BigInteger access$sequenceUnlimitedMinimumDefault(MsSchemaRetriever $this, DasType type2) {
            return $this.sequenceUnlimitedMinimumDefault(type2);
        }

        public static final /* synthetic */ BigInteger access$sequenceUnlimitedMaximumDefault(MsSchemaRetriever $this, DasType type2) {
            return $this.sequenceUnlimitedMaximumDefault(type2);
        }

        public static final /* synthetic */ void access$processExtendedPropertiesForObjects(MsSchemaRetriever $this, BasicModIdentifiedElement obj2, Map values2, Function2 processor2) {
            $this.processExtendedPropertiesForObjects(obj2, values2, processor2);
        }

        public static final /* synthetic */ void access$inSchema(MsSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$extractDefaults(MsSchemaRetriever $this, MsRoutine r, String text2) {
            $this.extractDefaults(r, text2);
        }
    }
}

