/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.dialects.mongo.generator.dml.UtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainOrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a0\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f\u001a0\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a,\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0004\u001a\u00020\u00012\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u001aZ\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142&\u0010\u001a\u001a\"\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bj\u0004\u0018\u0001`\u001fH\u0002\u00a8\u0006 "}, d2={"dbCollection", "Lcom/intellij/database/util/DdlBuilder;", "dbms", "Lcom/intellij/database/Dbms;", "builder", "table", "Lcom/intellij/database/model/DasObject;", "generateOrderBy", "", "orderBy", "Lcom/intellij/database/script/generator/dml/OrderBy;", "printSortFunction", "", "insertNewLines", "Lcom/intellij/database/script/generator/dml/PlainOrderBy;", "Lcom/intellij/database/script/generator/dml/ColumnsOrderBy;", "generateWhere", "whereClause", "Lcom/intellij/database/script/generator/dml/WhereClause;", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "op", "", "processor", "Lkotlin/Function3;", "Lcom/intellij/database/data/types/ColumnRef;", "Lcom/intellij/database/data/types/PredicateValue;", "Lcom/intellij/database/data/types/PredicateOperation;", "Lcom/intellij/database/script/generator/dml/ColumnValueConsumer;", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/mongo/generator/dml/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class UtilKt {
    public static final void generateWhere(@NotNull Dbms dbms, @Nullable WhereClause whereClause2, @NotNull DdlBuilder builder, @NotNull DmlTask<?> task) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        WhereClause whereClause3 = whereClause2;
        if (whereClause3 instanceof ValuesWhereClause) {
            List<List<PredicatesHelper.PredicateProducer>> predicates = ((ValuesWhereClause)whereClause2).getPredicates(dbms, DmlTaskKt.getTableAlias(task), DmlTaskKt.getVersion(task), DmlTaskKt.inUpdate(task));
            UtilKt.generateWhere(builder, predicates.get(0), ((ValuesWhereClause)whereClause2).getOpInner(), task, ((ValuesWhereClause)whereClause2).getProcessor());
        } else if (whereClause3 instanceof PlainWhereClause) {
            if (!StringsKt.isBlank((CharSequence)((PlainWhereClause)whereClause2).getFilter())) {
                builder.plain(((PlainWhereClause)whereClause2).getFilter());
            }
        } else if (whereClause3 instanceof PredicatesWhereClause) {
            UtilKt.generateWhere(builder, ((PredicatesWhereClause)whereClause2).getPredicates(), ((PredicatesWhereClause)whereClause2).getOp(), task, ((PredicatesWhereClause)whereClause2).getProcessor());
        } else {
            builder.symbol("{}");
        }
    }

    private static final void generateWhere(DdlBuilder builder, List<PredicatesHelper.PredicateProducer> predicates, String op, DmlTask<?> task, Function3<? super ColumnRef, ? super PredicateValue, ? super PredicateOperation, Unit> processor2) {
        boolean newLines = DmlTaskKt.insertNewLines(task) && predicates.size() > 1;
        MongoScriptUtilKt.inCurly$default(builder, false, newLines, (Function0)new Function0<Unit>(predicates, op, builder, newLines, processor2){
            final /* synthetic */ List<PredicatesHelper.PredicateProducer> $predicates;
            final /* synthetic */ String $op;
            final /* synthetic */ DdlBuilder $builder;
            final /* synthetic */ boolean $newLines;
            final /* synthetic */ Function3<ColumnRef, PredicateValue, PredicateOperation, Unit> $processor;
            {
                this.$predicates = $predicates;
                this.$op = $op;
                this.$builder = $builder;
                this.$newLines = $newLines;
                this.$processor = $processor;
                super(0);
            }

            public final void invoke() {
                boolean isOr;
                if (this.$predicates.isEmpty()) {
                    return;
                }
                boolean bl = isOr = Intrinsics.areEqual((Object)this.$op, (Object)"OR") && this.$predicates.size() > 1;
                if (isOr) {
                    this.$builder.plain("$or").symbol(":").space();
                }
                MongoScriptUtilKt.inBrackets(this.$builder, isOr, this.$newLines, (Function0<Unit>)((Function0)new Function0<Unit>(this.$predicates, this.$builder, this.$newLines, this.$processor, isOr){
                    final /* synthetic */ List<PredicatesHelper.PredicateProducer> $predicates;
                    final /* synthetic */ DdlBuilder $builder;
                    final /* synthetic */ boolean $newLines;
                    final /* synthetic */ Function3<ColumnRef, PredicateValue, PredicateOperation, Unit> $processor;
                    final /* synthetic */ boolean $isOr;
                    {
                        this.$predicates = $predicates;
                        this.$builder = $builder;
                        this.$newLines = $newLines;
                        this.$processor = $processor;
                        this.$isOr = $isOr;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        boolean first2 = true;
                        for (PredicatesHelper.PredicateProducer predicate : this.$predicates) {
                            if (first2) {
                                first2 = false;
                            } else {
                                DdlBuilder ddlBuilder = this.$builder.symbol(",");
                                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"symbol(...)");
                                DmlUtilKt.space(ddlBuilder, this.$newLines);
                            }
                            if (this.$processor != null) {
                                void $this$forEach$iv;
                                Iterable iterable = predicate.getColumnRefs();
                                Function3<ColumnRef, PredicateValue, PredicateOperation, Unit> function3 = this.$processor;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    ColumnRef it2 = (ColumnRef)element$iv;
                                    boolean bl = false;
                                    function3.invoke((Object)it2, (Object)predicate.getValue(), (Object)predicate.getOperation());
                                }
                            }
                            MongoScriptUtilKt.inCurly$default(this.$builder, this.$isOr, false, (Function0)new Function0<Unit>(predicate, this.$builder){
                                final /* synthetic */ PredicatesHelper.PredicateProducer $predicate;
                                final /* synthetic */ DdlBuilder $builder;
                                {
                                    this.$predicate = $predicate;
                                    this.$builder = $builder;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$predicate.getProduce().invoke((Object)this.$builder);
                                }
                            }, 2, null);
                        }
                    }
                }));
            }
        }, 1, null);
    }

    public static final void generateOrderBy(@NotNull Dbms dbms, @NotNull OrderBy orderBy, @NotNull DdlBuilder builder, boolean printSortFunction, boolean insertNewLines) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)orderBy, (String)"orderBy");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        OrderBy orderBy2 = orderBy;
        if (orderBy2 instanceof ColumnsOrderBy) {
            UtilKt.generateOrderBy((ColumnsOrderBy)orderBy, builder, printSortFunction, insertNewLines);
        } else if (orderBy2 instanceof PlainOrderBy) {
            UtilKt.generateOrderBy(dbms, (PlainOrderBy)orderBy, builder, printSortFunction, insertNewLines);
        }
    }

    public static /* synthetic */ void generateOrderBy$default(Dbms dbms, OrderBy orderBy, DdlBuilder ddlBuilder, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        UtilKt.generateOrderBy(dbms, orderBy, ddlBuilder, bl, bl2);
    }

    private static final void generateOrderBy(Dbms dbms, PlainOrderBy orderBy, DdlBuilder builder, boolean printSortFunction, boolean insertNewLines) {
        if (StringsKt.isBlank((CharSequence)orderBy.getText()) || Intrinsics.areEqual((Object)orderBy.getText(), (Object)"{}")) {
            return;
        }
        if (printSortFunction) {
            DmlUtilKt.newLine(builder, insertNewLines).symbol(".").plain("sort");
        }
        MongoScriptUtilKt.inParenth(builder, printSortFunction, (Function0<Unit>)((Function0)new Function0<Unit>(builder, orderBy){
            final /* synthetic */ DdlBuilder $builder;
            final /* synthetic */ PlainOrderBy $orderBy;
            {
                this.$builder = $builder;
                this.$orderBy = $orderBy;
                super(0);
            }

            public final void invoke() {
                this.$builder.plain(this.$orderBy.getText());
            }
        }));
    }

    private static final void generateOrderBy(ColumnsOrderBy orderBy, DdlBuilder builder, boolean printSortFunction, boolean insertNewLines) {
        if (orderBy.getColumns().isEmpty()) {
            return;
        }
        if (printSortFunction) {
            DmlUtilKt.newLine(builder, insertNewLines).symbol(".").plain("sort");
        }
        MongoScriptUtilKt.inParenth(builder, printSortFunction, (Function0<Unit>)((Function0)new Function0<Unit>(builder, orderBy){
            final /* synthetic */ DdlBuilder $builder;
            final /* synthetic */ ColumnsOrderBy $orderBy;
            {
                this.$builder = $builder;
                this.$orderBy = $orderBy;
                super(0);
            }

            public final void invoke() {
                MongoScriptUtilKt.inCurly$default(this.$builder, this.$orderBy.getColumns(), false, (Function1)new Function1<Pair<? extends String, ? extends RowSortOrder.Type>, Unit>(this.$builder){
                    final /* synthetic */ DdlBuilder $builder;
                    {
                        this.$builder = $builder;
                        super(1);
                    }

                    public final void invoke(@NotNull Pair<String, ? extends RowSortOrder.Type> pair) {
                        int n;
                        Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                        String name2 = (String)pair.component1();
                        RowSortOrder.Type sortOrder = (RowSortOrder.Type)pair.component2();
                        switch (generateOrderBy.WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
                            case 1: {
                                n = 1;
                                break;
                            }
                            case 2: {
                                n = -1;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        int order2 = n;
                        this.$builder.identifier(null, name2).symbol(":").space().number(order2);
                    }
                }, 2, null);
            }
        }));
    }

    @NotNull
    public static final DdlBuilder dbCollection(@NotNull Dbms dbms, @NotNull DdlBuilder builder, @NotNull DasObject table) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        builder.plain("db");
        if (!builder.inCurrentNamespace(table)) {
            String schemaName;
            String string;
            String it2 = string = DasUtil.getSchema(table);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            String string2 = schemaName = ((CharSequence)it2).length() > 0 ? string : null;
            if (string2 != null) {
                it2 = string2;
                boolean bl2 = false;
                DdlBuilder ddlBuilder = builder.symbol(".").plain("getSiblingDB");
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
                MongoScriptUtilKt.inParenth$default(ddlBuilder, false, (Function0)new Function0<Unit>(builder, schemaName, dbms){
                    final /* synthetic */ DdlBuilder $builder;
                    final /* synthetic */ String $schemaName;
                    final /* synthetic */ Dbms $dbms;
                    {
                        this.$builder = $builder;
                        this.$schemaName = $schemaName;
                        this.$dbms = $dbms;
                        super(0);
                    }

                    public final void invoke() {
                        this.$builder.literal(DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(this.$schemaName, this.$dbms));
                    }
                }, 1, null);
            }
        }
        DdlBuilder ddlBuilder = builder.symbol(".").plain("getCollection");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
        return MongoScriptUtilKt.inParenth$default(ddlBuilder, false, (Function0)new Function0<Unit>(builder, table, dbms){
            final /* synthetic */ DdlBuilder $builder;
            final /* synthetic */ DasObject $table;
            final /* synthetic */ Dbms $dbms;
            {
                this.$builder = $builder;
                this.$table = $table;
                this.$dbms = $dbms;
                super(0);
            }

            public final void invoke() {
                this.$builder.literal(DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(this.$table.getName(), this.$dbms));
            }
        }, 1, null);
    }
}

