/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospector;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector$retrieveFunctions$1$1$invoke$;
import com.intellij.database.dialects.hive.model.HiveForeignKey;
import com.intellij.database.dialects.hive.model.HiveFunction;
import com.intellij.database.dialects.hive.model.HiveFunctionBase;
import com.intellij.database.dialects.hive.model.HiveIndex;
import com.intellij.database.dialects.hive.model.HiveLikeTable;
import com.intellij.database.dialects.hive.model.HiveMacro;
import com.intellij.database.dialects.hive.model.HiveMatView;
import com.intellij.database.dialects.hive.model.HivePersistentFunction;
import com.intellij.database.dialects.hive.model.HiveRole;
import com.intellij.database.dialects.hive.model.HiveRoot;
import com.intellij.database.dialects.hive.model.HiveSchema;
import com.intellij.database.dialects.hive.model.HiveTable;
import com.intellij.database.dialects.hive.model.HiveTableColumn;
import com.intellij.database.dialects.hive.model.HiveView;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnType;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 Q2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003QRSB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J4\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u00020\u0016R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J\u001c\u0010\u001b\u001a\u00060\u001cR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0003H\u0014J,\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00132\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0!H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J1\u0010&\u001a\u0004\u0018\u0001H'\"\b\b\u0000\u0010'*\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H'0+H\u0002\u00a2\u0006\u0002\u0010,J$\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010.2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0016JH\u00104\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u000e\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u000207062\u000e\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u000209062\u0006\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u0019H\u0014J\u0018\u0010@\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J&\u0010A\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u00192\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00030C2\u0006\u0010D\u001a\u00020=H\u0014J\u0010\u0010E\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u0019H\u0014J\u0010\u0010F\u001a\u00020=2\u0006\u0010:\u001a\u00020\u0013H\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010\u00132\u0006\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020\fH\u0016J\u001e\u0010K\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00130CH\u0002J&\u0010M\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020\u00022\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00030CH\u0002J\u0010\u0010O\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u0019H\u0002J\u0010\u0010P\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/hive/model/HiveRoot;", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "genericIntrospector", "Lcom/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector;", "attachToDB", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "buildObject", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "type", "", "dbConnection", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever;", "schema", "forEachNotNullLine", "statement", "processor", "Lkotlin/Function1;", "getDdl", "name", "getMetadata", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "getStatement", "T", "Lcom/intellij/sql/psi/SqlStatement;", "sql", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Lcom/intellij/sql/psi/SqlStatement;", "init", "Lcom/intellij/database/model/basic/BasicModModel;", "model", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "introspectFunction", "funcFamily", "Lcom/intellij/database/model/families/ModNamingFamily;", "Lcom/intellij/database/dialects/hive/model/HiveFunctionBase;", "macroFamily", "Lcom/intellij/database/dialects/hive/model/HiveMacro;", "funcName", "qualifiedFuncName", "isBuiltin", "", "introspectNamespacesInTran", "tran", "introspectOneSchema", "introspectSchemasAuto", "schemas", "", "whole", "introspectTheServerObjects", "isSystemFunction", "joinRows", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "retrieveAndApplySchemas", "retrieveFunctions", "schemaNames", "retrieveFunctionsInner", "root", "retrieveRoles", "retrieveSchemasDetailedInfo", "Companion", "Factory", "HiveSchemaRetriever", "intellij.database.dialects.hive"})
@SourceDebugExtension(value={"SMAP\nHiveIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveIntrospector.kt\ncom/intellij/database/dialects/hive/introspector/HiveIntrospector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,508:1\n1#2:509\n1549#3:510\n1620#3,3:511\n1855#3,2:514\n*S KotlinDebug\n*F\n+ 1 HiveIntrospector.kt\ncom/intellij/database/dialects/hive/introspector/HiveIntrospector\n*L\n254#1:510\n254#1:511,3\n274#1:514,2\n*E\n"})
public final class HiveIntrospector
extends BaseSingleDatabaseIntrospector<HiveRoot, HiveSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JdbcIntrospector genericIntrospector;
    @NotNull
    private static final String FUNCTION_CLASS = "Function class:";
    @NotNull
    private static final Set<String> IGNORED_FUNCTIONS;
    @NotNull
    private static final Set<String> IGNORED_PROPERTIES;
    @NotNull
    private static final Map<String, Function4<HiveLikeTable, String, String, String, Unit>> viewProcessors;
    @NotNull
    private static final Map<String, Function4<HiveTable, String, String, String, Unit>> tableProcessors;

    public HiveIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.HIVE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"HIVE");
        super(context, nature, dbms, modelFactory);
        this.genericIntrospector = new JdbcIntrospector(context, JdbcIntrospector.Factory.ourNature, this.dbms, modelFactory);
    }

    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model2, @NotNull LocalDataSource dataSource2, @Nullable TreePattern introspectionScope) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        BasicModModel res2 = super.init(model2, dataSource2, introspectionScope);
        BasicModModel basicModModel = this.genericIntrospector.init(res2, dataSource2, introspectionScope);
        Intrinsics.checkNotNullExpressionValue((Object)basicModModel, (String)"init(...)");
        BasicModModel res22 = basicModModel;
        if (!Intrinsics.areEqual((Object)res2, (Object)res22)) {
            throw new AssertionError((Object)("Model is changed by delegate: " + res2.getClass().getSimpleName() + " -> " + res22.getClass().getSimpleName()));
        }
        return res2;
    }

    @Override
    public void attachToDB(@NotNull DatabaseConnectionCore connection2) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        super.attachToDB(connection2);
        this.genericIntrospector.attachToDB(connection2);
    }

    @Override
    public void retrieveAndApplySchemas() {
        block0: {
            this.genericIntrospector.introspectDatabaseSchemas(new BasicDatabase[0]);
            DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
            if (databaseConnectionCore == null) break block0;
            DatabaseConnectionCore it2 = databaseConnectionCore;
            boolean bl = false;
            this.retrieveSchemasDetailedInfo(it2);
        }
    }

    private final DatabaseMetaDataWrapper getMetadata(DatabaseConnectionCore dbConnection) {
        RemoteDatabaseMetaData metaData = dbConnection.getRemoteConnection().getMetaData();
        DatabaseMetaDataWrapper databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(dbConnection, metaData).withErrorSink(this.getErrorSink());
        Intrinsics.checkNotNullExpressionValue((Object)databaseMetaDataWrapper, (String)"withErrorSink(...)");
        return databaseMetaDataWrapper;
    }

    private final void retrieveSchemasDetailedInfo(DatabaseConnectionCore dbConnection) {
        this.inModel((Function1)new Function1<HiveRoot, Unit>(dbConnection, this){
            final /* synthetic */ DatabaseConnectionCore $dbConnection;
            final /* synthetic */ HiveIntrospector this$0;
            {
                this.$dbConnection = $dbConnection;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull HiveRoot root2) {
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                for (HiveSchema schema2 : root2.getSchemas()) {
                    SmartStatementFactoryService.Companion.getInstance().poweredBy(this.$dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute("describe schema extended `" + schema2.getName() + "`", StandardResultsProcessors.resultsTransformer((Function1)new Function1<RemoteResultSet, Unit>(schema2){
                        final /* synthetic */ HiveSchema $schema;
                        {
                            this.$schema = $schema;
                            super(1);
                        }

                        public final void invoke(@NotNull RemoteResultSet rs) {
                            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                            if (!rs.next()) {
                                return;
                            }
                            this.$schema.setComment(rs.getString(2));
                            this.$schema.setLocation(rs.getString(3));
                        }
                    }));
                    Intrinsics.checkNotNull((Object)schema2);
                    HiveIntrospector.access$buildObject(this.this$0, schema2, "schema", this.$dbConnection);
                }
            }
        });
    }

    private final void buildObject(BasicModElement obj2, String type2, DatabaseConnectionCore dbConnection) {
        String string = obj2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String ddl = this.getDdl(dbConnection, type2, string);
        SqlCreateStatement sqlCreateStatement = this.getStatement(ddl, SqlCreateStatement.class);
        if (sqlCreateStatement == null) {
            return;
        }
        SqlCreateStatement statement2 = sqlCreateStatement;
        this.getSqlHelper().getBuilder().build(obj2, (DasObject)statement2, this.getSqlHelper().getBuilderContext());
    }

    private final String getDdl(DatabaseConnectionCore dbConnection, String type2, String name2) {
        return SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute("show create " + type2 + " `" + name2 + "`", StandardResultsProcessors.resultsTransformer((Function1)new Function1<RemoteResultSet, String>(this){
            final /* synthetic */ HiveIntrospector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull RemoteResultSet resultSet) {
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                return HiveIntrospector.access$joinRows(this.this$0, resultSet);
            }
        })).rightOr((Object)null);
    }

    private final <T extends SqlStatement> T getStatement(String sql, Class<T> clazz) {
        if (sql == null) {
            return null;
        }
        try {
            return (T)((SqlStatement)this.getSqlHelper().statements(sql, clazz).first());
        }
        catch (Exception e2) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.log.error((Throwable)e2);
            }
            this.log.warn("Failed to parse sources", (Throwable)e2);
            return null;
        }
    }

    private final String joinRows(RemoteResultSet resultSet) {
        StringBuilder sb = new StringBuilder();
        while (resultSet.next()) {
            sb.append(resultSet.getString(1)).append("\n");
        }
        resultSet.close();
        if (((CharSequence)sb).length() == 0) {
            return null;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends HiveSchema> schemas2, boolean whole) {
        Collection<String> collection2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas2, (String)"schemas");
        for (HiveSchema hiveSchema : schemas2) {
            this.introspectOneSchema(tran, hiveSchema);
        }
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        if (databaseConnectionCore == null) {
            return;
        }
        DatabaseConnectionCore dbConnection = databaseConnectionCore;
        Iterable iterable = schemas2;
        DatabaseConnectionCore databaseConnectionCore2 = dbConnection;
        HiveIntrospector hiveIntrospector = this;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            HiveSchema hiveSchema = (HiveSchema)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            String string = it2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection2.add(string);
        }
        collection2 = (List)destination$iv$iv;
        hiveIntrospector.retrieveFunctions(databaseConnectionCore2, (List<String>)collection2);
    }

    private final void retrieveFunctions(DatabaseConnectionCore dbConnection, List<String> schemaNames2) {
        this.handleErrors("Introspecting functions", (Function0<Unit>)((Function0)new Function0<Unit>(this, schemaNames2, dbConnection){
            final /* synthetic */ HiveIntrospector this$0;
            final /* synthetic */ List<String> $schemaNames;
            final /* synthetic */ DatabaseConnectionCore $dbConnection;
            {
                this.this$0 = $receiver;
                this.$schemaNames = $schemaNames;
                this.$dbConnection = $dbConnection;
                super(0);
            }

            public final void invoke() {
                HiveIntrospector.access$inModel(this.this$0, (Function1)new Function1<HiveRoot, Unit>(this.$schemaNames, this.this$0, this.$dbConnection){
                    final /* synthetic */ List<String> $schemaNames;
                    final /* synthetic */ HiveIntrospector this$0;
                    final /* synthetic */ DatabaseConnectionCore $dbConnection;
                    {
                        this.$schemaNames = $schemaNames;
                        this.this$0 = $receiver;
                        this.$dbConnection = $dbConnection;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull HiveRoot root2) {
                        boolean bl;
                        HiveSchema schema2;
                        void $this$mapNotNullTo$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                        Iterable $this$mapNotNull$iv = this.$schemaNames;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            HiveSchema it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl2 = false;
                            String it2 = (String)element$iv$iv;
                            boolean bl3 = false;
                            if ((HiveSchema)root2.getSchemas().get(it2) == null) continue;
                            boolean bl4 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List schemas2 = (List)destination$iv$iv;
                        HiveIntrospector hiveIntrospector = this.this$0;
                        DatabaseConnectionCore databaseConnectionCore = this.$dbConnection;
                        boolean $i$f$modifyFamiliesAndCleanup = false;
                        Function1 it3 = retrieveFunctions$1$1$invoke$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
                        boolean bl5 = false;
                        ModNamingFamily<? extends HiveFunction> modNamingFamily = root2.getFunctions();
                        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getFunctions(...)");
                        it3.invoke(modNamingFamily);
                        ModNamingFamily<? extends HiveMacro> modNamingFamily2 = root2.getMacros();
                        Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getMacros(...)");
                        it3.invoke(modNamingFamily2);
                        Iterable $this$forEach$iv = schemas2;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            schema2 = (HiveSchema)element$iv;
                            bl = false;
                            ModNamingFamily<? extends HivePersistentFunction> modNamingFamily3 = schema2.getFunctions();
                            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getFunctions(...)");
                            it3.invoke(modNamingFamily3);
                        }
                        boolean bl6 = false;
                        HiveIntrospector.access$retrieveFunctionsInner(hiveIntrospector, databaseConnectionCore, root2, schemas2);
                        it = retrieveFunctions$1$1$invoke$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
                        bl5 = false;
                        ModNamingFamily<? extends HiveFunction> modNamingFamily4 = root2.getFunctions();
                        Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getFunctions(...)");
                        it.invoke(modNamingFamily4);
                        ModNamingFamily<? extends HiveMacro> modNamingFamily5 = root2.getMacros();
                        Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"getMacros(...)");
                        it.invoke(modNamingFamily5);
                        $this$forEach$iv = schemas2;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            schema2 = (HiveSchema)element$iv;
                            bl = false;
                            ModNamingFamily<? extends HivePersistentFunction> modNamingFamily6 = schema2.getFunctions();
                            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"getFunctions(...)");
                            it.invoke(modNamingFamily6);
                        }
                    }
                });
            }
        }));
    }

    private final void retrieveFunctionsInner(DatabaseConnectionCore dbConnection, HiveRoot root2, List<? extends HiveSchema> schemas2) {
        Map nameToSchema = new LinkedHashMap();
        Iterable $this$forEach$iv = schemas2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HiveSchema it2 = (HiveSchema)element$iv;
            boolean bl = false;
            Map map2 = nameToSchema;
            String string = it2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            map2.put(string, it2);
        }
        this.forEachNotNullLine(dbConnection, "show functions", (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Map<String, HiveSchema>)nameToSchema, this, dbConnection, root2){
            final /* synthetic */ Map<String, HiveSchema> $nameToSchema;
            final /* synthetic */ HiveIntrospector this$0;
            final /* synthetic */ DatabaseConnectionCore $dbConnection;
            final /* synthetic */ HiveRoot $root;
            {
                this.$nameToSchema = $nameToSchema;
                this.this$0 = $receiver;
                this.$dbConnection = $dbConnection;
                this.$root = $root;
                super(1);
            }

            public final void invoke(@NotNull String qualifiedFuncName) {
                Intrinsics.checkNotNullParameter((Object)qualifiedFuncName, (String)"qualifiedFuncName");
                if (HiveIntrospector.access$getIGNORED_FUNCTIONS$cp().contains(qualifiedFuncName)) {
                    return;
                }
                int dot = StringsKt.indexOf$default((CharSequence)qualifiedFuncName, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dot != -1) {
                    String string = qualifiedFuncName.substring(0, dot);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    HiveSchema hiveSchema = this.$nameToSchema.get(string);
                    if (hiveSchema == null) {
                        return;
                    }
                    HiveSchema schema2 = hiveSchema;
                    String string2 = qualifiedFuncName.substring(dot + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String funcName = string2;
                    ModNamingFamily<? extends HivePersistentFunction> modNamingFamily = schema2.getFunctions();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getFunctions(...)");
                    ModNamingFamily<? extends HiveMacro> modNamingFamily2 = this.$root.getMacros();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getMacros(...)");
                    HiveIntrospector.access$introspectFunction(this.this$0, this.$dbConnection, modNamingFamily, modNamingFamily2, funcName, qualifiedFuncName, false);
                } else {
                    HiveFunction function2;
                    boolean isBuiltin = HiveIntrospector.access$isSystemFunction(this.this$0, qualifiedFuncName);
                    if (isBuiltin && (function2 = (HiveFunction)this.$root.getFunctions().get(qualifiedFuncName)) != null) {
                        function2.setAutoCreated(true);
                        function2.resetSyncPending();
                        return;
                    }
                    ModNamingFamily<? extends HiveFunction> modNamingFamily = this.$root.getFunctions();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getFunctions(...)");
                    ModNamingFamily<? extends HiveMacro> modNamingFamily3 = this.$root.getMacros();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getMacros(...)");
                    HiveIntrospector.access$introspectFunction(this.this$0, this.$dbConnection, modNamingFamily, modNamingFamily3, qualifiedFuncName, qualifiedFuncName, isBuiltin);
                }
            }
        }));
    }

    private final boolean isSystemFunction(String funcName) {
        SqlLanguageDialect sqlLanguageDialect = this.getSqlHelper().getLanguage();
        Intrinsics.checkNotNull((Object)sqlLanguageDialect, (String)"null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialectEx");
        return ((SqlLanguageDialectEx)sqlLanguageDialect).getSupportedFunctions().contains(funcName);
    }

    private final void introspectFunction(DatabaseConnectionCore dbConnection, ModNamingFamily<? extends HiveFunctionBase> funcFamily, ModNamingFamily<? extends HiveMacro> macroFamily, String funcName, String qualifiedFuncName, boolean isBuiltin) {
        List description = new ArrayList();
        this.forEachNotNullLine(dbConnection, "describe function extended `" + qualifiedFuncName + "`", (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((List<String>)description){
            final /* synthetic */ List<String> $description;
            {
                this.$description = $description;
                super(1);
            }

            public final void invoke(@NotNull String it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                this.$description.add(it2);
            }
        }));
        if (description.size() < 3) {
            return;
        }
        String classNameLine = (String)description.get(description.size() - 2);
        if (!StringsKt.startsWith$default((String)classNameLine, (String)FUNCTION_CLASS, (boolean)false, (int)2, null)) {
            return;
        }
        String string = classNameLine.substring(15);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String className = string;
        if (StringsKt.endsWith$default((String)className, (String)"GenericUDFMacro", (boolean)false, (int)2, null)) {
            macroFamily.createOrGet(qualifiedFuncName);
            return;
        }
        HiveFunctionBase function2 = funcFamily.createOrGet(funcName);
        function2.setClassName(className);
        HiveFunction hiveFunction = function2 instanceof HiveFunction ? (HiveFunction)function2 : null;
        if (hiveFunction != null) {
            HiveFunction hiveFunction2;
            HiveFunction $this$introspectFunction_u24lambda_u243 = hiveFunction2 = hiveFunction;
            boolean bl = false;
            $this$introspectFunction_u24lambda_u243.setTemporary(StringsKt.endsWith$default((String)((String)description.get(description.size() - 1)), (String)"TEMPORARY", (boolean)false, (int)2, null));
            $this$introspectFunction_u24lambda_u243.setAutoCreated(isBuiltin);
        }
        function2.setComment(((Object)StringsKt.trim((CharSequence)((String)description.get(0)))).toString());
    }

    private final void forEachNotNullLine(DatabaseConnectionCore dbConnection, String statement2, Function1<? super String, Unit> processor2) {
        SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute(statement2, StandardResultsProcessors.resultsTransformer((Function1)new Function1<RemoteResultSet, Unit>(processor2){
            final /* synthetic */ Function1<String, Unit> $processor;
            {
                this.$processor = $processor;
                super(1);
            }

            public final void invoke(@NotNull RemoteResultSet rs) {
                Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                while (rs.next()) {
                    String string;
                    if (rs.getString(1) == null) continue;
                    Function1<String, Unit> function1 = this.$processor;
                    String it2 = string;
                    boolean bl = false;
                    function1.invoke((Object)it2);
                }
            }
        }));
    }

    private final void introspectOneSchema(DBTransaction tran, HiveSchema schema2) {
        this.handleErrors("Introspect schema " + schema2.getName(), (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, schema2){
            final /* synthetic */ HiveIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;
            final /* synthetic */ HiveSchema $schema;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                this.$schema = $schema;
                super(0);
            }

            public final void invoke() {
                HiveSchemaRetriever retriever = this.this$0.createSchemaRetriever(this.$tran, this.$schema);
                retriever.process();
            }
        }));
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveAndApplySchemas();
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<HiveRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull HiveRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        throw new UnsupportedOperationException();
    }

    @Override
    protected void introspectTheServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveRoles(tran);
    }

    private final void retrieveRoles(DBTransaction tran) {
        this.inModel((Function1)new Function1<HiveRoot, Unit>(this){
            final /* synthetic */ HiveIntrospector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull HiveRoot root2) {
                void $this$modifyAndCleanup_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
                ModFamily modFamily = root2.getRoles();
                HiveIntrospector hiveIntrospector = this.this$0;
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModNamingFamily it2 = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl = false;
                DatabaseConnectionCore databaseConnectionCore = HiveIntrospector.access$getDbConnection(hiveIntrospector);
                if (databaseConnectionCore != null) {
                    DatabaseConnectionCore dbConnection = databaseConnectionCore;
                    SmartStatementFactory statements2 = SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection);
                    List<String> roles = statements2.simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute("show roles", StandardResultsProcessors.listOfStrings(1)).rightOr(CollectionsKt.emptyList());
                    for (String role : roles) {
                        root2.getRoles().createOrGet(role);
                    }
                    statements2.simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute("show principals admin", StandardResultsProcessors.resultsTransformer((Function1)new Function1<RemoteResultSet, Unit>(root2){
                        final /* synthetic */ HiveRoot $root;
                        {
                            this.$root = $root;
                            super(1);
                        }

                        public final void invoke(@NotNull RemoteResultSet resultSet) {
                            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                            while (resultSet.next()) {
                                HiveRole hiveRole;
                                String userName = resultSet.getString(1);
                                String principalType = resultSet.getString(2);
                                if (!Intrinsics.areEqual((Object)principalType, (Object)"USER")) continue;
                                HiveRole $this$invoke_u24lambda_u240 = hiveRole = this.$root.getRoles().createOrGet(userName);
                                boolean bl = false;
                                $this$invoke_u24lambda_u240.setCanLogin(true);
                                $this$invoke_u24lambda_u240.setSuperRole(true);
                            }
                        }
                    }));
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        });
    }

    @NotNull
    protected HiveSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull HiveSchema schema2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        return new HiveSchemaRetriever(transaction, schema2);
    }

    public static final /* synthetic */ void access$buildObject(HiveIntrospector $this, BasicModElement obj2, String type2, DatabaseConnectionCore dbConnection) {
        $this.buildObject(obj2, type2, dbConnection);
    }

    public static final /* synthetic */ String access$joinRows(HiveIntrospector $this, RemoteResultSet resultSet) {
        return $this.joinRows(resultSet);
    }

    public static final /* synthetic */ void access$inModel(HiveIntrospector $this, Function1 modifier) {
        $this.inModel(modifier);
    }

    public static final /* synthetic */ void access$retrieveFunctionsInner(HiveIntrospector $this, DatabaseConnectionCore dbConnection, HiveRoot root2, List schemas2) {
        $this.retrieveFunctionsInner(dbConnection, root2, schemas2);
    }

    public static final /* synthetic */ Set access$getIGNORED_FUNCTIONS$cp() {
        return IGNORED_FUNCTIONS;
    }

    public static final /* synthetic */ void access$introspectFunction(HiveIntrospector $this, DatabaseConnectionCore dbConnection, ModNamingFamily funcFamily, ModNamingFamily macroFamily, String funcName, String qualifiedFuncName, boolean isBuiltin) {
        $this.introspectFunction(dbConnection, funcFamily, macroFamily, funcName, qualifiedFuncName, isBuiltin);
    }

    public static final /* synthetic */ boolean access$isSystemFunction(HiveIntrospector $this, String funcName) {
        return $this.isSystemFunction(funcName);
    }

    public static final /* synthetic */ JdbcIntrospector access$getGenericIntrospector$p(HiveIntrospector $this) {
        return $this.genericIntrospector;
    }

    static {
        Object[] objectArray = new String[]{"!", "!=", "$sum0", "%", "&", "*", "+", "-", "/", "<", "<=", "<=>", "<>", "=", "==", ">", ">=", "^", "and", "between", "case", "div", "in", "like", "or", "regexp", "rlike", "when", "|", "~"};
        IGNORED_FUNCTIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"transient_lastDdlTime", "last_modified_by", "last_modified_time", "numFiles", "numRows", "totalSize", "EXTERNAL", "comment", "rawDataSize", "numPartitions", "COLUMN_STATS_ACCURATE"};
        IGNORED_PROPERTIES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Table Parameters:", (Object)((Object)Companion.viewProcessors.1.INSTANCE)), TuplesKt.to((Object)"View Original Text:", (Object)HiveIntrospector.Companion.snd(Companion.viewProcessors.2.INSTANCE)), TuplesKt.to((Object)"View Expanded Text:", (Object)HiveIntrospector.Companion.snd(Companion.viewProcessors.3.INSTANCE)), TuplesKt.to((Object)"View Rewrite Enabled:", (Object)HiveIntrospector.Companion.noop())};
        viewProcessors = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Location:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.1.INSTANCE)), TuplesKt.to((Object)"Table Type:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.2.INSTANCE)), TuplesKt.to((Object)"Table Parameters:", (Object)((Object)Companion.tableProcessors.3.INSTANCE)), TuplesKt.to((Object)"# Partition Information", (Object)((Object)Companion.tableProcessors.4.INSTANCE)), TuplesKt.to((Object)"SerDe Library:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.5.INSTANCE)), TuplesKt.to((Object)"InputFormat:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.6.INSTANCE)), TuplesKt.to((Object)"OutputFormat:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.7.INSTANCE)), TuplesKt.to((Object)"Compressed:", (Object)HiveIntrospector.Companion.noop()), TuplesKt.to((Object)"Num Buckets:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.8.INSTANCE)), TuplesKt.to((Object)"Stored As SubDirectories:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.9.INSTANCE)), TuplesKt.to((Object)"Skewed Columns:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.10.INSTANCE)), TuplesKt.to((Object)"Skewed Values:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.11.INSTANCE)), TuplesKt.to((Object)"Bucket Columns:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.12.INSTANCE)), TuplesKt.to((Object)"Sort Columns:", (Object)HiveIntrospector.Companion.snd(Companion.tableProcessors.13.INSTANCE)), TuplesKt.to((Object)"Storage Desc Params:", (Object)((Object)Companion.tableProcessors.14.INSTANCE)), TuplesKt.to((Object)"# Constraints", (Object)HiveIntrospector.Companion.noop()), TuplesKt.to((Object)"# Foreign Keys", (Object)new Function4<HiveTable, String, String, String, Unit>(){
            @Nullable
            private HiveForeignKey currentConstraint;
            @NotNull
            private final Map<String, Integer> columnsPos;
            @NotNull
            private final Map<String, Integer> refColumnsPos;
            {
                this.columnsPos = new LinkedHashMap<K, V>();
                this.refColumnsPos = new LinkedHashMap<K, V>();
            }

            @Nullable
            public final HiveForeignKey getCurrentConstraint() {
                return this.currentConstraint;
            }

            public final void setCurrentConstraint(@Nullable HiveForeignKey hiveForeignKey) {
                this.currentConstraint = hiveForeignKey;
            }

            @NotNull
            public final Map<String, Integer> getColumnsPos() {
                return this.columnsPos;
            }

            @NotNull
            public final Map<String, Integer> getRefColumnsPos() {
                return this.refColumnsPos;
            }

            /*
             * Unable to fully structure code
             */
            public void invoke(@NotNull HiveTable t, @NotNull String key, @NotNull String v1, @Nullable String position) {
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
                        if (!Intrinsics.areEqual((Object)key, (Object)"Constraint Name:")) break block5;
                        this.currentConstraint = (HiveForeignKey)t.getForeignKeys().createOrGet(v1);
                        this.columnsPos.clear();
                        this.refColumnsPos.clear();
                        break block6;
                    }
                    if (!StringsKt.startsWith$default((String)key, (String)"Parent Column Name:", (boolean)false, (int)2, null)) break block6;
                    v0 = this.currentConstraint;
                    if (v0 == null) {
                        return;
                    }
                    fKey = v0;
                    v1 = v1.substring(12);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                    colName = v1;
                    v2 = key.substring(19);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                    refCol = v2;
                    dot1 = StringsKt.indexOf$default((CharSequence)refCol, (String)".", (int)0, (boolean)false, (int)6, null);
                    dot2 = StringsKt.lastIndexOf$default((CharSequence)refCol, (String)".", (int)0, (boolean)false, (int)6, null);
                    v3 = refCol.substring(dot2 + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                    refColName = v3;
                    v4 = position;
                    if (v4 == null) ** GOTO lbl-1000
                    v5 = v4.substring(13);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
                    v4 = v5;
                    if (v5 != null) {
                        v6 = Integer.parseInt(v4) + -1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = fKey.getColNames().size();
                    }
                    pos = v6;
                    var13_12 = pos;
                    this.columnsPos.put(colName, var13_12);
                    var13_12 = pos;
                    this.refColumnsPos.put(refColName, var13_12);
                    $this$invoke_u24lambda_u244 = fKey;
                    $i$a$-with-HiveIntrospector$Companion$tableProcessors$15$invoke$1 = false;
                    v7 = refCol.substring(0, dot1);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"substring(...)");
                    v8 = refCol.substring(dot1 + 1, dot2);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"substring(...)");
                    $this$invoke_u24lambda_u244.setRefTableRef(BasicParentReference.create(v7, BasicNameReference.create(v8)));
                    v9 = $this$invoke_u24lambda_u244.getRefColNames();
                    Intrinsics.checkNotNullExpressionValue(v9, (String)"getRefColNames(...)");
                    var15_16 = var14_15 = CollectionsKt.toMutableList((Collection)v9);
                    var16_17 = $this$invoke_u24lambda_u244;
                    $i$a$-apply-HiveIntrospector$Companion$tableProcessors$15$invoke$1$1 = false;
                    $this$invoke_u24lambda_u244_u24lambda_u241.add(refColName);
                    $this$sortBy$iv = $this$invoke_u24lambda_u244_u24lambda_u241;
                    $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(this){
                            final /* synthetic */ Companion.tableProcessors.15 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final int compare(T a, T b2) {
                                String it2 = (String)a;
                                boolean bl = false;
                                Integer n = this.this$0.getRefColumnsPos().get(it2);
                                Intrinsics.checkNotNull((Object)n);
                                it2 = (String)b2;
                                Comparable comparable = n;
                                bl = false;
                                Integer n3 = this.this$0.getRefColumnsPos().get(it2);
                                Intrinsics.checkNotNull((Object)n3);
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
                            }
                        });
                    }
                    var16_17.setRefColNames(var14_15);
                    v10 = $this$invoke_u24lambda_u244.getColNames();
                    Intrinsics.checkNotNullExpressionValue(v10, (String)"getColNames(...)");
                    $this$invoke_u24lambda_u244_u24lambda_u241 = var14_15 = CollectionsKt.toMutableList((Collection)v10);
                    var16_17 = $this$invoke_u24lambda_u244;
                    $i$a$-apply-HiveIntrospector$Companion$tableProcessors$15$invoke$1$2 = false;
                    $this$invoke_u24lambda_u244_u24lambda_u243.add(colName);
                    $this$sortBy$iv = $this$invoke_u24lambda_u244_u24lambda_u243;
                    $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(this){
                            final /* synthetic */ Companion.tableProcessors.15 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final int compare(T a, T b2) {
                                String it2 = (String)a;
                                boolean bl = false;
                                Integer n = this.this$0.getColumnsPos().get(it2);
                                Intrinsics.checkNotNull((Object)n);
                                it2 = (String)b2;
                                Comparable comparable = n;
                                bl = false;
                                Integer n3 = this.this$0.getColumnsPos().get(it2);
                                Intrinsics.checkNotNull((Object)n3);
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n3);
                            }
                        });
                    }
                    var16_17.setColNames(var14_15);
                }
            }
        })};
        tableProcessors = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0012\u001a'\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\"\b\b\u0000\u0010\u0013*\u00020\u0011H\u0002JV\u0010\u0014\u001a'\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\"\b\b\u0000\u0010\u0013*\u00020\u00112\u001d\u0010\u0015\u001a\u0019\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\u0016\u00a2\u0006\u0002\b\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR?\u0010\n\u001a3\u0012\u0004\u0012\u00020\u0004\u0012)\u0012'\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u0010\u001a3\u0012\u0004\u0012\u00020\u0004\u0012)\u0012'\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Companion;", "", "()V", "FUNCTION_CLASS", "", "IGNORED_FUNCTIONS", "", "IGNORED_PROPERTIES", "getIGNORED_PROPERTIES", "()Ljava/util/Set;", "tableProcessors", "", "Lkotlin/Function4;", "Lcom/intellij/database/dialects/hive/model/HiveTable;", "", "Lkotlin/ExtensionFunctionType;", "viewProcessors", "Lcom/intellij/database/dialects/hive/model/HiveLikeTable;", "noop", "T", "snd", "p", "Lkotlin/Function2;", "intellij.database.dialects.hive"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getIGNORED_PROPERTIES() {
            return IGNORED_PROPERTIES;
        }

        private final <T extends HiveLikeTable> Function4<T, String, String, String, Unit> snd(Function2<? super T, ? super String, Unit> p2) {
            return new Function4<T, String, String, String, Unit>(p2){
                final /* synthetic */ Function2<T, String, Unit> $p;
                {
                    this.$p = $p;
                    super(4);
                }

                public final void invoke(@NotNull T $this$null, @NotNull String string, @NotNull String v2, @Nullable String string2) {
                    Intrinsics.checkNotNullParameter($this$null, (String)"$this$null");
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
                    this.$p.invoke($this$null, (Object)v2);
                }
            };
        }

        private final <T extends HiveLikeTable> Function4<T, String, String, String, Unit> noop() {
            return noop.1.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.hive"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new HiveIntrospector(context, modelFactory);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.hive"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J`\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\u000e27\u0010\u0013\u001a3\u0012\u0004\u0012\u00020\u0015\u0012)\u0012'\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\r0\u0016\u00a2\u0006\u0002\b\u00170\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/hive/model/HiveRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/hive/model/HiveSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "parseDescription", "", "T", "Lcom/intellij/database/dialects/hive/model/HiveLikeTable;", "dbConnection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "table", "processors", "", "", "Lkotlin/Function4;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dialects/hive/model/HiveLikeTable;Ljava/util/Map;)V", "process", "retrieveDetailedInfo", "retrieveIndices", "retrieveJdbcMetadata", "retrieveTablesDetailedInfo", "retrieveViewsDetailedInfo", "intellij.database.dialects.hive"})
    @SourceDebugExtension(value={"SMAP\nHiveIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveIntrospector.kt\ncom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,508:1\n1549#2:509\n1620#2,3:510\n1549#2:532\n1620#2,3:533\n1855#2,2:548\n1855#2,2:550\n221#3,3:513\n224#3:518\n199#3,12:519\n225#3:531\n221#3,3:536\n224#3:541\n199#3,6:542\n206#3,5:552\n225#3:557\n37#4,2:516\n37#4,2:539\n*S KotlinDebug\n*F\n+ 1 HiveIntrospector.kt\ncom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever\n*L\n429#1:509\n429#1:510,3\n453#1:532\n453#1:533,3\n459#1:548,2\n460#1:550,2\n429#1:513,3\n429#1:518\n429#1:519,12\n429#1:531\n453#1:536,3\n453#1:541\n453#1:542,6\n453#1:552,5\n453#1:557\n429#1:516,2\n453#1:539,2\n*E\n"})
    protected final class HiveSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<HiveSchema> {
        public HiveSchemaRetriever(@NotNull DBTransaction transaction, HiveSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            super((BaseNativeIntrospector)HiveIntrospector.this, transaction, (BasicModSchema)schema2);
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull HiveSchema schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
            return false;
        }

        @Override
        public void process() {
            DatabaseConnectionCore databaseConnectionCore = HiveIntrospector.this.getDbConnection();
            if (databaseConnectionCore == null) {
                return;
            }
            DatabaseConnectionCore dbConnection = databaseConnectionCore;
            this.retrieveJdbcMetadata(dbConnection);
            this.retrieveDetailedInfo(dbConnection);
        }

        private final void retrieveJdbcMetadata(DatabaseConnectionCore dbConnection) {
            String string = ((HiveSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            HiveIntrospector.this.reportIntrospectingSchemaUsingJdbc(string);
            DatabaseMetaDataWrapper metadata = HiveIntrospector.this.getMetadata(dbConnection);
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(HiveIntrospector.this, metadata){
                final /* synthetic */ HiveIntrospector this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metadata;
                {
                    this.this$0 = $receiver;
                    this.$metadata = $metadata;
                    super(1);
                }

                public final void invoke(@NotNull HiveSchema it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    HiveIntrospector.access$getGenericIntrospector$p(this.this$0).introspectTablesInSchema(this.$metadata, it2);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(HiveIntrospector.this, metadata){
                final /* synthetic */ HiveIntrospector this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metadata;
                {
                    this.this$0 = $receiver;
                    this.$metadata = $metadata;
                    super(1);
                }

                public final void invoke(@NotNull HiveSchema it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    HiveIntrospector.access$getGenericIntrospector$p(this.this$0).introspectColumnsInSchema(this.$metadata, it2);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(HiveIntrospector.this, metadata){
                final /* synthetic */ HiveIntrospector this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metadata;
                {
                    this.this$0 = $receiver;
                    this.$metadata = $metadata;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull HiveSchema it2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    ModNamingFamily<? extends HiveTable> modNamingFamily = it2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                    Iterable iterable = modNamingFamily;
                    HiveIntrospector hiveIntrospector = this.this$0;
                    DatabaseMetaDataWrapper databaseMetaDataWrapper = this.$metadata;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        HiveTable t = (HiveTable)element$iv;
                        boolean bl = false;
                        HiveIntrospector.access$getGenericIntrospector$p(hiveIntrospector).introspectTableKeys(databaseMetaDataWrapper, t, true);
                    }
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(HiveIntrospector.this, metadata){
                final /* synthetic */ HiveIntrospector this$0;
                final /* synthetic */ DatabaseMetaDataWrapper $metadata;
                {
                    this.this$0 = $receiver;
                    this.$metadata = $metadata;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull HiveSchema it2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    ModNamingFamily<? extends HiveTable> modNamingFamily = it2.getTables();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                    Iterable iterable = modNamingFamily;
                    HiveIntrospector hiveIntrospector = this.this$0;
                    DatabaseMetaDataWrapper databaseMetaDataWrapper = this.$metadata;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        HiveTable t = (HiveTable)element$iv;
                        boolean bl = false;
                        HiveIntrospector.access$getGenericIntrospector$p(hiveIntrospector).introspectTableForeignKeys(databaseMetaDataWrapper, t);
                    }
                }
            });
        }

        private final void retrieveDetailedInfo(DatabaseConnectionCore dbConnection) {
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, dbConnection){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseConnectionCore $dbConnection;
                {
                    this.this$0 = $receiver;
                    this.$dbConnection = $dbConnection;
                    super(1);
                }

                public final void invoke(@NotNull HiveSchema it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    HiveSchemaRetriever.access$retrieveTablesDetailedInfo(this.this$0, it2, this.$dbConnection);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, dbConnection){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseConnectionCore $dbConnection;
                {
                    this.this$0 = $receiver;
                    this.$dbConnection = $dbConnection;
                    super(1);
                }

                public final void invoke(@NotNull HiveSchema it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    HiveSchemaRetriever.access$retrieveViewsDetailedInfo(this.this$0, it2, this.$dbConnection);
                }
            });
            this.inSchema((Function1)new Function1<HiveSchema, Unit>(this, dbConnection){
                final /* synthetic */ HiveSchemaRetriever this$0;
                final /* synthetic */ DatabaseConnectionCore $dbConnection;
                {
                    this.this$0 = $receiver;
                    this.$dbConnection = $dbConnection;
                    super(1);
                }

                public final void invoke(@NotNull HiveSchema it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    HiveSchemaRetriever.access$retrieveIndices(this.this$0, it2, this.$dbConnection);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void retrieveIndices(HiveSchema schema2, DatabaseConnectionCore dbConnection) {
            SimpleSmartStatement stmt2 = SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM));
            String currentSchema = null;
            try {
                currentSchema = dbConnection.getRemoteConnection().getSchema();
            }
            catch (Throwable t) {
                this.log.warn(t);
            }
            try {
                void families$iv;
                void $this$mapTo$iv$iv;
                stmt2.execute("use `" + schema2.getName() + "`", retrieveIndices.1.INSTANCE);
                ModNamingFamily<? extends HiveTable> modNamingFamily = schema2.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                Iterable $this$map$iv = modNamingFamily;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    HiveTable hiveTable = (HiveTable)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it2.getIndices());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean inc$iv = true;
                boolean $i$f$modifyFamiliesAndCleanup = false;
                void $this$toTypedArray$iv$iv = families$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
                ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                for (ModFamily f$iv$iv : families$iv$iv) {
                    f$iv$iv.markChildrenAsSyncPending();
                }
                boolean bl = false;
                for (HiveTable hiveTable : schema2.getTables()) {
                    stmt2.execute("show indexes on `" + hiveTable.getName() + "`", StandardResultsProcessors.resultsTransformer((Function1)new Function1<RemoteResultSet, Unit>(hiveTable){
                        final /* synthetic */ HiveTable $table;
                        {
                            this.$table = $table;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull RemoteResultSet rs) {
                            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                            while (rs.next()) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                String string = rs.getString(1);
                                String name2 = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                                CharSequence charSequence = name2;
                                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                                    return;
                                }
                                HiveIndex index2 = (HiveIndex)this.$table.getIndices().createOrGet(name2);
                                String string2 = rs.getString(3);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                                Object object = new String[]{", "};
                                object = StringsKt.split$default((CharSequence)string2, (String[])object, (boolean)false, (int)0, (int)6, null);
                                HiveIndex hiveIndex = index2;
                                boolean $i$f$map = false;
                                void var6_6 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it2;
                                    String string3 = (String)item$iv$iv;
                                    Collection collection2 = destination$iv$iv;
                                    boolean bl = false;
                                    collection2.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it2))).toString());
                                }
                                hiveIndex.setColNames((List)destination$iv$iv);
                                String string4 = rs.getString(4);
                                index2.setIndexTableRef(BasicNameReference.create(string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null));
                                String string5 = rs.getString(5);
                                index2.setType(string5 != null ? ((Object)StringsKt.trim((CharSequence)string5)).toString() : null);
                                String string6 = rs.getString(6);
                                index2.setComment(string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null);
                            }
                        }
                    }));
                }
                for (ModFamily f$iv$iv : families$iv$iv) {
                    f$iv$iv.removeSyncPendingChildren();
                    f$iv$iv.sort();
                }
            }
            finally {
                if (currentSchema != null) {
                    stmt2.execute("use `" + currentSchema + "`", retrieveIndices.4.INSTANCE);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTablesDetailedInfo(HiveSchema schema2, DatabaseConnectionCore dbConnection) {
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            HiveIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends HiveTable> modNamingFamily = schema2.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                HiveTable hiveTable = (HiveTable)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it2.getForeignKeys());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = HiveIntrospector.this;
            boolean inc$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            void $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            for (HiveTable hiveTable : schema2.getTables()) {
                ProgressIndicator progressIndicator = ((BaseIntrospector)object).getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                hiveTable.setSerdeProperties(CollectionsKt.emptyList());
                hiveTable.setProperties(CollectionsKt.emptyList());
                PositioningNamingFamily positioningNamingFamily = hiveTable.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
                Iterable $this$forEach$iv = positioningNamingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HiveTableColumn it3 = (HiveTableColumn)element$iv;
                    boolean bl2 = false;
                    it3.setType(HiveTableColumnType.REGULAR);
                }
                PositioningNamingFamily positioningNamingFamily2 = hiveTable.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily2, (String)"getColumns(...)");
                $this$forEach$iv = positioningNamingFamily2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HiveTableColumn it2 = (HiveTableColumn)element$iv;
                    boolean bl3 = false;
                    it2.setSorting(HiveTableColumnSortingOrder.NONE);
                }
                hiveTable.setSkewedByColumns(CollectionsKt.emptyList());
                hiveTable.setStoredAsDirectories(false);
                hiveTable.setTemporary(true);
                this.parseDescription(dbConnection, (HiveLikeTable)hiveTable, tableProcessors);
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final void retrieveViewsDetailedInfo(HiveSchema schema2, DatabaseConnectionCore dbConnection) {
            ObjectKind objectKind = ObjectKind.VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"VIEW");
            HiveIntrospector.this.reportRetrieving(objectKind);
            for (HiveView hiveView : schema2.getViews()) {
                ProgressIndicator progressIndicator = HiveIntrospector.this.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                hiveView.setProperties(CollectionsKt.emptyList());
                this.parseDescription(dbConnection, (HiveLikeTable)hiveView, viewProcessors);
            }
            for (HiveMatView hiveMatView : schema2.getMatViews()) {
                ProgressIndicator progressIndicator = HiveIntrospector.this.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                hiveMatView.setProperties(CollectionsKt.emptyList());
                this.parseDescription(dbConnection, (HiveLikeTable)hiveMatView, viewProcessors);
            }
        }

        private final <T extends HiveLikeTable> void parseDescription(DatabaseConnectionCore dbConnection, T table, Map<String, ? extends Function4<? super T, ? super String, ? super String, ? super String, Unit>> processors) {
            Ref.ObjectRef processor2 = new Ref.ObjectRef();
            SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute("describe formatted `" + table.getName() + "`", StandardResultsProcessors.resultsTransformer((Function1)new Function1<RemoteResultSet, Unit>(processors, processor2, table){
                final /* synthetic */ Map<String, Function4<T, String, String, String, Unit>> $processors;
                final /* synthetic */ Ref.ObjectRef<Function4<T, String, String, String, Unit>> $processor;
                final /* synthetic */ T $table;
                {
                    this.$processors = $processors;
                    this.$processor = $processor;
                    this.$table = $table;
                    super(1);
                }

                public final void invoke(@NotNull RemoteResultSet rs) {
                    Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                    while (rs.next()) {
                        String string;
                        Function4 p2;
                        String string2 = rs.getString(1);
                        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) continue;
                        String headerOrKey = string2;
                        Function4<T, String, String, String, Unit> newProcessor = this.$processors.get(headerOrKey);
                        if (newProcessor != null) {
                            this.$processor.element = newProcessor;
                        }
                        if ((p2 = (Function4)this.$processor.element) == null || (string = rs.getString(2)) == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) continue;
                        String v2 = string;
                        String string3 = rs.getString(3);
                        String v3 = string3 != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null;
                        p2.invoke(this.$table, (Object)headerOrKey, (Object)v2, (Object)v3);
                    }
                }
            }));
        }

        public static final /* synthetic */ void access$retrieveTablesDetailedInfo(HiveSchemaRetriever $this, HiveSchema schema2, DatabaseConnectionCore dbConnection) {
            $this.retrieveTablesDetailedInfo(schema2, dbConnection);
        }

        public static final /* synthetic */ void access$retrieveViewsDetailedInfo(HiveSchemaRetriever $this, HiveSchema schema2, DatabaseConnectionCore dbConnection) {
            $this.retrieveViewsDetailedInfo(schema2, dbConnection);
        }

        public static final /* synthetic */ void access$retrieveIndices(HiveSchemaRetriever $this, HiveSchema schema2, DatabaseConnectionCore dbConnection) {
            $this.retrieveIndices(schema2, dbConnection);
        }
    }
}

