/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.derby;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.Placeholder;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0014J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u001c\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000b2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0002JP\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0012\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\u0006H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/derby/DerbyPredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "supportsInOperator", "", "getSupportsInOperator", "()Z", "typeCanCastToText", "", "", "equalsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "quote", "version", "Lcom/intellij/database/util/Version;", "alias", "isBitDataType", "columnRef", "typeName", "suffix", "likePredicate", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "canCastToText", "inUpdate", "intellij.database.dialects.derby"})
@SourceDebugExtension(value={"SMAP\nDerbyPredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DerbyPredicatesHelper.kt\ncom/intellij/database/dialects/derby/DerbyPredicatesHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class DerbyPredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<String> typeCanCastToText;

    public DerbyPredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        Object[] objectArray = new String[]{"time", "date", "timestamp", "clob"};
        this.typeCanCastToText = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public boolean getSupportsInOperator() {
        return true;
    }

    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer equalsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value2, @NotNull ComparePredicateOperation op, boolean quote, @Nullable Version version, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return this.isBitDataType(column2) ? null : super.equalsPredicate(column2, value2, op, quote, version, alias);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer likePredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value, @Nullable Domain domain, @NotNull LikePredicateOperation op, boolean canCastToText, @Nullable String alias, @Nullable Version version, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (this.isBitDataType(columnRef)) {
            return null;
        }
        if (!(value instanceof StringPredicateValue) && !(value instanceof Placeholder)) {
            return null;
        }
        v0 = domain;
        v1 = v0 != null ? v0.supports(OperationKt.LIKE_OPERATION) : (typeSupportsOperation = false);
        if (!canCastToText) ** GOTO lbl-1000
        v2 = domain;
        if (v2 != null ? v2.supports(OperationKt.EQUALS_TO_NUMBER_OPERATION) : false) ** GOTO lbl-1000
        v3 = columnRef.getTypeName();
        if (v3 != null) {
            it = v3;
            $i$a$-let-DerbyPredicatesHelper$likePredicate$canCast$1 = false;
            v4 = this.typeCanCastToText.contains(StringUtil.toLowerCase((String)it));
        } else {
            v4 = false;
        }
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 3 sources

        {
            v5 = canCast = false;
        }
        if (!canCast && !typeSupportsOperation) {
            return null;
        }
        v6 = PredicatesUtilKt.getLikeKeyword(op.getMatchCase(), op.isNotLike(), this.getDbms(), version, inUpdate);
        if (v6 == null) {
            return null;
        }
        likeWord = v6;
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value, op, (Function1<? super DdlBuilder, Unit>)((Function1)new Function1<DdlBuilder, Unit>(typeSupportsOperation, alias, columnRef, likeWord, value, this, op){
            final /* synthetic */ boolean $typeSupportsOperation;
            final /* synthetic */ String $alias;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ DerbyPredicatesHelper this$0;
            final /* synthetic */ LikePredicateOperation $op;
            {
                this.$typeSupportsOperation = $typeSupportsOperation;
                this.$alias = $alias;
                this.$columnRef = $columnRef;
                this.$likeWord = $likeWord;
                this.$value = $value;
                this.this$0 = $receiver;
                this.$op = $op;
                super(1);
            }

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (!this.$typeSupportsOperation) {
                    DdlBuilder ddlBuilder = builder.keyword("CAST").symbol("(");
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"symbol(...)");
                    PredicatesUtilKt.identifier(ddlBuilder, this.$alias, this.$columnRef).space().keyword("AS").space().type("VARCHAR(100)").symbol(")");
                } else {
                    PredicatesUtilKt.identifier(builder, this.$alias, this.$columnRef);
                }
                DdlBuilder ddlBuilder = builder.space().keyword(this.$likeWord).space();
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
                PredicatesUtilKt.value(ddlBuilder, this.$value, this.$columnRef, this.this$0.getDbms(), this.$op.getLikeType().getDecorator());
            }
        }));
    }

    private final boolean isBitDataType(ColumnRef columnRef) {
        boolean bl;
        DasColumn dasColumn = PredicatesUtilKt.toDasColumn(columnRef);
        if (dasColumn != null) {
            DasType dasType = dasColumn.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasType dasType2 = dasType;
            DataType dataType = dasType2.toDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
            DataType dataType2 = dataType;
            bl = this.isBitDataType(DasTypeUtilsKt.getTypeName(dasType2), dataType2.suffix);
        } else if (columnRef instanceof ConsumerColumnRef) {
            String string = ((ConsumerColumnRef)columnRef).getCol().getTypeName();
            if (string == null) {
                string = "";
            }
            bl = DerbyPredicatesHelper.isBitDataType$default(this, string, null, 2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isBitDataType(String typeName, String suffix2) {
        return StringUtil.equalsIgnoreCase((CharSequence)suffix2, (CharSequence)"FOR BIT DATA") || StringUtil.endsWithIgnoreCase((String)typeName, (String)"FOR BIT DATA");
    }

    static /* synthetic */ boolean isBitDataType$default(DerbyPredicatesHelper derbyPredicatesHelper, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return derbyPredicatesHelper.isBitDataType(string, string2);
    }
}

