/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.model;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.db2.model.Db2Index;
import com.intellij.database.dialects.db2.model.Db2IndexExtension;
import com.intellij.database.dialects.db2.model.Db2IndexExtensionArgument;
import com.intellij.database.dialects.db2.model.Db2Table;
import com.intellij.database.dialects.db2.model.Db2TableColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0014J(\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/db2/model/Db2DescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeIndexExtension", "", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/dialects/db2/model/Db2IndexExtension;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeTable", "Lcom/intellij/database/dialects/db2/model/Db2Table;", "describeTableColumn", "Lcom/intellij/database/dialects/db2/model/Db2TableColumn;", "shouldAutoDescribe", "", "property", "Lcom/intellij/database/model/meta/BasicMetaField;", "updatePresentation", "Lcom/intellij/database/model/DasObject;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "intellij.database.dialects.db2"})
public final class Db2DescriptionService
extends DescriptionService {
    @Override
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o2, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (o2 instanceof Db2IndexExtension) {
            this.describeIndexExtension(project, (Db2IndexExtension)o2, presentation);
        } else {
            super.updatePresentation(project, o2, viewOptions, presentation);
        }
    }

    @Override
    @NotNull
    public String content(@NotNull BasicElement e2, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e2;
        return basicElement instanceof Db2Table ? this.describeTable((Db2Table)e2, context) : (basicElement instanceof Db2TableColumn ? this.describeTableColumn((Db2TableColumn)e2, context) : super.content(e2, context));
    }

    @Override
    protected boolean shouldAutoDescribe(@NotNull BasicMetaField<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return Intrinsics.areEqual((Object)property.getId(), Db2Index.INDEX_SCHEMA_REF) || Intrinsics.areEqual((Object)property.getId(), Db2Index.COL_VIEW_REF) || super.shouldAutoDescribe(property);
    }

    private final String describeTable(Db2Table o2, DescriptionService.Context context) {
        Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicTable");
        Object res2 = this.describeTable((BasicTable)o2, context);
        ((Collection)context.getDescribed()).add(Db2Table.CLUSTERING_INDEX_NAMES);
        List<String> list = o2.getClusteringIndexNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getClusteringIndexNames(...)");
        List<String> ci = list;
        if (!((Collection)ci).isEmpty()) {
            res2 = (String)res2 + " clustering indices (" + CollectionsKt.joinToString$default((Iterable)ci, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this, o2, context){
                final /* synthetic */ Db2DescriptionService this$0;
                final /* synthetic */ Db2Table $o;
                final /* synthetic */ DescriptionService.Context $context;
                {
                    this.this$0 = $receiver;
                    this.$o = $o;
                    this.$context = $context;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(String it2) {
                    String string = Db2DescriptionService.access$objectName(this.this$0, it2, (BasicElement)this.$o.getIndices().get(it2), this.$context);
                    return string != null ? (CharSequence)string : (CharSequence)"";
                }
            }), (int)31, null) + ")";
        }
        return res2;
    }

    private final String describeTableColumn(Db2TableColumn o2, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(Db2TableColumn.SEQUENCE_REF);
        Intrinsics.checkNotNull((Object)o2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicTableOrViewColumn");
        return this.describeTableOrViewColumn(o2, context);
    }

    private final void describeIndexExtension(Project project, Db2IndexExtension o2, PresentationData presentation) {
        Dbms dbms = DbImplUtilCore.getDbms(o2);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        DdlBuilder builder = new DdlBuilder().applyCodeStyle(project, DbSqlUtilCore.getSqlDialect(dbms2)).withDialect(DbImplUtilCore.getDatabaseDialect(dbms2));
        builder.symbol("(");
        boolean first2 = true;
        for (Db2IndexExtensionArgument db2IndexExtensionArgument : o2.getIndexExtensionArguments()) {
            if (first2) {
                first2 = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type(db2IndexExtensionArgument.getDasType().toDataType());
        }
        builder.symbol(")");
        presentation.addText(builder.getStatement(), DbPresentationCore.INFO_ATTRS);
    }

    public static final /* synthetic */ String access$objectName(Db2DescriptionService $this, String name2, BasicElement obj2, DescriptionService.Context context) {
        return $this.objectName(name2, obj2, context);
    }
}

