/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CHouseErrorHandler
extends BaseDatabaseErrorHandler {
    @Override
    @NotNull
    protected ErrorInfo getErrorInfo(@Nullable LocalDataSource dataSource2, @NotNull Throwable original, @NotNull Throwable cause) {
        String originalMessage;
        if (original == null) {
            CHouseErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            CHouseErrorHandler.$$$reportNull$$$0(1);
        }
        if ((originalMessage = original.getMessage()) != null && originalMessage.contains("HTTP request was sent to HTTPS port")) {
            return new CHouseHTTPSErrorInfo(dataSource2, original, cause);
        }
        if (originalMessage != null && StringUtil.startsWithIgnoreCase((String)originalMessage, (String)"ClickHouse exception")) {
            return new CHouseNativeErrorInfo(dataSource2, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(dataSource2, original, cause);
        if (errorInfo == null) {
            CHouseErrorHandler.$$$reportNull$$$0(2);
        }
        return errorInfo;
    }

    @Override
    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText2) {
        Matcher matcher;
        if (project == null) {
            CHouseErrorHandler.$$$reportNull$$$0(3);
        }
        if (errorInfo == null) {
            CHouseErrorHandler.$$$reportNull$$$0(4);
        }
        if (queryText2 == null) {
            CHouseErrorHandler.$$$reportNull$$$0(5);
        }
        if (!(matcher = Pattern.compile("\\bfailed at position (\\d+)\\b").matcher(errorInfo.getMessage())).find()) {
            return -1;
        }
        int pos = StringUtil.parseInt((String)matcher.group(1), (int)-1);
        return pos == -1 ? -1 : pos - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/clickhouse/CHouseErrorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/clickhouse/CHouseErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class CHouseHTTPSErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        CHouseHTTPSErrorInfo(@Nullable LocalDataSource dataSource2, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                CHouseHTTPSErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                CHouseHTTPSErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource2, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                CHouseHTTPSErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                CHouseHTTPSErrorInfo.$$$reportNull$$$0(3);
            }
            this.appendOriginalPrefixIfNeeded(sb);
            sb.append(GridUtilCore.getMessage((Throwable)this.myCause));
            CHouseHTTPSErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.enableSSL(this.getDataSource())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/clickhouse/CHouseErrorHandler$CHouseHTTPSErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CHouseNativeErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        CHouseNativeErrorInfo(@Nullable LocalDataSource dataSource2, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                CHouseNativeErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                CHouseNativeErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource2, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                CHouseNativeErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                CHouseNativeErrorInfo.$$$reportNull$$$0(3);
            }
            CHouseNativeErrorInfo.appendGenericMessage(this.myCause, sb);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/clickhouse/CHouseErrorHandler$CHouseNativeErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

