/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.bigquery.generator.dml.BigQuerySelectGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.io.Serializable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J0\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u0002H\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u0011\u0018\u00010\u000f\"\u0004\b\u0000\u0010\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0011H\u0014J&\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dialects/bigquery/BigQueryDmlHelper;", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "appendFromTable", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "dasTable", "Lcom/intellij/database/model/DasObject;", "alias", "", "tableSamplingSize", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "OUT", "Lcom/intellij/database/script/generator/dml/DmlTask;", "task", "isEditableTable", "", "table", "dataProperties", "", "Ljava/io/Serializable;", "supportsOffset", "intellij.database.dialects.bigquery"})
public final class BigQueryDmlHelper
extends BaseDmlHelper {
    public BigQueryDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    @Nullable
    protected <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlGenerator dmlGenerator = task instanceof SelectTask ? (DmlGenerator)new BigQuerySelectGenerator((SelectTask)task, this.getDbms(), this) : super.getGenerator(task);
        return dmlGenerator instanceof DmlGenerator ? dmlGenerator : null;
    }

    @Override
    public void appendFromTable(@NotNull DdlBuilder builder, @NotNull DasObject dasTable, @NotNull String alias, @Nullable String tableSamplingSize) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dasTable, (String)"dasTable");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        builder.keyword("FROM").space().qualifiedRef(dasTable).space().alias(alias);
        if (tableSamplingSize != null && DbImplUtilCore.supportsTableSampling(dasTable, this.getDbms())) {
            String[] stringArray = new String[]{"TABLESAMPLE", "SYSTEM"};
            builder.space().keywords(stringArray).space().symbol("(").literal(tableSamplingSize).space().keyword("PERCENT").symbol(")");
        }
    }

    @Override
    public boolean supportsOffset(@Nullable DasObject table) {
        return true;
    }

    @Override
    public boolean isEditableTable(@Nullable DasObject table, @NotNull Map<String, ? extends Serializable> dataProperties) {
        Intrinsics.checkNotNullParameter(dataProperties, (String)"dataProperties");
        return super.isEditableTable(table, dataProperties) && !Intrinsics.areEqual((Object)DmlHelper.Companion.getCOLUMNS_CHANGED_DURING_FETCH().get(dataProperties), (Object)true) && !Intrinsics.areEqual((Object)DmlHelper.Companion.getMULTIPLE_ROWS_WITH_THE_SAME_NUMBER().get(dataProperties), (Object)true);
    }
}

