/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dialects.bigquery.BigQueryAuthProviderKt;
import com.intellij.database.dialects.bigquery.FieldType;
import com.intellij.database.dialects.bigquery.ParameterType;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aJ\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010 \u001a\u0004\u0018\u00010\u0001J\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/bigquery/BigQueryAuthParameter;", "", "jdbcParameter", "", "title", "Ljava/util/function/Supplier;", "Lorg/jetbrains/annotations/Nls;", "type", "Lcom/intellij/database/dialects/bigquery/FieldType;", "parameterType", "Lcom/intellij/database/dialects/bigquery/ParameterType;", "(Ljava/lang/String;Ljava/util/function/Supplier;Lcom/intellij/database/dialects/bigquery/FieldType;Lcom/intellij/database/dialects/bigquery/ParameterType;)V", "getJdbcParameter", "()Ljava/lang/String;", "getParameterType", "()Lcom/intellij/database/dialects/bigquery/ParameterType;", "getTitle", "()Ljava/util/function/Supplier;", "getType", "()Lcom/intellij/database/dialects/bigquery/FieldType;", "loadImpl", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "oneTimeStringSerialiser", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder$Serialiser;", "Lcom/intellij/credentialStore/OneTimeString;", "saveImpl", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "v", "stringSerialiser", "intellij.database.dialects.bigquery"})
public final class BigQueryAuthParameter {
    @NotNull
    private final String jdbcParameter;
    @NotNull
    private final Supplier<String> title;
    @NotNull
    private final FieldType type;
    @NotNull
    private final ParameterType parameterType;

    public BigQueryAuthParameter(@NotNull String jdbcParameter, @NotNull Supplier<String> title, @NotNull FieldType type2, @NotNull ParameterType parameterType) {
        Intrinsics.checkNotNullParameter((Object)jdbcParameter, (String)"jdbcParameter");
        Intrinsics.checkNotNullParameter(title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)parameterType), (String)"parameterType");
        this.jdbcParameter = jdbcParameter;
        this.title = title;
        this.type = type2;
        this.parameterType = parameterType;
    }

    public /* synthetic */ BigQueryAuthParameter(String string, Supplier supplier2, FieldType fieldType, ParameterType parameterType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            parameterType = ParameterType.URL;
        }
        this(string, supplier2, fieldType, parameterType);
    }

    @NotNull
    public final String getJdbcParameter() {
        return this.jdbcParameter;
    }

    @NotNull
    public final Supplier<String> getTitle() {
        return this.title;
    }

    @NotNull
    public final FieldType getType() {
        return this.type;
    }

    @NotNull
    public final ParameterType getParameterType() {
        return this.parameterType;
    }

    @NotNull
    public final AuthWidgetBuilder.Serialiser<String> stringSerialiser() {
        return new AuthWidgetBuilder.Serialiser<String>(this){
            final /* synthetic */ BigQueryAuthParameter this$0;
            {
                this.this$0 = $receiver;
            }

            public void save(@Nullable String v2, @NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials) {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                this.this$0.saveImpl(config, credentials, v2);
            }

            @Nullable
            public String load(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials) {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                Object object = this.this$0.loadImpl(point, credentials);
                return object != null ? object.toString() : null;
            }
        };
    }

    @NotNull
    public final AuthWidgetBuilder.Serialiser<OneTimeString> oneTimeStringSerialiser() {
        return new AuthWidgetBuilder.Serialiser<OneTimeString>(this){
            final /* synthetic */ BigQueryAuthParameter this$0;
            {
                this.this$0 = $receiver;
            }

            public void save(@Nullable OneTimeString v2, @NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials) {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                this.this$0.saveImpl(config, credentials, v2);
            }

            @Nullable
            public OneTimeString load(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials) {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                Object object = this.this$0.loadImpl(point, credentials);
                return object != null ? BigQueryAuthProviderKt.access$toOneTimeString(object) : null;
            }
        };
    }

    @Nullable
    public final Object loadImpl(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials) {
        DatabaseCredentials databaseCredentials;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.type == FieldType.PASSWORD ? ((databaseCredentials = credentials) != null && (databaseCredentials = databaseCredentials.loadPassword(point, this.jdbcParameter)) != null ? (CharSequence)((Object)databaseCredentials) : (CharSequence)point.getAdditionalProperty(this.jdbcParameter)) : (CharSequence)point.getAdditionalProperty(this.jdbcParameter);
    }

    public final void saveImpl(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object v2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.type == FieldType.PASSWORD) {
            DatabaseCredentials databaseCredentials = credentials;
            if (databaseCredentials != null) {
                Object object = v2;
                databaseCredentials.storePassword(config, this.jdbcParameter, (OneTimeString)(object != null ? BigQueryAuthProviderKt.access$toOneTimeString(object) : null));
            }
        } else {
            Object object = v2;
            config.setAdditionalProperty(this.jdbcParameter, object != null ? object.toString() : null);
        }
    }
}

