/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.GrantsHelper;
import com.intellij.database.dialects.base.generator.Producer;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.SizeAndScale;
import com.intellij.database.dialects.base.generator.producers.AlterArgument;
import com.intellij.database.dialects.base.generator.producers.AlterCapableInvocator;
import com.intellij.database.dialects.base.generator.producers.AlterCapableProducer;
import com.intellij.database.dialects.base.generator.producers.AlterCapableProducerKt;
import com.intellij.database.dialects.base.generator.producers.AlterCheck;
import com.intellij.database.dialects.base.generator.producers.AlterData;
import com.intellij.database.dialects.base.generator.producers.AlterDatabase;
import com.intellij.database.dialects.base.generator.producers.AlterForeignKey;
import com.intellij.database.dialects.base.generator.producers.AlterIndex;
import com.intellij.database.dialects.base.generator.producers.AlterKey;
import com.intellij.database.dialects.base.generator.producers.AlterLikeColumn;
import com.intellij.database.dialects.base.generator.producers.AlterProducer;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.AlterSchema;
import com.intellij.database.dialects.base.generator.producers.AlterSynonym;
import com.intellij.database.dialects.base.generator.producers.AlterTable;
import com.intellij.database.dialects.base.generator.producers.AlterTableColumn;
import com.intellij.database.dialects.base.generator.producers.AlterTrigger;
import com.intellij.database.dialects.base.generator.producers.AlterUnknown;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.BasicElementProducer;
import com.intellij.database.dialects.base.generator.producers.CapabilityInvocator;
import com.intellij.database.dialects.base.generator.producers.CreateCapableInvocator;
import com.intellij.database.dialects.base.generator.producers.CreateCapableProducer;
import com.intellij.database.dialects.base.generator.producers.CreateCheck;
import com.intellij.database.dialects.base.generator.producers.CreateCommentCapable;
import com.intellij.database.dialects.base.generator.producers.CreateData;
import com.intellij.database.dialects.base.generator.producers.CreateForeignKey;
import com.intellij.database.dialects.base.generator.producers.CreateIndex;
import com.intellij.database.dialects.base.generator.producers.CreateKey;
import com.intellij.database.dialects.base.generator.producers.CreateLikeColumn;
import com.intellij.database.dialects.base.generator.producers.CreateMatView;
import com.intellij.database.dialects.base.generator.producers.CreateOther;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.CreateProducerBase;
import com.intellij.database.dialects.base.generator.producers.CreateSequence;
import com.intellij.database.dialects.base.generator.producers.CreateSourceAware;
import com.intellij.database.dialects.base.generator.producers.CreateSynonym;
import com.intellij.database.dialects.base.generator.producers.CreateTable;
import com.intellij.database.dialects.base.generator.producers.CreateTrigger;
import com.intellij.database.dialects.base.generator.producers.CreateView;
import com.intellij.database.dialects.base.generator.producers.DropCapableInvocator;
import com.intellij.database.dialects.base.generator.producers.DropCapableProducer;
import com.intellij.database.dialects.base.generator.producers.DropData;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.DropUnknown;
import com.intellij.database.dialects.base.generator.producers.ElementData;
import com.intellij.database.dialects.base.generator.producers.FlagValue;
import com.intellij.database.dialects.base.generator.producers.NewProducerUtilsKt;
import com.intellij.database.dialects.base.generator.producers.OldAlterAdapter;
import com.intellij.database.dialects.base.generator.producers.OldCreateAdapter;
import com.intellij.database.dialects.base.generator.producers.OldDropAdapter;
import com.intellij.database.dialects.base.generator.producers.ProducerData;
import com.intellij.database.dialects.base.generator.producers.ProducerUtilsKt;
import com.intellij.database.dialects.base.generator.producers.RecompileProducer;
import com.intellij.database.dialects.base.generator.producers.SearchPathProducer;
import com.intellij.database.dialects.base.generator.producers.SourceAwareProducersKt;
import com.intellij.database.dialects.base.generator.producers.TruncateProducer;
import com.intellij.database.dialects.base.generator.producers.TruncateTable;
import com.intellij.database.dialects.base.generator.producers.UnsupportedCapableInvocator;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ElementDeltaKt;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingConstraintContext;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingUtilsKt;
import com.intellij.database.types.DasType;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u00101\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u000302\u0018\u00010)2\u0006\u00103\u001a\u000204H\u0016J:\u00105\u001a\b\u0012\u0004\u0012\u00020\"06\"\b\b\u0000\u00107*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70:2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H70<2\u0006\u0010=\u001a\u00020>J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\"062\u0006\u0010@\u001a\u00020*H\u0016J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\"062\u0006\u0010@\u001a\u00020*H\u0016J:\u0010B\u001a\b\u0012\u0004\u0012\u00020\"06\"\b\b\u0000\u00107*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70C2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H70D2\u0006\u0010=\u001a\u00020>J\u0018\u0010E\u001a\u00020\"2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u000208H\u0014J\"\u0010I\u001a\u00020\"2\u0006\u0010F\u001a\u00020G2\u0006\u0010J\u001a\u00020K2\b\u0010H\u001a\u0004\u0018\u000108H\u0016J\u001c\u0010L\u001a\u0004\u0018\u00010M2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030<2\u0006\u0010N\u001a\u00020>J2\u0010O\u001a\u0004\u0018\u00010M\"\b\b\u0000\u00107*\u0002082\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H70<2\u0010\u0010=\u001a\f\u0012\u0004\u0012\u0002H7\u0012\u0002\b\u00030PJ-\u0010Q\u001a\u00020\"\"\u0004\b\u0000\u0010R2\u0006\u0010;\u001a\u00020S2\b\u0010T\u001a\u0004\u0018\u0001HR2\b\u0010U\u001a\u0004\u0018\u0001HR\u00a2\u0006\u0002\u0010VJ\u0012\u0010W\u001a\u00020\t2\b\u0010X\u001a\u0004\u0018\u00010\tH\u0016J\u001e\u0010Y\u001a\u0006\u0012\u0002\b\u00030Z2\u0006\u0010F\u001a\u00020G2\n\u0010[\u001a\u0006\u0012\u0002\b\u00030\\J \u0010]\u001a\u0006\u0012\u0002\b\u00030^2\u0006\u0010F\u001a\u00020G2\n\u0010[\u001a\u0006\u0012\u0002\b\u00030\\H\u0016J\u001a\u0010_\u001a\u0006\u0012\u0002\b\u00030`2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u000208J\u001c\u0010a\u001a\u0006\u0012\u0002\b\u00030`2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u000208H\u0016J\u001a\u0010b\u001a\u0006\u0012\u0002\b\u00030c2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u000208J\u001c\u0010d\u001a\u0006\u0012\u0002\b\u00030c2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u000208H\u0016J\u001c\u0010e\u001a\u0006\u0012\u0002\b\u00030f2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u000208H\u0016J\u001a\u0010g\u001a\u0004\u0018\u00010h2\u0006\u0010F\u001a\u00020G2\u0006\u0010i\u001a\u00020jH\u0016J\u001c\u0010k\u001a\u0006\u0012\u0002\b\u00030l2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u000208H\u0016J\u001e\u0010m\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030o0n2\n\u0010p\u001a\u0006\u0012\u0002\b\u00030qH\u0016J\u001a\u0010r\u001a\u0004\u0018\u00010\n2\u0006\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020vH\u0014J\u0016\u0010w\u001a\b\u0012\u0002\b\u0003\u0018\u00010x2\u0006\u0010H\u001a\u000208H\u0016J.\u0010y\u001a\u00020z\"\b\b\u0000\u00107*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70x2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H70{H\u0016J$\u0010|\u001a\u00020}2\b\u0010~\u001a\u0004\u0018\u00010\u007f2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0000\u00a2\u0006\u0003\b\u0082\u0001J\u000f\u0010\u0083\u0001\u001a\u00020\t2\u0006\u0010H\u001a\u000208J\u0011\u0010\u0084\u0001\u001a\u00020\t2\u0006\u0010H\u001a\u000208H\u0002J\u0015\u0010\u0085\u0001\u001a\u00020\t2\n\u0010\u0086\u0001\u001a\u0005\u0018\u00010\u0087\u0001H\u0016J\u0016\u0010\u0088\u0001\u001a\u00030\u0089\u00012\n\u00109\u001a\u0006\u0012\u0002\b\u00030^H\u0014J\u0019\u0010\u008a\u0001\u001a\u00020\"2\u0006\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020vH\u0016J'\u0010\u008b\u0001\u001a\u00020\"2\u0006\u0010F\u001a\u00020G2\n\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0016J\u0011\u0010\u0090\u0001\u001a\u00020\"2\u0006\u0010s\u001a\u00020tH\u0016J\u0015\u0010\u0091\u0001\u001a\u00020\"2\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u0001H\u0016J\u0016\u0010\u0094\u0001\u001a\u00020\"2\u000b\u0010\u0095\u0001\u001a\u0006\u0012\u0002\b\u000302H\u0016J\u0012\u0010\u0096\u0001\u001a\u00020\"2\u0007\u0010\u0097\u0001\u001a\u00020\tH\u0016J0\u0010\u0098\u0001\u001a\u00030\u0089\u0001\"\b\b\u0000\u00107*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70:2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H70<H\u0016J\"\u0010\u0098\u0001\u001a\u00030\u0089\u0001\"\b\b\u0000\u00107*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70^H\u0016J.\u0010\u0099\u0001\u001a\u00030\u0089\u00012\n\u0010;\u001a\u0006\u0012\u0002\b\u00030<2\u0006\u0010N\u001a\u00020>2\u000e\u0010\u009a\u0001\u001a\t\u0012\u0004\u0012\u00020>0\u009b\u0001H\u0016J.\u0010\u0099\u0001\u001a\u00030\u0089\u00012\n\u00109\u001a\u0006\u0012\u0002\b\u00030^2\u0006\u0010N\u001a\u00020>2\u000e\u0010\u009a\u0001\u001a\t\u0012\u0004\u0012\u00020>0\u009b\u0001H\u0016J\u001c\u0010\u009c\u0001\u001a\u00030\u0089\u00012\n\u0010;\u001a\u0006\u0012\u0002\b\u00030<2\u0006\u0010N\u001a\u00020>J0\u0010\u009d\u0001\u001a\u00030\u0089\u0001\"\b\b\u0000\u00107*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70C2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H70DH\u0002J0\u0010\u009e\u0001\u001a\u00030\u0089\u0001\"\b\b\u0000\u00107*\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H70C2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H70DH\u0016J#\u0010\u009e\u0001\u001a\u00030\u0089\u0001\"\b\b\u0000\u00107*\u0002082\r\u00109\u001a\t\u0012\u0004\u0012\u0002H70\u009f\u0001H\u0016J\u0013\u0010\u00a0\u0001\u001a\u0004\u0018\u0001082\u0006\u0010H\u001a\u000208H\u0016J\u0014\u0010\u00a1\u0001\u001a\u0004\u0018\u00010j2\u0007\u00109\u001a\u00030\u00a2\u0001H\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020\t2\u0007\u0010\u00a4\u0001\u001a\u000208H\u0016J&\u0010\u00a5\u0001\u001a\u00020\t2\u0006\u0010s\u001a\u00020t2\b\u0010F\u001a\u0004\u0018\u00010G2\t\u0010\u00a6\u0001\u001a\u0004\u0018\u00010\tH\u0016J\u0011\u0010\u00a7\u0001\u001a\u00020\"2\u0006\u0010F\u001a\u00020GH\u0014J\u001b\u0010\u00a8\u0001\u001a\u00020\"2\u0006\u0010F\u001a\u00020G2\b\u0010\u00a9\u0001\u001a\u00030\u008f\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020*0)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010,R\u0014\u0010/\u001a\u00020\"8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010$\u00a8\u0006\u00aa\u0001"}, d2={"Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/dialects/base/generator/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "grantsHelper", "Lcom/intellij/database/dialects/base/generator/GrantsHelper;", "getGrantsHelper", "()Lcom/intellij/database/dialects/base/generator/GrantsHelper;", "namingServiceProvider", "Lcom/intellij/database/script/generator/NamingService$Provider;", "getNamingServiceProvider", "()Lcom/intellij/database/script/generator/NamingService$Provider;", "namingServiceProvider$delegate", "Lkotlin/Lazy;", "sqlDef", "Lcom/intellij/lang/ParserDefinition;", "getSqlDef", "()Lcom/intellij/lang/ParserDefinition;", "sqlDef$delegate", "sqlLang", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getSqlLang", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "sqlLang$delegate", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "getStatementDelimiterStr", "()Ljava/lang/String;", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "supportsCreateOrReplace", "getSupportsCreateOrReplace", "useObjectIdInOrder", "getUseObjectIdInOrder", "availableOptions", "Lcom/intellij/database/script/generator/ScriptingOption;", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "canAlter", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "producer", "Lcom/intellij/database/dialects/base/generator/producers/AlterCapableProducer;", "data", "Lcom/intellij/database/dialects/base/generator/producers/AlterData;", "prop", "Lcom/intellij/database/model/meta/BasicMetaId;", "canCreateIfNotExists", "kind", "canCreateOrReplace", "canCreateWith", "Lcom/intellij/database/dialects/base/generator/producers/CreateCapableProducer;", "Lcom/intellij/database/dialects/base/generator/producers/CreateData;", "canGenerateElementRightNow", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "canGenerateHere", "locus", "Lcom/intellij/database/script/generator/ScriptLocus;", "checkAlterFakeFlag", "Lcom/intellij/database/dialects/base/generator/producers/FlagValue;", "id", "checkAlterPropertyFlag", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "checkAlterValue", "V", "Lcom/intellij/database/dialects/base/generator/producers/ProducerData;", "v1", "v2", "(Lcom/intellij/database/dialects/base/generator/producers/ProducerData;Ljava/lang/Object;Ljava/lang/Object;)Z", "commentStr", "comment", "createAlterProducer", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducer;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "createDropProducer", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createDropProducerImpl", "createProducer", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "createProducerImpl", "createRecompileProducer", "Lcom/intellij/database/dialects/base/generator/producers/RecompileProducer;", "createSearchPathGroup", "Lcom/intellij/database/dialects/base/generator/producers/SearchPathProducer;", "path", "Lcom/intellij/database/util/SearchPath;", "createTruncateProducer", "Lcom/intellij/database/dialects/base/generator/producers/TruncateProducer;", "extraProperties", "", "Lcom/intellij/database/model/meta/BasicMetaPropertyId;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getDefaultPrimitiveSize", "d", "Lcom/intellij/database/model/DataType;", "v", "Lcom/intellij/database/util/Version;", "getElementProducer", "Lcom/intellij/database/dialects/base/generator/producers/BasicElementProducer;", "getInvocator", "Lcom/intellij/database/dialects/base/generator/producers/CapabilityInvocator;", "Lcom/intellij/database/dialects/base/generator/producers/ElementData;", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "getNamingService$intellij_database_dialects_base", "getObjectPreliminaryOrder", "getObjectPreliminaryOrderPart", "getTableTerm", "table", "Lcom/intellij/database/model/basic/BasicLikeTable;", "initAlterProducer", "", "isDefaultSize", "isIndexExplicitFor", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "key", "Lcom/intellij/database/model/basic/BasicKey;", "isMaxForbidden", "isNullExplicit", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "isOptionSupported", "option", "isSchemaAlwaysInPath", "sc", "produceAlter", "produceAlterFlag", "produced", "", "produceAlterNotSupported", "produceComments", "produceCreate", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducerBase;", "qualifier", "requiredSearchPath", "Lcom/intellij/database/dialects/base/generator/Producer;", "scopeResolutionSeparator", "e", "script", "contextSchema", "shouldCollectColumnElements", "shouldGenerateOutsideTable", "it", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nScriptGeneratorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptGeneratorHelper.kt\ncom/intellij/database/dialects/base/generator/ScriptGeneratorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,573:1\n1#2:574\n*E\n"})
public abstract class ScriptGeneratorHelper {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final Lazy sqlLang$delegate;
    @NotNull
    private final Lazy sqlDef$delegate;
    @NotNull
    private final Lazy namingServiceProvider$delegate;
    @NotNull
    private final Set<ObjectKind> supportsCreateOrReplace;
    @NotNull
    private final Set<ObjectKind> supportsCreateIfNotExists;
    @NotNull
    private final Map<String, SizeAndScale> defaultPrimitiveSizes;
    @Nullable
    private final GrantsHelper<?, ?> grantsHelper;

    public ScriptGeneratorHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.sqlLang$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SqlLanguageDialect>(this){
            final /* synthetic */ ScriptGeneratorHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final SqlLanguageDialect invoke() {
                return (SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(this.this$0.getDbms());
            }
        }));
        this.sqlDef$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ParserDefinition>(this){
            final /* synthetic */ ScriptGeneratorHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ParserDefinition invoke() {
                ParserDefinition parserDefinition;
                SqlLanguageDialect sqlLanguageDialect = this.this$0.getSqlLang();
                if (sqlLanguageDialect != null) {
                    SqlLanguageDialect it2 = sqlLanguageDialect;
                    boolean bl = false;
                    parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)it2);
                } else {
                    parserDefinition = null;
                }
                return parserDefinition;
            }
        }));
        this.namingServiceProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NamingService.Provider>(this){
            final /* synthetic */ ScriptGeneratorHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final NamingService.Provider invoke() {
                return (NamingService.Provider)NamingServices.INSTANCE.forDbms(this.this$0.getDbms());
            }
        }));
        this.supportsCreateOrReplace = SetsKt.emptySet();
        this.supportsCreateIfNotExists = SetsKt.emptySet();
        this.defaultPrimitiveSizes = MapsKt.emptyMap();
    }

    @NotNull
    public final Dbms getDbms() {
        return this.dbms;
    }

    @Nullable
    public final SqlLanguageDialect getSqlLang() {
        Lazy lazy = this.sqlLang$delegate;
        return (SqlLanguageDialect)lazy.getValue();
    }

    @Nullable
    public final ParserDefinition getSqlDef() {
        Lazy lazy = this.sqlDef$delegate;
        return (ParserDefinition)lazy.getValue();
    }

    private final NamingService.Provider getNamingServiceProvider() {
        Lazy lazy = this.namingServiceProvider$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (NamingService.Provider)object;
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateOrReplace() {
        return this.supportsCreateOrReplace;
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        return this.supportsCreateIfNotExists;
    }

    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    @NotNull
    public String getStatementDelimiterStr() {
        return ";";
    }

    public boolean getStatementDelimiterOwnsLine() {
        return false;
    }

    public boolean isNullExplicit(@Nullable BasicLikeColumn column2) {
        return false;
    }

    @NotNull
    public String script(@NotNull DataType d2, @Nullable ScriptingContext context, @Nullable String contextSchema) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d");
        Object specification = null;
        if (!d2.custom && !d2.sizeUnitExplicit && d2.size != -1) {
            Object object = context;
            if (object == null || (object = ((ScriptingContext)object).getTask()) == null || (object = ((ScriptingTask)object).getVersion()) == null) {
                object = Version.INFINITY;
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            boolean defaultSize = this.isDefaultSize(d2, (Version)object2);
            if (defaultSize) {
                specification = d2.typeName;
                if (d2.suffix != null) {
                    specification = (String)specification + " " + d2.suffix;
                }
            }
        }
        String string = specification;
        if (string != null) {
            return string;
        }
        String it2 = contextSchema;
        boolean bl = false;
        boolean ignoreSchema = it2 != null && StringsKt.equals((String)it2, (String)d2.schemaName, (boolean)true);
        String string2 = d2.getSpecification(false, this.isMaxForbidden(d2), !ignoreSchema);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSpecification(...)");
        return string2;
    }

    public boolean isMaxForbidden(@NotNull DataType d2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d");
        return false;
    }

    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreateIfNotExists(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return this.getSupportsCreateIfNotExists().contains(kind) ? AbstractScriptGeneratorKt.getSUPPORTED() : AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreateOrReplace(@NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return this.getSupportsCreateOrReplace().contains(kind) ? AbstractScriptGeneratorKt.getSUPPORTED() : AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    @NotNull
    public final NamingService getNamingService$intellij_database_dialects_base(@Nullable BasicModel model2, @Nullable BasicDatabase database) {
        return this.getNamingServiceProvider().getNamingService(model2, database);
    }

    public boolean isDefaultSize(@NotNull DataType d2, @NotNull Version v2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        SizeAndScale defaults = this.getDefaultPrimitiveSize(d2, v2);
        return defaults != null && d2.size == defaults.getSize() && d2.scale == defaults.getScale();
    }

    @Nullable
    protected SizeAndScale getDefaultPrimitiveSize(@NotNull DataType d2, @NotNull Version v2) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        return this.getDefaultPrimitiveSizes().get(StringUtil.toLowerCase((String)d2.typeName));
    }

    @NotNull
    public final String getObjectPreliminaryOrder(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        StringBuilder b2 = new StringBuilder(60);
        for (BasicElement e2 = element2; e2 != null; e2 = e2.getParent()) {
            if (((CharSequence)b2).length() > 0) {
                b2.insert(0, '.');
            }
            b2.insert(0, this.getObjectPreliminaryOrderPart(e2));
            if (e2 instanceof BasicMajorObject) break;
        }
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getObjectPreliminaryOrderPart(BasicElement element2) {
        Object object;
        ObjectKind objectKind = element2.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        String kindOrder = ScriptingUtilsKt.orderString(objectKind);
        if (element2 instanceof BasicArrangedElement) {
            object = "#" + ScriptingUtilsKt.toFixedOrderString(ScriptingUtilsKt.positionSafe((BasicArrangedElement)element2)) + "#" + element2.identity();
        } else if (element2 instanceof BasicIdentifiedElement && this.getUseObjectIdInOrder()) {
            object = ScriptingUtilsKt.toOrderString(((BasicIdentifiedElement)element2).getObjectId()) + "#" + element2.identity();
        } else if (element2 instanceof BasicOverloadable) {
            object = "?_" + element2.identity();
        } else if (element2 instanceof BasicNamedElement) {
            String string = ((BasicNamedElement)element2).getRealName();
            if (string == null) {
                string = "???";
            }
            object = "?_" + string + "#" + element2.identity();
        } else {
            object = "?????";
        }
        String elementOrder = object;
        return kindOrder + (element2 instanceof BasicKey && ((BasicKey)element2).isPrimary() ? "^" : "_") + elementOrder;
    }

    protected boolean getUseObjectIdInOrder() {
        return true;
    }

    @Nullable
    public BasicElement qualifier(@NotNull BasicElement element2) {
        BasicElement basicElement;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElement basicElement2 = element2;
        if (basicElement2 instanceof BasicSchemaObject) {
            basicElement = ((BasicSchemaObject)element2).getSchema();
        } else if (basicElement2 instanceof BasicLikeColumn) {
            basicElement = ((BasicLikeColumn)element2).getLikeTable();
        } else if (basicElement2 instanceof BasicMinorObject) {
            BasicMajorObject basicMajorObject = ((BasicMinorObject)element2).getMajorObject();
            basicElement = basicMajorObject != null ? basicMajorObject.getSchema() : null;
        } else {
            basicElement = null;
        }
        return basicElement;
    }

    @NotNull
    public String getTableTerm(@Nullable BasicLikeTable table) {
        return "table";
    }

    @NotNull
    public String commentStr(@Nullable String comment) {
        String string = comment;
        if (string == null) {
            string = "";
        }
        return ScriptGeneratorHelperKt.getSqlString(string);
    }

    protected boolean shouldCollectColumnElements(@NotNull ScriptingContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_IN_COLUMN && context.getLocus() == ScriptLocus.IN_TABLE;
    }

    public boolean canGenerateHere(@NotNull ScriptingContext context, @NotNull ScriptLocus locus, @Nullable BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)locus), (String)"locus");
        return switch (WhenMappings.$EnumSwitchMapping$0[locus.ordinal()]) {
            case 1 -> {
                if (!(element2 instanceof BasicConstraint) || context.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_AFTER_TABLE) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (element2 instanceof BasicTableOrViewColumn || element2 instanceof BasicConstraint && context.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT).compareTo((Enum)ScriptingConstraintContext.CONSTRAINT_IN_TABLE) <= 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (element2 instanceof BasicConstraint && context.getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT) == ScriptingConstraintContext.CONSTRAINT_IN_COLUMN) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    protected boolean canGenerateElementRightNow(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof BasicMinorObject && context.getLocus().compareTo((Enum)ScriptLocus.IN_TABLE) < 0) {
            return ((BasicMinorObject)element2).getMajorObject() == null;
        }
        return true;
    }

    public boolean isIndexExplicitFor(@NotNull ScriptingContext context, @Nullable BasicIndex index2, @NotNull BasicKey key2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return index2 != null && ScriptGeneratorHelperKt.useName(index2, context) && !Intrinsics.areEqual((Object)index2.getName(), (Object)key2.getName());
    }

    public boolean shouldGenerateOutsideTable(@NotNull ScriptingContext context, @NotNull BasicKey it2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return this.isIndexExplicitFor(context, it2.getUnderlyingIndex(), it2);
    }

    @Nullable
    public GrantsHelper<?, ?> getGrantsHelper() {
        return this.grantsHelper;
    }

    @Nullable
    public BasicElementProducer<?> getElementProducer(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return null;
    }

    @NotNull
    public final CreateProducer<?> createProducer(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        CreateCapableProducer producer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElementProducer<?> basicElementProducer = this.getElementProducer(element2);
        CreateCapableProducer createCapableProducer = producer = basicElementProducer instanceof CreateCapableProducer ? (CreateCapableProducer)basicElementProducer : null;
        if (producer != null) {
            CreateData<BasicElement> data = new CreateData<BasicElement>(context, element2);
            producer.init((ProducerData)data);
            return new OldCreateAdapter<BasicElement>(producer, data);
        }
        return this.createProducerImpl(context, element2);
    }

    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        return basicElement instanceof BasicSequence ? (CreateProducer)new CreateSequence<BasicSequence>(context, (BasicSequence)element2) : (basicElement instanceof BasicTable ? (CreateProducer)new CreateTable<BasicTable>(context, (BasicTable)element2) : (basicElement instanceof BasicLikeColumn ? (CreateProducer)new CreateLikeColumn<BasicLikeColumn>(context, (BasicLikeColumn)element2) : (basicElement instanceof BasicIndex ? (CreateProducer)new CreateIndex<BasicIndex>(context, (BasicIndex)element2) : (basicElement instanceof BasicKey ? (CreateProducer)new CreateKey<BasicKey>(context, (BasicKey)element2) : (basicElement instanceof BasicForeignKey ? (CreateProducer)new CreateForeignKey<BasicForeignKey>(context, (BasicForeignKey)element2) : (basicElement instanceof BasicCheck ? (CreateProducer)new CreateCheck<BasicCheck>(context, (BasicCheck)element2) : (basicElement instanceof BasicTrigger ? (CreateProducer)new CreateTrigger<BasicTrigger>(context, (BasicTrigger)element2) : (basicElement instanceof BasicMatView ? (CreateProducer)new CreateMatView<BasicMatView>(context, (BasicMatView)element2) : (basicElement instanceof BasicView ? (CreateProducer)new CreateView<BasicView>(context, (BasicView)element2) : (basicElement instanceof BasicSourceAware ? (CreateProducer)new CreateSourceAware<BasicSourceAware>(context, (BasicSourceAware)element2) : (basicElement instanceof BasicSynonym ? (CreateProducer)new CreateSynonym<BasicSynonym>(context, (BasicSynonym)element2) : (CreateProducer)new CreateOther(context, element2))))))))))));
    }

    @NotNull
    public final DropProducer<?> createDropProducer(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        DropCapableProducer producer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElementProducer<?> basicElementProducer = this.getElementProducer(element2);
        DropCapableProducer dropCapableProducer = producer = basicElementProducer instanceof DropCapableProducer ? (DropCapableProducer)basicElementProducer : null;
        if (producer != null) {
            DropData<BasicElement> data = new DropData<BasicElement>(context, element2);
            producer.init((ProducerData)data);
            return new OldDropAdapter<BasicElement>(producer, data);
        }
        return this.createDropProducerImpl(context, element2);
    }

    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return new DropUnknown(context, element2);
    }

    @NotNull
    public final AlterProducer<?> createAlterProducer(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements2) {
        AlterCapableProducer producer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Object object = this.getElementProducer((BasicElement)ElementDeltaKt.anyElement((ElementDelta)elements2));
        AlterCapableProducer alterCapableProducer = producer = object instanceof AlterCapableProducer ? (AlterCapableProducer)object : null;
        if (producer != null) {
            AlterData data = new AlterData(context, elements2.getSourceElement(), elements2.getTargetElement());
            producer.init((ProducerData)data);
            return new OldAlterAdapter(producer, data);
        }
        Object $this$createAlterProducer_u24lambda_u241 = object = this.createAlterProducerImpl(context, elements2);
        boolean bl = false;
        this.initAlterProducer((AlterProducerBase<?>)$this$createAlterProducer_u24lambda_u241);
        return (AlterProducer)object;
    }

    protected void initAlterProducer(@NotNull AlterProducerBase<?> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
    }

    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Object it2 = elements2.getSourceElement();
        boolean bl = false;
        Object obj2 = it2;
        return obj2 instanceof BasicDatabase ? (AlterProducerBase)new AlterDatabase(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicSchema ? (AlterProducerBase)new AlterSchema(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicTable ? (AlterProducerBase)new AlterTable(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicTableColumn ? (AlterProducerBase)new AlterTableColumn(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicKey ? (AlterProducerBase)new AlterKey(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicIndex ? (AlterProducerBase)new AlterIndex(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicForeignKey ? (AlterProducerBase)new AlterForeignKey(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicCheck ? (AlterProducerBase)new AlterCheck(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicSynonym ? (AlterProducerBase)new AlterSynonym(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicTrigger ? (AlterProducerBase)new AlterTrigger(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicLikeColumn ? (AlterProducerBase)new AlterLikeColumn(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof BasicArgument ? (AlterProducerBase)new AlterArgument(context, BaseProducersKt.cast(elements2, it2)) : (AlterProducerBase)new AlterUnknown(context, elements2))))))))))));
    }

    @NotNull
    public RecompileProducer<?> createRecompileProducer(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return new RecompileProducer<BasicElement>(context, element2){

            @NotNull
            public ScriptingCapabilities.VersionedCapability<Boolean> canRecompile() {
                return AbstractScriptGeneratorKt.getUNSUPPORTED();
            }
        };
    }

    @NotNull
    public TruncateProducer<?> createTruncateProducer(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return element2 instanceof BasicTable ? (TruncateProducer)new TruncateTable<BasicLikeTable>(context, (BasicLikeTable)element2) : new TruncateProducer(context, element2);
    }

    public <T extends BasicElement> void produceAlter(@NotNull AlterCapableProducer<T> producer, @NotNull AlterData<T> data) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        producer.produceAlter(data);
    }

    public <T extends BasicElement> void produceAlter(@NotNull AlterProducerBase<T> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        producer.produceAlter();
    }

    public <T extends BasicElement> void produceCreate(@NotNull CreateCapableProducer<T> producer, @NotNull CreateData<T> data) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        producer.produceCreate(data);
        if (data.getContext().getLocus() == ScriptLocus.OUTSIDE && !data.getOptions().get(ScriptingOptionStatic.SKIP_COMMENTS).booleanValue()) {
            this.produceComments(producer, data);
        }
    }

    private final <T extends BasicElement> void produceComments(CreateCapableProducer<T> producer, CreateData<T> data) {
        if (data.getOptions().get(ScriptingOptionStatic.SKIP_COMMENTS).booleanValue()) {
            return;
        }
        if (producer instanceof CreateCommentCapable && data.getElement().getComment() != null) {
            ((CreateCommentCapable)producer).produceCommentIfSupported(data, data.getElement().getComment());
        }
    }

    public <T extends BasicElement> void produceCreate(@NotNull CreateProducerBase<T> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        producer.produceCreate();
        if (producer.getContext().getLocus() == ScriptLocus.OUTSIDE && !producer.getOptions().get(ScriptingOptionStatic.SKIP_COMMENTS).booleanValue()) {
            producer.produceComments();
        }
    }

    @Nullable
    public Set<ScriptingOption<?>> availableOptions(@NotNull ScriptingTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return WhenMappings.$EnumSwitchMapping$1[task.getCategory().ordinal()] == 1 ? SetsKt.setOf(ScriptingOptionStatic.USE_DELETE) : null;
    }

    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        ScriptingOption<?> scriptingOption = option;
        return (((((((((((((((((Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.ALLOW_RECREATE) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.INCLUDE_NESTED_ELEMENTS)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CONSIDER_SCHEMA_NAME)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IGNORE_CASE_CHANGES)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CASCADE)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.RESTART_IDENTITY)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.PURGE_MV_LOG)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.REUSE_STORAGE)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.RESTRICT_DELETE_TRIGGERS)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IMMEDIATE)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IGNORE_ORDER)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.SKIP_COMMENTS)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.USE_COMPACT_DEFINITION)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.REFORMAT)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CODE_STYLE)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IGNORE_COMPACT)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.DROP_CASCADE)) ? true : ((Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CONSIDER_TRIGGERS) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CONSIDER_SURROGATE_NAMES)) ? !Intrinsics.areEqual((Object)this.dbms, (Object)Dbms.UNKNOWN) : (Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.RUN_DIAGNOSTIC) ? ApplicationManager.getApplication().isInternal() : (Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.DUMP_TASK) ? Registry.is((String)"database.script.generator.show.dump.option") || ApplicationManager.getApplication().isInternal() : false)));
    }

    public void produceAlterFlag(@NotNull AlterProducerBase<?> producer, @NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        this.produceAlterFlag(producer.getData(), id, produced);
    }

    public void produceAlterFlag(@NotNull AlterData<?> data, @NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        this.produceAlterNotSupported(data, id);
    }

    public final void produceAlterNotSupported(@NotNull AlterData<?> data, @NotNull BasicMetaId id) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        NewProducerUtilsKt.newCoding(data, (Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(id){
            final /* synthetic */ BasicMetaId $id;
            {
                this.$id = $id;
                super(1);
            }

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
                $this$newCoding.error("Alter " + this.$id.name + " not supported");
            }
        }));
    }

    @NotNull
    public List<BasicMetaPropertyId<?>> extraProperties(@NotNull BasicMetaObject<?> meta) {
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        return CollectionsKt.emptyList();
    }

    @Nullable
    public SearchPath requiredSearchPath(@NotNull Producer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        return null;
    }

    @Nullable
    public SearchPathProducer createSearchPathGroup(@NotNull ScriptingContext context, @NotNull SearchPath path) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return null;
    }

    public boolean isSchemaAlwaysInPath(@NotNull String sc2) {
        Intrinsics.checkNotNullParameter((Object)sc2, (String)"sc");
        return false;
    }

    @NotNull
    public <T extends BasicElement> CapabilityInvocator getInvocator(@NotNull BasicElementProducer<T> producer, @NotNull ElementData<T> data) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return AlterCapableInvocator.INSTANCE.isSuitable(producer, data) ? (CapabilityInvocator)AlterCapableInvocator.INSTANCE : (CreateCapableInvocator.INSTANCE.isSuitable(producer, data) ? (CapabilityInvocator)CreateCapableInvocator.INSTANCE : (DropCapableInvocator.INSTANCE.isSuitable(producer, data) ? (CapabilityInvocator)DropCapableInvocator.INSTANCE : (CapabilityInvocator)UnsupportedCapableInvocator.INSTANCE));
    }

    @Nullable
    public final <T extends BasicElement> FlagValue checkAlterPropertyFlag(@NotNull AlterData<T> data, @NotNull BasicMetaProperty<T, ?> prop) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(prop, (String)"prop");
        BasicMetaPropertyId basicMetaPropertyId = prop.id;
        return Intrinsics.areEqual(basicMetaPropertyId, BasicModNamedElement.NAME) ? FlagValue.Companion.ofChange(ProducerUtilsKt.checkRenameImpl(data.getElement(), data.getTo(), data.getOptions())) : (((Intrinsics.areEqual(basicMetaPropertyId, BasicModNamedElement.NAME_QUOTED) ? true : Intrinsics.areEqual(basicMetaPropertyId, BasicModNamedElement.NAME_SCRIPTED)) ? true : Intrinsics.areEqual(basicMetaPropertyId, BasicModNamedElement.NAME_SURROGATE)) ? FlagValue.IGNORE : null);
    }

    @Nullable
    public final FlagValue checkAlterFakeFlag(@NotNull AlterData<?> data, @NotNull BasicMetaId id) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)id, (Object)AlterCapableProducerKt.getTMP_NAME_FLAG_ID()) ? FlagValue.Companion.ofChange(data.getTmpName() != null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <V> boolean checkAlterValue(@NotNull ProducerData data, @Nullable V v1, @Nullable V v2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        V v3 = v1;
        if (v3 instanceof DasType) {
            DasType dasType = (DasType)v2;
            if (SourceAwareProducersKt.areEqual(((DasType)v1).toDataType(), dasType != null ? dasType.toDataType() : null, data.getContext())) return false;
            return true;
        }
        if (v3 instanceof SequenceIdentity) {
            if (!((SequenceIdentity)v1).equalsIgnoreNext((SequenceIdentity)v2)) return true;
            if (data.getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE) == false) return false;
            SequenceIdentity sequenceIdentity = (SequenceIdentity)v2;
            if (sequenceIdentity == null) return false;
            BigInteger bigInteger = sequenceIdentity.next;
            if (bigInteger == null) return false;
            SequenceIdentity sequenceIdentity2 = (SequenceIdentity)v2;
            if (Intrinsics.areEqual((Object)((SequenceIdentity)v1).next, (Object)(sequenceIdentity2 != null ? sequenceIdentity2.next : null))) return false;
            return true;
        }
        if (Objects.deepEquals(v1, v2)) return false;
        return true;
    }

    @NotNull
    public final <T extends BasicElement> ScriptingCapabilities.VersionedCapability<Boolean> canCreateWith(@NotNull CreateCapableProducer<T> producer, @NotNull CreateData<T> data, @NotNull BasicMetaId prop) {
        ScriptingCapabilities.VersionedCapability<Boolean> versionedCapability;
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        if (Intrinsics.areEqual((Object)prop, BasicModArrangedElement.POSITION)) {
            versionedCapability = AbstractScriptGeneratorKt.getUNSUPPORTED();
        } else {
            BasicMetaField $this$canCreateWith_u24lambda_u243 = data.getMetaObject().getField(prop);
            boolean bl = false;
            versionedCapability = $this$canCreateWith_u24lambda_u243 == null || $this$canCreateWith_u24lambda_u243.isInternal() || $this$canCreateWith_u24lambda_u243.isAbstract() ? AbstractScriptGeneratorKt.getUNSUPPORTED() : AbstractScriptGeneratorKt.getSUPPORTED();
        }
        return versionedCapability;
    }

    @NotNull
    public final <T extends BasicElement> ScriptingCapabilities.VersionedCapability<Boolean> canAlter(@NotNull AlterCapableProducer<T> producer, @NotNull AlterData<T> data, @NotNull BasicMetaId prop) {
        ScriptingCapabilities.VersionedCapability<Boolean> versionedCapability;
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        BasicMetaId basicMetaId = prop;
        if ((Intrinsics.areEqual((Object)basicMetaId, BasicModNamedElement.NAME_QUOTED) ? true : Intrinsics.areEqual((Object)basicMetaId, BasicModNamedElement.NAME_SCRIPTED)) ? true : Intrinsics.areEqual((Object)basicMetaId, BasicModNamedElement.NAME_SURROGATE)) {
            BasicMetaPropertyId<String> basicMetaPropertyId = BasicModNamedElement.NAME;
            Intrinsics.checkNotNullExpressionValue(basicMetaPropertyId, (String)"NAME");
            versionedCapability = producer.canAlter(data, basicMetaPropertyId);
        } else if (Intrinsics.areEqual((Object)basicMetaId, BasicModSourceAware.SOURCE_TEXT)) {
            versionedCapability = AbstractScriptGeneratorKt.getSUPPORTED();
        } else {
            BasicMetaField $this$canAlter_u24lambda_u244 = data.getMetaObject().getField(prop);
            boolean bl = false;
            versionedCapability = $this$canAlter_u24lambda_u244 == null || $this$canAlter_u24lambda_u244.isInternal() || $this$canAlter_u24lambda_u244.isAbstract() ? AbstractScriptGeneratorKt.getUNSUPPORTED() : AbstractScriptGeneratorKt.getSUPPORTED();
        }
        return versionedCapability;
    }

    @NotNull
    public String scopeResolutionSeparator(@NotNull BasicElement e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        return ".";
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ScriptLocus.values().length];
            try {
                nArray[ScriptLocus.OUTSIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptLocus.IN_TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptLocus.IN_COLUMN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ScriptCategory.values().length];
            try {
                nArray[ScriptCategory.TRUNCATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

