/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableRunnable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseExecutionEnvironmentHelper
implements ExecutionEnvironmentHelper {
    private static final String EXPRESSION = "'keep alive'";

    @Override
    @NotNull
    public String getQuery(@NotNull String text2, @NotNull SqlElement sqlElement) {
        if (text2 == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        if (sqlElement instanceof SqlExpression && BaseExecutionEnvironmentHelper.isSufficientExpression((SqlExpression)sqlElement)) {
            String string = text2;
            if (string == null) {
                BaseExecutionEnvironmentHelper.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.generateSelectStatement(text2, sqlElement);
        if (string == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public List<RowSortOrder<String>> getOrderByElements(@NotNull PsiFile fileWithOrderBy) {
        SqlOrderByClause orderBy;
        if (fileWithOrderBy == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(4);
        }
        if ((orderBy = (SqlOrderByClause)PsiTreeUtil.getChildOfType((PsiElement)fileWithOrderBy, SqlOrderByClause.class)) == null) {
            List<RowSortOrder<String>> list = Collections.emptyList();
            if (list == null) {
                BaseExecutionEnvironmentHelper.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<RowSortOrder<String>> ordering = new ArrayList<RowSortOrder<String>>();
        SqlReferenceExpression ref2 = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)orderBy, SqlReferenceExpression.class);
        while (ref2 != null) {
            SqlIdentifier identifier = ref2.getIdentifier();
            if (identifier != null) {
                PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ref2);
                IElementType type2 = next == null ? null : next.getNode().getElementType();
                ordering.add((RowSortOrder<String>)(type2 == SqlCommonKeywords.SQL_DESC ? RowSortOrder.desc((Object)identifier.getName()) : RowSortOrder.asc((Object)identifier.getName())));
            }
            ref2 = (SqlReferenceExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)ref2, SqlReferenceExpression.class);
        }
        ArrayList<RowSortOrder<String>> arrayList = ordering;
        if (arrayList == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean isSufficientExpression(@NotNull SqlExpression expression) {
        if (expression == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(7);
        }
        return expression instanceof SqlResultSetExpression;
    }

    @NotNull
    protected String generateSelectStatement(@NotNull String text2, @NotNull SqlElement sqlElement) {
        if (text2 == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(8);
        }
        if (sqlElement == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(9);
        }
        String string = String.format("SELECT %s", text2);
        if (string == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    public ThreeState getSslState(@NotNull DatabaseConnectionCore connection2) {
        if (connection2 == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @NotNull
    public String getKeepAliveQuery(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(12);
        }
        if (dataSource2 == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(13);
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(dataSource2);
        String string = (String)ReadAction.compute(() -> {
            SqlCodeFragment fragment = SqlPsiFacade.getInstance((Project)project).createExpressionFragment((Language)dialect, null, null, EXPRESSION);
            SqlElement child = (SqlElement)fragment.getFirstChild();
            return this.getQuery(EXPRESSION, child);
        });
        if (string == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @Nullable
    public Long getRowCount(@NotNull RemoteResultSet resultSet) throws RemoteException, SQLException {
        if (resultSet == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(15);
        }
        if (!resultSet.next()) {
            throw new AssertionError((Object)"Incorrect count query!");
        }
        return resultSet.getLong(1);
    }

    @Override
    @Nullable
    public ObjectKind getTableKind(@NotNull RemoteResultSet resultSet) throws RemoteException, SQLException {
        if (resultSet == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = ExecutionEnvironmentHelper.TimeZoneManager.UNSUPPORTED;
        if (timeZoneManager == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(17);
        }
        return timeZoneManager;
    }

    @Override
    public void runInSpecificEnvironment(@NotNull String sql, @NotNull Configuration configuration, @NotNull DatabaseConnectionCore connection2, @Nullable Project project, @NotNull ThrowableRunnable<Exception> execution) throws Exception {
        if (sql == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(18);
        }
        if (configuration == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(19);
        }
        if (connection2 == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(20);
        }
        if (execution == null) {
            BaseExecutionEnvironmentHelper.$$$reportNull$$$0(21);
        }
        execution.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 10, 14, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/BaseExecutionEnvironmentHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithOrderBy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/BaseExecutionEnvironmentHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderByElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeepAliveQuery";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeZoneManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuery";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrderByElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSufficientExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSslState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getKeepAliveQuery";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRowCount";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTableKind";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runInSpecificEnvironment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 10, 14, 17 -> new IllegalStateException(string);
        };
    }
}

