/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.SqlAffectAnalyzer;
import com.intellij.database.dialects.base.BaseAffectAnalyzer$Companion$parseQualifiedIdentifier$;
import com.intellij.database.introspection.Impactees;
import com.intellij.database.introspection.ImpacteesBuilder;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlCreateSynonymStatementImpl;
import com.intellij.sql.psi.impl.SqlDropStatementImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer;", "Lcom/intellij/database/dialects/SqlAffectAnalyzer;", "()V", "determineAffectedObjects", "Lcom/intellij/database/introspection/Impactees;", "dbms", "Lcom/intellij/database/Dbms;", "script", "", "Lcom/intellij/psi/PsiElement;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "prepareDeterminer", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "Companion", "Determiner", "MultiDatabaseDeterminer", "SingleDatabaseDeterminer", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
public class BaseAffectAnalyzer
implements SqlAffectAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final boolean checkObjectPaths;

    @Override
    @NotNull
    public Impactees determineAffectedObjects(@NotNull Dbms dbms, @NotNull List<? extends PsiElement> script2, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter(script2, (String)"script");
        if (script2.isEmpty()) {
            return Impactees.EMPTY;
        }
        Determiner determiner = this.prepareDeterminer(dbms, searchPath);
        for (PsiElement psiElement : script2) {
            determiner.analyze(psiElement);
        }
        return determiner.getImpactees();
    }

    @NotNull
    protected Determiner prepareDeterminer(@NotNull Dbms dbms, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return ModelFun.isMultiDatabase(dbms) ? (Determiner)new MultiDatabaseDeterminer(searchPath) : (Determiner)new SingleDatabaseDeterminer(searchPath);
    }

    static {
        Application $this$checkObjectPaths_u24lambda_u240 = ApplicationManager.getApplication();
        boolean bl = false;
        checkObjectPaths = $this$checkObjectPaths_u24lambda_u240.isInternal() || $this$checkObjectPaths_u24lambda_u240.isUnitTestMode();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u0012*\u00020\u0012H\u0086\b\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion;", "", "()V", "checkObjectPaths", "", "parseQualifiedIdentifier", "", "Lcom/intellij/sql/psi/SqlNameElement;", "str", "", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "skip", "", "child", "P", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,276:1\n223#2,2:277\n473#3:279\n*S KotlinDebug\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n*L\n268#1:277,2\n268#1:279\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <P extends PsiElement> P child(PsiElement $this$child) {
            Intrinsics.checkNotNullParameter((Object)$this$child, (String)"<this>");
            boolean $i$f$child = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"P");
            return (P)PsiTreeUtil.findChildOfType((PsiElement)$this$child, PsiElement.class, (boolean)false);
        }

        @Nullable
        public final List<SqlNameElement> parseQualifiedIdentifier(@NotNull String str, @NotNull SqlLanguageDialect dialect, @NotNull Project project, int skip) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(str, dialect, project, null);
            if (sqlExpression == null) {
                return null;
            }
            SqlExpression exp = sqlExpression;
            PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)exp;
            boolean childrenFirst$iv = false;
            boolean $i$f$descendantsOfType = false;
            Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)Companion$parseQualifiedIdentifier$$inlined$descendantsOfType$default$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            List names1 = SequencesKt.toList((Sequence)sequence);
            if (names1.size() <= skip) {
                return null;
            }
            List names2 = skip <= 0 ? names1 : names1.subList(0, names1.size() - skip);
            return CollectionsKt.asReversed((List)names2);
        }

        public static /* synthetic */ List parseQualifiedIdentifier$default(Companion companion, String string, SqlLanguageDialect sqlLanguageDialect, Project project, int n, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n = 0;
            }
            return companion.parseQualifiedIdentifier(string, sqlLanguageDialect, project, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b$\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H$J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020#H&J0\u0010$\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0004J6\u0010$\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010(H$J*\u0010)\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\b\u0010*\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\rH$J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H$R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006/"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/util/SearchPath;)V", "getSearchPath", "()Lcom/intellij/database/util/SearchPath;", "acceptSchemaObject", "", "actionType", "Lcom/intellij/database/introspection/ImpacteesBuilder$ActionType;", "Lcom/intellij/database/dialects/base/ActionType;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectName", "", "objectQuoted", "", "schemaName", "schemaQuoted", "analyze", "statement", "Lcom/intellij/psi/PsiElement;", "analyzeBatchBlock", "block", "Lcom/intellij/sql/psi/SqlBatchBlock;", "analyzeCallStatement", "Lcom/intellij/sql/psi/SqlCallStatement;", "analyzeDdlStatement", "Lcom/intellij/sql/psi/SqlDdlStatement;", "analyzeRoutineDefinition", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "analyzeStatement", "Lcom/intellij/sql/psi/SqlStatement;", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "handleByNameAndParentRef", "objNameElement", "Lcom/intellij/sql/psi/SqlNameElement;", "parentRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "handleByRef", "ref", "kind", "handleDrop", "dropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner\n+ 2 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Companion\n*L\n1#1,276:1\n260#2:277\n*S KotlinDebug\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner\n*L\n83#1:277\n*E\n"})
    protected static abstract class Determiner {
        @Nullable
        private final SearchPath searchPath;

        public Determiner(@Nullable SearchPath searchPath) {
            this.searchPath = searchPath;
        }

        @Nullable
        public final SearchPath getSearchPath() {
            return this.searchPath;
        }

        public void analyze(@NotNull PsiElement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            PsiElement psiElement = statement2;
            if (psiElement instanceof SqlBatchBlock) {
                this.analyzeBatchBlock((SqlBatchBlock)statement2);
            } else if (psiElement instanceof SqlStatement) {
                this.analyzeStatement((SqlStatement)statement2);
            }
        }

        protected void analyzeBatchBlock(@NotNull SqlBatchBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            PsiElement[] psiElementArray = block.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            for (PsiElement innerElement : psiElementArray) {
                Intrinsics.checkNotNull((Object)innerElement);
                this.analyze(innerElement);
            }
        }

        protected void analyzeStatement(@NotNull SqlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlStatement sqlStatement = statement2;
            if (sqlStatement instanceof SqlDdlStatement) {
                this.analyzeDdlStatement((SqlDdlStatement)statement2);
            } else if (sqlStatement instanceof SqlCallStatement) {
                this.analyzeCallStatement((SqlCallStatement)statement2);
            }
        }

        protected void analyzeDdlStatement(@NotNull SqlDdlStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlDdlStatement sqlDdlStatement = statement2;
            if (sqlDdlStatement instanceof SqlTableDefinition) {
                this.handleByRef(ImpacteesBuilder.ActionType.ALTER, ((SqlTableDefinition)statement2).getNameElement(), ((SqlTableDefinition)statement2).getKind());
            } else if (sqlDdlStatement instanceof SqlRoutineDefinition) {
                this.analyzeRoutineDefinition((SqlRoutineDefinition)statement2);
            } else if (sqlDdlStatement instanceof SqlConstraintDefinition) {
                Determiner.handleByRef$default(this, ImpacteesBuilder.ActionType.ALTER, ((SqlConstraintDefinition)statement2).getParentRef(), null, 4, null);
            } else if (sqlDdlStatement instanceof SqlAlterStatement) {
                Determiner.handleByRef$default(this, ImpacteesBuilder.ActionType.ALTER, ((SqlAlterStatement)statement2).getAlterTargetReference(), null, 4, null);
            } else if (sqlDdlStatement instanceof SqlDropStatementImpl) {
                this.handleByRef(ImpacteesBuilder.ActionType.DROP, ((SqlDropStatementImpl)statement2).getTargetExpression(), ((SqlDropStatementImpl)statement2).getTargetType());
            } else if (sqlDdlStatement instanceof SqlCreateIndexStatement) {
                this.handleByRef(ImpacteesBuilder.ActionType.ALTER, ((SqlCreateIndexStatement)statement2).getTargetReference(), ObjectKind.TABLE);
            } else if (sqlDdlStatement instanceof SqlCreateTriggerStatement) {
                Determiner.handleByRef$default(this, ImpacteesBuilder.ActionType.ALTER, ((SqlCreateTriggerStatement)statement2).getTargetContextExpression(), null, 4, null);
            } else if (sqlDdlStatement instanceof SqlCreateSynonymStatementImpl) {
                Companion companion = Companion;
                PsiElement $this$child$iv = (PsiElement)statement2;
                boolean $i$f$child = false;
                Determiner.handleByRef$default(this, ImpacteesBuilder.ActionType.ALTER, (SqlReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, SqlReferenceExpression.class, (boolean)false), null, 4, null);
            }
        }

        protected void analyzeRoutineDefinition(@NotNull SqlRoutineDefinition statement2) {
            SqlReferenceExpression x;
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            SqlNameElement sqlNameElement = statement2.getNameElement();
            if (sqlNameElement == null) {
                return;
            }
            SqlNameElement nameElement = sqlNameElement;
            SqlReferenceExpression sqlReferenceExpression = x = nameElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)nameElement : null;
            String schemaName = sqlReferenceExpression != null ? sqlReferenceExpression.getReferencePart(ObjectKind.SCHEMA) : null;
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            String string = nameElement.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.acceptSchemaObject(ImpacteesBuilder.ActionType.ALTER, objectKind, string, nameElement.isQuotedIdentifier(), schemaName, schemaName != null);
        }

        protected void analyzeCallStatement(@NotNull SqlCallStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        }

        protected abstract void handleByRef(@NotNull ImpacteesBuilder.ActionType var1, @Nullable SqlReferenceExpression var2, @Nullable ObjectKind var3);

        public static /* synthetic */ void handleByRef$default(Determiner determiner, ImpacteesBuilder.ActionType actionType, SqlReferenceExpression sqlReferenceExpression, ObjectKind objectKind, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleByRef");
            }
            if ((n & 4) != 0) {
                objectKind = null;
            }
            determiner.handleByRef(actionType, sqlReferenceExpression, objectKind);
        }

        protected final void handleByNameAndParentRef(@NotNull ImpacteesBuilder.ActionType actionType, @NotNull ObjectKind objectKind, @Nullable SqlNameElement objNameElement, @Nullable SqlReferenceExpression parentRef) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            if (objNameElement != null) {
                String string = objNameElement.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.handleByNameAndParentRef(actionType, objectKind, string, objNameElement.isQuotedIdentifier(), parentRef);
            }
        }

        protected abstract void handleByNameAndParentRef(@NotNull ImpacteesBuilder.ActionType var1, @NotNull ObjectKind var2, @NotNull String var3, boolean var4, @Nullable SqlReferenceExpression var5);

        protected abstract void handleDrop(@NotNull SqlDropStatementImpl var1);

        protected abstract void acceptSchemaObject(@NotNull ImpacteesBuilder.ActionType var1, @NotNull ObjectKind var2, @NotNull String var3, boolean var4, @Nullable String var5, boolean var6);

        @NotNull
        public abstract Impactees getImpactees();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004JP\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0019H\u0004J*\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0004J>\u0010!\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020\u0019H\u0014J\b\u0010$\u001a\u00020%H\u0016J6\u0010&\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J(\u0010)\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\b\u0010*\u001a\u0004\u0018\u00010(2\b\u0010+\u001a\u0004\u0018\u00010\u0015H\u0014J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006/"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$MultiDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/util/SearchPath;)V", "b", "Lcom/intellij/database/introspection/ImpacteesBuilder;", "getB", "()Lcom/intellij/database/introspection/ImpacteesBuilder;", "currDatabase", "Lcom/intellij/database/util/ObjectPath;", "getCurrDatabase", "()Lcom/intellij/database/util/ObjectPath;", "currSchema", "getCurrSchema", "acceptObject", "", "actionType", "Lcom/intellij/database/introspection/ImpacteesBuilder$ActionType;", "Lcom/intellij/database/dialects/base/ActionType;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectName", "", "objectNameIsQuoted", "", "schemaName", "schemaNameIsQuoted", "databaseName", "databaseNameIsQuoted", "qi", "", "Lcom/intellij/sql/psi/SqlNameElement;", "acceptSchemaObject", "objectQuoted", "schemaQuoted", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "handleByNameAndParentRef", "parentRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "handleByRef", "ref", "kind", "handleDrop", "dropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$MultiDatabaseDeterminer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
    protected static class MultiDatabaseDeterminer
    extends Determiner {
        @NotNull
        private final ObjectPath currDatabase;
        @NotNull
        private final ObjectPath currSchema;
        @NotNull
        private final ImpacteesBuilder b;

        public MultiDatabaseDeterminer(@Nullable SearchPath searchPath) {
            Object object;
            block11: {
                block10: {
                    Object v6;
                    MultiDatabaseDeterminer multiDatabaseDeterminer;
                    MultiDatabaseDeterminer multiDatabaseDeterminer2;
                    block7: {
                        ObjectPath it2;
                        Iterable iterable;
                        Iterable iterable2;
                        Object object2;
                        block9: {
                            block8: {
                                Object v2;
                                MultiDatabaseDeterminer multiDatabaseDeterminer3;
                                block6: {
                                    super(searchPath);
                                    multiDatabaseDeterminer3 = this;
                                    object2 = searchPath;
                                    if (object2 == null || (object2 = ((SearchPath)object2).elements) == null) break block8;
                                    iterable2 = (Iterable)object2;
                                    multiDatabaseDeterminer2 = multiDatabaseDeterminer3;
                                    iterable = iterable2;
                                    for (Object t : iterable) {
                                        it2 = (ObjectPath)t;
                                        boolean bl = false;
                                        if (!Intrinsics.areEqual((Object)it2.kind, (Object)ObjectKind.DATABASE)) continue;
                                        v2 = t;
                                        break block6;
                                    }
                                    v2 = null;
                                }
                                multiDatabaseDeterminer3 = multiDatabaseDeterminer2;
                                object2 = v2;
                                if (object2 != null) break block9;
                            }
                            ObjectPath objectPath = ObjectPath.create("@", ObjectKind.DATABASE);
                            object2 = objectPath;
                            Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"create(...)");
                        }
                        multiDatabaseDeterminer3.currDatabase = object2;
                        multiDatabaseDeterminer = this;
                        object = searchPath;
                        if (object == null || (object = ((SearchPath)object).elements) == null) break block10;
                        iterable2 = (Iterable)object;
                        multiDatabaseDeterminer2 = multiDatabaseDeterminer;
                        iterable = iterable2;
                        for (Object t : iterable) {
                            it2 = (ObjectPath)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it2.kind, (Object)ObjectKind.SCHEMA)) continue;
                            v6 = t;
                            break block7;
                        }
                        v6 = null;
                    }
                    multiDatabaseDeterminer = multiDatabaseDeterminer2;
                    object = v6;
                    if (object != null) break block11;
                }
                ObjectPath objectPath = this.currDatabase.append("@", ObjectKind.SCHEMA);
                object = objectPath;
                Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"append(...)");
            }
            multiDatabaseDeterminer.currSchema = object;
            this.b = new ImpacteesBuilder(this.currDatabase, this.currSchema, checkObjectPaths);
        }

        @NotNull
        protected final ObjectPath getCurrDatabase() {
            return this.currDatabase;
        }

        @NotNull
        protected final ObjectPath getCurrSchema() {
            return this.currSchema;
        }

        @NotNull
        protected final ImpacteesBuilder getB() {
            return this.b;
        }

        @Override
        protected void handleByRef(@NotNull ImpacteesBuilder.ActionType actionType, @Nullable SqlReferenceExpression ref2, @Nullable ObjectKind kind) {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            if (ref2 == null) {
                return;
            }
            ObjectKind objectKind = kind;
            if (objectKind == null) {
                ObjectKind objectKind2 = ref2.getReferenceElementType().getTargetKind();
                objectKind = objectKind2;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"getTargetKind(...)");
            }
            ObjectKind objKind = objectKind;
            String string3 = ref2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            String objName = string3;
            String it2 = string2 = ref2.getReferencePart(ObjectKind.SCHEMA);
            boolean bl = false;
            String schemaName = !Intrinsics.areEqual((Object)it2, (Object)ModelConsts.NO_NAME) ? string2 : null;
            String it3 = string = ref2.getReferencePart(ObjectKind.DATABASE);
            boolean bl2 = false;
            String databaseName = !Intrinsics.areEqual((Object)it3, (Object)ModelConsts.NO_NAME) ? string : null;
            this.acceptObject(actionType, objKind, objName, ref2.isQuoted(), schemaName, false, databaseName, false);
        }

        @Override
        protected void handleByNameAndParentRef(@NotNull ImpacteesBuilder.ActionType actionType, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectQuoted, @Nullable SqlReferenceExpression parentRef) {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            SqlReferenceExpression sqlReferenceExpression = parentRef;
            String it2 = string2 = sqlReferenceExpression != null ? sqlReferenceExpression.getReferencePart(ObjectKind.SCHEMA) : null;
            boolean bl = false;
            String schemaName = !Intrinsics.areEqual((Object)it2, (Object)ModelConsts.NO_NAME) ? string2 : null;
            SqlReferenceExpression sqlReferenceExpression2 = parentRef;
            String it3 = string = sqlReferenceExpression2 != null ? sqlReferenceExpression2.getReferencePart(ObjectKind.DATABASE) : null;
            boolean bl2 = false;
            String databaseName = !Intrinsics.areEqual((Object)it3, (Object)ModelConsts.NO_NAME) ? string : null;
            this.acceptObject(actionType, objectKind, objectName, objectQuoted, schemaName, false, databaseName, false);
        }

        @Override
        protected void acceptSchemaObject(@NotNull ImpacteesBuilder.ActionType actionType, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectQuoted, @Nullable String schemaName, boolean schemaQuoted) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            if (schemaName != null) {
                this.b.include(actionType, schemaName, schemaQuoted, objectName, objectQuoted, objectKind);
            } else {
                this.b.include(actionType, objectName, objectQuoted, objectKind);
            }
        }

        protected final void acceptObject(@NotNull ImpacteesBuilder.ActionType actionType, @NotNull ObjectKind objectKind, @NotNull List<? extends SqlNameElement> qi) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter(qi, (String)"qi");
            switch (qi.size()) {
                case 1: {
                    String string = qi.get(0).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.acceptObject(actionType, objectKind, string, qi.get(0).isQuotedIdentifier(), null, false, null, false);
                    break;
                }
                case 2: {
                    String string = qi.get(0).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.acceptObject(actionType, objectKind, string, qi.get(0).isQuotedIdentifier(), qi.get(1).getName(), qi.get(1).isQuotedIdentifier(), null, false);
                    break;
                }
                case 3: {
                    String string = qi.get(0).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.acceptObject(actionType, objectKind, string, qi.get(0).isQuotedIdentifier(), qi.get(1).getName(), qi.get(1).isQuotedIdentifier(), qi.get(2).getName(), qi.get(2).isQuotedIdentifier());
                }
            }
        }

        protected final void acceptObject(@NotNull ImpacteesBuilder.ActionType actionType, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectNameIsQuoted, @Nullable String schemaName, boolean schemaNameIsQuoted, @Nullable String databaseName, boolean databaseNameIsQuoted) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            if (databaseName != null) {
                this.b.include(actionType, databaseName, databaseNameIsQuoted, schemaName, schemaNameIsQuoted, objectName, objectNameIsQuoted, objectKind);
            } else if (schemaName != null) {
                this.b.include(actionType, schemaName, schemaNameIsQuoted, objectName, objectNameIsQuoted, objectKind);
            } else {
                this.b.include(actionType, objectName, objectNameIsQuoted, objectKind);
            }
        }

        @Override
        protected void handleDrop(@NotNull SqlDropStatementImpl dropStatement) {
            ObjectKind objectKind;
            SqlReferenceExpression contextExpression;
            Intrinsics.checkNotNullParameter((Object)((Object)dropStatement), (String)"dropStatement");
            SqlReferenceExpression sqlReferenceExpression = dropStatement.getTargetExpression();
            if (sqlReferenceExpression == null) {
                return;
            }
            SqlReferenceExpression originRef = sqlReferenceExpression;
            SqlReferenceExpression sqlReferenceExpression2 = contextExpression = dropStatement.getTargetContextExpression();
            String databaseName = sqlReferenceExpression2 != null ? sqlReferenceExpression2.getReferencePart(ObjectKind.DATABASE) : null;
            SqlReferenceExpression sqlReferenceExpression3 = contextExpression;
            String schemaName = sqlReferenceExpression3 != null ? sqlReferenceExpression3.getReferencePart(ObjectKind.DATABASE) : null;
            ObjectKind it2 = objectKind = originRef.getKind();
            boolean bl = false;
            ObjectKind objectKind2 = !(Intrinsics.areEqual((Object)it2, (Object)ObjectKind.NONE) || Intrinsics.areEqual((Object)it2, (Object)SqlDbElementType.ANY)) ? objectKind : null;
            if (objectKind2 == null) {
                return;
            }
            ObjectKind objectKind3 = objectKind2;
            if (databaseName == null) {
                if (schemaName == null) {
                    String string = originRef.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.b.include(ImpacteesBuilder.ActionType.DROP, string, originRef.isQuoted(), objectKind3);
                } else {
                    String string = originRef.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.b.include(ImpacteesBuilder.ActionType.DROP, schemaName, true, string, originRef.isQuoted(), objectKind3);
                }
            } else {
                String string = originRef.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.b.include(ImpacteesBuilder.ActionType.DROP, databaseName, true, schemaName, true, string, originRef.isQuoted(), objectKind3);
            }
        }

        @Override
        @NotNull
        public Impactees getImpactees() {
            return this.b.build();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u0017H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J6\u0010\u001c\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J(\u0010\u001f\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010 \u001a\u0004\u0018\u00010\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u0013H\u0014J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer;", "Lcom/intellij/database/dialects/base/BaseAffectAnalyzer$Determiner;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/util/SearchPath;)V", "b", "Lcom/intellij/database/introspection/ImpacteesBuilder;", "getB", "()Lcom/intellij/database/introspection/ImpacteesBuilder;", "currSchema", "Lcom/intellij/database/util/ObjectPath;", "getCurrSchema", "()Lcom/intellij/database/util/ObjectPath;", "acceptSchemaObject", "", "actionType", "Lcom/intellij/database/introspection/ImpacteesBuilder$ActionType;", "Lcom/intellij/database/dialects/base/ActionType;", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectName", "", "objectQuoted", "", "schemaName", "schemaQuoted", "getImpactees", "Lcom/intellij/database/introspection/Impactees;", "handleByNameAndParentRef", "parentRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "handleByRef", "ref", "kind", "handleDrop", "dropStatement", "Lcom/intellij/sql/psi/impl/SqlDropStatementImpl;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nBaseAffectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAffectAnalyzer.kt\ncom/intellij/database/dialects/base/BaseAffectAnalyzer$SingleDatabaseDeterminer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n1#2:277\n*E\n"})
    protected static class SingleDatabaseDeterminer
    extends Determiner {
        @NotNull
        private final ObjectPath currSchema;
        @NotNull
        private final ImpacteesBuilder b;

        public SingleDatabaseDeterminer(@Nullable SearchPath searchPath) {
            Object object;
            block5: {
                block4: {
                    Object v2;
                    SingleDatabaseDeterminer singleDatabaseDeterminer;
                    SingleDatabaseDeterminer singleDatabaseDeterminer2;
                    block3: {
                        super(searchPath);
                        singleDatabaseDeterminer2 = this;
                        object = searchPath;
                        if (object == null || (object = ((SearchPath)object).elements) == null) break block4;
                        Iterable iterable = (Iterable)object;
                        singleDatabaseDeterminer = singleDatabaseDeterminer2;
                        Iterable iterable2 = iterable;
                        for (Object t : iterable2) {
                            ObjectPath it2 = (ObjectPath)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it2.kind, (Object)ObjectKind.SCHEMA)) continue;
                            v2 = t;
                            break block3;
                        }
                        v2 = null;
                    }
                    singleDatabaseDeterminer2 = singleDatabaseDeterminer;
                    object = v2;
                    if (object != null) break block5;
                }
                ObjectPath objectPath = ObjectPath.create("@", ObjectKind.SCHEMA);
                object = objectPath;
                Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"create(...)");
            }
            singleDatabaseDeterminer2.currSchema = object;
            this.b = new ImpacteesBuilder(null, this.currSchema, checkObjectPaths);
        }

        @NotNull
        protected final ObjectPath getCurrSchema() {
            return this.currSchema;
        }

        @NotNull
        protected final ImpacteesBuilder getB() {
            return this.b;
        }

        @Override
        protected void handleByRef(@NotNull ImpacteesBuilder.ActionType actionType, @Nullable SqlReferenceExpression ref2, @Nullable ObjectKind kind) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            if (ref2 == null) {
                return;
            }
            ObjectKind objectKind = kind;
            if (objectKind == null) {
                ObjectKind objectKind2;
                ObjectKind it2 = objectKind2 = ref2.getReferenceElementType().getTargetKind();
                boolean string2 = false;
                objectKind = !Intrinsics.areEqual((Object)it2, (Object)SqlDbElementType.ANY) ? objectKind2 : null;
                if (objectKind == null) {
                    objectKind = ObjectKind.TABLE;
                }
            }
            ObjectKind objKind = objectKind;
            String string3 = ref2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            String objName = string3;
            boolean objQuoted = ref2.isQuoted();
            String it3 = string2 = ref2.getReferencePart(ObjectKind.SCHEMA);
            boolean bl = false;
            String schemaName = !Intrinsics.areEqual((Object)it3, (Object)ModelConsts.NO_NAME) ? string2 : null;
            boolean schemaQuoted = schemaName != null;
            Intrinsics.checkNotNull((Object)objKind);
            this.acceptSchemaObject(actionType, objKind, objName, objQuoted, schemaName, schemaQuoted);
        }

        @Override
        protected void handleByNameAndParentRef(@NotNull ImpacteesBuilder.ActionType actionType, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectQuoted, @Nullable SqlReferenceExpression parentRef) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            SqlReferenceExpression sqlReferenceExpression = parentRef;
            String it2 = string = sqlReferenceExpression != null ? sqlReferenceExpression.getReferencePart(ObjectKind.SCHEMA) : null;
            boolean bl = false;
            String schemaName = !Intrinsics.areEqual((Object)it2, (Object)ModelConsts.NO_NAME) ? string : null;
            boolean schemaQuoted = schemaName != null;
            this.acceptSchemaObject(actionType, objectKind, objectName, objectQuoted, schemaName, schemaQuoted);
        }

        @Override
        protected void acceptSchemaObject(@NotNull ImpacteesBuilder.ActionType actionType, @NotNull ObjectKind objectKind, @NotNull String objectName, boolean objectQuoted, @Nullable String schemaName, boolean schemaQuoted) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            if (schemaName != null) {
                this.b.include(actionType, schemaName, schemaQuoted, objectName, objectQuoted, objectKind);
            } else {
                this.b.include(actionType, objectName, objectQuoted, objectKind);
            }
        }

        @Override
        protected void handleDrop(@NotNull SqlDropStatementImpl dropStatement) {
            Intrinsics.checkNotNullParameter((Object)((Object)dropStatement), (String)"dropStatement");
            Determiner.handleByRef$default(this, ImpacteesBuilder.ActionType.DROP, dropStatement.getTargetExpression(), null, 4, null);
        }

        @Override
        @NotNull
        public Impactees getImpactees() {
            return this.b.build();
        }
    }
}

