/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.csv.CsvFormatEditor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponentBase;
import com.intellij.database.dbimport.ui.csv.CharsetComponent;
import com.intellij.database.dbimport.ui.csv.CsvFormatComponent;
import com.intellij.database.dbimport.ui.database.TargetSchemaComponent;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TransparentSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportPanel
extends JBLoadingPanel {
    private static final int INSET = 3;
    private final Project myProject;
    private final TabbedPaneWrapper myPane;
    private final List<ImportComponent<?, ?>> myComponents;
    private final Disposable myDisposable;
    private final ImportSourceType mySourceType;
    private final ImportInfo.Builder myBuilder;
    private final GraphObservable<ImportEditorContext> myObservable;
    private final ErrorNotificationWrapperPanel myErrorNotificationPanel;

    public ImportPanel(@NotNull Project project, @NotNull List<ImportComponent<?, ?>> components, @NotNull Collection<ImportComponent<?, ?>> invisibleComponents, @NotNull ImportInfo.Builder builder, @NotNull Disposable disposable, @NotNull ImportSourceType sourceType) {
        if (project == null) {
            ImportPanel.$$$reportNull$$$0(0);
        }
        if (components == null) {
            ImportPanel.$$$reportNull$$$0(1);
        }
        if (invisibleComponents == null) {
            ImportPanel.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            ImportPanel.$$$reportNull$$$0(3);
        }
        if (disposable == null) {
            ImportPanel.$$$reportNull$$$0(4);
        }
        if (sourceType == null) {
            ImportPanel.$$$reportNull$$$0(5);
        }
        super((LayoutManager)new BorderLayout(), disposable);
        this.myProject = project;
        this.myComponents = components;
        this.myDisposable = disposable;
        this.mySourceType = sourceType;
        JBIterable.from(this.myComponents).forEach(component2 -> component2.setImportPanel(this));
        this.myBuilder = builder;
        this.myErrorNotificationPanel = new ErrorNotificationWrapperPanel();
        this.myObservable = this.createObservable(this.myComponents, invisibleComponents);
        this.myObservable.addListener((Consumer<Throwable>)((Consumer)t -> {
            this.reportError((Throwable)t);
            this.revalidate();
            this.repaint();
        }));
        this.myPane = new TabbedPaneWrapper(this.myDisposable);
        DataManager.registerDataProvider((JComponent)((Object)this), key2 -> {
            if (!CsvFormatEditor.CSV_FORMAT_EDITOR_KEY.is(key2)) {
                return null;
            }
            CsvFormatComponent formatComponent = this.getFormatComponent();
            return formatComponent != null ? formatComponent.getFormatsUI().getFormatForm() : null;
        });
    }

    @NotNull
    public ImportPanel initializer(@NotNull ImportEditorContext initializer) {
        if (initializer == null) {
            ImportPanel.$$$reportNull$$$0(6);
        }
        this.myObservable.initializer(initializer);
        ImportPanel importPanel = this;
        if (importPanel == null) {
            ImportPanel.$$$reportNull$$$0(7);
        }
        return importPanel;
    }

    @NotNull
    public CompletionStage<?> init(boolean requestFocus, boolean focusOnSchemaComboBox) {
        this.startLoading();
        CompletionStage<Object> completionStage = this.myObservable.init().whenComplete((o2, e2) -> {
            this.reportError(AsyncUtil.unwrap(e2));
            this.fillPanel();
            this.stopLoading();
            if (requestFocus) {
                this.requestFocusOnEditor(focusOnSchemaComboBox);
            }
        });
        if (completionStage == null) {
            ImportPanel.$$$reportNull$$$0(8);
        }
        return completionStage;
    }

    public void contextChanged(@NotNull ImportEditorContext context) {
        if (context == null) {
            ImportPanel.$$$reportNull$$$0(9);
        }
        this.myObservable.changed(context);
    }

    public void reportError(@Nullable @NlsContexts.NotificationContent String s2) {
        if (s2 != null) {
            this.myErrorNotificationPanel.reportError(s2);
        }
    }

    private void reportError(@Nullable Throwable t) {
        Optional.ofNullable(t).ifPresent(t1 -> {
            ErrorHandler handler2 = new ErrorHandler();
            handler2.addError(null, t1);
            this.reportError(handler2.getSummary());
        });
    }

    private void requestFocusOnEditor(boolean focusOnSchemaComboBox) {
        IdeFocusManager instance = IdeFocusManager.getInstance((Project)this.myProject);
        instance.doWhenFocusSettlesDown(() -> {
            if (focusOnSchemaComboBox) {
                instance.requestFocus((Component)this.getTargetSchemaComponent().getPreferredFocusedComponent(), true);
            } else {
                JComponent editor2 = this.getTableEditorComponentBase().getPreferredFocusedComponent();
                if (editor2 != null) {
                    instance.requestFocus((Component)editor2, true);
                }
            }
        });
    }

    @NotNull
    public ImportInfo getImportInfo(@NotNull ImportEditorContext context) {
        if (context == null) {
            ImportPanel.$$$reportNull$$$0(10);
        }
        for (ImportComponent<?, ?> component2 : this.myComponents) {
            component2.build(this.myBuilder, context);
        }
        ImportInfo importInfo = this.myBuilder.build(this.mySourceType);
        if (importInfo == null) {
            ImportPanel.$$$reportNull$$$0(11);
        }
        return importInfo;
    }

    @Nullable
    public ValidationInfo validationInfo() {
        for (ImportComponent<?, ?> component2 : this.myComponents) {
            ValidationInfo info2 = component2.validate();
            if (info2 == null) continue;
            return info2;
        }
        return null;
    }

    private void fillPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.fillTabbedPane();
        JComponent paneComponent = this.myPane.getComponent();
        paneComponent.setBorder((Border)JBUI.Borders.emptyTop((int)3));
        JComponent editorComponent = this.getTableEditorComponentBase().getComponent();
        editorComponent.setBorder((Border)JBUI.Borders.emptyBottom((int)3));
        TransparentSplitter splitter = new TransparentSplitter(true);
        splitter.setFirstComponent(editorComponent);
        splitter.setSecondComponent(paneComponent);
        JPanel right = new JPanel(new BorderLayout());
        TargetSchemaComponent schemaComponent = this.getTargetSchemaComponent();
        right.add((Component)schemaComponent.getComponent(), "North");
        right.add((Component)splitter, "Center");
        right.add((Component)this.createSettingsPanel(), "South");
        mainPanel.add((Component)right, "Center");
        CsvFormatComponent component2 = this.getFormatComponent();
        if (component2 != null) {
            mainPanel.add((Component)component2.getComponent(), "West");
        }
        this.add(mainPanel, "Center");
        this.add(this.myErrorNotificationPanel, "South");
    }

    private void fillTabbedPane() {
        int i2 = 0;
        DataPreviewComponent<?, ?> previewComponent = this.getPreviewComponent();
        if (previewComponent != null) {
            String title = DatabaseBundle.message("database.data.import.data.preview.tab.title", new Object[0]);
            this.myPane.insertTab(title, null, ImportPanel.setTabBorder(previewComponent.getComponent()), null, i2++);
        }
        DdlPreviewComponent ddlComponent = this.getDdlComponent();
        String ddlPreviewTitle = DatabaseBundle.message("database.data.import.ddl.preview.tab.title", new Object[0]);
        this.myPane.insertTab(ddlPreviewTitle, null, ddlComponent.getComponent(), null, i2);
        this.listenText(ddlComponent, i2);
    }

    @NotNull
    private static JComponent setTabBorder(JComponent component2) {
        component2.setBorder(IdeBorderFactory.createBorder((int)13));
        JComponent jComponent = component2;
        if (jComponent == null) {
            ImportPanel.$$$reportNull$$$0(12);
        }
        return jComponent;
    }

    private void listenText(@NotNull DdlPreviewComponent component2, int index2) {
        if (component2 == null) {
            ImportPanel.$$$reportNull$$$0(13);
        }
        component2.getDdlPreview().addDocumentListener(() -> {
            ImportEditorContext context = component2.getCurrentContext();
            boolean tableExists = context != null && context.getImportType(this.getTableName(context)).tableExists();
            String text2 = component2.getDdlPreviewText();
            this.myPane.setIconAt(index2, !tableExists || StringUtil.isEmptyOrSpaces((String)text2) ? null : AllIcons.General.Warning);
        }, this.myDisposable);
    }

    @NotNull
    public DeTable getDeTable(@NotNull ImportEditorContext context) {
        if (context == null) {
            ImportPanel.$$$reportNull$$$0(14);
        }
        DeTable deTable = this.getTableEditorComponent().getDeTable(context);
        if (deTable == null) {
            ImportPanel.$$$reportNull$$$0(15);
        }
        return deTable;
    }

    @NotNull
    public String getTableName(@NotNull ImportEditorContext context) {
        if (context == null) {
            ImportPanel.$$$reportNull$$$0(16);
        }
        String string = this.getTableEditorComponentBase().getTableName(context);
        if (string == null) {
            ImportPanel.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public DdlPreviewComponent getDdlComponent() {
        DdlPreviewComponent ddlPreviewComponent = Objects.requireNonNull(this.getComponent(DdlPreviewComponent.class));
        if (ddlPreviewComponent == null) {
            ImportPanel.$$$reportNull$$$0(18);
        }
        return ddlPreviewComponent;
    }

    @NotNull
    public TableEditorComponent getTableEditorComponent() {
        TableEditorComponent tableEditorComponent = Objects.requireNonNull(this.getComponent(TableEditorComponent.class));
        if (tableEditorComponent == null) {
            ImportPanel.$$$reportNull$$$0(19);
        }
        return tableEditorComponent;
    }

    @NotNull
    public DataPreviewComponent<?, ?> getDataPreviewComponent() {
        DataPreviewComponent dataPreviewComponent = Objects.requireNonNull(this.getComponent(DataPreviewComponent.class));
        if (dataPreviewComponent == null) {
            ImportPanel.$$$reportNull$$$0(20);
        }
        return dataPreviewComponent;
    }

    @NotNull
    public TableEditorComponentBase<?, ?> getTableEditorComponentBase() {
        TableEditorComponentBase tableEditorComponentBase = Objects.requireNonNull(this.getComponent(TableEditorComponentBase.class));
        if (tableEditorComponentBase == null) {
            ImportPanel.$$$reportNull$$$0(21);
        }
        return tableEditorComponentBase;
    }

    @NotNull
    protected ImportSettingsComponent getSettingsComponent() {
        ImportSettingsComponent importSettingsComponent = Objects.requireNonNull(this.getComponent(ImportSettingsComponent.class));
        if (importSettingsComponent == null) {
            ImportPanel.$$$reportNull$$$0(22);
        }
        return importSettingsComponent;
    }

    @NotNull
    public TargetSchemaComponent getTargetSchemaComponent() {
        TargetSchemaComponent targetSchemaComponent = Objects.requireNonNull(this.getComponent(TargetSchemaComponent.class));
        if (targetSchemaComponent == null) {
            ImportPanel.$$$reportNull$$$0(23);
        }
        return targetSchemaComponent;
    }

    @Nullable
    protected DataPreviewComponent<?, ?> getPreviewComponent() {
        return this.getComponent(DataPreviewComponent.class);
    }

    @Nullable
    protected CsvFormatComponent getFormatComponent() {
        return this.getComponent(CsvFormatComponent.class);
    }

    @Nullable
    protected CharsetComponent getCharsetComponent() {
        return this.getComponent(CharsetComponent.class);
    }

    @NotNull
    private JComponent createSettingsPanel() {
        JPanel result2 = new JPanel((LayoutManager)new VerticalStackLayout());
        ImportSettingsComponent settingsComponent = this.getSettingsComponent();
        CharsetComponent charsetComponent = this.getCharsetComponent();
        if (charsetComponent == null) {
            JComponent jComponent = settingsComponent.getComponent();
            if (jComponent == null) {
                ImportPanel.$$$reportNull$$$0(24);
            }
            return jComponent;
        }
        ImportSettingsComponent.addStrut(result2);
        result2.add(charsetComponent.getComponent());
        ImportSettingsComponent.addStrut(result2);
        ImportSettingsComponent.addStrut(result2);
        result2.add(settingsComponent.getComponent());
        JPanel jPanel = result2;
        if (jPanel == null) {
            ImportPanel.$$$reportNull$$$0(25);
        }
        return jPanel;
    }

    @NotNull
    private GraphObservable<ImportEditorContext> createObservable(@NotNull List<ImportComponent<?, ?>> components, @NotNull Collection<ImportComponent<?, ?>> invisibleComponents) {
        if (components == null) {
            ImportPanel.$$$reportNull$$$0(26);
        }
        if (invisibleComponents == null) {
            ImportPanel.$$$reportNull$$$0(27);
        }
        GraphObservable<ImportEditorContext> graphObservable = new GraphObservable.Builder().add(components).addInvisible(invisibleComponents).root(this.getTargetSchemaComponent()).build();
        if (graphObservable == null) {
            ImportPanel.$$$reportNull$$$0(28);
        }
        return graphObservable;
    }

    @Nullable
    private <T extends ImportComponent<?, ?>> T getComponent(Class<T> filterBy) {
        return (T)((ImportComponent)JBIterable.from(this.myComponents).filter(filterBy).first());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 11, 12, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invisibleComponents";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/ImportPanel";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/ImportPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "initializer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabBorder";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeTable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPreviewComponent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorComponentBase";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsComponent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSchemaComponent";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPanel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createObservable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initializer";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contextChanged";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getImportInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "listenText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDeTable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTableName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createObservable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 11, 12, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 28 -> new IllegalStateException(string);
        };
    }
}

