/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.TableSettings;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ImportType {
    NEW_TABLE(false){

        @Override
        boolean suitable(DasObject element2) {
            return element2.getKind() == ObjectKind.SCHEMA || element2.getKind() == ObjectKind.DATABASE || element2 instanceof DbDataSource;
        }

        @Override
        @NotNull
        public DeTable createTable(@NotNull ImportEditorContext context, @NotNull DeModel deModel, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @NotNull ImportSourceType sourceType, @Nullable List<? extends ColumnDescriptor> visibleProducers, @Nullable DbTable existingTable, @NotNull String tableName) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (deModel == null) {
                1.$$$reportNull$$$0(1);
            }
            if (descriptors == null) {
                1.$$$reportNull$$$0(2);
            }
            if (sourceType == null) {
                1.$$$reportNull$$$0(3);
            }
            if (tableName == null) {
                1.$$$reportNull$$$0(4);
            }
            DeTable deTable = sourceType.createNewTable(context, deModel, descriptors, rows, visibleProducers, tableName);
            if (deTable == null) {
                1.$$$reportNull$$$0(5);
            }
            return deTable;
        }

        @Override
        @NotNull
        public BasicModTable createTable(@NotNull ImportEditorContext context, @NotNull BasicModModel model2, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @NotNull ImportSourceType sourceType, @Nullable List<? extends ColumnDescriptor> visibleProducers, @Nullable BasicTable existingTable, @NotNull String tableName) {
            if (context == null) {
                1.$$$reportNull$$$0(6);
            }
            if (model2 == null) {
                1.$$$reportNull$$$0(7);
            }
            if (descriptors == null) {
                1.$$$reportNull$$$0(8);
            }
            if (sourceType == null) {
                1.$$$reportNull$$$0(9);
            }
            if (tableName == null) {
                1.$$$reportNull$$$0(10);
            }
            BasicModTable basicModTable = sourceType.createNewTable(context, model2, descriptors, rows, visibleProducers, tableName);
            if (basicModTable == null) {
                1.$$$reportNull$$$0(11);
            }
            return basicModTable;
        }

        @Override
        @NotNull
        public TableSettings getCodeGenerationSettings() {
            return new TableSettings(TableSettings.FinalAction.EXEC_IN_DB, TableSettings.CodeType.CREATE_NEW_CODE);
        }

        @Override
        @NotNull
        public CsvFormatUISettings getCsvFormatSettings() {
            CsvFormatUISettings csvFormatUISettings = CsvFormatUISettings.DEFAULT;
            if (csvFormatUISettings == null) {
                1.$$$reportNull$$$0(12);
            }
            return csvFormatUISettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deModel";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableName";
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportType$1";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportType$1";
                    break;
                }
                case 5: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTable";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCsvFormatSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTable";
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 11, 12 -> new IllegalStateException(string);
            };
        }
    }
    ,
    EXISTING_TABLE(true){

        @Override
        boolean suitable(DasObject element2) {
            return element2.getKind() == ObjectKind.TABLE;
        }

        @Override
        @NotNull
        public DeTable createTable(@NotNull ImportEditorContext context, @NotNull DeModel deModel, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @NotNull ImportSourceType sourceType, @Nullable List<? extends ColumnDescriptor> visibleProducers, @Nullable DbTable existingTable, @NotNull String tableName) {
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            if (deModel == null) {
                2.$$$reportNull$$$0(1);
            }
            if (descriptors == null) {
                2.$$$reportNull$$$0(2);
            }
            if (sourceType == null) {
                2.$$$reportNull$$$0(3);
            }
            if (tableName == null) {
                2.$$$reportNull$$$0(4);
            }
            DeTable deTable = ImportUtilCore.createDeTableFromDasObject(Objects.requireNonNull(context.getDataSource()).getModel(), (BasicElement)DbImplUtilCore.unwrap(Objects.requireNonNull(existingTable)), deModel);
            if (deTable == null) {
                2.$$$reportNull$$$0(5);
            }
            return deTable;
        }

        @Override
        @NotNull
        public BasicModTable createTable(@NotNull ImportEditorContext context, @NotNull BasicModModel model2, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @NotNull ImportSourceType sourceType, @Nullable List<? extends ColumnDescriptor> visibleProducers, @Nullable BasicTable existingTable, @NotNull String tableName) {
            if (context == null) {
                2.$$$reportNull$$$0(6);
            }
            if (model2 == null) {
                2.$$$reportNull$$$0(7);
            }
            if (descriptors == null) {
                2.$$$reportNull$$$0(8);
            }
            if (sourceType == null) {
                2.$$$reportNull$$$0(9);
            }
            if (tableName == null) {
                2.$$$reportNull$$$0(10);
            }
            BasicModTable basicModTable = (BasicModTable)ModelLightCopier.copy(model2, Objects.requireNonNull(existingTable), true);
            if (basicModTable == null) {
                2.$$$reportNull$$$0(11);
            }
            return basicModTable;
        }

        @Override
        @NotNull
        public TableSettings getCodeGenerationSettings() {
            return new TableSettings(TableSettings.FinalAction.EXEC_IN_DB, TableSettings.CodeType.ALTER_CODE);
        }

        @Override
        @NotNull
        public CsvFormatUISettings getCsvFormatSettings() {
            CsvFormatUISettings csvFormatUISettings = CsvFormatUISettings.IMPORT_IN_TABLE;
            if (csvFormatUISettings == null) {
                2.$$$reportNull$$$0(12);
            }
            return csvFormatUISettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deModel";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableName";
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportType$2";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportType$2";
                    break;
                }
                case 5: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTable";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCsvFormatSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTable";
                    break;
                }
                case 5: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 11, 12 -> new IllegalStateException(string);
            };
        }
    };

    private final boolean myTableExists;

    private ImportType(boolean exists) {
        this.myTableExists = exists;
    }

    public boolean tableExists() {
        return this.myTableExists;
    }

    @NotNull
    public abstract CsvFormatUISettings getCsvFormatSettings();

    @NotNull
    public abstract TableSettings getCodeGenerationSettings();

    @NotNull
    public abstract DeTable createTable(@NotNull ImportEditorContext var1, @NotNull DeModel var2, @NotNull List<? extends ColumnDescriptor> var3, @Nullable List<? extends GridRow> var4, @NotNull ImportSourceType var5, @Nullable List<? extends ColumnDescriptor> var6, @Nullable DbTable var7, @NotNull String var8);

    @NotNull
    public abstract BasicModTable createTable(@NotNull ImportEditorContext var1, @NotNull BasicModModel var2, @NotNull List<? extends ColumnDescriptor> var3, @Nullable List<? extends GridRow> var4, @NotNull ImportSourceType var5, @Nullable List<? extends ColumnDescriptor> var6, @Nullable BasicTable var7, @NotNull String var8);

    abstract boolean suitable(DasObject var1);

    @Nullable
    public static ImportType of(@NotNull DasObject element2) {
        if (element2 == null) {
            ImportType.$$$reportNull$$$0(0);
        }
        for (ImportType type2 : ImportType.values()) {
            if (!type2.suitable(element2)) continue;
            return type2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportType", "of"));
    }
}

