/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.BatchInsertsStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.dbimport.DatabaseTableSource;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportTarget;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseImportTarget
implements ImportTarget {
    private final DatabaseConnection myConnection;
    private final ImportManager myManager;
    private final boolean mySingleConnection;
    private final JdbcTarget myJdbcTarget;

    public DatabaseImportTarget(@NotNull DatabaseConnection connection2, @NotNull ImportManager manager, boolean singleConnection) {
        if (connection2 == null) {
            DatabaseImportTarget.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DatabaseImportTarget.$$$reportNull$$$0(1);
        }
        this.myConnection = connection2;
        this.myManager = manager;
        this.mySingleConnection = singleConnection;
        this.myJdbcTarget = new JdbcTarget(manager, connection2);
    }

    @Override
    public void beforeImportStart(@NotNull ImportInfo info2) throws Exception {
        if (info2 == null) {
            DatabaseImportTarget.$$$reportNull$$$0(2);
        }
        this.retrieveColumns(info2);
        this.myJdbcTarget.beforeImportStart(info2);
    }

    @Override
    public void afterImportEnd(@NotNull ImportInfo info2) {
        if (info2 == null) {
            DatabaseImportTarget.$$$reportNull$$$0(3);
        }
        this.myJdbcTarget.afterImportEnd(info2);
    }

    @Override
    @NotNull
    public List<ErrorRecord> importBatch(@NotNull ImportInfo info2, @NotNull BatchRecords records) throws SQLException, RemoteException {
        if (info2 == null) {
            DatabaseImportTarget.$$$reportNull$$$0(4);
        }
        if (records == null) {
            DatabaseImportTarget.$$$reportNull$$$0(5);
        }
        List<ErrorRecord> list = this.myJdbcTarget.importBatch(info2, records);
        if (list == null) {
            DatabaseImportTarget.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @Nullable
    public Long getInsertedRows() throws RemoteException {
        return this.myJdbcTarget.getInsertedRows();
    }

    @Override
    @NotNull
    public ImportTarget.Combination combine(@NotNull ReaderTask.Source source) {
        if (source == null) {
            DatabaseImportTarget.$$$reportNull$$$0(7);
        }
        if (source instanceof DatabaseTableSource) {
            LocalDataSource dataSource2;
            DatabaseTableSource dbInput = (DatabaseTableSource)source;
            if (this.mySingleConnection && (dataSource2 = dbInput.getDataSource()) == this.myConnection.getConnectionPoint().getDataSource() && dbInput.isSingleConnection()) {
                ImportTarget.Combination combination = ImportTarget.SerialCombination.INSTANCE;
                if (combination == null) {
                    DatabaseImportTarget.$$$reportNull$$$0(8);
                }
                return combination;
            }
        }
        ImportTarget.Combination combination = ImportTarget.ConcurrentCombination.INSTANCE;
        if (combination == null) {
            DatabaseImportTarget.$$$reportNull$$$0(9);
        }
        return combination;
    }

    private void retrieveColumns(@NotNull ImportInfo info2) throws Exception {
        if (info2 == null) {
            DatabaseImportTarget.$$$reportNull$$$0(10);
        }
        SelectTask task = DmlTaskKt.allColumns(info2.cache().getBasicTable()).version(this.myConnection.getVersion()).limit(1).build(ImportManager.createConfiguredBuilder(info2.getContext()));
        DdlBuilder builder = DmlUtilKt.dmlGenerator(this.myConnection.getDbms()).generate(task).getBuilder();
        List<JdbcColumnDescriptor> columns2 = this.getColumns(this.myConnection, builder);
        if (columns2 != null) {
            info2.setConsumers(columns2);
        }
    }

    @Nullable
    private List<JdbcColumnDescriptor> getColumns(@NotNull DatabaseConnection connection2, @NotNull DdlBuilder builder) throws SQLException {
        if (connection2 == null) {
            DatabaseImportTarget.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            DatabaseImportTarget.$$$reportNull$$$0(12);
        }
        return (List)SmartStatements.poweredBy(connection2).simple().noisy().execute(builder.getStatement(), StandardResultsProcessors.throwableResultsTransformer(rs -> Arrays.asList(JdbcEngineUtils.getColumnDescriptors(rs))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DatabaseImportTarget";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DatabaseImportTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "importBatch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeImportStart";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "afterImportEnd";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importBatch";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "retrieveColumns";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class JdbcTarget
    implements ImportTarget {
        private final ImportManager myManager;
        private final DatabaseConnection myConnection;
        private BatchInsertsStatement myStatement;
        private List<ImportManager.ConnectionStateSwitch> mySwitches;

        JdbcTarget(@NotNull ImportManager manager, @NotNull DatabaseConnection connection2) {
            if (manager == null) {
                JdbcTarget.$$$reportNull$$$0(0);
            }
            if (connection2 == null) {
                JdbcTarget.$$$reportNull$$$0(1);
            }
            this.myManager = manager;
            this.myConnection = connection2;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void beforeImportStart(@NotNull ImportInfo info) throws Exception {
            if (info == null) {
                JdbcTarget.$$$reportNull$$$0(2);
            }
            if ((metaData = this.myConnection.getRemoteMetaData()) == null) ** GOTO lbl-1000
            if (JdbcNativeUtil.getBooleanSafe((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, supportsTransactions(), ()Ljava/lang/Boolean;)((RemoteDatabaseMetaData)metaData)) && this.myManager.shouldUseTransactions()) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = transactions = false;
            }
            if (metaData == null) ** GOTO lbl-1000
            if (JdbcNativeUtil.getBooleanSafe((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, supportsBatchUpdates(), ()Ljava/lang/Boolean;)((RemoteDatabaseMetaData)metaData)) && this.myManager.shouldUseBatches()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = batches = false;
            }
            if (metaData == null) ** GOTO lbl-1000
            if (JdbcNativeUtil.getBooleanSafe((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, supportsSavepoints(), ()Ljava/lang/Boolean;)((RemoteDatabaseMetaData)metaData)) && this.myManager.shouldUseSavepoints()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            savepoints = v2;
            linesPerStatement = this.myManager.getLinesPerStatement();
            this.mySwitches = this.myManager.getConnectionStateSwitches(info);
            for (ImportManager.ConnectionStateSwitch oneSwitch : this.mySwitches) {
                oneSwitch.turnOn(this.myConnection);
            }
            queriesBefore = this.myManager.getFastModeOnQueries(info);
            if (info.shouldLockTable()) {
                JdbcTarget.execute(this.myConnection, queriesBefore);
            }
            if (transactions) {
                this.myConnection.setAutoCommit(false);
            }
            statement = ImportManager.getInsertStatement(info, linesPerStatement);
            oneLine = ImportManager.getInsertStatement(info, 1);
            lockQuery = info.shouldLockTable() != false ? this.myManager.getLockQuery(info) : null;
            columnInfos = info.cache().getColumnInfos();
            configuration = new RemoteBatchPreparedStatementImpl.Configuration(statement, oneLine, lockQuery, columnInfos, transactions, savepoints, batches, linesPerStatement);
            this.myStatement = SmartStatements.poweredBy(this.myConnection).batchInserts(configuration);
        }

        @Override
        @NotNull
        public List<ErrorRecord> importBatch(@NotNull ImportInfo info2, @NotNull BatchRecords records) throws RemoteException, SQLException {
            if (info2 == null) {
                JdbcTarget.$$$reportNull$$$0(3);
            }
            if (records == null) {
                JdbcTarget.$$$reportNull$$$0(4);
            }
            if (records.isEmpty()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JdbcTarget.$$$reportNull$$$0(5);
                }
                return list;
            }
            int lastCount = records.getLinesCount() % this.myManager.getLinesPerStatement();
            String lastSql = ImportManager.getInsertStatement(info2, lastCount == 0 ? this.myManager.getLinesPerStatement() : lastCount);
            List<ErrorRecord> list = this.myStatement.addBatch(records, lastSql);
            if (list == null) {
                JdbcTarget.$$$reportNull$$$0(6);
            }
            return list;
        }

        @Override
        public void afterImportEnd(@NotNull ImportInfo info2) {
            if (info2 == null) {
                JdbcTarget.$$$reportNull$$$0(7);
            }
            if (this.mySwitches == null) {
                return;
            }
            for (ImportManager.ConnectionStateSwitch oneSwitch : this.mySwitches) {
                oneSwitch.turnOff(this.myConnection);
            }
            List<String> queriesAfter = this.myManager.getFastModeOffQueries(info2);
            if (info2.shouldLockTable()) {
                JdbcTarget.executeIgnore(this.myConnection, queriesAfter);
            }
            DbImplUtil.closeSafe(this.myStatement);
        }

        @Override
        @Nullable
        public Long getInsertedRows() throws RemoteException {
            return this.myStatement == null ? null : Long.valueOf(this.myStatement.getInsertedLinesCount());
        }

        @Override
        @NotNull
        public ImportTarget.Combination combine(@NotNull ReaderTask.Source source) {
            if (source == null) {
                JdbcTarget.$$$reportNull$$$0(8);
            }
            throw new UnsupportedOperationException("Mustn't be called");
        }

        private static void execute(@NotNull DatabaseConnection connection2, @NotNull List<String> queries) throws SQLException {
            if (connection2 == null) {
                JdbcTarget.$$$reportNull$$$0(9);
            }
            if (queries == null) {
                JdbcTarget.$$$reportNull$$$0(10);
            }
            try (ReusableSmartStatement<String> statement2 = SmartStatements.poweredBy(connection2).simple().reuse();){
                for (String query : queries) {
                    statement2.barren().execute(query);
                }
            }
        }

        private static void executeIgnore(@NotNull DatabaseConnection connection2, @NotNull List<String> queries) {
            if (connection2 == null) {
                JdbcTarget.$$$reportNull$$$0(11);
            }
            if (queries == null) {
                JdbcTarget.$$$reportNull$$$0(12);
            }
            try {
                JdbcTarget.execute(connection2, queries);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/DatabaseImportTarget$JdbcTarget";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/DatabaseImportTarget$JdbcTarget";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "importBatch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeImportStart";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "importBatch";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "afterImportEnd";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "combine";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "executeIgnore";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

