/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.util.DbUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternBuilder {
    private final StringBuilder myBuilder;
    private final IntArrayList myStack;

    public Pattern compile() {
        return PatternBuilder.compile(this.myBuilder.toString());
    }

    public PatternBuilder wrap(@NotNull CharSequence pre, @NotNull CharSequence post) {
        if (pre == null) {
            PatternBuilder.$$$reportNull$$$0(0);
        }
        if (post == null) {
            PatternBuilder.$$$reportNull$$$0(1);
        }
        this.myBuilder.insert(this.floor(), pre);
        this.myBuilder.append(post);
        return this;
    }

    public PatternBuilder prepend(@NotNull CharSequence pre) {
        if (pre == null) {
            PatternBuilder.$$$reportNull$$$0(2);
        }
        this.myBuilder.insert(this.floor(), pre);
        return this;
    }

    public PatternBuilder append(@NotNull CharSequence post) {
        if (post == null) {
            PatternBuilder.$$$reportNull$$$0(3);
        }
        this.myBuilder.append(post);
        return this;
    }

    public PatternBuilder append(@NotNull PatternBuilder post) {
        if (post == null) {
            PatternBuilder.$$$reportNull$$$0(4);
        }
        return this.append(post.myBuilder);
    }

    public PatternBuilder appendQuoted(@NotNull String post) {
        if (post == null) {
            PatternBuilder.$$$reportNull$$$0(5);
        }
        return this.append(Pattern.quote(post));
    }

    public PatternBuilder push() {
        this.myStack.push(this.myBuilder.length());
        return this;
    }

    public PatternBuilder pop() {
        assert (this.myStack.size() != 0);
        this.myStack.pop();
        return this;
    }

    public PatternBuilder append(@NotNull Pattern pattern2) {
        if (pattern2 == null) {
            PatternBuilder.$$$reportNull$$$0(6);
        }
        return this.append(pattern2.pattern());
    }

    public PatternBuilder matchingGroup() {
        return this.wrap("(", ")");
    }

    public PatternBuilder group() {
        return this.wrap("(?:", ")");
    }

    public PatternBuilder negativeLookahead() {
        return this.wrap("(?!", ")");
    }

    public PatternBuilder positiveLookahead() {
        return this.wrap("(?=", ")");
    }

    public PatternBuilder quote() {
        return this.wrap("\\Q", "\\E");
    }

    public PatternBuilder opt() {
        return this.append("?");
    }

    public PatternBuilder oneOrMore() {
        return this.append("+");
    }

    public PatternBuilder any() {
        return this.append("*");
    }

    public PatternBuilder orQuoted(@Nullable StatelessTextDecomposition.QuoteHandler quote) {
        if (quote == null) {
            return this;
        }
        return this.append("|").append(quote.getPattern());
    }

    public static Pattern compile(@NotNull String s2) {
        if (s2 == null) {
            PatternBuilder.$$$reportNull$$$0(7);
        }
        return Pattern.compile(s2, 2);
    }

    public static PatternBuilder build(@NotNull CharSequence string) {
        if (string == null) {
            PatternBuilder.$$$reportNull$$$0(8);
        }
        return new PatternBuilder(string);
    }

    public static PatternBuilder build(@NotNull Pattern pattern2) {
        if (pattern2 == null) {
            PatternBuilder.$$$reportNull$$$0(9);
        }
        return PatternBuilder.build(pattern2.pattern());
    }

    public static PatternBuilder build(@NotNull PatternBuilder builder) {
        if (builder == null) {
            PatternBuilder.$$$reportNull$$$0(10);
        }
        return PatternBuilder.build(builder.myBuilder);
    }

    public static int countGroups(@NotNull String pattern2) {
        if (pattern2 == null) {
            PatternBuilder.$$$reportNull$$$0(11);
        }
        return PatternBuilder.countGroups(PatternBuilder.compile(pattern2));
    }

    public static int countGroups(@NotNull Pattern pattern2) {
        if (pattern2 == null) {
            PatternBuilder.$$$reportNull$$$0(12);
        }
        return pattern2.matcher("").groupCount();
    }

    public String toString() {
        return DbUtil.intern2(this.myBuilder.toString());
    }

    private PatternBuilder(@NotNull CharSequence string) {
        if (string == null) {
            PatternBuilder.$$$reportNull$$$0(13);
        }
        this.myStack = new IntArrayList(0);
        this.myBuilder = new StringBuilder(string);
    }

    private int floor() {
        return this.myStack.size() == 0 ? 0 : this.myStack.topInt();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pre";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "post";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/url/template/PatternBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepend";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendQuoted";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "countGroups";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

