/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentMarkup
implements CompositeText {
    private final CharSequence myText;
    private final int[] myOffsets;
    private final char[] myKinds;
    private final Int2ObjectMap<String> myErrors;

    public PersistentMarkup(@NotNull CharSequence text2, int @NotNull [] offsets, char @NotNull [] kinds, @Nullable Int2ObjectMap<String> errors) {
        if (text2 == null) {
            PersistentMarkup.$$$reportNull$$$0(0);
        }
        if (offsets == null) {
            PersistentMarkup.$$$reportNull$$$0(1);
        }
        if (kinds == null) {
            PersistentMarkup.$$$reportNull$$$0(2);
        }
        assert (offsets.length == kinds.length);
        this.myText = text2;
        this.myOffsets = offsets;
        this.myKinds = kinds;
        this.myErrors = errors;
    }

    @Override
    public int getLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public List<CompositeText.Fragment> getFragments() {
        return new AbstractList<CompositeText.Fragment>(){

            @Override
            public CompositeText.Fragment get(int index2) {
                return PersistentMarkup.this.createFragment(index2);
            }

            @Override
            public int size() {
                return PersistentMarkup.this.myOffsets.length;
            }
        };
    }

    @Override
    @NotNull
    public CharSequence getText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            PersistentMarkup.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    public String toString() {
        return this.getText().toString();
    }

    @Override
    @Nullable
    public TextRange getContentRange() {
        int s2 = this.findStart(0);
        if (s2 >= this.myKinds.length || this.myKinds[s2] == PersistentMarkup.ord(CompositeText.Kind.COMPACT_DEFINITION)) {
            return null;
        }
        int e2 = this.findEnd(s2);
        return TextRange.create((int)this.getOffset(s2 - 1), (int)this.getOffset(e2 - 1));
    }

    @Override
    @Nullable
    public CompositeText getContent() {
        int s2 = this.findStart(0);
        if (s2 >= this.myKinds.length || this.myKinds[s2] == PersistentMarkup.ord(CompositeText.Kind.COMPACT_DEFINITION)) {
            return null;
        }
        int e2 = this.findEnd(s2);
        return this.subFragments(s2, e2);
    }

    private int findStart(int s2) {
        char ot = PersistentMarkup.ord(CompositeText.Kind.ORIGINAL_TEXT);
        char dt = PersistentMarkup.ord(CompositeText.Kind.DECOMPILED_TEXT);
        char ct = PersistentMarkup.ord(CompositeText.Kind.COMPACT_DEFINITION);
        while (s2 < this.myKinds.length) {
            if (this.myKinds[s2] == ot || this.myKinds[s2] == dt || this.myKinds[s2] == ct) {
                return s2;
            }
            ++s2;
        }
        return s2;
    }

    private int findEnd(int s2) {
        char ot = PersistentMarkup.ord(CompositeText.Kind.ORIGINAL_TEXT);
        char dt = PersistentMarkup.ord(CompositeText.Kind.DECOMPILED_TEXT);
        for (int i2 = s2 + 1; i2 < this.myKinds.length; ++i2) {
            if (this.myKinds[i2] != ot && this.myKinds[i2] != dt) continue;
            return i2 + 1;
        }
        return s2 + 1;
    }

    @NotNull
    private CompositeText.Fragment createFragment(final int idx) {
        return new CompositeText.Fragment(){

            @Override
            @NotNull
            public CharSequence getText() {
                CharSequence charSequence = PersistentMarkup.this.myText.subSequence(this.getBegin(), this.getEnd());
                if (charSequence == null) {
                    2.$$$reportNull$$$0(0);
                }
                return charSequence;
            }

            @Override
            @Nullable
            public String getError() {
                return PersistentMarkup.this.myErrors == null ? null : (String)PersistentMarkup.this.myErrors.get(idx);
            }

            @Override
            @NotNull
            public CompositeText.Kind getKind() {
                CompositeText.Kind kind = (CompositeText.Kind)((Object)ObjectUtils.chooseNotNull((Object)((Object)CompositeText.Kind.of(PersistentMarkup.this.myKinds[idx])), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)));
                if (kind == null) {
                    2.$$$reportNull$$$0(1);
                }
                return kind;
            }

            @Override
            public int getBegin() {
                return Math.min(PersistentMarkup.this.getOffset(idx - 1), PersistentMarkup.this.myText.length());
            }

            @Override
            public int getEnd() {
                return Math.min(Math.max(PersistentMarkup.this.getOffset(idx - 1), PersistentMarkup.this.getOffset(idx)), PersistentMarkup.this.myText.length());
            }

            @Override
            public int getLength() {
                return this.getEnd() - this.getBegin();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/dataSource/srcStorage/PersistentMarkup$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private int getOffset(int i2) {
        return i2 < 0 ? 0 : this.myOffsets[i2];
    }

    @NotNull
    public DbSrcStorageDsMetadata.MetaData getExpectedMetaData(@Nullable DbSrcStorageDsMetadata.MetaData md, int introVersion, int genVersion) {
        if (md == null) {
            md = DbSrcStorageDsMetadata.MetaData.EMPTY;
        }
        return new DbSrcStorageDsMetadata.MetaData(md.srcVersion, DbSrcUtilsCore.hashCode(this.myText), this.myOffsets, this.myKinds, introVersion, genVersion);
    }

    private static char ord(CompositeText.Kind k) {
        return k.getCode();
    }

    @Override
    @NotNull
    public CompositeText subFragments(int s2, int e2) {
        return new SimpleCompositeText((CompositeText)this, s2, e2);
    }

    @NotNull
    public static PersistentMarkup asPersistent(@NotNull CompositeText text2) {
        if (text2 == null) {
            PersistentMarkup.$$$reportNull$$$0(4);
        }
        if (text2 instanceof PersistentMarkup) {
            PersistentMarkup persistentMarkup = (PersistentMarkup)text2;
            if (persistentMarkup == null) {
                PersistentMarkup.$$$reportNull$$$0(5);
            }
            return persistentMarkup;
        }
        Builder builder = new Builder();
        for (CompositeText.Fragment f : text2.getFragments()) {
            builder.add(f.getKind(), f.getBegin(), f.getEnd(), f.getError());
        }
        PersistentMarkup persistentMarkup = builder.build(text2.getText());
        if (persistentMarkup == null) {
            PersistentMarkup.$$$reportNull$$$0(6);
        }
        return persistentMarkup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/PersistentMarkup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/PersistentMarkup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asPersistent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "asPersistent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static final class Builder {
        private final StringBuilder kinds = new StringBuilder();
        private final IntList offsets = new IntArrayList();
        private Int2ObjectMap<String> errors;

        public Builder add(CompositeText.Kind k, int o2, String error2) {
            if (!k.getContent() && (o2 == 0 || !this.offsets.isEmpty() && this.offsets.getInt(this.offsets.size() - 1) == o2)) {
                return this;
            }
            int sz = this.kinds.length();
            char ord = PersistentMarkup.ord(k);
            if (k == CompositeText.Kind.PLAIN_TEXT && sz > 0 && this.kinds.charAt(sz - 1) == ord && Objects.equals(error2, this.getError(sz - 1))) {
                this.offsets.set(sz - 1, o2);
            } else {
                this.offsets.add(o2);
                this.kinds.append(ord);
                if (error2 != null) {
                    if (this.errors == null) {
                        this.errors = new Int2ObjectOpenHashMap();
                    }
                    this.errors.put(this.offsets.size() - 1, (Object)error2);
                }
            }
            return this;
        }

        private String getError(int pos) {
            return this.errors == null ? null : (String)this.errors.get(pos);
        }

        public void add(CompositeText.Kind k, int from, int to, String error2) {
            this.add(CompositeText.Kind.PLAIN_TEXT, from, null);
            this.add(k, to, error2);
        }

        public void clear() {
            this.kinds.setLength(0);
            this.offsets.clear();
        }

        public PersistentMarkup build(CharSequence text2) {
            char[] kindsArray = new char[this.kinds.length()];
            this.kinds.getChars(0, this.kinds.length(), kindsArray, 0);
            return new PersistentMarkup(text2, this.offsets.toIntArray(), kindsArray, this.errors);
        }
    }
}

