/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.BatchesContainer;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.OneShotSmartStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u001bB\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ*\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000eH\u0014J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001aR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dataSource/connection/statements/SimpleSmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Simple;", "Lcom/intellij/database/dataSource/connection/statements/OneShotSmartStatement;", "", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "before", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "input", "statement", "reuse", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "(Lkotlin/Unit;)Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "Reusable", "intellij.database.core.impl"})
public final class SimpleSmartStatement
extends JdbcBasedSmartStatement.Simple
implements OneShotSmartStatement<String, Unit, String> {
    @NotNull
    private final StatementHolder.OneShot<RemoteStatement> statementHolder;

    public SimpleSmartStatement(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(connection2, auditService, configuration);
        this.statementHolder = new StatementHolder.OneShot(auditService, this);
    }

    @Override
    @NotNull
    protected StatementHolder.OneShot<RemoteStatement> getStatementHolder() {
        return this.statementHolder;
    }

    @NotNull
    public final ReusableSmartStatement<String> reuse() {
        return new Reusable(this.getConnection(), this.getAuditService(), this.getConfiguration());
    }

    @Override
    @NotNull
    protected Either<StagedException, List<RemoteCloseable>> before(@NotNull String input, @NotNull RemoteStatement statement2) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        this.getAuditService().beforeSimpleStatement(input, this);
        return super.before(input, statement2);
    }

    @Override
    @NotNull
    public ReusableSmartStatement<String> reuse(@NotNull Unit input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.reuse();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J*\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00162\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u000fH\u0014J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001d0\u0016H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dataSource/connection/statements/SimpleSmartStatement$Reusable;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Simple;", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "batches", "Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "addBatch", "", "input", "before", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "statement", "close", "executeBatch", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "intellij.database.core.impl"})
    private static final class Reusable
    extends JdbcBasedSmartStatement.Simple
    implements ReusableSmartStatement<String> {
        @NotNull
        private final StatementHolder.Reusable<RemoteStatement> statementHolder;
        @NotNull
        private final BatchesContainer batches;

        public Reusable(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(connection2, auditService, configuration);
            this.statementHolder = new StatementHolder.Reusable();
            this.batches = new BatchesContainer();
        }

        @Override
        @NotNull
        protected StatementHolder.Reusable<RemoteStatement> getStatementHolder() {
            return this.statementHolder;
        }

        @Override
        public void addBatch(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            EitherKt.tryGet(this.getCurrentStatement(input)).getValue().addBatch(input);
            this.batches.add(input);
        }

        @Override
        @NotNull
        protected Either<StagedException, List<RemoteCloseable>> before(@NotNull String input, @NotNull RemoteStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            this.getAuditService().beforeSimpleStatement(input, this);
            return super.before(input, statement2);
        }

        @Override
        @NotNull
        public Either<StagedException, ClosableResultsProducer> executeBatch() {
            Object s2 = ((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
            Intrinsics.checkNotNull(s2);
            return SmartStatementsUtil.executeBatch(s2, this.getConnection(), this, this.batches);
        }

        @Override
        public void close() {
            Object statement2 = ((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
            if (statement2 != null) {
                this.getAuditService().beforeStatementClosing((RemoteStatement)statement2, this);
                JdbcNativeUtil.performSafe(() -> statement2.close());
            }
            this.batches.clear();
        }
    }
}

