/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseDriverUtils {
    public static Couple<Version> getSupportedRange(@NotNull DatabaseArtifactList artifactList, @Nullable DatabaseDriver driver2, @Nullable Dbms dbms) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(0);
        }
        return DatabaseDriverUtils.getSupportedRange(artifactList, driver2 == null ? Collections.emptyList() : driver2.getArtifacts(), dbms);
    }

    public static Couple<Version> getSupportedRange(@NotNull DatabaseArtifactList artifactList, @NotNull List<DatabaseDriver.ArtifactRef> artifacts, @Nullable Dbms dbms) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(1);
        }
        if (artifacts == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(2);
        }
        Version minV = Version.ZERO;
        Version maxV = Version.INFINITY;
        for (DatabaseDriver.ArtifactRef artifact : artifacts) {
            Couple<Version> range = DatabaseDriverUtils.getSupportedRange(artifactList, artifact, dbms);
            if (minV.less((Version)range.first)) {
                minV = (Version)range.first;
            }
            if (!((Version)range.second).less(maxV)) continue;
            maxV = (Version)range.second;
        }
        return maxV.isOrGreater(minV) ? Couple.of((Object)minV, (Object)maxV) : Couple.of((Object)Version.INFINITY, (Object)Version.INFINITY);
    }

    public static Couple<Version> getSupportedRange(@NotNull DatabaseArtifactList artifactList, @NotNull DatabaseDriver.ArtifactRef artifact, @Nullable Dbms dbms) {
        Version version;
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(4);
        }
        DatabaseArtifactList.ArtifactVersion artifactVersion = (version = artifact.getArtifactVersion()) == null ? null : artifactList.resolveVersion(artifact.getId(), version);
        List<DatabaseArtifactList.Constraint> constraints = artifactVersion == null ? Collections.emptyList() : artifactVersion.artifact.constraints;
        Version minV = null;
        Version maxV = null;
        for (DatabaseArtifactList.Constraint c2 : constraints) {
            if (!c2.matches(version, dbms, true)) continue;
            maxV = DatabaseDriverUtils.merge(maxV, c2.dbFrom, 1);
            minV = DatabaseDriverUtils.merge(minV, c2.dbTo, -1);
        }
        return Couple.of((Object)Objects.requireNonNullElse(minV, Version.ZERO), (Object)Objects.requireNonNullElse(maxV, Version.INFINITY));
    }

    private static Version merge(Version minV, Version v2, int s2) {
        return minV == null || v2 != null && v2.compareTo(minV) == s2 ? v2 : minV;
    }

    public static boolean isDriverFilesValid(@NotNull DatabaseArtifactList artifactList, @NotNull List<DatabaseDriver.ArtifactRef> artifacts, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(5);
        }
        if (artifacts == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(6);
        }
        return ContainerUtil.and(artifacts, a -> DatabaseDriverUtils.isDriverFilesValid(artifactList, a.getId(), a.getArtifactVersion(), actual));
    }

    public static boolean isDriverFilesValid(@NotNull DatabaseArtifactList artifactList, @NotNull String artifact, @Nullable Version version, @Nullable Collection<SimpleClasspathElement> actual) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(7);
        }
        if (artifact == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(8);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        if (version == null) {
            return actual != null && !actual.isEmpty() && DatabaseDriverUtils.isFileListExists(DatabaseDriverUtils.getUrls(actual));
        }
        return loader.isValid(artifactList, artifact, version);
    }

    public static boolean isDriverFilesUpToDate(@NotNull DatabaseArtifactList artifactList, @NotNull DatabaseDriver driver2, @NotNull List<DatabaseDriver.ArtifactRef> artifacts) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(9);
        }
        if (driver2 == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(10);
        }
        if (artifacts == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(11);
        }
        return ContainerUtil.and(artifacts, a -> DatabaseDriverUtils.isDriverFilesUpToDate(artifactList, driver2, a.getId(), a.getArtifactVersion(), a.getChannel()));
    }

    public static boolean isDriverFilesUpToDate(@NotNull DatabaseArtifactList artifactList, @NotNull DatabaseDriver driver2, @NotNull String artifact, @Nullable Version version, @Nullable String channel) {
        if (artifactList == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(12);
        }
        if (driver2 == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(13);
        }
        if (artifact == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(14);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        DatabaseArtifactList.ArtifactVersion actualVersion = DatabaseArtifactList.resolveVersion(artifactList, artifact, version, channel, driver2);
        if (actualVersion == null) {
            return loader.isValid(artifactList, artifact, version);
        }
        return (version == Version.INFINITY || version == null || actualVersion.version.equals(version)) && loader.isValid(actualVersion);
    }

    public static boolean hasMissingLocalFiles(@NotNull DatabaseArtifactList.ArtifactVersion artifactVersion) {
        if (artifactVersion == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(15);
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        return loader.hasMissingLocalFiles(artifactVersion);
    }

    @NotNull
    private static JBIterable<String> getUrls(@Nullable Collection<SimpleClasspathElement> actual) {
        JBIterable jBIterable = JBIterable.from(actual).flatten(SimpleClasspathElement::getClassesRootUrls);
        if (jBIterable == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    private static boolean isFileListExists(@NotNull JBIterable<String> urls) {
        if (urls == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(17);
        }
        return urls.filter(url -> !FileUtil.exists((String)VfsUtilCore.urlToPath((String)url))).isEmpty();
    }

    public static int getFirstErrorPos(@NotNull LocalDataSource ds, @NotNull DatabaseDriver dr) {
        if (ds == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(18);
        }
        if (dr == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(19);
        }
        String url = StringUtil.notNullize((String)ds.getUrl());
        JdbcUrlParser parsed = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(dr.getJDBCUrlParsers(), url));
        if (parsed == null) {
            return 0;
        }
        parsed.setUrlText(url);
        List<TextRange> errors = parsed.getInvalidRanges();
        if (errors.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        TextRange firstError = Collections.min(errors, Comparator.comparing(TextRange::getStartOffset));
        return firstError.getStartOffset();
    }

    public static boolean passesConstraints(@NotNull DatabaseDriver driver2, @NotNull LocalDataSource dataSource2) {
        DatabaseDriver.Constraint constraint;
        if (driver2 == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(20);
        }
        if (dataSource2 == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(21);
        }
        if ((constraint = DatabaseDriverUtils.getConstraint(driver2, dataSource2)) == null) {
            return true;
        }
        return constraint.matches(dataSource2.getDbms(), dataSource2.getVersion());
    }

    public static DatabaseDriver.Constraint getConstraint(@NotNull DatabaseDriver driver2, @NotNull LocalDataSource dataSource2) {
        if (driver2 == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(22);
        }
        if (dataSource2 == null) {
            DatabaseDriverUtils.$$$reportNull$$$0(23);
        }
        Set<DatabaseDriver.Constraint> constraints = driver2.getConstraints();
        return (DatabaseDriver.Constraint)ContainerUtil.find(constraints, c2 -> c2.matches(dataSource2.getDbms(), null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactList";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 4: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 10: 
            case 13: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactVersion";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverUtils";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dr";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverUtils";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDriverFilesValid";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDriverFilesUpToDate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasMissingLocalFiles";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFileListExists";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFirstErrorPos";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "passesConstraints";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConstraint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16 -> new IllegalStateException(string);
        };
    }
}

