/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.ReboundNotPossibleException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionManagerKt;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SimpleDatabaseConnection;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncTaskKt;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.messages.Topic;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 '2\u00020\u0001:\u0006&'()*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000e\u001a\u00060\u000fR\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ@\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2 \u0010!\u001a\u001c\u0012\b\b\u0000\u0012\u0004\u0018\u00010#\u0012\u000e\b\u0001\u0012\n\u0018\u00010$j\u0004\u0018\u0001`%0\"R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "activeConnections", "", "Lcom/intellij/database/dataSource/DatabaseConnection;", "getActiveConnections", "()Ljava/util/List;", "getCs$annotations", "()V", "myConnections", "", "build", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Builder;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "releaseConnection", "", "driverManager", "Lcom/intellij/database/console/JdbcDriverManager;", "connection", "terminateConnections", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "useDriver", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "user", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/database/remote/jdbc/RemoteDriver;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Builder", "Companion", "ConnectInterceptor", "Executor", "Listener", "Operation", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseConnectionManager.kt\ncom/intellij/database/dataSource/DatabaseConnectionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,414:1\n766#2:415\n857#2,2:416\n*S KotlinDebug\n*F\n+ 1 DatabaseConnectionManager.kt\ncom/intellij/database/dataSource/DatabaseConnectionManager\n*L\n337#1:415\n337#1:416,2\n*E\n"})
public final class DatabaseConnectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Set<DatabaseConnection> myConnections;
    @NotNull
    private static final Topic<Listener> TOPIC;

    public DatabaseConnectionManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        Set set = ConcurrentCollectionFactory.createConcurrentIdentitySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentIdentitySet(...)");
        this.myConnections = set;
    }

    @Deprecated(message="Provide your own")
    private static /* synthetic */ void getCs$annotations() {
    }

    @NotNull
    public final Builder build(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        return new Builder(project, connectionPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void useDriver(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull DatabaseCredentials credentialsStore, @NotNull ThrowableConsumer<? super RemoteDriver, ? extends Exception> user) throws Exception {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)credentialsStore, (String)"credentialsStore");
        Intrinsics.checkNotNullParameter(user, (String)"user");
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        ConsoleRunConfiguration consoleRunConfiguration = driverManager.getDefaultRunConfiguration(dataSource2, credentialsStore);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)consoleRunConfiguration), (String)"getDefaultRunConfiguration(...)");
        ConsoleRunConfiguration configuration = consoleRunConfiguration;
        RemoteDriver driver2 = driverManager.getDriver(dataSource2, configuration);
        try {
            user.consume((Object)driver2);
        }
        finally {
            Intrinsics.checkNotNull((Object)((Object)driverManager));
            DatabaseConnectionManager.Companion.releaseDriver(driverManager, dataSource2, configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseConnection(JdbcDriverManager driverManager, DatabaseConnection connection2) {
        this.myConnections.remove(connection2);
        try {
            DatabaseConnectionManager.Companion.releaseConnectionInner(driverManager, connection2);
        }
        finally {
            DatabaseConnectionManager.Companion.connectionChanged(connection2, false);
        }
    }

    @NotNull
    public final List<DatabaseConnection> getActiveConnections() {
        return new ArrayList(this.myConnections);
    }

    /*
     * WARNING - void declaration
     */
    public final void terminateConnections(@NotNull LocalDataSource dataSource2, @Nullable ConsoleRunConfiguration configuration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Iterable $this$filter$iv = this.myConnections;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseConnection it2 = (DatabaseConnection)element$iv$iv;
            boolean bl = false;
            boolean bl2 = it2.getConnectionPoint().getDataSource() == dataSource2 && (configuration == null || it2.getConfiguration() == configuration);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toTerminate = (List)destination$iv$iv;
        for (DatabaseConnection connection2 : toTerminate) {
            Intrinsics.checkNotNull((Object)connection2, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.SimpleDatabaseConnection");
            ((SimpleDatabaseConnection)connection2).cancelAll();
        }
    }

    @NotNull
    public static final Topic<Listener> getTOPIC() {
        return Companion.getTOPIC();
    }

    @JvmStatic
    @NotNull
    public static final DatabaseConnectionManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @TestOnly
    public static final void setInterceptor(@NotNull Disposable disposable, @Nullable ConnectInterceptor interceptor) {
        Companion.setInterceptor(disposable, interceptor);
    }

    @JvmStatic
    @NotNull
    public static final ErrorInfo getConnectionErrorInfo(@NotNull Throwable e2, @NotNull LocalDataSource dataSource2) {
        return Companion.getConnectionErrorInfo(e2, dataSource2);
    }

    @JvmStatic
    @TestOnly
    @Nullable
    public static final Object establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull ConnectionRequestor requestor, @NotNull Project project, boolean askPassword, @NotNull Continuation<? super DatabaseConnection> $completion) {
        return Companion.establishConnection(connectionPoint, runConfiguration, requestor, project, askPassword, $completion);
    }

    public static final /* synthetic */ Set access$getMyConnections$p(DatabaseConnectionManager $this) {
        return $this.myConnections;
    }

    static {
        Topic topic = Topic.create((String)"DatabaseConnectionManager.Listener", Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J@\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020 2\"\u0010!\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0$\u0012\u0006\u0012\u0004\u0018\u00010\u00010\"H\u0086@\u00a2\u0006\u0002\u0010%J0\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001e0&\"\u0004\b\u0000\u0010\u001e2\u0006\u0010'\u001a\u00020(2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001e0)2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010+H\u0086@\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010+J\u0010\u0010.\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010+H\u0007J\u0012\u0010/\u001a\u00060\u0000R\u0002002\u0006\u0010\t\u001a\u00020\bJ\u0014\u00101\u001a\u00060\u0000R\u0002002\b\u00102\u001a\u0004\u0018\u00010\u0011J\u0014\u00103\u001a\u00060\u0000R\u0002002\b\u00104\u001a\u0004\u0018\u000105J\u0012\u00106\u001a\u00060\u0000R\u0002002\u0006\u0010\u0017\u001a\u00020\u0016J\u0014\u00107\u001a\u00060\u0000R\u0002002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0007\u001a\u0004\u0018\u00010\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Builder;", "", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "(Lcom/intellij/database/dataSource/DatabaseConnectionManager;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)V", "<set-?>", "", "askPassword", "getAskPassword", "()Z", "getConnectionPoint", "()Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "setConnectionPoint", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)V", "myCredentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "myRunConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "requestor", "getRequestor", "()Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "runConfiguration", "getRunConfiguration", "()Lcom/intellij/database/run/ConsoleRunConfiguration;", "async", "T", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "user", "Lkotlin/Function2;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lkotlin/coroutines/Continuation;", "(Lcom/intellij/database/util/ErrorHandler;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/intellij/database/util/AsyncTask;", "context", "Lkotlin/coroutines/CoroutineContext;", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Operation;", "create", "Lcom/intellij/database/util/GuardedRef;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBlocking", "createBlockingNonCancellable", "setAskPassword", "Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "setCredentialsStore", "credentialsStore", "setDestination", "path", "Lcom/intellij/database/util/ObjectPath;", "setRequestor", "setRunConfiguration", "intellij.database.connectivity"})
    public final class Builder {
        @NotNull
        private final Project project;
        @NotNull
        private DatabaseConnectionPoint connectionPoint;
        private boolean askPassword;
        @Nullable
        private ConsoleRunConfiguration myRunConfiguration;
        @Nullable
        private ConnectionRequestor requestor;
        @Nullable
        private DatabaseCredentials myCredentialsStore;

        public Builder(@NotNull Project project, DatabaseConnectionPoint connectionPoint) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            this.project = project;
            this.connectionPoint = connectionPoint;
            this.askPassword = true;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final DatabaseConnectionPoint getConnectionPoint() {
            return this.connectionPoint;
        }

        public final void setConnectionPoint(@NotNull DatabaseConnectionPoint databaseConnectionPoint) {
            Intrinsics.checkNotNullParameter((Object)databaseConnectionPoint, (String)"<set-?>");
            this.connectionPoint = databaseConnectionPoint;
        }

        public final boolean getAskPassword() {
            return this.askPassword;
        }

        @Nullable
        public final ConnectionRequestor getRequestor() {
            return this.requestor;
        }

        @NotNull
        public final Builder setDestination(@Nullable ObjectPath path) {
            if (path != null) {
                DatabaseConnectionPoint rebound = JdbcUrlParserUtil.connectedTo(this.connectionPoint, path);
                if (rebound == null) {
                    throw new ReboundNotPossibleException(path);
                }
                this.connectionPoint = rebound;
            }
            return this;
        }

        @NotNull
        public final Builder setAskPassword(boolean askPassword) {
            this.askPassword = askPassword;
            return this;
        }

        @NotNull
        public final Builder setRunConfiguration(@Nullable ConsoleRunConfiguration runConfiguration) {
            this.myRunConfiguration = runConfiguration;
            return this;
        }

        @NotNull
        public final ConsoleRunConfiguration getRunConfiguration() {
            ConsoleRunConfiguration consoleRunConfiguration;
            if (this.myRunConfiguration == null) {
                ConsoleRunConfiguration consoleRunConfiguration2 = JdbcDriverManager.getDriverManager(this.project).getDefaultRunConfiguration(this.connectionPoint.getDataSource(), this.myCredentialsStore);
                consoleRunConfiguration = consoleRunConfiguration2;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)consoleRunConfiguration2), (String)"getDefaultRunConfiguration(...)");
            } else {
                ConsoleRunConfiguration consoleRunConfiguration3 = this.myRunConfiguration;
                consoleRunConfiguration = consoleRunConfiguration3;
                Intrinsics.checkNotNull((Object)((Object)consoleRunConfiguration3));
            }
            return consoleRunConfiguration;
        }

        @NotNull
        public final Builder setCredentialsStore(@Nullable DatabaseCredentials credentialsStore) {
            this.myCredentialsStore = credentialsStore;
            return this;
        }

        @NotNull
        public final Builder setRequestor(@NotNull ConnectionRequestor requestor) {
            Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
            this.requestor = requestor;
            return this;
        }

        @NotNull
        public final <T> AsyncTask<T> async(@NotNull CoroutineContext context, @NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
            return AsyncTask.Companion.currentFrame().asAsyncTask(context.plus((CoroutineContext)new CoroutineName("DatabaseConnectionManager.async")), (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this, errorHandler, user, null){
                int label;
                final /* synthetic */ Builder this$0;
                final /* synthetic */ ErrorHandler $errorHandler;
                final /* synthetic */ Operation<T> $user;
                {
                    this.this$0 = $receiver;
                    this.$errorHandler = $errorHandler;
                    this.$user = $user;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.async(this.$errorHandler, (Function2)new Function2<DatabaseConnection, Continuation<? super T>, Object>(this.$user, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ Operation<T> $user;
                                {
                                    this.$user = $user;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            DatabaseConnection it2 = (DatabaseConnection)this.L$0;
                                            return this.$user.perform(it2);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                @Nullable
                                public final Object invoke(@NotNull DatabaseConnection p1, @Nullable Continuation<? super T> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        @Nullable
        public final <T> Object async(@NotNull ErrorHandler errorHandler, @NotNull Function2<? super DatabaseConnection, ? super Continuation<? super T>, ? extends Object> user, @NotNull Continuation<? super T> $completion) {
            return new Executor(this).async(user, errorHandler, $completion);
        }

        @TestOnly
        @Nullable
        public final GuardedRef<DatabaseConnection> createBlockingNonCancellable() throws SQLException {
            return (GuardedRef)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this, null){
                int label;
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = AsyncTask.Companion.currentFrame().indicatorReporting((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ Builder this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = this.this$0.create((Continuation<? super GuardedRef<DatabaseConnection>>)((Continuation)this));
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Nullable
        public final GuardedRef<DatabaseConnection> createBlocking() throws SQLException {
            return (GuardedRef)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this, null){
                int label;
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = AsyncTask.Companion.currentFrame().indicatorReporting((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ Builder this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = this.this$0.create((Continuation<? super GuardedRef<DatabaseConnection>>)((Continuation)this));
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Nullable
        public final Object create(@NotNull Continuation<? super GuardedRef<DatabaseConnection>> $completion) throws SQLException {
            return new Executor(this).create($completion);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0087@\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010 \u001a\u00020!H\u0007J\u0016\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\fH\u0002J \u0010*\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0007R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u00060"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Companion;", "", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Listener;", "getTOPIC$annotations", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "connectionChanged", "", "r", "Lcom/intellij/database/dataSource/DatabaseConnection;", "added", "", "establishConnection", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "runConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "requestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "askPassword", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/run/ConsoleRunConfiguration;Lcom/intellij/database/dataSource/connection/ConnectionRequestor;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConnectionErrorInfo", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "e", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getInstance", "Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "getSpecialErrorInfo", "t", "getTimeZone", "", "releaseConnectionInner", "driverManager", "Lcom/intellij/database/console/JdbcDriverManager;", "connection", "releaseDriver", "setInterceptor", "disposable", "Lcom/intellij/openapi/Disposable;", "interceptor", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$ConnectInterceptor;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseConnectionManager.kt\ncom/intellij/database/dataSource/DatabaseConnectionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,414:1\n31#2,2:415\n1#3:417\n*S KotlinDebug\n*F\n+ 1 DatabaseConnectionManager.kt\ncom/intellij/database/dataSource/DatabaseConnectionManager$Companion\n*L\n352#1:415,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<Listener> getTOPIC() {
            return TOPIC;
        }

        @JvmStatic
        public static /* synthetic */ void getTOPIC$annotations() {
        }

        @JvmStatic
        @NotNull
        public final DatabaseConnectionManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DatabaseConnectionManager> serviceClass$iv = DatabaseConnectionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DatabaseConnectionManager)object;
        }

        @JvmStatic
        @TestOnly
        public final void setInterceptor(@NotNull Disposable disposable, @Nullable ConnectInterceptor interceptor) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            ConnectInterceptor prev = DatabaseConnectionManagerKt.access$getOurInterceptor$p();
            boolean bl2 = bl = prev == null || interceptor == null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Already have interceptor";
                throw new AssertionError((Object)string);
            }
            DatabaseConnectionManagerKt.access$setOurInterceptor$p(interceptor);
            Disposer.register((Disposable)disposable, () -> Companion.setInterceptor$lambda$1(prev));
        }

        @NotNull
        public final ErrorInfo getSpecialErrorInfo(@NotNull Throwable t, @NotNull LocalDataSource dataSource2) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            DatabaseErrorHandler handler2 = DatabaseErrorHandler.EP.forDbms(dataSource2.getDbms());
            ErrorInfo errorInfo = handler2.getErrorInfo(dataSource2, t);
            Intrinsics.checkNotNullExpressionValue((Object)errorInfo, (String)"getErrorInfo(...)");
            return errorInfo;
        }

        private final void releaseConnectionInner(JdbcDriverManager driverManager, DatabaseConnection connection2) {
            Intrinsics.checkNotNull((Object)connection2, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.SimpleDatabaseConnection");
            RemoteConnection remoteConnection = ((SimpleDatabaseConnection)connection2).release();
            JdbcNativeUtil.performSafe(() -> Companion.releaseConnectionInner$lambda$2(remoteConnection));
            LocalDataSource localDataSource = connection2.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            ConsoleRunConfiguration consoleRunConfiguration = connection2.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)consoleRunConfiguration), (String)"getConfiguration(...)");
            this.releaseDriver(driverManager, localDataSource, consoleRunConfiguration);
        }

        private final void releaseDriver(JdbcDriverManager driverManager, LocalDataSource dataSource2, ConsoleRunConfiguration runConfiguration) {
            if (dataSource2.isTemporary()) {
                driverManager.releaseDriver(dataSource2, runConfiguration);
            }
        }

        @JvmStatic
        @NotNull
        public final ErrorInfo getConnectionErrorInfo(@NotNull Throwable e2, @NotNull LocalDataSource dataSource2) {
            Throwable throwable;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            if (AsyncUtil.isCancellation(e2)) {
                AsyncUtil.rethrow(e2);
            }
            if (e2 instanceof CompletionException) {
                Throwable throwable2 = e2.getCause();
                throwable = throwable2;
                Intrinsics.checkNotNull((Object)throwable2);
            } else {
                throwable = e2;
            }
            Throwable ex = throwable;
            return this.getSpecialErrorInfo(ex, dataSource2);
        }

        private final void connectionChanged(DatabaseConnection r, boolean added) {
            Application app = ApplicationManager.getApplication();
            app.invokeLater(() -> Companion.connectionChanged$lambda$3(app, r, added), ModalityState.any());
        }

        private final String getTimeZone(LocalDataSource dataSource2) {
            String timeZone = dataSource2.getTimeZone();
            CharSequence charSequence = timeZone;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : timeZone;
        }

        @JvmStatic
        @TestOnly
        @Nullable
        public final Object establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull ConnectionRequestor requestor, @NotNull Project project, boolean askPassword, @NotNull Continuation<? super DatabaseConnection> $completion) {
            return DatabaseConnectionEstablisher.Companion.establishConnection(connectionPoint, runConfiguration, requestor, Companion::establishConnection$lambda$4, project, askPassword, $completion);
        }

        private static final void setInterceptor$lambda$1(ConnectInterceptor $prev) {
            DatabaseConnectionManagerKt.access$setOurInterceptor$p($prev);
        }

        private static final void releaseConnectionInner$lambda$2(RemoteConnection $remoteConnection) {
            Intrinsics.checkNotNullParameter((Object)$remoteConnection, (String)"$remoteConnection");
            $remoteConnection.close();
        }

        private static final void connectionChanged$lambda$3(Application $app, DatabaseConnection $r, boolean $added) {
            Intrinsics.checkNotNullParameter((Object)$r, (String)"$r");
            ((Listener)$app.getMessageBus().syncPublisher(Companion.getTOPIC())).connectionChanged($r, $added);
        }

        private static final void establishConnection$lambda$4(JdbcDriverManager driverManager, DatabaseConnection connection2) {
            Intrinsics.checkNotNullParameter((Object)((Object)driverManager), (String)"driverManager");
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Companion.releaseConnectionInner(driverManager, connection2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J8\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u00a6@\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$ConnectInterceptor;", "", "establishConnection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "runConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "requestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "askPassword", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/run/ConsoleRunConfiguration;Lcom/intellij/database/dataSource/connection/ConnectionRequestor;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.connectivity"})
    public static interface ConnectInterceptor {
        @Nullable
        public Object establishConnection(@NotNull DatabaseConnectionPoint var1, @NotNull ConsoleRunConfiguration var2, @NotNull ConnectionRequestor var3, @NotNull Project var4, boolean var5, @NotNull Continuation<? super DatabaseConnection> var6);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J@\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\"\u0010\u0012\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010!\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010\u001eJJ\u0010\"\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\"\u0010#\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0013H\u0082@\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u001a\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010+\u001a\u0004\u0018\u00010\u0014H\u0082@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Executor;", "", "b", "Lcom/intellij/database/dataSource/DatabaseConnectionManager$Builder;", "Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "(Lcom/intellij/database/dataSource/DatabaseConnectionManager;Lcom/intellij/database/dataSource/DatabaseConnectionManager$Builder;)V", "myAskPassword", "", "myConnectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "myProject", "Lcom/intellij/openapi/project/Project;", "myRequestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "myRunConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "async", "T", "user", "Lkotlin/Function2;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lkotlin/coroutines/Continuation;", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "(Lkotlin/jvm/functions/Function2;Lcom/intellij/database/util/ErrorHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changeSessionTimeZone", "", "connection", "create", "Lcom/intellij/database/util/GuardedRef;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBlocking", "establishConnection", "establishConnectionAndPrepare", "perform", "op", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/util/ErrorHandler;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareDatabaseConnection", "release", "driverManager", "Lcom/intellij/database/console/JdbcDriverManager;", "ref", "runInitializationScript", "supplyAsync", "intellij.database.connectivity"})
    private final class Executor {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ConsoleRunConfiguration myRunConfiguration;
        @NotNull
        private final DatabaseConnectionPoint myConnectionPoint;
        @Nullable
        private final ConnectionRequestor myRequestor;
        private final boolean myAskPassword;

        public Executor(Builder b2) {
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
            this.myProject = b2.getProject();
            this.myRunConfiguration = b2.getRunConfiguration();
            this.myConnectionPoint = b2.getConnectionPoint();
            this.myRequestor = b2.getRequestor();
            this.myAskPassword = b2.getAskPassword();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final <T> Object async(@NotNull Function2<? super DatabaseConnection, ? super Continuation<? super T>, ? extends Object> var1_1, @NotNull ErrorHandler var2_2, @NotNull Continuation<? super T> var3_3) {
            if (!(var3_3 instanceof async.1)) ** GOTO lbl-1000
            var10_4 = var3_3;
            if ((var10_4.label & -2147483648) != 0) {
                var10_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ Executor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.async(null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    driverManager = JdbcDriverManager.getDriverManager(this.myProject);
                    $continuation.L$0 = this;
                    $continuation.L$1 = user;
                    $continuation.L$2 = errorHandler;
                    $continuation.L$3 = driverManager;
                    $continuation.label = 1;
                    v0 = this.supplyAsync((Continuation<? super DatabaseConnection>)$continuation);
                    ** if (v0 != var11_6) goto lbl23
lbl22:
                    // 1 sources

                    return var11_6;
lbl23:
                    // 1 sources

                    ** GOTO lbl33
                }
                case 1: {
                    driverManager = (JdbcDriverManager)$continuation.L$3;
                    errorHandler = (ErrorHandler)$continuation.L$2;
                    user = (Function2)$continuation.L$1;
                    this = (Executor)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl33:
                        // 2 sources

                        var6_8 = (DatabaseConnection)v0;
                    }
                    catch (Throwable th) {
                        if (!AsyncUtil.isCancellation(th)) {
                            var8_11 = this.myConnectionPoint.getDataSource();
                            Intrinsics.checkNotNullExpressionValue((Object)var8_11, (String)"getDataSource(...)");
                            errorHandler.add(DatabaseConnectionManager.Companion.getConnectionErrorInfo(th, var8_11));
                        }
                        Intrinsics.checkNotNull((Object)driverManager);
                        this.release(driverManager, null);
                        throw new CancellationException();
                    }
                    connection = var6_8;
                    $continuation.L$0 = this;
                    $continuation.L$1 = driverManager;
                    $continuation.L$2 = connection;
                    $continuation.L$3 = null;
                    $continuation.label = 2;
                    v1 = this.perform((DatabaseConnection)connection, errorHandler, (Function2<? super DatabaseConnection, ? super Continuation<? super T>, ? extends Object>)user, (Continuation<? super T>)$continuation);
                    ** if (v1 != var11_6) goto lbl54
lbl53:
                    // 1 sources

                    return var11_6;
lbl54:
                    // 1 sources

                    ** GOTO lbl63
                }
                case 2: {
                    connection = (DatabaseConnection)$continuation.L$2;
                    driverManager = (JdbcDriverManager)$continuation.L$1;
                    this = (Executor)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl63:
                        // 2 sources

                        var6_8 = v1;
                    }
                    catch (Throwable var7_10) {
                        throw var7_10;
                    }
                    finally {
                        Intrinsics.checkNotNull((Object)driverManager);
                        this.release(driverManager, (DatabaseConnection)connection);
                    }
                    return var6_8;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object create(@NotNull Continuation<? super GuardedRef<DatabaseConnection>> var1_1) {
            if (!(var1_1 instanceof create.1)) ** GOTO lbl-1000
            var6_2 = var1_1;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Executor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.create((Continuation<? super GuardedRef<DatabaseConnection>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    driverManager = JdbcDriverManager.getDriverManager(this.myProject);
                    $continuation.L$0 = this;
                    $continuation.L$1 = driverManager;
                    $continuation.label = 1;
                    v0 = this.supplyAsync((Continuation<? super DatabaseConnection>)$continuation);
                    ** if (v0 != var7_4) goto lbl21
lbl20:
                    // 1 sources

                    return var7_4;
lbl21:
                    // 1 sources

                    ** GOTO lbl29
                }
                case 1: {
                    driverManager = (JdbcDriverManager)$continuation.L$1;
                    this = (Executor)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl29:
                        // 2 sources

                        if ((connection = (DatabaseConnection)v0) == null) {
                            Intrinsics.checkNotNull((Object)driverManager);
                            this.release(driverManager, null);
                            return null;
                        }
                        return new GuardedRef<DatabaseConnection>(connection, this, driverManager){
                            final /* synthetic */ Executor this$0;
                            final /* synthetic */ JdbcDriverManager $driverManager;
                            {
                                this.this$0 = $receiver;
                                this.$driverManager = $driverManager;
                                super($connection);
                            }

                            protected void close(@NotNull DatabaseConnection ref2) {
                                Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
                                JdbcDriverManager jdbcDriverManager = this.$driverManager;
                                Intrinsics.checkNotNullExpressionValue((Object)((Object)jdbcDriverManager), (String)"$driverManager");
                                Executor.access$release(this.this$0, jdbcDriverManager, ref2);
                            }
                        };
                    }
                    catch (Throwable e) {
                        Intrinsics.checkNotNull((Object)driverManager);
                        this.release(driverManager, null);
                        t = AsyncUtil.unwrap(e);
                        if (t instanceof SQLException) {
                            throw t;
                        }
                        ExceptionUtil.rethrow((Throwable)t);
                        return null;
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Nullable
        public final GuardedRef<DatabaseConnection> createBlocking() throws SQLException {
            return (GuardedRef)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GuardedRef<DatabaseConnection>>, Object>(this, null){
                int label;
                final /* synthetic */ Executor this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.create((Continuation<? super GuardedRef<DatabaseConnection>>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GuardedRef<DatabaseConnection>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final void release(JdbcDriverManager driverManager, DatabaseConnection ref2) {
            if (ref2 != null) {
                DatabaseConnectionManager.this.releaseConnection(driverManager, ref2);
            } else {
                LocalDataSource localDataSource = this.myConnectionPoint.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                Companion.releaseDriver(driverManager, localDataSource, this.myRunConfiguration);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final <T> Object perform(DatabaseConnection var1_1, ErrorHandler var2_2, Function2<? super DatabaseConnection, ? super Continuation<? super T>, ? extends Object> var3_3, Continuation<? super T> var4_4) {
            if (!(var4_4 instanceof perform.1)) ** GOTO lbl-1000
            var9_5 = var4_4;
            if ((var9_5.label & -2147483648) != 0) {
                var9_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Executor this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Executor.access$perform(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (connection == null) {
                        errorHandler.addError(DatabaseBundle.message("message.wrong.driver.specified", new Object[0]), null);
                        throw new CancellationException();
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = errorHandler;
                    $continuation.label = 1;
                    v0 = op.invoke((Object)connection, $continuation);
                    ** if (v0 != var10_7) goto lbl24
lbl23:
                    // 1 sources

                    return var10_7;
lbl24:
                    // 1 sources

                    ** GOTO lbl32
                }
                case 1: {
                    errorHandler = (ErrorHandler)$continuation.L$1;
                    this = (Executor)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl32:
                        // 2 sources

                        return v0;
                    }
                    catch (CancellationException c) {
                        throw c;
                    }
                    catch (Exception e) {
                        if (!AsyncUtil.isCancellation(e)) {
                            v1 = e;
                            var6_10 = this.myConnectionPoint.getDataSource();
                            Intrinsics.checkNotNullExpressionValue((Object)var6_10, (String)"getDataSource(...)");
                            errorHandler.add(DatabaseConnectionManager.Companion.getSpecialErrorInfo(v1, (LocalDataSource)var6_10));
                        }
                        v2 = e;
                        var7_11 = var6_10 = new CancellationException(v2 != null ? v2.toString() : null);
                        var7_11.initCause(e);
                        throw var6_10;
                    }
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Object supplyAsync(Continuation<? super DatabaseConnection> $completion) {
            String string = DatabaseBundle.message("progress.text.connecting.to.database", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return AsyncTaskKt.traceableFrame(string, (Function1)new Function1<Continuation<? super DatabaseConnection>, Object>(this, DatabaseConnectionManager.this, null){
                int label;
                final /* synthetic */ Executor this$0;
                final /* synthetic */ DatabaseConnectionManager this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = Executor.access$establishConnectionAndPrepare(this.this$0, (Continuation)this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = (DatabaseConnection)v0;
                            if (v1 != null) {
                                var2_3 = v1;
                                var3_4 = this.this$1;
                                it = var2_3;
                                $i$a$-also-DatabaseConnectionManager$Executor$supplyAsync$2$1 = false;
                                DatabaseConnectionManager.access$getMyConnections$p(var3_4).add(it);
                                com.intellij.database.dataSource.DatabaseConnectionManager$Companion.access$connectionChanged(DatabaseConnectionManager.Companion, it, true);
                                v2 = var2_3;
                            } else {
                                v2 = null;
                            }
                            return v2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super DatabaseConnection> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
        }

        private final Object establishConnectionAndPrepare(Continuation<? super DatabaseConnection> $completion) {
            String string = DatabaseBundle.message("progress.title.prepare.connection", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return AsyncTaskKt.traceableFrame(string, (Function1)new Function1<Continuation<? super DatabaseConnection>, Object>(this, null){
                int label;
                final /* synthetic */ Executor this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = Executor.access$establishConnection(this.this$0, (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((connection = (DatabaseConnection)v0) != null) {
                                try {
                                    Executor.access$prepareDatabaseConnection(this.this$0, connection);
                                }
                                catch (Throwable th) {
                                    v1 = JdbcDriverManager.getDriverManager(Executor.access$getMyProject$p(this.this$0));
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDriverManager(...)");
                                    com.intellij.database.dataSource.DatabaseConnectionManager$Companion.access$releaseConnectionInner(DatabaseConnectionManager.Companion, v1, connection);
                                    throw new RuntimeException("Failed to prepare connection", th);
                                }
                            }
                            return connection;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super DatabaseConnection> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }, $completion);
        }

        private final void prepareDatabaseConnection(DatabaseConnection connection2) throws SQLException {
            DataSourceInfo.refreshDatabaseInfo(this.myConnectionPoint.getDataSource(), connection2);
            this.changeSessionTimeZone(connection2);
            this.runInitializationScript(connection2);
        }

        private final void changeSessionTimeZone(DatabaseConnection connection2) {
            LocalDataSource localDataSource = this.myConnectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource2 = localDataSource;
            ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = ExecutionEnvironmentHelper.EP.forDbms(dataSource2.getDbms()).getTimeZoneManager();
            Intrinsics.checkNotNullExpressionValue((Object)timeZoneManager, (String)"getTimeZoneManager(...)");
            ExecutionEnvironmentHelper.TimeZoneManager helper = timeZoneManager;
            String tz = Companion.getTimeZone(dataSource2);
            if (helper.canChange() && tz != null) {
                helper.changeTimeZone(connection2, tz);
            }
        }

        private final void runInitializationScript(DatabaseConnection connection2) throws SQLException {
            String initScript;
            String string = this.myConnectionPoint.getInitScript();
            if (string != null) {
                String string2;
                String it2 = string;
                boolean bl = false;
                try {
                    string2 = MacroManager.getInstance().expandSilentMacros(it2, true, SimpleDataContext.getProjectContext((Project)this.myProject));
                }
                catch (Macro.ExecutionCancelledException e2) {
                    string2 = it2;
                }
                v1 = string2;
            } else {
                v1 = initScript = null;
            }
            if (StringUtil.isNotEmpty(initScript)) {
                String string3 = initScript;
                Intrinsics.checkNotNull((Object)string3);
                List<String> list = DbSqlUtilCore.getQueries(string3, this.myProject, DbSqlUtilCore.getLanguage(this.myConnectionPoint.getDataSource()));
                Intrinsics.checkNotNullExpressionValue(list, (String)"getQueries(...)");
                List<String> queries = list;
                BarrenStatement<String> barren = SmartStatements.Companion.poweredBy(connection2).simple().barren();
                for (String query : queries) {
                    Intrinsics.checkNotNull((Object)query);
                    barren.execute(query);
                }
            }
        }

        private final Object establishConnection(Continuation<? super DatabaseConnection> $completion) {
            ConnectionRequestor requestor;
            ConnectionRequestor connectionRequestor = this.myRequestor;
            if (connectionRequestor == null) {
                connectionRequestor = requestor = (ConnectionRequestor)new ConnectionRequestor.Anonymous();
            }
            if (DatabaseConnectionManagerKt.access$getOurInterceptor$p() != null) {
                ConnectInterceptor connectInterceptor = DatabaseConnectionManagerKt.access$getOurInterceptor$p();
                Intrinsics.checkNotNull((Object)connectInterceptor);
                return connectInterceptor.establishConnection(this.myConnectionPoint, this.myRunConfiguration, requestor, this.myProject, this.myAskPassword, $completion);
            }
            return DatabaseConnectionEstablisher.Companion.establishConnection(this.myConnectionPoint, this.myRunConfiguration, requestor, Executor::establishConnection$lambda$1, this.myProject, this.myAskPassword, $completion);
        }

        private static final void establishConnection$lambda$1(JdbcDriverManager driverManager, DatabaseConnection connection2) {
            Intrinsics.checkNotNullParameter((Object)((Object)driverManager), (String)"driverManager");
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Companion.releaseConnectionInner(driverManager, connection2);
        }

        public static final /* synthetic */ void access$release(Executor $this, JdbcDriverManager driverManager, DatabaseConnection ref2) {
            $this.release(driverManager, ref2);
        }

        public static final /* synthetic */ Object access$perform(Executor $this, DatabaseConnection connection2, ErrorHandler errorHandler, Function2 op, Continuation $completion) {
            return $this.perform(connection2, errorHandler, op, $completion);
        }

        public static final /* synthetic */ Object access$supplyAsync(Executor $this, Continuation $completion) {
            return $this.supplyAsync((Continuation<? super DatabaseConnection>)$completion);
        }

        public static final /* synthetic */ Object access$establishConnectionAndPrepare(Executor $this, Continuation $completion) {
            return $this.establishConnectionAndPrepare((Continuation<? super DatabaseConnection>)$completion);
        }

        public static final /* synthetic */ Object access$establishConnection(Executor $this, Continuation $completion) {
            return $this.establishConnection((Continuation<? super DatabaseConnection>)$completion);
        }

        public static final /* synthetic */ void access$prepareDatabaseConnection(Executor $this, DatabaseConnection connection2) {
            $this.prepareDatabaseConnection(connection2);
        }

        public static final /* synthetic */ Project access$getMyProject$p(Executor $this) {
            return $this.myProject;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Listener;", "", "connectionChanged", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "added", "", "connectionFailed", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "th", "", "intellij.database.connectivity"})
    public static interface Listener {
        public void connectionChanged(@NotNull DatabaseConnection var1, boolean var2);

        default public void connectionFailed(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull Throwable th) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)th, (String)"th");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseConnectionManager$Operation;", "T", "", "perform", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lcom/intellij/database/dataSource/DatabaseConnection;)Ljava/lang/Object;", "intellij.database.connectivity"})
    public static interface Operation<T> {
        public T perform(@NotNull DatabaseConnection var1) throws Exception;
    }
}

