/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DBConnectionAccessibilityMatcher;
import com.intellij.database.dataSource.DBConnectionAccessibilityMatchingService;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dataSource/DataSourceConnectionAccessibilityMatchingService;", "Lcom/intellij/database/dataSource/DBConnectionAccessibilityMatchingService;", "()V", "getAccessibilityMatcher", "Lcom/intellij/database/dataSource/DBConnectionAccessibilityMatcher;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "DatabaseAccessibilityMatcher", "intellij.database.connectivity"})
public final class DataSourceConnectionAccessibilityMatchingService
implements DBConnectionAccessibilityMatchingService {
    @Override
    @Nullable
    public DBConnectionAccessibilityMatcher getAccessibilityMatcher(@NotNull LocalDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        DatabaseDriver databaseDriver = dataSource2.getDatabaseDriver();
        if (databaseDriver == null) {
            return null;
        }
        DatabaseDriver databaseDriver2 = databaseDriver;
        DatabaseDriver.Bounds bounds = databaseDriver2.getConnectionBounds();
        if (bounds == null) {
            return null;
        }
        DatabaseDriver.Bounds bounds2 = bounds;
        return Intrinsics.areEqual((Object)bounds2.boundTo, (Object)ObjectKind.DATABASE) ? (DBConnectionAccessibilityMatcher)new DatabaseAccessibilityMatcher(dataSource2.isRewriteBounds(), bounds2) : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/DataSourceConnectionAccessibilityMatchingService$DatabaseAccessibilityMatcher;", "Lcom/intellij/database/dataSource/DBConnectionAccessibilityMatcher;", "canSwitchDatabase", "", "driverConnectionBounds", "Lcom/intellij/database/dataSource/DatabaseDriver$Bounds;", "(ZLcom/intellij/database/dataSource/DatabaseDriver$Bounds;)V", "getCanSwitchDatabase", "()Z", "getDriverConnectionBounds", "()Lcom/intellij/database/dataSource/DatabaseDriver$Bounds;", "getDriverBounds", "isDatabaseAccessible", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.connectivity"})
    private static final class DatabaseAccessibilityMatcher
    implements DBConnectionAccessibilityMatcher {
        private final boolean canSwitchDatabase;
        @Nullable
        private final DatabaseDriver.Bounds driverConnectionBounds;

        public DatabaseAccessibilityMatcher(boolean canSwitchDatabase, @Nullable DatabaseDriver.Bounds driverConnectionBounds) {
            this.canSwitchDatabase = canSwitchDatabase;
            this.driverConnectionBounds = driverConnectionBounds;
        }

        public final boolean getCanSwitchDatabase() {
            return this.canSwitchDatabase;
        }

        @Nullable
        public final DatabaseDriver.Bounds getDriverConnectionBounds() {
            return this.driverConnectionBounds;
        }

        @Override
        public boolean isDatabaseAccessible(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull BasicDatabase database) {
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            if (database.isCurrent() && !this.canSwitchDatabase) {
                return true;
            }
            ObjectPath op = ObjectPaths.of(database);
            boolean outOfBounds = JdbcUrlParserUtil.outOfBounds(connectionPoint, op);
            return !outOfBounds;
        }

        @Override
        @Nullable
        public DatabaseDriver.Bounds getDriverBounds() {
            return this.driverConnectionBounds;
        }

        @Override
        public boolean canSwitchDatabase() {
            return this.canSwitchDatabase;
        }
    }
}

