/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DataSourcePage;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.view.DatabaseDocumentationService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.JTextPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u000b\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/console/DataSourceInfoPage;", "Lcom/intellij/database/console/DataSourcePage;", "dataSource", "Lcom/intellij/database/psi/DbDataSourceImpl;", "(Lcom/intellij/database/psi/DbDataSourceImpl;)V", "getDataSource", "()Lcom/intellij/database/psi/DbDataSourceImpl;", "primaryComponent", "Lcom/intellij/ui/components/JBScrollPane;", "getPrimaryComponent", "()Lcom/intellij/ui/components/JBScrollPane;", "tabTitleSup", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "getTabTitleSup", "()Ljava/util/function/Supplier;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceInfoTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceInfoTool.kt\ncom/intellij/database/console/DataSourceInfoPage\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,82:1\n31#2,2:83\n*S KotlinDebug\n*F\n+ 1 DataSourceInfoTool.kt\ncom/intellij/database/console/DataSourceInfoPage\n*L\n73#1:83,2\n*E\n"})
public final class DataSourceInfoPage
extends DataSourcePage {
    @NotNull
    private final DbDataSourceImpl dataSource;
    @NotNull
    private final Supplier<String> tabTitleSup;
    @NotNull
    private final JBScrollPane primaryComponent;

    /*
     * WARNING - void declaration
     */
    public DataSourceInfoPage(@NotNull DbDataSourceImpl dataSource2) {
        void $this$_init__u24lambda_u240;
        JBScrollPane jBScrollPane;
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        this.dataSource = dataSource2;
        Supplier<String> supplier2 = DatabaseBundle.messagePointer("service.tab.info.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier2, (String)"messagePointer(...)");
        this.tabTitleSup = supplier2;
        JTextPane textPane = new JTextPane();
        JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)textPane);
        DataSourceInfoPage dataSourceInfoPage = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setHorizontalScrollBarPolicy(30);
        $this$_init__u24lambda_u240.setVerticalScrollBarPolicy(20);
        $this$_init__u24lambda_u240.setBorder(JBUI.Borders.empty((int)2));
        dataSourceInfoPage.primaryComponent = jBScrollPane;
        Project project = this.dataSource.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DatabaseDocumentationService> serviceClass$iv = DatabaseDocumentationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DatabaseDocumentationService docService = (DatabaseDocumentationService)object;
        StringBuilder b2 = new StringBuilder();
        Object d2 = this.dataSource.getDelegate();
        Intrinsics.checkNotNullExpressionValue(d2, (String)"getDelegate(...)");
        docService.produceForDataSourceFast((RawDataSource)d2, b2);
        String text2 = StringFun.wrapWithHtmlTag(b2);
        Messages.configureMessagePaneUi((JTextPane)textPane, (String)text2);
    }

    @NotNull
    public final DbDataSourceImpl getDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public Supplier<String> getTabTitleSup() {
        return this.tabTitleSup;
    }

    @NotNull
    public JBScrollPane getPrimaryComponent() {
        return this.primaryComponent;
    }
}

