/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliModel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliPathBrowseFolderListener
extends TextBrowseFolderListener {
    private final CliModel myModel;
    private final TextFieldWithBrowseButton myExecutableField;

    public CliPathBrowseFolderListener(@NotNull FileChooserDescriptor fileChooserDescriptor, @NotNull CliModel model2, @NotNull TextFieldWithBrowseButton field) {
        if (fileChooserDescriptor == null) {
            CliPathBrowseFolderListener.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            CliPathBrowseFolderListener.$$$reportNull$$$0(1);
        }
        if (field == null) {
            CliPathBrowseFolderListener.$$$reportNull$$$0(2);
        }
        super(fileChooserDescriptor);
        this.myModel = model2;
        this.myExecutableField = field;
    }

    @Nullable
    protected VirtualFile getInitialFile() {
        VirtualFile root2 = (VirtualFile)ContainerUtil.getFirstItem((List)this.myFileChooserDescriptor.getRoots());
        if (root2 != null) {
            return root2;
        }
        return super.getInitialFile();
    }

    protected void chooseFile(FileChooserDescriptor descriptor2) {
        PathChooserDialog pathChooser = this.myModel.getRunTarget().createPathChooser(descriptor2, this.getProject(), this.myTextComponent);
        pathChooser.choose(this.getInitialFile(), files2 -> this.onFileChosen((VirtualFile)files2.get(0)));
    }

    protected void onFileChosen(@NotNull VirtualFile chosenFile) {
        if (chosenFile == null) {
            CliPathBrowseFolderListener.$$$reportNull$$$0(3);
        }
        String currentPath = this.myExecutableField.getText();
        Object chosenPath = this.myModel.getRunTarget().getPresentableUrl(chosenFile);
        if (chosenFile.isDirectory() && !currentPath.isEmpty()) {
            chosenPath = (String)chosenPath + "/" + PathUtil.getFileName((String)currentPath);
        }
        this.myExecutableField.setText((String)chosenPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/cli/CliPathBrowseFolderListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onFileChosen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

