/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.diagnostic;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.diagnostic.DumpModelAction;
import com.intellij.database.actions.diagnostic.PrepareIntrospectionDiagnostic;
import com.intellij.database.model.DescriptionOptions;
import com.intellij.database.model.ModelDescribing;
import com.intellij.database.model.ModelDescriptionAnnotation;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.util.CodeMarker;
import com.intellij.database.util.CodeWithMarkers;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.sql.editor.SqlColors;
import com.intellij.ui.JBColor;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0005\u001e\u001f !\"B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0006\u0010\u0016\u001a\u00020\u0013J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/actions/diagnostic/DumpModelDialog;", "Lcom/intellij/openapi/Disposable;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "(Ljava/util/Collection;)V", "document", "Lcom/intellij/openapi/editor/Document;", "editorFactory", "Lcom/intellij/openapi/editor/EditorFactory;", "ready", "", "text", "", "useSurrogates", "useXml", "viewer", "Lcom/intellij/openapi/editor/Editor;", "copyTextToClipboard", "", "describeXml", "dispose", "doIt", "highlightText", "cwm", "Lcom/intellij/database/util/CodeWithMarkers;", "Lcom/intellij/database/model/ModelDescriptionAnnotation;", "populateDocument", "populateDocumentWithText", "populateDocumentWithXml", "Companion", "DefaultDumpHighlighting", "DumpHighlighting", "RightDumbAwareAction", "SchemaDumpHighlighting", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDumpModelDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpModelDialog.kt\ncom/intellij/database/actions/diagnostic/DumpModelDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1446#2,5:307\n*S KotlinDebug\n*F\n+ 1 DumpModelDialog.kt\ncom/intellij/database/actions/diagnostic/DumpModelDialog\n*L\n191#1:307,5\n*E\n"})
public final class DumpModelDialog
implements Disposable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<BasicNode> nodes;
    @NotNull
    private final EditorFactory editorFactory;
    @NotNull
    private final Document document;
    @NotNull
    private final Editor viewer;
    private boolean useSurrogates;
    private boolean useXml;
    @Nullable
    private String text;
    private boolean ready;
    @Deprecated
    public static final int highlightingLayer = 2002;

    public DumpModelDialog(@NotNull Collection<? extends BasicNode> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.nodes = nodes;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"getInstance(...)");
        this.editorFactory = editorFactory;
        Document document = this.editorFactory.createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        this.document = document;
        Editor editor2 = this.editorFactory.createViewer(this.document);
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"createViewer(...)");
        this.viewer = editor2;
        this.viewer.getSettings().setUseSoftWraps(false);
    }

    public final void doIt() {
        DialogBuilder dialogBuilder;
        JComponent jComponent = this.viewer.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent viewerComponent = jComponent;
        viewerComponent.setMinimumSize(new Dimension(200, 200));
        viewerComponent.setPreferredSize(new Dimension(500, 500));
        Supplier<String> supplier2 = DatabaseBundle.messagePointer("action.with.synthetic.stuff.text", new Object[0]);
        Supplier<String> supplier3 = DatabaseBundle.messagePointer("action.include.auto.generated.objects.names.description", new Object[0]);
        Supplier<String> supplier4 = DatabaseIcons.BinaryData;
        ToggleAction withSurrogatesAction2 = new ToggleAction(this, supplier2, supplier3, (Icon)((Object)supplier4)){
            final /* synthetic */ DumpModelDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public boolean isSelected(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                return DumpModelDialog.access$getUseSurrogates$p(this.this$0);
            }

            public void setSelected(@NotNull AnActionEvent e2, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                DumpModelDialog.access$setUseSurrogates$p(this.this$0, state);
                DumpModelDialog.access$setUseXml$p(this.this$0, false);
                DumpModelDialog.access$populateDocument(this.this$0);
            }
        };
        supplier3 = DatabaseBundle.messagePointer("action.show.xml.text", new Object[0]);
        supplier4 = DumpModelDialog::doIt$lambda$0;
        Supplier<String> supplier5 = AllIcons.FileTypes.Xml;
        ToggleAction useXmlAction2 = new ToggleAction(this, supplier3, supplier4, (Icon)((Object)supplier5)){
            final /* synthetic */ DumpModelDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public boolean isSelected(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                return DumpModelDialog.access$getUseXml$p(this.this$0);
            }

            public void setSelected(@NotNull AnActionEvent e2, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                DumpModelDialog.access$setUseXml$p(this.this$0, state);
                DumpModelDialog.access$setUseSurrogates$p(this.this$0, true);
                DumpModelDialog.access$populateDocument(this.this$0);
            }
        };
        supplier4 = DatabaseBundle.messagePointer("action.DumpModelEntityDebugAction.text", new Object[0]);
        supplier5 = Presentation.NULL_STRING;
        AnAction[] anActionArray = AllIcons.Actions.Refresh;
        RefreshAction refreshAction2 = new RefreshAction(this, supplier4, supplier5, (Icon)anActionArray){
            final /* synthetic */ DumpModelDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void update(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                e2.getPresentation().setEnabled(DumpModelDialog.access$getReady$p(this.this$0));
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                DumpModelDialog.access$populateDocument(this.this$0);
            }
        };
        refreshAction2.registerShortcutOn(viewerComponent);
        supplier5 = DatabaseBundle.messagePointer("action.DumpModelEntityDebugAction.copyText.text", new Object[0]);
        anActionArray = AllIcons.Actions.Copy;
        RightDumbAwareAction copyTextAction2 = new RightDumbAwareAction(this, supplier5, (Icon)anActionArray){
            final /* synthetic */ DumpModelDialog this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNull($super_call_param$1);
                Intrinsics.checkNotNull((Object)$super_call_param$2);
                super($super_call_param$1, $super_call_param$2);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean enabled() {
                if (!DumpModelDialog.access$getReady$p(this.this$0)) return false;
                CharSequence $this$isNotNullOrEmpty$iv = DumpModelDialog.access$getText$p(this.this$0);
                boolean $i$f$isNotNullOrEmpty = false;
                if ($this$isNotNullOrEmpty$iv == null) return false;
                if ($this$isNotNullOrEmpty$iv.length() <= 0) return false;
                return true;
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                DumpModelDialog.access$copyTextToClipboard(this.this$0);
            }
        };
        anActionArray = new AnAction[]{withSurrogatesAction2, useXmlAction2, refreshAction2, copyTextAction2};
        DefaultActionGroup buttonsGroup = new DefaultActionGroup(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("DbDump", (ActionGroup)buttonsGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar2 = actionToolbar;
        toolbar2.setTargetComponent(viewerComponent);
        DialogBuilder $this$doIt_u24lambda_u241 = dialogBuilder = new DialogBuilder();
        boolean bl = false;
        $this$doIt_u24lambda_u241.setTitle(DatabaseBundle.message("dialog.title.database.model.dump", new Object[0]));
        $this$doIt_u24lambda_u241.setNorthPanel(toolbar2.getComponent());
        $this$doIt_u24lambda_u241.setCenterPanel(viewerComponent);
        $this$doIt_u24lambda_u241.setPreferredFocusComponent(this.viewer.getContentComponent());
        $this$doIt_u24lambda_u241.addDisposable((Disposable)this);
        $this$doIt_u24lambda_u241.setDimensionServiceKey(DumpModelAction.class.getSimpleName());
        $this$doIt_u24lambda_u241.removeAllActions();
        DialogBuilder dia = dialogBuilder;
        dia.showNotModal();
        this.populateDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void populateDocument() {
        this.ready = false;
        try {
            if (this.useXml) {
                this.populateDocumentWithXml();
            } else {
                this.populateDocumentWithText();
            }
        }
        finally {
            this.ready = true;
        }
    }

    private final void populateDocumentWithText() {
        String text2;
        boolean useLevels = this.useSurrogates;
        boolean bl = this.useSurrogates;
        CodeWithMarkers<ModelDescriptionAnnotation> cwm = ModelDescribing.describeForest((Iterable<? extends BasicNode>)this.nodes, new DescriptionOptions(useLevels, bl, false, true, 4, null));
        this.text = text2 = cwm.getText();
        ApplicationManager.getApplication().runWriteAction(() -> DumpModelDialog.populateDocumentWithText$lambda$2(this, text2, cwm));
    }

    private final void populateDocumentWithXml() {
        String text2;
        this.text = text2 = this.describeXml(this.nodes);
        ApplicationManager.getApplication().runWriteAction(() -> DumpModelDialog.populateDocumentWithXml$lambda$3(this, text2));
    }

    private final void highlightText(CodeWithMarkers<ModelDescriptionAnnotation> cwm) {
        DumpHighlighting dumpHighlighting;
        if (Registry.is((String)"database.dump.model.useEditorColors")) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
            dumpHighlighting = new SchemaDumpHighlighting((TextAttributesScheme)editorColorsScheme);
        } else {
            dumpHighlighting = DefaultDumpHighlighting.INSTANCE;
        }
        DumpHighlighting dh = dumpHighlighting;
        MarkupModel markupModel = this.viewer.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        MarkupModel markupModel2 = markupModel;
        for (CodeMarker<ModelDescriptionAnnotation> marker : cwm.getMarkers()) {
            TextAttributes ta;
            switch (WhenMappings.$EnumSwitchMapping$0[marker.getAnnotation().ordinal()]) {
                case 1: {
                    TextAttributes textAttributes = dh.hgIntroLevel(cwm.charAt(marker, 1));
                    break;
                }
                case 2: {
                    TextAttributes textAttributes = dh.hgDetailsLevel(cwm.charAt(marker, 1));
                    break;
                }
                case 3: {
                    TextAttributes textAttributes = dh.getHgName();
                    break;
                }
                case 4: {
                    TextAttributes textAttributes = dh.getHgObjectId();
                    break;
                }
                case 5: {
                    TextAttributes textAttributes = dh.getHgNaturalPosition();
                    break;
                }
                case 6: {
                    TextAttributes textAttributes = dh.getHgAdditionalOptions();
                    break;
                }
                case 7: {
                    TextAttributes textAttributes = dh.getHgComment();
                    break;
                }
                default: {
                    TextAttributes textAttributes = ta = null;
                }
            }
            if (ta == null) continue;
            markupModel2.addRangeHighlighter(marker.getBegin(), marker.getEnd(), 2002, ta, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String describeXml(Collection<? extends BasicNode> nodes) {
        String string;
        void destination$iv;
        void $this$flatMapTo$iv;
        if (nodes.isEmpty()) {
            return "";
        }
        Iterable iterable = nodes;
        Collection collection2 = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            BasicNode it2 = (BasicNode)element$iv;
            boolean bl = false;
            BasicNode basicNode = it2;
            Iterable list$iv = basicNode instanceof BasicElement ? (Iterable)CollectionsKt.listOf((Object)it2) : (basicNode instanceof Family ? (Iterable)((Object)it2) : (Iterable)CollectionsKt.emptyList());
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet elements2 = (HashSet)destination$iv;
        BasicModel basicModel = ((BasicNode)CollectionsKt.first((Iterable)nodes)).getModel();
        Intrinsics.checkNotNull((Object)basicModel, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModModel");
        BasicModModel basicModModel = PrepareIntrospectionDiagnostic.retainedModel((BasicModModel)basicModel, elements2);
        Intrinsics.checkNotNullExpressionValue((Object)basicModModel, (String)"retainedModel(...)");
        BasicModModel model2 = basicModModel;
        Closeable closeable = new StringWriter();
        Object object = null;
        try {
            StringWriter res2 = (StringWriter)closeable;
            boolean bl = false;
            PrintWriter printWriter = new PrintWriter(res2);
            printWriter.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            ModelSerializerKt.serialize(model2, new PrettyPrintWriter(printWriter), null);
            string = res2.toString();
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)closeable, object);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"use(...)");
        return string2;
    }

    private final void copyTextToClipboard() {
        String string = this.text;
        if (string == null) {
            return;
        }
        String text2 = string;
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
    }

    public void dispose() {
        this.editorFactory.releaseEditor(this.viewer);
    }

    private static final String doIt$lambda$0() {
        return null;
    }

    private static final void populateDocumentWithText$lambda$2(DumpModelDialog this$0, String $text, CodeWithMarkers $cwm) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$cwm, (String)"$cwm");
        this$0.document.setText((CharSequence)$text);
        this$0.highlightText($cwm);
    }

    private static final void populateDocumentWithXml$lambda$3(DumpModelDialog this$0, String $text) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        this$0.document.setText((CharSequence)$text);
    }

    public static final /* synthetic */ boolean access$getUseSurrogates$p(DumpModelDialog $this) {
        return $this.useSurrogates;
    }

    public static final /* synthetic */ void access$setUseSurrogates$p(DumpModelDialog $this, boolean bl) {
        $this.useSurrogates = bl;
    }

    public static final /* synthetic */ void access$setUseXml$p(DumpModelDialog $this, boolean bl) {
        $this.useXml = bl;
    }

    public static final /* synthetic */ void access$populateDocument(DumpModelDialog $this) {
        $this.populateDocument();
    }

    public static final /* synthetic */ boolean access$getUseXml$p(DumpModelDialog $this) {
        return $this.useXml;
    }

    public static final /* synthetic */ boolean access$getReady$p(DumpModelDialog $this) {
        return $this.ready;
    }

    public static final /* synthetic */ String access$getText$p(DumpModelDialog $this) {
        return $this.text;
    }

    public static final /* synthetic */ void access$copyTextToClipboard(DumpModelDialog $this) {
        $this.copyTextToClipboard();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/actions/diagnostic/DumpModelDialog$Companion;", "", "()V", "highlightingLayer", "", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/actions/diagnostic/DumpModelDialog$DefaultDumpHighlighting;", "Lcom/intellij/database/actions/diagnostic/DumpModelDialog$DumpHighlighting;", "()V", "intellij.database.impl"})
    private static final class DefaultDumpHighlighting
    extends DumpHighlighting {
        @NotNull
        public static final DefaultDumpHighlighting INSTANCE = new DefaultDumpHighlighting();

        private DefaultDumpHighlighting() {
            super(new TextAttributes((Color)new JBColor(35723, 61680), null, null, null, 0), new TextAttributes((Color)new JBColor(5597999, 7376967), null, null, null, 0), new TextAttributes((Color)new JBColor(15308410, 16744272), null, null, null, 0), new TextAttributes((Color)JBColor.PINK, null, null, null, 0), new TextAttributes((Color)JBColor.GRAY, null, null, null, 2), new TextAttributes(null, (Color)new JBColor(0xF5F5F5, 0x808080), null, null, 1), new TextAttributes(null, (Color)new JBColor(16775885, 9127187), null, null, 1), new TextAttributes(null, (Color)new JBColor(0x90EE90, 3050327), null, null, 1), new TextAttributes(null, (Color)new JBColor(0x18FFFF, 35755), null, null, 1), new TextAttributes(null, (Color)new JBColor(0xF5F5F5, 0x808080), null, null, 0), new TextAttributes(null, (Color)new JBColor(16775885, 9127187), null, null, 0), new TextAttributes(null, (Color)new JBColor(0x90EE90, 3050327), null, null, 0), new TextAttributes(null, (Color)new JBColor(0x18FFFF, 35755), null, null, 0), null);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001Bo\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012\u0082\u0001\u0002#$\u00a8\u0006%"}, d2={"Lcom/intellij/database/actions/diagnostic/DumpModelDialog$DumpHighlighting;", "", "hgName", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "hgObjectId", "hgNaturalPosition", "hgAdditionalOptions", "hgComment", "hgIntroLevel0", "hgIntroLevel1", "hgIntroLevel2", "hgIntroLevel3", "hgDetailsLevel0", "hgDetailsLevel1", "hgDetailsLevel2", "hgDetailsLevel3", "(Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;Lcom/intellij/openapi/editor/markup/TextAttributes;)V", "getHgAdditionalOptions", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "getHgComment", "getHgDetailsLevel0", "getHgDetailsLevel1", "getHgDetailsLevel2", "getHgDetailsLevel3", "getHgIntroLevel0", "getHgIntroLevel1", "getHgIntroLevel2", "getHgIntroLevel3", "getHgName", "getHgNaturalPosition", "getHgObjectId", "hgDetailsLevel", "level", "", "hgIntroLevel", "Lcom/intellij/database/actions/diagnostic/DumpModelDialog$DefaultDumpHighlighting;", "Lcom/intellij/database/actions/diagnostic/DumpModelDialog$SchemaDumpHighlighting;", "intellij.database.impl"})
    private static abstract class DumpHighlighting {
        @NotNull
        private final TextAttributes hgName;
        @NotNull
        private final TextAttributes hgObjectId;
        @NotNull
        private final TextAttributes hgNaturalPosition;
        @NotNull
        private final TextAttributes hgAdditionalOptions;
        @NotNull
        private final TextAttributes hgComment;
        @NotNull
        private final TextAttributes hgIntroLevel0;
        @NotNull
        private final TextAttributes hgIntroLevel1;
        @NotNull
        private final TextAttributes hgIntroLevel2;
        @NotNull
        private final TextAttributes hgIntroLevel3;
        @NotNull
        private final TextAttributes hgDetailsLevel0;
        @NotNull
        private final TextAttributes hgDetailsLevel1;
        @NotNull
        private final TextAttributes hgDetailsLevel2;
        @NotNull
        private final TextAttributes hgDetailsLevel3;

        private DumpHighlighting(TextAttributes hgName, TextAttributes hgObjectId, TextAttributes hgNaturalPosition, TextAttributes hgAdditionalOptions, TextAttributes hgComment, TextAttributes hgIntroLevel0, TextAttributes hgIntroLevel1, TextAttributes hgIntroLevel2, TextAttributes hgIntroLevel3, TextAttributes hgDetailsLevel0, TextAttributes hgDetailsLevel1, TextAttributes hgDetailsLevel2, TextAttributes hgDetailsLevel3) {
            this.hgName = hgName;
            this.hgObjectId = hgObjectId;
            this.hgNaturalPosition = hgNaturalPosition;
            this.hgAdditionalOptions = hgAdditionalOptions;
            this.hgComment = hgComment;
            this.hgIntroLevel0 = hgIntroLevel0;
            this.hgIntroLevel1 = hgIntroLevel1;
            this.hgIntroLevel2 = hgIntroLevel2;
            this.hgIntroLevel3 = hgIntroLevel3;
            this.hgDetailsLevel0 = hgDetailsLevel0;
            this.hgDetailsLevel1 = hgDetailsLevel1;
            this.hgDetailsLevel2 = hgDetailsLevel2;
            this.hgDetailsLevel3 = hgDetailsLevel3;
        }

        @NotNull
        public final TextAttributes getHgName() {
            return this.hgName;
        }

        @NotNull
        public final TextAttributes getHgObjectId() {
            return this.hgObjectId;
        }

        @NotNull
        public final TextAttributes getHgNaturalPosition() {
            return this.hgNaturalPosition;
        }

        @NotNull
        public final TextAttributes getHgAdditionalOptions() {
            return this.hgAdditionalOptions;
        }

        @NotNull
        public final TextAttributes getHgComment() {
            return this.hgComment;
        }

        @NotNull
        public final TextAttributes getHgIntroLevel0() {
            return this.hgIntroLevel0;
        }

        @NotNull
        public final TextAttributes getHgIntroLevel1() {
            return this.hgIntroLevel1;
        }

        @NotNull
        public final TextAttributes getHgIntroLevel2() {
            return this.hgIntroLevel2;
        }

        @NotNull
        public final TextAttributes getHgIntroLevel3() {
            return this.hgIntroLevel3;
        }

        @NotNull
        public final TextAttributes getHgDetailsLevel0() {
            return this.hgDetailsLevel0;
        }

        @NotNull
        public final TextAttributes getHgDetailsLevel1() {
            return this.hgDetailsLevel1;
        }

        @NotNull
        public final TextAttributes getHgDetailsLevel2() {
            return this.hgDetailsLevel2;
        }

        @NotNull
        public final TextAttributes getHgDetailsLevel3() {
            return this.hgDetailsLevel3;
        }

        @Nullable
        public final TextAttributes hgIntroLevel(char level) {
            char c2 = level;
            return c2 == '0' ? this.hgIntroLevel0 : (c2 == '1' ? this.hgIntroLevel1 : (c2 == '2' ? this.hgIntroLevel2 : (c2 == '3' ? this.hgIntroLevel3 : null)));
        }

        @Nullable
        public final TextAttributes hgDetailsLevel(char level) {
            char c2 = level;
            return c2 == '0' ? this.hgDetailsLevel0 : (c2 == '1' ? this.hgDetailsLevel1 : (c2 == '2' ? this.hgDetailsLevel2 : (c2 == '3' ? this.hgDetailsLevel3 : null)));
        }

        public /* synthetic */ DumpHighlighting(TextAttributes hgName, TextAttributes hgObjectId, TextAttributes hgNaturalPosition, TextAttributes hgAdditionalOptions, TextAttributes hgComment, TextAttributes hgIntroLevel0, TextAttributes hgIntroLevel1, TextAttributes hgIntroLevel2, TextAttributes hgIntroLevel3, TextAttributes hgDetailsLevel0, TextAttributes hgDetailsLevel1, TextAttributes hgDetailsLevel2, TextAttributes hgDetailsLevel3, DefaultConstructorMarker $constructor_marker) {
            this(hgName, hgObjectId, hgNaturalPosition, hgAdditionalOptions, hgComment, hgIntroLevel0, hgIntroLevel1, hgIntroLevel2, hgIntroLevel3, hgDetailsLevel0, hgDetailsLevel1, hgDetailsLevel2, hgDetailsLevel3);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/diagnostic/DumpModelDialog$RightDumbAwareAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/RightAlignedToolbarAction;", "text", "Ljava/util/function/Supplier;", "", "icon", "Ljavax/swing/Icon;", "(Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "enabled", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private static abstract class RightDumbAwareAction
    extends DumbAwareAction
    implements RightAlignedToolbarAction {
        public RightDumbAwareAction(@NotNull Supplier<String> text2, @NotNull Icon icon) {
            Intrinsics.checkNotNullParameter(text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            super(text2, icon);
        }

        public abstract boolean enabled();

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            e2.getPresentation().setVisible(true);
            e2.getPresentation().setEnabled(this.enabled());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/actions/diagnostic/DumpModelDialog$SchemaDumpHighlighting;", "Lcom/intellij/database/actions/diagnostic/DumpModelDialog$DumpHighlighting;", "scheme", "Lcom/intellij/openapi/editor/colors/TextAttributesScheme;", "(Lcom/intellij/openapi/editor/colors/TextAttributesScheme;)V", "intellij.database.impl"})
    private static final class SchemaDumpHighlighting
    extends DumpHighlighting {
        public SchemaDumpHighlighting(@NotNull TextAttributesScheme scheme) {
            TextAttributes textAttributes;
            TextAttributes textAttributes2;
            TextAttributes textAttributes3;
            TextAttributes textAttributes4;
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            TextAttributes textAttributes5 = scheme.getAttributes(SqlColors.SQL_IDENT);
            if (textAttributes5 == null) {
                textAttributes5 = DefaultDumpHighlighting.INSTANCE.getHgName();
            }
            if ((textAttributes4 = scheme.getAttributes(SqlColors.SQL_LABEL)) == null) {
                textAttributes4 = DefaultDumpHighlighting.INSTANCE.getHgObjectId();
            }
            if ((textAttributes3 = scheme.getAttributes(SqlColors.SQL_LOCAL_ALIAS)) == null) {
                textAttributes3 = DefaultDumpHighlighting.INSTANCE.getHgNaturalPosition();
            }
            if ((textAttributes2 = scheme.getAttributes(SqlColors.SQL_TYPE)) == null) {
                textAttributes2 = DefaultDumpHighlighting.INSTANCE.getHgAdditionalOptions();
            }
            if ((textAttributes = scheme.getAttributes(SqlColors.SQL_COMMENT)) == null) {
                textAttributes = DefaultDumpHighlighting.INSTANCE.getHgComment();
            }
            super(textAttributes5, textAttributes4, textAttributes3, textAttributes2, textAttributes, DefaultDumpHighlighting.INSTANCE.getHgIntroLevel0(), DefaultDumpHighlighting.INSTANCE.getHgIntroLevel1(), DefaultDumpHighlighting.INSTANCE.getHgIntroLevel2(), DefaultDumpHighlighting.INSTANCE.getHgIntroLevel3(), DefaultDumpHighlighting.INSTANCE.getHgDetailsLevel0(), DefaultDumpHighlighting.INSTANCE.getHgDetailsLevel1(), DefaultDumpHighlighting.INSTANCE.getHgDetailsLevel2(), DefaultDumpHighlighting.INSTANCE.getHgDetailsLevel3(), null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModelDescriptionAnnotation.values().length];
            try {
                nArray[ModelDescriptionAnnotation.MdaIntrospectionLevel.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModelDescriptionAnnotation.MdaDetailsLevel.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModelDescriptionAnnotation.MdaName.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModelDescriptionAnnotation.MdaObjectId.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModelDescriptionAnnotation.MdaPosition.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModelDescriptionAnnotation.MdaAdditionalOptions.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModelDescriptionAnnotation.MdaComment.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

