/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbGridGotoRelatedProvider;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeNodeRankFun;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.AlignedIconWithTextAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenEditorAction
extends DumbAwareAction {
    public OpenEditorAction() {
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenEditorAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e2) {
        Project project;
        if (e2 == null) {
            OpenEditorAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (project = e2.getProject()) != null && this.isEnabled(e2) && this.getNavigatables(project, e2, false).filter(Navigatable::canNavigate).isNotEmpty();
        e2.getPresentation().setEnabled(enabled);
        e2.getPresentation().setVisible(enabled || e2.isFromActionToolbar());
    }

    protected boolean isEnabled(@NotNull AnActionEvent e2) {
        boolean mouseSelection;
        if (e2 == null) {
            OpenEditorAction.$$$reportNull$$$0(2);
        }
        if (mouseSelection = this.isMouseSelection(e2)) {
            return false;
        }
        Editor editor2 = (Editor)e2.getData(CommonDataKeys.EDITOR);
        return editor2 == null || editor2 instanceof ImaginaryEditor;
    }

    protected boolean isMouseSelection(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            OpenEditorAction.$$$reportNull$$$0(3);
        }
        return e2.getInputEvent() instanceof MouseEvent && UIUtil.isToggleListSelectionEvent((MouseEvent)((MouseEvent)e2.getInputEvent()));
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Project project;
        if (e2 == null) {
            OpenEditorAction.$$$reportNull$$$0(4);
        }
        if ((project = e2.getProject()) == null) {
            return;
        }
        OpenSourceUtil.navigate((boolean)true, (boolean)true, this.getNavigatables(project, e2, true));
    }

    @NotNull
    protected abstract JBIterable<? extends Navigatable> getNavigatables(@NotNull Project var1, @NotNull AnActionEvent var2, boolean var3);

    @NotNull
    private static JBIterable<PsiElement> getPsiElements(@NotNull AnActionEvent e2) {
        Object[] array;
        if (e2 == null) {
            OpenEditorAction.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = (array = (PsiElement[])e2.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) == null ? JBIterable.of((Object)((PsiElement)e2.getData(CommonDataKeys.PSI_ELEMENT))) : JBIterable.of((Object[])array);
        if (jBIterable == null) {
            OpenEditorAction.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMouseSelection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    static class OpenDDLGridAction
    extends AlignedIconWithTextAction
    implements DumbAware {
        OpenDDLGridAction() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                OpenDDLGridAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                OpenDDLGridAction.$$$reportNull$$$0(1);
            }
            PsiElement element2 = (PsiElement)e2.getData(CommonDataKeys.PSI_ELEMENT);
            boolean enabled = e2.getData(DatabaseDataKeys.DATA_GRID_KEY) != null && DbGridGotoRelatedProvider.getTargetElement(element2) != null;
            e2.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbElement target2;
            if (e2 == null) {
                OpenDDLGridAction.$$$reportNull$$$0(2);
            }
            if ((target2 = DbGridGotoRelatedProvider.getTargetElement((PsiElement)e2.getData(CommonDataKeys.PSI_ELEMENT))) == null) {
                return;
            }
            EditorWindow editorWindow = (EditorWindow)e2.getData(EditorWindow.DATA_KEY);
            if (editorWindow != null) {
                FileEditorManagerEx.getInstanceEx((Project)target2.getProject()).setCurrentWindow(editorWindow);
            }
            DbNavigationUtils.navigateToSource(target2, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDDLGridAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDDLGridAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class OpenFilesAction
    extends OpenEditorAction {
        OpenFilesAction() {
        }

        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e2, boolean forInvoke) {
            if (project == null) {
                OpenFilesAction.$$$reportNull$$$0(0);
            }
            if (e2 == null) {
                OpenFilesAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = OpenEditorAction.getPsiElements(e2).filterMap(n -> {
                DbDataSource mapped;
                DbDataSource o2 = (DbDataSource)ObjectUtils.tryCast((Object)DbNavigationUtils.extractDbElementFromPsi(n), DbDataSource.class);
                LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource(o2);
                DbDataSource dbDataSource = mapped = lds == null ? null : (DbDataSource)DdlMappingsManager.getInstance(project).findByDataSourceId(lds.getUniqueId()).filterMap(m -> DbPsiFacade.getInstance(project).findDataSource(m.getDdlDataSourceId())).first();
                if (mapped == null && lds != null) {
                    return null;
                }
                if (mapped != null) {
                    o2 = mapped;
                }
                if (o2 == null) {
                    return null;
                }
                return DbNavigationUtils.createToDataSourceFileNavigatable(o2);
            });
            if (jBIterable == null) {
                OpenFilesAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenFilesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenFilesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static class OpenDDLAction
    extends OpenEditorAction {
        OpenDDLAction() {
        }

        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e2, boolean forInvoke) {
            if (project == null) {
                OpenDDLAction.$$$reportNull$$$0(0);
            }
            if (e2 == null) {
                OpenDDLAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = OpenEditorAction.getPsiElements(e2).filterMap(n -> {
                DbElement o2 = DbNavigationUtils.extractDbElementFromPsi(n);
                if (o2 == null) {
                    return null;
                }
                if (DbSqlUtil.isSqlElement(o2)) {
                    return o2;
                }
                if (!DbNavigationUtils.canNavigateToSource(o2)) {
                    return null;
                }
                VirtualFile file = DbTargetUtil.getContainingFile(o2, forInvoke);
                if (file == null) {
                    return null;
                }
                if (!forInvoke) {
                    return new OpenFileDescriptor(project, file);
                }
                return DbNavigationUtils.createToSourceNavigatable(o2);
            });
            if (jBIterable == null) {
                OpenDDLAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public boolean useSmallerFontForTextInToolbar() {
            return true;
        }

        @Override
        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                OpenDDLAction.$$$reportNull$$$0(3);
            }
            super.update(e2);
            if (e2.getPlace().equals("DatabaseViewToolbar")) {
                e2.getPresentation().setText(DatabaseBundle.message("action.Jdbc.OpenEditor.Grid.DDL.text", new Object[0]));
                e2.getPresentation().setIcon(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static class OpenConsoleAction
    extends OpenEditorAction {
        OpenConsoleAction() {
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                OpenConsoleAction.$$$reportNull$$$0(0);
            }
            return !this.isMouseSelection(e2);
        }

        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e2, boolean forInvoke) {
            if (project == null) {
                OpenConsoleAction.$$$reportNull$$$0(1);
            }
            if (e2 == null) {
                OpenConsoleAction.$$$reportNull$$$0(2);
            }
            JBIterable jBIterable = OpenEditorAction.getPsiElements(e2).filterMap(o2 -> {
                if (e2.getData(CommonDataKeys.EDITOR) != null) {
                    return null;
                }
                DbElement element2 = DbNavigationUtils.extractDbElementFromPsi(o2);
                if (element2 != null && DbNavigationUtils.canNavigateToDataSourceFile(element2)) {
                    return DbNavigationUtils.createToDataSourceFileNavigatable(element2);
                }
                return null;
            });
            if (jBIterable == null) {
                OpenConsoleAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenConsoleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenConsoleAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static class OpenFamilyAction
    extends OpenEditorAction {
        OpenFamilyAction() {
        }

        @Override
        @NotNull
        protected JBIterable<? extends Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e2, boolean forInvoke) {
            if (project == null) {
                OpenFamilyAction.$$$reportNull$$$0(0);
            }
            if (e2 == null) {
                OpenFamilyAction.$$$reportNull$$$0(1);
            }
            DataContext context = e2.getDataContext();
            JBIterable jBIterable = OpenFamilyAction.collectSelectedFamilyWrappers(context, project).filter(navigatable -> navigatable.canNavigate());
            if (jBIterable == null) {
                OpenFamilyAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static JBIterable<? extends DatabaseNodeWrappingService.NodeWrapper> collectSelectedFamilyWrappers(@NotNull DataContext context, @NotNull Project project) {
            if (context == null) {
                OpenFamilyAction.$$$reportNull$$$0(3);
            }
            if (project == null) {
                OpenFamilyAction.$$$reportNull$$$0(4);
            }
            if (DatabaseContextFun.fromDatabaseTree(context)) {
                return OpenFamilyAction.collectSelectedFamilyWrappersFromTree(context, project);
            }
            return OpenFamilyAction.collectSelectedFamilyWrappersFromDbWrapper(context);
        }

        private static JBIterable<? extends DatabaseNodeWrappingService.NodeWrapper> collectSelectedFamilyWrappersFromTree(@NotNull DataContext context, @NotNull Project project) {
            Set<DvTreeNodeRank> ranks;
            if (context == null) {
                OpenFamilyAction.$$$reportNull$$$0(5);
            }
            if (project == null) {
                OpenFamilyAction.$$$reportNull$$$0(6);
            }
            if (!(ranks = DatabaseContextFun.getSelectedTreeNodeRanks(context)).contains(DvTreeNodeRank.TL_FAMILY)) {
                return JBIterable.empty();
            }
            DatabaseNodeWrappingService wrappingService2 = (DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class);
            return DatabaseContextFun.getSelectedNodes(context).filter(node2 -> DvTreeNodeRankFun.getTreeNodeRank(node2) == DvTreeNodeRank.TL_FAMILY).filterMap(node2 -> wrappingService2.wrap((BasicNode)node2)).filter(DatabaseNodeWrappingService.NodeWrapper.class);
        }

        private static JBIterable<? extends DatabaseNodeWrappingService.NodeWrapper> collectSelectedFamilyWrappersFromDbWrapper(@NotNull DataContext context) {
            if (context == null) {
                OpenFamilyAction.$$$reportNull$$$0(7);
            }
            return JBIterable.of((Object[])((Navigatable[])context.getData(CommonDataKeys.NAVIGATABLE_ARRAY))).filter(DatabaseNodeWrappingService.NodeWrapper.class).filter(nw -> DvTreeNodeRankFun.getTreeNodeRank(nw.getNode()) == DvTreeNodeRank.TL_FAMILY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenFamilyAction";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenFamilyAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSelectedFamilyWrappers";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSelectedFamilyWrappersFromTree";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSelectedFamilyWrappersFromDbWrapper";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static class OpenDataAction
    extends OpenEditorAction {
        OpenDataAction() {
        }

        @Override
        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                OpenDataAction.$$$reportNull$$$0(0);
            }
            super.update(e2);
            boolean goTo = "EditorPopup".equals(e2.getPlace());
            String text2 = DatabaseBundle.message(goTo ? "action.Jdbc.OpenEditor.Data.GoTo.text" : "action.Jdbc.OpenEditor.Data.text", new Object[0]);
            e2.getPresentation().setText(text2);
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                OpenDataAction.$$$reportNull$$$0(1);
            }
            return !this.isMouseSelection(e2);
        }

        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e2, boolean forInvoke) {
            if (project == null) {
                OpenDataAction.$$$reportNull$$$0(2);
            }
            if (e2 == null) {
                OpenDataAction.$$$reportNull$$$0(3);
            }
            JBIterable jBIterable = OpenEditorAction.getPsiElements(e2).filterMap(o2 -> {
                DasObject table;
                DataGrid grid;
                DbElement element2 = OpenDataAction.getDbElement(o2);
                DataGrid dataGrid = grid = element2 == null ? null : DataGridPomTarget.unwrapDataGrid((PsiElement)o2);
                if (grid != null && (table = DataGridUtilCore.getDatabaseTable((CoreGrid<GridRow, GridColumn>)grid)) != null && DasUtil.isAncestor(table, element2, false)) {
                    return null;
                }
                if (element2 == null || !DbNavigationUtils.canNavigateToData(element2)) {
                    return null;
                }
                return DbNavigationUtils.createToDataNavigatable(element2);
            });
            if (jBIterable == null) {
                OpenDataAction.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Nullable
        private static DbElement getDbElement(PsiElement o2) {
            DbElement element2 = DbNavigationUtils.extractDbElementFromPsi(o2);
            if (element2 != null) {
                return element2;
            }
            SqlDefinition def = (SqlDefinition)ObjectUtils.tryCast((Object)o2, SqlDefinition.class);
            if (def != null) {
                return (DbElement)SqlPsiFacade.getInstance((Project)def.getProject()).findRelatedDbElements((PsiElement)def, false).first();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

