/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LinkedDataSourceHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0006\n\u000b\f\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/actions/LinkedDataSourceGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "ChooseDataSourceAction", "ClearMapping", "Companion", "CreateDataSource", "Navigate", "SetMappingGroup", "intellij.database.impl"})
public final class LinkedDataSourceGroup
extends DefaultActionGroup
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        e2.getPresentation().setEnabledAndVisible(LinkedDataSourceGroup.Companion.getTargetObject(e2) != null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/actions/LinkedDataSourceGroup$ChooseDataSourceAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "targetDataSource", "Lcom/intellij/database/model/DasDataSource;", "(Lcom/intellij/database/model/DasDataSource;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.database.impl"})
    public static final class ChooseDataSourceAction
    extends DumbAwareAction {
        @NotNull
        private final DasDataSource targetDataSource;

        public ChooseDataSourceAction(@NotNull DasDataSource targetDataSource) {
            Intrinsics.checkNotNullParameter((Object)targetDataSource, (String)"targetDataSource");
            this.targetDataSource = targetDataSource;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Presentation $this$update_u24lambda_u240 = e2.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u240.setText(this.targetDataSource.getName());
            $this$update_u24lambda_u240.setIcon(this.targetDataSource.getIcon(0));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Companion.updateMapping(e2, this.targetDataSource);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/actions/LinkedDataSourceGroup$ClearMapping;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.database.impl"})
    public static final class ClearMapping
    extends AnAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            e2.getPresentation().setEnabledAndVisible(Companion.getMapping(e2) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Companion.updateMapping(e2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/LinkedDataSourceGroup$Companion;", "", "()V", "getLinkedDataSource", "Lcom/intellij/database/psi/DbDataSource;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getMapping", "", "getTargetObject", "Lcom/intellij/database/psi/DbElement;", "updateMapping", "", "targetDataSource", "Lcom/intellij/database/model/DasDataSource;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nLinkedDataSourceGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkedDataSourceGroup.kt\ncom/intellij/database/actions/LinkedDataSourceGroup$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final DbElement getTargetObject(AnActionEvent e2) {
            DbElement dbElement;
            DatabaseView databaseView = (DatabaseView)e2.getData(DatabaseView.DATABASE_VIEW_KEY);
            if (databaseView == null) {
                return null;
            }
            DatabaseView databaseView2 = databaseView;
            Object[] objectArray = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData((DataProvider)databaseView2);
            PsiElement psiElement = objectArray != null ? (PsiElement)ArraysKt.singleOrNull((Object[])objectArray) : null;
            DbElement dbElement2 = psiElement instanceof DbElement ? (DbElement)psiElement : null;
            if (dbElement2 == null) {
                return null;
            }
            DbElement element2 = dbElement2;
            DbDataSource dbDataSource = element2.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
            DbDataSource dataSource2 = dbDataSource;
            if (DbImplUtilCore.getMaybeLocalDataSource(dataSource2) == null) {
                return null;
            }
            LinkedDataSourceHelper linkedDataSourceHelper = LinkedDataSourceHelper.of(dataSource2.getDbms());
            ObjectKind linkedKind = linkedDataSourceHelper != null ? linkedDataSourceHelper.getLinkedDataSourceKind() : null;
            DbElement it2 = dbElement = element2;
            boolean bl = false;
            return Intrinsics.areEqual((Object)it2.getKind(), (Object)linkedKind) ? dbElement : null;
        }

        private final String getMapping(AnActionEvent e2) {
            DbElement dbElement = this.getTargetObject(e2);
            if (dbElement == null) {
                return null;
            }
            DbElement target2 = dbElement;
            LocalDataSource localDataSource = DbImplUtilCore.getMaybeLocalDataSource(target2.getDataSource());
            if (localDataSource == null) {
                return null;
            }
            LocalDataSource ds = localDataSource;
            ObjectPath path = ObjectPaths.of(target2);
            return ds.getLinkedDataSourceIds().get(path);
        }

        private final DbDataSource getLinkedDataSource(AnActionEvent e2) {
            String string = this.getMapping(e2);
            if (string == null) {
                return null;
            }
            String id = string;
            Project project = e2.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            return DbPsiFacade.getInstance(project2).findDataSource(id);
        }

        private final void updateMapping(AnActionEvent e2, DasDataSource targetDataSource) {
            DbElement dbElement = this.getTargetObject(e2);
            if (dbElement == null) {
                return;
            }
            DbElement target2 = dbElement;
            LocalDataSource localDataSource = DbImplUtilCore.getMaybeLocalDataSource(target2.getDataSource());
            if (localDataSource == null) {
                return;
            }
            LocalDataSource ds = localDataSource;
            ObjectPath path = ObjectPaths.of(target2);
            if (targetDataSource != null) {
                Map<ObjectPath, String> map2 = ds.getLinkedDataSourceIds();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getLinkedDataSourceIds(...)");
                Map<ObjectPath, String> map3 = map2;
                String string = targetDataSource.getUniqueId();
                map3.put(path, string);
            } else {
                ds.getLinkedDataSourceIds().remove(path);
            }
            DbPsiFacade.getInstance(target2.getProject()).clearCaches();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/actions/LinkedDataSourceGroup$CreateDataSource;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.database.impl"})
    public static final class CreateDataSource
    extends AnAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            DbElement dbElement = Companion.getTargetObject(e2);
            if (dbElement == null) {
                return;
            }
            DbElement target2 = dbElement;
            Object object = target2.getDelegate();
            DasObject dasObject = object instanceof DasObject ? (DasObject)object : null;
            if (dasObject == null) {
                return;
            }
            DasObject link = dasObject;
            LocalDataSource localDataSource = DbImplUtilCore.getMaybeLocalDataSource(target2.getDataSource());
            if (localDataSource == null) {
                return;
            }
            LocalDataSource linkDs = localDataSource;
            LinkedDataSourceHelper linkedDataSourceHelper = LinkedDataSourceHelper.of(linkDs.getDbms());
            if (linkedDataSourceHelper == null) {
                return;
            }
            LinkedDataSourceHelper helper = linkedDataSourceHelper;
            Project project = target2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            LocalDataSource localDataSource2 = helper.createLinkedDataSource(link, linkDs, project2);
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource2, (String)"createLinkedDataSource(...)");
            LocalDataSource linkedDs = localDataSource2;
            DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(project2);
            Intrinsics.checkNotNull((Object)((Object)dbPsiFacade), (String)"null cannot be cast to non-null type com.intellij.database.psi.DbPsiFacadeImpl");
            DbPsiFacadeImpl dbPsiFacade2 = (DbPsiFacadeImpl)dbPsiFacade;
            LocalDataSourceManager localDataSourceManager = LocalDataSourceManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)localDataSourceManager, (String)"getInstance(...)");
            LocalDataSourceManager manager = localDataSourceManager;
            DbDataSource dbDataSource = dbPsiFacade2.createDataSourceWrapperElement(linkedDs, manager);
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"createDataSourceWrapperElement(...)");
            DbDataSource linkedDsPsi = dbDataSource;
            DataSourceManagerDialog.showDialog(dbPsiFacade2, linkedDsPsi, null, null, () -> CreateDataSource.actionPerformed$lambda$0(linkedDsPsi, e2));
        }

        private static final void actionPerformed$lambda$0(DbDataSource $linkedDsPsi, AnActionEvent $e) {
            Intrinsics.checkNotNullParameter((Object)$linkedDsPsi, (String)"$linkedDsPsi");
            Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
            if ($linkedDsPsi.isValid()) {
                Companion.updateMapping($e, $linkedDsPsi);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/actions/LinkedDataSourceGroup$Navigate;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.database.impl"})
    public static final class Navigate
    extends AnAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            e2.getPresentation().setEnabledAndVisible(Companion.getLinkedDataSource(e2) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            DbDataSource dbDataSource = Companion.getLinkedDataSource(e2);
            if (dbDataSource == null) {
                return;
            }
            DbDataSource target2 = dbDataSource;
            DatabaseView.select(target2, true);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/actions/LinkedDataSourceGroup$SetMappingGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nLinkedDataSourceGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkedDataSourceGroup.kt\ncom/intellij/database/actions/LinkedDataSourceGroup$SetMappingGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,143:1\n1611#2:144\n1855#2:145\n1856#2:147\n1612#2:148\n1#3:146\n37#4,2:149\n*S KotlinDebug\n*F\n+ 1 LinkedDataSourceGroup.kt\ncom/intellij/database/actions/LinkedDataSourceGroup$SetMappingGroup\n*L\n72#1:144\n72#1:145\n72#1:147\n72#1:148\n72#1:146\n76#1:149,2\n*E\n"})
    public static final class SetMappingGroup
    extends ActionGroup {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e2) {
            if (e2 == null) {
                Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return AnAction.EMPTY_ARRAY;
            }
            DbElement dbElement = Companion.getTargetObject(e2);
            if (dbElement == null) {
                Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return AnAction.EMPTY_ARRAY;
            }
            DbElement target2 = dbElement;
            Dbms dbms = target2.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            ArrayList actions = new ArrayList();
            for (DataSourceManager<?> manager : DataSourceManager.getManagers(target2.getProject())) {
                List<?> dataSources2;
                Intrinsics.checkNotNullExpressionValue(manager.getDataSources(), (String)"getDataSources(...)");
                if (dataSources2.isEmpty()) continue;
                if (!((Collection)actions).isEmpty()) {
                    ((Collection)actions).add(Separator.getInstance());
                }
                Iterable $this$mapNotNullTo$iv = dataSources2;
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ChooseDataSourceAction chooseDataSourceAction;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    RawDataSource it2 = (RawDataSource)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it2.getDbms(), (Object)dbms2)) {
                        Intrinsics.checkNotNull((Object)it2);
                        chooseDataSourceAction = new ChooseDataSourceAction(it2);
                    } else {
                        chooseDataSourceAction = null;
                    }
                    if (chooseDataSourceAction == null) continue;
                    ChooseDataSourceAction it$iv = chooseDataSourceAction;
                    boolean bl3 = false;
                    ((Collection)actions).add(it$iv);
                }
            }
            Collection $this$toTypedArray$iv = actions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new AnAction[0]);
        }
    }
}

