/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u001dJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0018\u001a\u00020\u001dJ\u0012\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\u0012H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\bH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0014\u0010'\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010)\u001a\u00020\u00142\b\u0010%\u001a\u0004\u0018\u00010\bH\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/DbModelRegistry;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "models", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/psi/DbDataSource;", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFacade", "Lcom/intellij/database/psi/DbPsiFacade;", "getPsiFacade", "()Lcom/intellij/database/psi/DbPsiFacade;", "psiFacade$delegate", "Lkotlin/Lazy;", "roots", "Lcom/intellij/database/model/DasObject;", "clear", "", "dispose", "findDataSource", "Lcom/intellij/database/model/RawDataSource;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "model", "findDbDataSource", "o", "Lcom/intellij/database/model/basic/BasicObjectNode;", "dsn", "Lcom/intellij/database/view/DataSourceNode;", "findDbElement", "Lcom/intellij/database/psi/DbElement;", "getDbDataSourceByRoot", "root", "invalidate", "dbDS", "obtainDbDataSourceForModel", "obtainDbDataSourceForRoot", "key", "onDataSourceChanged", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDbModelRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbModelRegistry.kt\ncom/intellij/database/DbModelRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n1747#3,3:181\n*S KotlinDebug\n*F\n+ 1 DbModelRegistry.kt\ncom/intellij/database/DbModelRegistry\n*L\n61#1:181,3\n*E\n"})
public final class DbModelRegistry
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy psiFacade$delegate;
    @NotNull
    private final ConcurrentMap<BasicModel, DbDataSource> models;
    @NotNull
    private final ConcurrentMap<DasObject, DbDataSource> roots;

    private DbModelRegistry(Project project) {
        this.project = project;
        this.psiFacade$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DbPsiFacade>(this){
            final /* synthetic */ DbModelRegistry this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DbPsiFacade invoke() {
                DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(this.this$0.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dbPsiFacade), (String)"getInstance(...)");
                return dbPsiFacade;
            }
        }));
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createWeakMap(arg_0 -> DbModelRegistry.models$lambda$0((Function1)new Function1<BasicModel, DbDataSource>((Object)this){

            @Nullable
            public final DbDataSource invoke(@NotNull BasicModel p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DbModelRegistry.access$obtainDbDataSourceForModel((DbModelRegistry)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createWeakMap(...)");
        this.models = concurrentMap;
        ConcurrentMap concurrentMap2 = ConcurrentFactoryMap.create(arg_0 -> DbModelRegistry.roots$lambda$1((Function1)new Function1<DasObject, DbDataSource>((Object)this){

            @Nullable
            public final DbDataSource invoke(@Nullable DasObject p0) {
                return DbModelRegistry.access$obtainDbDataSourceForRoot((DbModelRegistry)this.receiver, p0);
            }
        }, arg_0), DbModelRegistry::roots$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"create(...)");
        this.roots = concurrentMap2;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<DbPsiFacade.Listener> topic = DbPsiFacade.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, this::onDataSourceChanged);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DbPsiFacade getPsiFacade() {
        Lazy lazy = this.psiFacade$delegate;
        return (DbPsiFacade)((Object)lazy.getValue());
    }

    private final DbDataSource obtainDbDataSourceForModel(BasicModel model2) {
        Object v1;
        block1: {
            List<DbDataSource> list = this.getPsiFacade().getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DbDataSource ds = (DbDataSource)t;
                boolean bl = false;
                if (!(ds.getDelegateDataSource().getModel() == model2)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final DbDataSource obtainDbDataSourceForRoot(DasObject key2) {
        Object v3;
        block7: {
            List<DbDataSource> list = this.getPsiFacade().getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                boolean bl;
                block6: {
                    DasModel model2;
                    DbDataSource o2 = (DbDataSource)t;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)o2.getDelegate().getModel(), (String)"getModel(...)");
                    if (model2 instanceof BasicModel) {
                        bl = ((BasicModel)model2).getRoot() == key2;
                    } else {
                        JBIterable<? extends DasObject> jBIterable = model2.getModelRoots();
                        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getModelRoots(...)");
                        Iterable $this$any$iv = (Iterable)jBIterable;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                DasObject root2 = (DasObject)element$iv;
                                boolean bl3 = false;
                                if (!(root2 == key2 || root2.getDasParent() == key2)) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    }
                }
                if (!bl) continue;
                v3 = t;
                break block7;
            }
            v3 = null;
        }
        return v3;
    }

    @Nullable
    public final RawDataSource findDataSource(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DbDataSource dbDataSource = this.findDbDataSource(element2);
        return dbDataSource != null ? DataSourceFun.getRawDataSource(dbDataSource) : null;
    }

    @Nullable
    public final RawDataSource findDataSource(@NotNull BasicModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        DbDataSource dbDataSource = this.findDbDataSource(model2);
        return dbDataSource != null ? DataSourceFun.getRawDataSource(dbDataSource) : null;
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.findDbDataSource((BasicObjectNode)element2);
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull BasicObjectNode element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicModel basicModel = element2.getModel();
        if (basicModel == null) {
            return null;
        }
        BasicModel model2 = basicModel;
        return this.findDbDataSource(model2);
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull BasicModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        DbDataSource dbDataSource = (DbDataSource)this.models.get(model2);
        if (dbDataSource != null && !dbDataSource.isValid()) {
            this.models.remove(model2);
            this.roots.remove(model2.getRoot(), dbDataSource);
            dbDataSource = (DbDataSource)this.models.get(model2);
        }
        return dbDataSource;
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull DataSourceNode dsn) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        BasicModel model2 = dsn.getModel();
        return model2 != null ? this.findDbDataSource(model2) : null;
    }

    @Nullable
    public final DbElement findDbElement(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.findDbElement((BasicObjectNode)element2);
    }

    @Nullable
    public final DbElement findDbElement(@NotNull BasicObjectNode element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DbDataSource dbDataSource = this.findDbDataSource(element2);
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dataSource2 = dbDataSource;
        DasObject dasObject = element2 instanceof DasObject ? (DasObject)((Object)element2) : null;
        if (dasObject == null) {
            BasicElement basicElement = element2.extractObject();
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"extractObject(...)");
            dasObject = basicElement;
        }
        return dataSource2.findElement(dasObject);
    }

    @Nullable
    public final DbDataSource findDbDataSource(@Nullable DasObject o2) {
        DbDataSource dbDataSource;
        DasObject theOldestAncestor;
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof DbElement) {
            return ((DbElement)o2).getDataSource();
        }
        DasObject dasObject = o2;
        DasObject dasObject2 = theOldestAncestor = dasObject instanceof BasicRoot ? o2 : (dasObject instanceof BasicObjectNode ? (DasObject)DasUtil.getParentOfClass(o2, BasicRoot.class, false) : (DasObject)DasUtil.dasParents(o2).last());
        if (dasObject2 != null) {
            DasObject it2 = dasObject2;
            boolean bl = false;
            dbDataSource = this.getDbDataSourceByRoot(it2);
        } else {
            dbDataSource = null;
        }
        return dbDataSource;
    }

    @Nullable
    public final DbElement findDbElement(@Nullable DasObject o2) {
        DbDataSource dataSource2;
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof DbElement) {
            return (DbElement)o2;
        }
        DbDataSource dbDataSource = dataSource2 = this.findDbDataSource(o2);
        return dbDataSource == null ? null : DbImplUtilCore.findElement(dbDataSource, o2);
    }

    private final DbDataSource getDbDataSourceByRoot(DasObject root2) {
        BasicModel model2;
        DbDataSource dbDS = null;
        if (root2 instanceof BasicElement && (model2 = ((BasicElement)root2).getModel()) != null) {
            dbDS = this.findDbDataSource(model2);
        }
        if (dbDS == null && (dbDS = (DbDataSource)this.roots.get(root2)) != null && !dbDS.isValid()) {
            this.roots.remove(root2);
            this.invalidate(dbDS);
            dbDS = (DbDataSource)this.roots.get(root2);
        }
        return dbDS;
    }

    private final void clear() {
        this.models.clear();
        this.roots.clear();
    }

    private final void invalidate(DbDataSource dbDS) {
        if (this.models.isEmpty()) {
            return;
        }
        Set entries = this.models.entrySet();
        Iterator it2 = entries.iterator();
        while (it2.hasNext()) {
            Map.Entry e2 = it2.next();
            if (e2.getValue() != dbDS || e2.getKey() == dbDS.getModel()) continue;
            it2.remove();
        }
    }

    private final void onDataSourceChanged(DbDataSource dbDS) {
        DbDataSource dbDataSource = dbDS;
        if (dbDataSource == null) {
            this.models.clear();
        } else {
            this.invalidate(dbDataSource);
        }
        this.roots.clear();
    }

    public void dispose() {
        this.clear();
    }

    private static final DbDataSource models$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DbDataSource)$tmp0.invoke(p0);
    }

    private static final DbDataSource roots$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DbDataSource)$tmp0.invoke(p0);
    }

    private static final ConcurrentMap roots$lambda$2() {
        return Caffeine.newBuilder().weakKeys().weakValues().build().asMap();
    }

    public static final /* synthetic */ DbDataSource access$obtainDbDataSourceForModel(DbModelRegistry $this, BasicModel model2) {
        return $this.obtainDbDataSourceForModel(model2);
    }

    public static final /* synthetic */ DbDataSource access$obtainDbDataSourceForRoot(DbModelRegistry $this, DasObject key2) {
        return $this.obtainDbDataSourceForRoot(key2);
    }
}

