/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator.path;

import com.intellij.indexing.shared.generator.IndexesExporterExtension;
import com.intellij.indexing.shared.generator.SharedIndexWriter;
import com.intellij.indexing.shared.generator.path.ArchiveRelativePathIndex;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/generator/path/ArchiveRelativePathIndexGenerator;", "Lcom/intellij/indexing/shared/generator/IndexesExporterExtension;", "()V", "extensionPresentableName", "", "getExtensionPresentableName", "()Ljava/lang/String;", "id", "getId", "generateAdditionalIndexes", "", "context", "Lcom/intellij/indexing/shared/generator/SharedIndexWriter;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nArchiveRelativePathIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiveRelativePathIndex.kt\ncom/intellij/indexing/shared/generator/path/ArchiveRelativePathIndexGenerator\n+ 2 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n*L\n1#1,68:1\n22#2,6:69\n*S KotlinDebug\n*F\n+ 1 ArchiveRelativePathIndex.kt\ncom/intellij/indexing/shared/generator/path/ArchiveRelativePathIndexGenerator\n*L\n22#1:69,6\n*E\n"})
public final class ArchiveRelativePathIndexGenerator
implements IndexesExporterExtension {
    @NotNull
    private final String extensionPresentableName;
    @NotNull
    private final String id;

    public ArchiveRelativePathIndexGenerator() {
        this.extensionPresentableName = "Relative Path Index Generator";
        this.id = "relative-path";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateAdditionalIndexes(@NotNull SharedIndexWriter context2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Path path = context2.getIndexRootPath().resolve("relative.path");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Disposable $this$use$iv = new ArchiveRelativePathIndex(path, false);
        boolean $i$f$use = false;
        try {
            ArchiveRelativePathIndex it = (ArchiveRelativePathIndex)$this$use$iv;
            boolean bl = false;
            for (VirtualFile inputFile : context2.getInputFiles()) {
                Integer n = context2.getEnumeratedHashId(inputFile);
                Intrinsics.checkNotNull((Object)n);
                it.putFilePath(n, inputFile);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Disposer.dispose((Disposable)$this$use$iv);
        }
    }

    @Override
    @NotNull
    public String getExtensionPresentableName() {
        return this.extensionPresentableName;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }
}

