/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.generator.BaseIndex;
import com.intellij.indexing.shared.generator.IndexChunk;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.MainArgs;
import com.intellij.indexing.shared.generator.MainGenerateArgs;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.platform.util.ArgsParser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u0006\u0010J\u001a\u00020!R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\n\u001a\u0004\b\u0013\u0010\u0014R'\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00128BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\n\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u0014R\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\n\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010 \u001a\u0004\u0018\u00010!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\n\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020!8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010#R\u001d\u0010'\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\n\u001a\u0004\b(\u0010\u001eR\u001b\u0010*\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\n\u001a\u0004\b+\u0010\bR\u001b\u0010-\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\n\u001a\u0004\b.\u0010\bR\u001b\u00100\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\n\u001a\u0004\b1\u0010\bR\u001d\u00103\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\n\u001a\u0004\b4\u00105R!\u00107\u001a\b\u0012\u0004\u0012\u00020\r0\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\n\u001a\u0004\b8\u0010\u0014R\u001b\u0010:\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010\n\u001a\u0004\b;\u0010\u001eR\u001b\u0010=\u001a\u00020\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\n\u001a\u0004\b>\u0010\u001eR\u001d\u0010@\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010\n\u001a\u0004\bA\u0010B\u00a8\u0006K"}, d2={"Lcom/intellij/indexing/shared/generator/MainGenerateArgs;", "Lcom/intellij/indexing/shared/generator/MainArgs;", "parser", "Lcom/intellij/platform/util/ArgsParser;", "(Lcom/intellij/platform/util/ArgsParser;)V", "addHashToOutputNames", "", "getAddHashToOutputNames", "()Z", "addHashToOutputNames$delegate", "Lcom/intellij/platform/util/ArgsParser$TypedArg;", "additionalHashProviders", "Ljava/util/SortedSet;", "", "getAdditionalHashProviders", "()Ljava/util/SortedSet;", "additionalHashProviders$delegate", "additionalIndexes", "", "getAdditionalIndexes", "()Ljava/util/List;", "additionalIndexes$delegate", "additionalSupportedOs", "getAdditionalSupportedOs$annotations", "()V", "getAdditionalSupportedOs", "additionalSupportedOs$delegate", "baseIndexPath", "Ljava/nio/file/Path;", "getBaseIndexPath", "()Ljava/nio/file/Path;", "baseIndexPath$delegate", "compression", "Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "getCompression", "()Lcom/intellij/indexing/shared/download/SharedIndexCompression;", "compression$delegate", "defaultCompression", "getDefaultCompression", "dumpProjectRoots", "getDumpProjectRoots", "dumpProjectRoots$delegate", "excludeFilesWithHashCollision", "getExcludeFilesWithHashCollision", "excludeFilesWithHashCollision$delegate", "filterOutDuplicatesBeforeIndexing", "getFilterOutDuplicatesBeforeIndexing", "filterOutDuplicatesBeforeIndexing$delegate", "generateReproducibleMaps", "getGenerateReproducibleMaps", "generateReproducibleMaps$delegate", "lineupName", "getLineupName", "()Ljava/lang/String;", "lineupName$delegate", "noStubTreeFileTypes", "getNoStubTreeFileTypes", "noStubTreeFileTypes$delegate", "outputDir", "getOutputDir", "outputDir$delegate", "tempDir", "getTempDir", "tempDir$delegate", "useXzCompression", "getUseXzCompression", "()Ljava/lang/Boolean;", "useXzCompression$delegate", "createIndexesExporterRequest", "Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;", "chunk", "Lcom/intellij/indexing/shared/generator/IndexChunk;", "addon", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "resolveCompressionMethod", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nDumpSharedIndexStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpSharedIndexStarter.kt\ncom/intellij/indexing/shared/generator/MainGenerateArgs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n1549#2:350\n1620#2,3:351\n1#3:354\n*S KotlinDebug\n*F\n+ 1 DumpSharedIndexStarter.kt\ncom/intellij/indexing/shared/generator/MainGenerateArgs\n*L\n97#1:350\n97#1:351,3\n*E\n"})
public class MainGenerateArgs
extends MainArgs {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ArgsParser.TypedArg outputDir$delegate;
    @NotNull
    private final ArgsParser.TypedArg tempDir$delegate;
    @NotNull
    private final ArgsParser.TypedArg dumpProjectRoots$delegate;
    @NotNull
    private final ArgsParser.TypedArg useXzCompression$delegate;
    @NotNull
    private final ArgsParser.TypedArg compression$delegate;
    @NotNull
    private final ArgsParser.TypedArg excludeFilesWithHashCollision$delegate;
    @NotNull
    private final ArgsParser.TypedArg additionalIndexes$delegate;
    @NotNull
    private final ArgsParser.TypedArg noStubTreeFileTypes$delegate;
    @NotNull
    private final ArgsParser.TypedArg additionalSupportedOs$delegate;
    @NotNull
    private final ArgsParser.TypedArg additionalHashProviders$delegate;
    @NotNull
    private final ArgsParser.TypedArg filterOutDuplicatesBeforeIndexing$delegate;
    @NotNull
    private final ArgsParser.TypedArg baseIndexPath$delegate;
    @NotNull
    private final ArgsParser.TypedArg lineupName$delegate;
    @NotNull
    private final ArgsParser.TypedArg addHashToOutputNames$delegate;
    @NotNull
    private final ArgsParser.TypedArg generateReproducibleMaps$delegate;

    /*
     * WARNING - void declaration
     */
    public MainGenerateArgs(@NotNull ArgsParser parser) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super(parser);
        this.outputDir$delegate = ArgsParser.ArgInfo.file$default((ArgsParser.ArgInfo)parser.arg("output", "location of the indexes output directory\nit will be updated with generated new indexes"), null, (int)1, null).andApply((Function1)outputDir.2.INSTANCE);
        this.tempDir$delegate = parser.arg("temp", "optional temp directory to use during indexes generation").hidden().file((Function0)tempDir.2.INSTANCE).andApply((Function1)tempDir.3.INSTANCE);
        this.dumpProjectRoots$delegate = parser.arg("dump-project-roots", "Dumps project roots to the given file").hidden().fileOrNull();
        this.useXzCompression$delegate = parser.arg("use-xz-compression", "Shared index can be additionally compressed with xz").optional().deprecated("Please use 'compression=xz' or 'compression=plain instead").booleanOrNull();
        this.compression$delegate = parser.arg("compression", "Compress shared index using: " + CollectionsKt.joinToString$default((Iterable)((Iterable)EntriesMappings.entries$0), (CharSequence)", ", null, null, (int)0, null, (Function1)compression.2.INSTANCE, (int)30, null)).optional().stringOrNull().andMap((Function1)compression.3.INSTANCE);
        this.excludeFilesWithHashCollision$delegate = parser.arg("filter-out-collisions", "Shared index will not contain files with hash collision").hidden().optional().boolean((Function0)excludeFilesWithHashCollision.2.INSTANCE);
        this.additionalIndexes$delegate = parser.arg("additional-indexes", "Additional indexes to generate").hidden().optional().strings();
        this.noStubTreeFileTypes$delegate = parser.arg("no-stub-tree-file-types", "File types for which stub trees will not be shared").hidden().optional().strings();
        Set set = IndexInfrastructureOs.textValues();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"textValues(...)");
        this.additionalSupportedOs$delegate = parser.arg("additional-os", "Claim to support " + CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " in addition to the host OS").hidden().optional().deprecated("Shared Indexes are OS-independent starting from 2020.3. There is no need to specify additional supported OS-es. This option will be ignored. See https://youtrack.jetbrains.com/issue/IDEA-248440").strings();
        Iterable iterable = SharedIndexHashProviders.getNonDefaultSharedIndexHashingProviders();
        String string = "additional-hash";
        ArgsParser argsParser = parser;
        MainGenerateArgs mainGenerateArgs = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SharedIndexContentHash sharedIndexContentHash = (SharedIndexContentHash)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProviderId());
        }
        collection = (List)destination$iv$iv;
        mainGenerateArgs.additionalHashProviders$delegate = argsParser.arg(string, "Include additional hash providers to the hash: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)collection), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).hidden().optional().strings().andMap((Function1)additionalHashProviders.3.INSTANCE);
        this.filterOutDuplicatesBeforeIndexing$delegate = parser.arg("filter-out-duplicates", "Chooses only distinct (in terms of file's hash) files to indexing. Please do not use this option until you sure index implementations are file-based.").hidden().optional().boolean((Function0)filterOutDuplicatesBeforeIndexing.2.INSTANCE);
        this.baseIndexPath$delegate = parser.arg("base-shared-index", "Specifies another shared index as base index for the command.\nThe implementation may use the supplied shared index as base").hidden().fileOrNull();
        this.lineupName$delegate = parser.arg("line-up", "Specifies project shared index line-up").hidden().stringOrNull();
        this.addHashToOutputNames$delegate = parser.arg("add-hash-to-output-names", "Adds a hash suffix for output files").hidden().optional().boolean((Function0)addHashToOutputNames.2.INSTANCE);
        this.generateReproducibleMaps$delegate = parser.arg("generate-binary-reproducible-maps", "Make persistent maps binary reproducible").hidden().optional().boolean((Function0)generateReproducibleMaps.2.INSTANCE);
    }

    @NotNull
    public final Path getOutputDir() {
        return (Path)this.outputDir$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final Path getTempDir() {
        return (Path)this.tempDir$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final Path getDumpProjectRoots() {
        return (Path)this.dumpProjectRoots$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final Boolean getUseXzCompression() {
        return (Boolean)this.useXzCompression$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final SharedIndexCompression getCompression() {
        return (SharedIndexCompression)this.compression$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    private final boolean getExcludeFilesWithHashCollision() {
        return (Boolean)this.excludeFilesWithHashCollision$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    private final List<String> getAdditionalIndexes() {
        return (List)this.additionalIndexes$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    private final List<String> getNoStubTreeFileTypes() {
        return (List)this.noStubTreeFileTypes$delegate.getValue((Object)this, $$delegatedProperties[7]);
    }

    private final List<String> getAdditionalSupportedOs() {
        return (List)this.additionalSupportedOs$delegate.getValue((Object)this, $$delegatedProperties[8]);
    }

    @Deprecated(message="Remove this option when cross-platform shared indexes are battle-tested: IDEA-248440")
    private static /* synthetic */ void getAdditionalSupportedOs$annotations() {
    }

    private final SortedSet<String> getAdditionalHashProviders() {
        return (SortedSet)this.additionalHashProviders$delegate.getValue((Object)this, $$delegatedProperties[9]);
    }

    private final boolean getFilterOutDuplicatesBeforeIndexing() {
        return (Boolean)this.filterOutDuplicatesBeforeIndexing$delegate.getValue((Object)this, $$delegatedProperties[10]);
    }

    private final Path getBaseIndexPath() {
        return (Path)this.baseIndexPath$delegate.getValue((Object)this, $$delegatedProperties[11]);
    }

    private final String getLineupName() {
        return (String)this.lineupName$delegate.getValue((Object)this, $$delegatedProperties[12]);
    }

    public final boolean getAddHashToOutputNames() {
        return (Boolean)this.addHashToOutputNames$delegate.getValue((Object)this, $$delegatedProperties[13]);
    }

    private final boolean getGenerateReproducibleMaps() {
        return (Boolean)this.generateReproducibleMaps$delegate.getValue((Object)this, $$delegatedProperties[14]);
    }

    @NotNull
    protected SharedIndexCompression getDefaultCompression() {
        return SharedIndexCompression.XZ;
    }

    @NotNull
    public final SharedIndexCompression resolveCompressionMethod() {
        SharedIndexCompression sharedIndexCompression;
        SharedIndexCompression compression2;
        SharedIndexCompression sharedIndexCompression2 = compression2 = this.getCompression();
        if (sharedIndexCompression2 != null) {
            return sharedIndexCompression2;
        }
        Boolean bl = this.getUseXzCompression();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            sharedIndexCompression = SharedIndexCompression.XZ;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            sharedIndexCompression = SharedIndexCompression.PLAIN;
        } else if (bl == null) {
            sharedIndexCompression = this.getDefaultCompression();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sharedIndexCompression;
    }

    @NotNull
    public final IndexesExporterRequest createIndexesExporterRequest(@NotNull IndexChunk chunk, @NotNull SharedIndexMetadataInfo addon) {
        BaseIndex baseIndex;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        SharedIndexCompression sharedIndexCompression = this.resolveCompressionMethod();
        boolean bl = this.getExcludeFilesWithHashCollision();
        boolean bl2 = this.getFilterOutDuplicatesBeforeIndexing();
        Path path = this.getOutputDir();
        Path path2 = this.getTempDir();
        Path path3 = this.getDumpProjectRoots();
        List<String> list = this.getAdditionalIndexes();
        List<String> list2 = this.getNoStubTreeFileTypes();
        String string = this.getLineupName();
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            baseIndex = new BaseIndex(this.getBaseIndexPath(), it);
        } else {
            baseIndex = null;
        }
        BaseIndex baseIndex2 = baseIndex;
        SortedSet<String> sortedSet = this.getAdditionalHashProviders();
        boolean bl4 = this.getAddHashToOutputNames();
        boolean bl5 = this.getGenerateReproducibleMaps();
        return new IndexesExporterRequest(chunk, sharedIndexCompression, path, null, bl, bl2, list, list2, path3, addon, path2, null, baseIndex2, sortedSet, bl4, bl5, 2056, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "outputDir", "getOutputDir()Ljava/nio/file/Path;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "tempDir", "getTempDir()Ljava/nio/file/Path;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "dumpProjectRoots", "getDumpProjectRoots()Ljava/nio/file/Path;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "useXzCompression", "getUseXzCompression()Ljava/lang/Boolean;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "compression", "getCompression()Lcom/intellij/indexing/shared/download/SharedIndexCompression;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "excludeFilesWithHashCollision", "getExcludeFilesWithHashCollision()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "additionalIndexes", "getAdditionalIndexes()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "noStubTreeFileTypes", "getNoStubTreeFileTypes()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "additionalSupportedOs", "getAdditionalSupportedOs()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "additionalHashProviders", "getAdditionalHashProviders()Ljava/util/SortedSet;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "filterOutDuplicatesBeforeIndexing", "getFilterOutDuplicatesBeforeIndexing()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "baseIndexPath", "getBaseIndexPath()Ljava/nio/file/Path;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "lineupName", "getLineupName()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "addHashToOutputNames", "getAddHashToOutputNames()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MainGenerateArgs.class, "generateReproducibleMaps", "getGenerateReproducibleMaps()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<SharedIndexCompression> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])SharedIndexCompression.values()));
        }
    }
}

