/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.IndexChunk;
import com.intellij.indexing.shared.generator.IndexesExporterExtension;
import com.intellij.indexing.shared.generator.IndexesExporterExtensionKt;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.SharedIndexWriter;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.IdeSharedIndexesState;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporterEP;", "", "project", "Lcom/intellij/openapi/project/Project;", "myRequest", "Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "indexRootPath", "Ljava/nio/file/Path;", "state", "Lcom/intellij/indexing/shared/platform/api/IdeSharedIndexesState;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;Lcom/intellij/indexing/shared/generator/ErrorsCollector;Ljava/nio/file/Path;Lcom/intellij/indexing/shared/platform/api/IdeSharedIndexesState;)V", "executeExtensionPoints", "", "files", "Lcom/intellij/indexing/shared/generator/EnumeratedHashedIndexedFiles;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getSharedIndexWriter", "Lcom/intellij/indexing/shared/generator/SharedIndexWriter;", "intellij.indexing.shared.generator"})
public final class IndexesExporterEP {
    @NotNull
    private final Project project;
    @NotNull
    private final IndexesExporterRequest myRequest;
    @NotNull
    private final ErrorsCollector errorsCollector;
    @NotNull
    private final Path indexRootPath;
    @NotNull
    private final IdeSharedIndexesState state;

    public IndexesExporterEP(@NotNull Project project, @NotNull IndexesExporterRequest myRequest, @NotNull ErrorsCollector errorsCollector, @NotNull Path indexRootPath, @NotNull IdeSharedIndexesState state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myRequest, (String)"myRequest");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        Intrinsics.checkNotNullParameter((Object)indexRootPath, (String)"indexRootPath");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.project = project;
        this.myRequest = myRequest;
        this.errorsCollector = errorsCollector;
        this.indexRootPath = indexRootPath;
        this.state = state;
    }

    public final void executeExtensionPoints(@NotNull EnumeratedHashedIndexedFiles files, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        SharedIndexWriter writer = this.getSharedIndexWriter(files);
        IndexesExporterExtensionKt.access$getEP_NAME$p().forEachExtensionSafe(arg_0 -> IndexesExporterEP.executeExtensionPoints$lambda$0((Function1)new Function1<IndexesExporterExtension, Unit>(this, indicator, writer){
            final /* synthetic */ IndexesExporterEP this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ SharedIndexWriter $writer;
            {
                this.this$0 = $receiver;
                this.$indicator = $indicator;
                this.$writer = $writer;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull IndexesExporterExtension ext) {
                Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
                if (!IndexesExporterEP.access$getMyRequest$p(this.this$0).getAdditionalIndexes().contains(ext.getId())) {
                    return;
                }
                this.$indicator.pushState();
                try {
                    Object[] objectArray = new Object[]{ext.getExtensionPresentableName()};
                    this.$indicator.setText(SharedIndexesBundle.message((String)"index.exporter.processing.exporter.extension", (Object[])objectArray));
                    ext.generateAdditionalIndexes(this.$writer, this.$indicator);
                }
                catch (Throwable t) {
                    IndexesExporterEP.access$getErrorsCollector$p(this.this$0).genericError("Failed to generate index for " + ext.getClass().getName() + ". " + t.getMessage(), t);
                }
                finally {
                    this.$indicator.popState();
                }
            }
        }, arg_0));
    }

    private final SharedIndexWriter getSharedIndexWriter(EnumeratedHashedIndexedFiles files) {
        return new SharedIndexWriter(files, this){
            @NotNull
            private final Set<VirtualFile> allFiles;
            @NotNull
            private final Set<VirtualFile> inputFiles;
            final /* synthetic */ EnumeratedHashedIndexedFiles $files;
            final /* synthetic */ IndexesExporterEP this$0;
            {
                this.$files = $files;
                this.this$0 = $receiver;
                this.allFiles = $files.getAllFiles();
                this.inputFiles = this.allFiles;
            }

            @NotNull
            public final Set<VirtualFile> getAllFiles() {
                return this.allFiles;
            }

            @NotNull
            public Project getProject() {
                return IndexesExporterEP.access$getProject$p(this.this$0);
            }

            @NotNull
            public Path getIndexRootPath() {
                return IndexesExporterEP.access$getIndexRootPath$p(this.this$0);
            }

            @NotNull
            public IndexChunk getChunk() {
                return IndexesExporterEP.access$getMyRequest$p(this.this$0).getChunk();
            }

            @NotNull
            public Set<VirtualFile> getInputFiles() {
                return this.inputFiles;
            }

            @NotNull
            public ErrorsCollector getErrorsCollector() {
                return IndexesExporterEP.access$getErrorsCollector$p(this.this$0);
            }

            @Nullable
            public Integer getEnumeratedHashId(@NotNull VirtualFile fileOrDirectory) {
                Intrinsics.checkNotNullParameter((Object)fileOrDirectory, (String)"fileOrDirectory");
                return this.$files.getIds().get(fileOrDirectory);
            }

            public void pushCapability(@NotNull IndexInfrastructureCapability capability, @NotNull Map<String, String> versions) {
                Intrinsics.checkNotNullParameter((Object)capability, (String)"capability");
                Intrinsics.checkNotNullParameter(versions, (String)"versions");
                IndexesExporterEP.access$getState$p(this.this$0).registerCapability(capability, versions);
            }
        };
    }

    private static final void executeExtensionPoints$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ IndexesExporterRequest access$getMyRequest$p(IndexesExporterEP $this) {
        return $this.myRequest;
    }

    public static final /* synthetic */ ErrorsCollector access$getErrorsCollector$p(IndexesExporterEP $this) {
        return $this.errorsCollector;
    }

    public static final /* synthetic */ Project access$getProject$p(IndexesExporterEP $this) {
        return $this.project;
    }

    public static final /* synthetic */ Path access$getIndexRootPath$p(IndexesExporterEP $this) {
        return $this.indexRootPath;
    }

    public static final /* synthetic */ IdeSharedIndexesState access$getState$p(IndexesExporterEP $this) {
        return $this.state;
    }
}

