/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.indexing.shared.generator.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generator.HashedIndexedFiles;
import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.generator.IndexedFilesReporterKt;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticBuilder;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u001e\u001f !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0012\u001a\u00020\b2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00142\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;", "", "targetDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dumpEmptyFiles", "", "files", "Lcom/intellij/indexing/shared/generator/HashedIndexedFiles;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dumpFileHashes", "Lcom/intellij/indexing/shared/generator/EnumeratedHashedIndexedFiles;", "dumpFilesForIndex", "project", "Lcom/intellij/openapi/project/Project;", "dumpHashCollisionFiles", "collisions", "", "Lcom/intellij/indexing/shared/generator/IndexedFileHash;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "dumpProjectRoots", "withIndicator", "reportFileName", "", "action", "Lkotlin/Function0;", "JsonEmptyFiles", "JsonEnumeratedHashes", "JsonHashCollisions", "JsonProjectRoots", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexedFilesReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedFilesReporter.kt\ncom/intellij/indexing/shared/generator/IndexedFilesReporter\n+ 2 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n*L\n1#1,99:1\n13#2,8:100\n*S KotlinDebug\n*F\n+ 1 IndexedFilesReporter.kt\ncom/intellij/indexing/shared/generator/IndexedFilesReporter\n*L\n70#1:100,8\n*E\n"})
public final class IndexedFilesReporter {
    @NotNull
    private final Path targetDir;
    @NotNull
    private final ObjectMapper objectMapper;

    public IndexedFilesReporter(@NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        this.targetDir = targetDir;
        this.objectMapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
    }

    public final void dumpHashCollisionFiles(@NotNull Map<IndexedFileHash, ? extends Set<? extends VirtualFile>> collisions, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(collisions, (String)"collisions");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("hash-collisions.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(collisions){
            final /* synthetic */ Map<IndexedFileHash, Set<VirtualFile>> $collisions;
            {
                this.$collisions = $collisions;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                void $this$mapTo$iv$iv;
                Map<IndexedFileHash, Set<VirtualFile>> $this$map$iv = this.$collisions;
                boolean $i$f$map = false;
                Map<IndexedFileHash, Set<VirtualFile>> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IndexedFileHash hash = (IndexedFileHash)entry.getKey();
                    Set files = (Set)entry.getValue();
                    Iterable iterable = files;
                    String string = hash.toBase64String();
                    boolean $i$f$map2 = false;
                    void var15_15 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        VirtualFile virtualFile = (VirtualFile)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        String string2 = it.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                        collection2.add(string2);
                    }
                    List list = (List)destination$iv$iv2;
                    String string3 = string;
                    collection.add(new JsonHashCollisions.JsonHashCollision(string3, list));
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    public final void dumpEmptyFiles(@NotNull HashedIndexedFiles files, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("empty-files.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(files){
            final /* synthetic */ HashedIndexedFiles $files;
            {
                this.$files = $files;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                void $this$mapTo$iv$iv;
                VirtualFile file;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.$files.getHashes().keySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    file = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    if (!(!file.isDirectory() && file.getLength() == 0L)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    file = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getUrl());
                }
                List result = (List)destination$iv$iv;
                return new JsonEmptyFiles(result);
            }
        }));
    }

    public final void dumpFilesForIndex(@NotNull Project project, @NotNull HashedIndexedFiles files, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("files-list.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(project, files){
            final /* synthetic */ Project $project;
            final /* synthetic */ HashedIndexedFiles $files;
            {
                this.$project = $project;
                this.$files = $files;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                IndexContentDiagnosticBuilder builder = new IndexContentDiagnosticBuilder(this.$project);
                for (Map.Entry<IndexableFilesIterator, Set<VirtualFile>> entry : this.$files.getByProviderWithHashes().entrySet()) {
                    IndexableFilesIterator provider = entry.getKey();
                    Set<VirtualFile> vFiles = entry.getValue();
                    for (VirtualFile file : vFiles) {
                        String string = provider.getDebugName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebugName(...)");
                        builder.addFile(file, string);
                    }
                }
                return builder.build();
            }
        }));
    }

    public final void dumpFileHashes(@NotNull EnumeratedHashedIndexedFiles files, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("enumerated-hashes.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(files){
            final /* synthetic */ EnumeratedHashedIndexedFiles $files;
            {
                this.$files = $files;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Map<VirtualFile, IndexedFileHash> map = this.$files.getFiles().getHashes();
                EnumeratedHashedIndexedFiles enumeratedHashedIndexedFiles = this.$files;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    JsonEnumeratedHashes.JsonEnumeratedHash jsonEnumeratedHash;
                    Map.Entry<K, V> element$iv$iv$iv;
                    Map.Entry<K, V> element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Map.Entry<K, V> entry = element$iv$iv;
                    boolean bl2 = false;
                    VirtualFile file = (VirtualFile)entry.getKey();
                    IndexedFileHash hash = (IndexedFileHash)entry.getValue();
                    Integer n = enumeratedHashedIndexedFiles.getIds().get(file);
                    if (n == null) {
                        jsonEnumeratedHash = null;
                    } else {
                        int id = n;
                        jsonEnumeratedHash = new JsonEnumeratedHashes.JsonEnumeratedHash(hash.toBase64String(), id);
                    }
                    if (jsonEnumeratedHash == null) continue;
                    JsonEnumeratedHashes.JsonEnumeratedHash it$iv$iv = jsonEnumeratedHash;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$sortedBy$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                List list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        JsonEnumeratedHashes.JsonEnumeratedHash it = (JsonEnumeratedHashes.JsonEnumeratedHash)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getEnumeratedId());
                        it = (JsonEnumeratedHashes.JsonEnumeratedHash)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getEnumeratedId()));
                    }
                });
                return new JsonEnumeratedHashes(list);
            }
        }));
    }

    public final void dumpProjectRoots(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("project-roots.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
                List list = fileBasedIndex2.getIndexableFilesProviders(this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIndexableFilesProviders(...)");
                List roots = list;
                Iterable iterable = roots;
                Project project = this.$project;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IndexableFilesIterator indexableFilesIterator = (IndexableFilesIterator)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getDebugName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebugName(...)");
                    String string2 = it.getOrigin().toString();
                    Set set = it.getRootUrls(project);
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRootUrls(...)");
                    collection.add(new JsonProjectRoots.JsonProjectRoot(string, string2, CollectionsKt.toList((Iterable)set)));
                }
                List list2 = (List)destination$iv$iv;
                return new JsonProjectRoots(list2);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withIndicator(String reportFileName, ProgressIndicator indicator, Function0<? extends Object> action) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            block8: {
                boolean bl = false;
                Object[] objectArray = new Object[]{reportFileName};
                indicator.setText(SharedIndexesBundle.message((String)"progress.text.dumping.indexed.files.list", (Object[])objectArray));
                indicator.setIndeterminate(true);
                if (action.invoke() != null) break block8;
                return;
            }
            try {
                Object object;
                Object data = object;
                PathKt.createDirectories((Path)this.targetDir);
                this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(this.targetDir.resolve(reportFileName).toFile(), data);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                IndexedFilesReporterKt.access$getLOG$p().warn("Failed to generate report to " + reportFileName + ". " + t.getMessage(), t);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonEmptyFiles;", "", "files", "", "", "(Ljava/util/List;)V", "getFiles", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared.generator"})
    private static final class JsonEmptyFiles {
        @NotNull
        private final List<String> files;

        public JsonEmptyFiles(@NotNull List<String> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.files = files;
        }

        @NotNull
        public final List<String> getFiles() {
            return this.files;
        }

        @NotNull
        public final List<String> component1() {
            return this.files;
        }

        @NotNull
        public final JsonEmptyFiles copy(@NotNull List<String> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            return new JsonEmptyFiles(files);
        }

        public static /* synthetic */ JsonEmptyFiles copy$default(JsonEmptyFiles jsonEmptyFiles, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = jsonEmptyFiles.files;
            }
            return jsonEmptyFiles.copy(list);
        }

        @NotNull
        public String toString() {
            return "JsonEmptyFiles(files=" + this.files + ")";
        }

        public int hashCode() {
            return ((Object)this.files).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JsonEmptyFiles)) {
                return false;
            }
            JsonEmptyFiles jsonEmptyFiles = (JsonEmptyFiles)other;
            return Intrinsics.areEqual(this.files, jsonEmptyFiles.files);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonEnumeratedHashes;", "", "hashes", "", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonEnumeratedHashes$JsonEnumeratedHash;", "(Ljava/util/List;)V", "getHashes", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "JsonEnumeratedHash", "intellij.indexing.shared.generator"})
    private static final class JsonEnumeratedHashes {
        @NotNull
        private final List<JsonEnumeratedHash> hashes;

        public JsonEnumeratedHashes(@NotNull List<JsonEnumeratedHash> hashes) {
            Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
            this.hashes = hashes;
        }

        @NotNull
        public final List<JsonEnumeratedHash> getHashes() {
            return this.hashes;
        }

        @NotNull
        public final List<JsonEnumeratedHash> component1() {
            return this.hashes;
        }

        @NotNull
        public final JsonEnumeratedHashes copy(@NotNull List<JsonEnumeratedHash> hashes) {
            Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
            return new JsonEnumeratedHashes(hashes);
        }

        public static /* synthetic */ JsonEnumeratedHashes copy$default(JsonEnumeratedHashes jsonEnumeratedHashes, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = jsonEnumeratedHashes.hashes;
            }
            return jsonEnumeratedHashes.copy(list);
        }

        @NotNull
        public String toString() {
            return "JsonEnumeratedHashes(hashes=" + this.hashes + ")";
        }

        public int hashCode() {
            return ((Object)this.hashes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JsonEnumeratedHashes)) {
                return false;
            }
            JsonEnumeratedHashes jsonEnumeratedHashes = (JsonEnumeratedHashes)other;
            return Intrinsics.areEqual(this.hashes, jsonEnumeratedHashes.hashes);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonEnumeratedHashes$JsonEnumeratedHash;", "", "hash", "", "enumeratedId", "", "(Ljava/lang/String;I)V", "getEnumeratedId", "()I", "getHash", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.indexing.shared.generator"})
        public static final class JsonEnumeratedHash {
            @NotNull
            private final String hash;
            private final int enumeratedId;

            public JsonEnumeratedHash(@NotNull String hash, int enumeratedId) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                this.hash = hash;
                this.enumeratedId = enumeratedId;
            }

            @NotNull
            public final String getHash() {
                return this.hash;
            }

            public final int getEnumeratedId() {
                return this.enumeratedId;
            }

            @NotNull
            public final String component1() {
                return this.hash;
            }

            public final int component2() {
                return this.enumeratedId;
            }

            @NotNull
            public final JsonEnumeratedHash copy(@NotNull String hash, int enumeratedId) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                return new JsonEnumeratedHash(hash, enumeratedId);
            }

            public static /* synthetic */ JsonEnumeratedHash copy$default(JsonEnumeratedHash jsonEnumeratedHash, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = jsonEnumeratedHash.hash;
                }
                if ((n2 & 2) != 0) {
                    n = jsonEnumeratedHash.enumeratedId;
                }
                return jsonEnumeratedHash.copy(string, n);
            }

            @NotNull
            public String toString() {
                return "JsonEnumeratedHash(hash=" + this.hash + ", enumeratedId=" + this.enumeratedId + ")";
            }

            public int hashCode() {
                int result = this.hash.hashCode();
                result = result * 31 + Integer.hashCode(this.enumeratedId);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JsonEnumeratedHash)) {
                    return false;
                }
                JsonEnumeratedHash jsonEnumeratedHash = (JsonEnumeratedHash)other;
                if (!Intrinsics.areEqual((Object)this.hash, (Object)jsonEnumeratedHash.hash)) {
                    return false;
                }
                return this.enumeratedId == jsonEnumeratedHash.enumeratedId;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonHashCollisions;", "", "collisions", "", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonHashCollisions$JsonHashCollision;", "(Ljava/util/List;)V", "getCollisions", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "JsonHashCollision", "intellij.indexing.shared.generator"})
    private static final class JsonHashCollisions {
        @NotNull
        private final List<JsonHashCollision> collisions;

        public JsonHashCollisions(@NotNull List<JsonHashCollision> collisions) {
            Intrinsics.checkNotNullParameter(collisions, (String)"collisions");
            this.collisions = collisions;
        }

        @NotNull
        public final List<JsonHashCollision> getCollisions() {
            return this.collisions;
        }

        @NotNull
        public final List<JsonHashCollision> component1() {
            return this.collisions;
        }

        @NotNull
        public final JsonHashCollisions copy(@NotNull List<JsonHashCollision> collisions) {
            Intrinsics.checkNotNullParameter(collisions, (String)"collisions");
            return new JsonHashCollisions(collisions);
        }

        public static /* synthetic */ JsonHashCollisions copy$default(JsonHashCollisions jsonHashCollisions, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = jsonHashCollisions.collisions;
            }
            return jsonHashCollisions.copy(list);
        }

        @NotNull
        public String toString() {
            return "JsonHashCollisions(collisions=" + this.collisions + ")";
        }

        public int hashCode() {
            return ((Object)this.collisions).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JsonHashCollisions)) {
                return false;
            }
            JsonHashCollisions jsonHashCollisions = (JsonHashCollisions)other;
            return Intrinsics.areEqual(this.collisions, jsonHashCollisions.collisions);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonHashCollisions$JsonHashCollision;", "", "hash", "", "files", "", "(Ljava/lang/String;Ljava/util/List;)V", "getFiles", "()Ljava/util/List;", "getHash", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared.generator"})
        public static final class JsonHashCollision {
            @NotNull
            private final String hash;
            @NotNull
            private final List<String> files;

            public JsonHashCollision(@NotNull String hash, @NotNull List<String> files) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                Intrinsics.checkNotNullParameter(files, (String)"files");
                this.hash = hash;
                this.files = files;
            }

            @NotNull
            public final String getHash() {
                return this.hash;
            }

            @NotNull
            public final List<String> getFiles() {
                return this.files;
            }

            @NotNull
            public final String component1() {
                return this.hash;
            }

            @NotNull
            public final List<String> component2() {
                return this.files;
            }

            @NotNull
            public final JsonHashCollision copy(@NotNull String hash, @NotNull List<String> files) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                Intrinsics.checkNotNullParameter(files, (String)"files");
                return new JsonHashCollision(hash, files);
            }

            public static /* synthetic */ JsonHashCollision copy$default(JsonHashCollision jsonHashCollision, String string, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = jsonHashCollision.hash;
                }
                if ((n & 2) != 0) {
                    list = jsonHashCollision.files;
                }
                return jsonHashCollision.copy(string, list);
            }

            @NotNull
            public String toString() {
                return "JsonHashCollision(hash=" + this.hash + ", files=" + this.files + ")";
            }

            public int hashCode() {
                int result = this.hash.hashCode();
                result = result * 31 + ((Object)this.files).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JsonHashCollision)) {
                    return false;
                }
                JsonHashCollision jsonHashCollision = (JsonHashCollision)other;
                if (!Intrinsics.areEqual((Object)this.hash, (Object)jsonHashCollision.hash)) {
                    return false;
                }
                return Intrinsics.areEqual(this.files, jsonHashCollision.files);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonProjectRoots;", "", "roots", "", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonProjectRoots$JsonProjectRoot;", "(Ljava/util/List;)V", "getRoots", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "JsonProjectRoot", "intellij.indexing.shared.generator"})
    private static final class JsonProjectRoots {
        @NotNull
        private final List<JsonProjectRoot> roots;

        public JsonProjectRoots(@NotNull List<JsonProjectRoot> roots) {
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            this.roots = roots;
        }

        @NotNull
        public final List<JsonProjectRoot> getRoots() {
            return this.roots;
        }

        @NotNull
        public final List<JsonProjectRoot> component1() {
            return this.roots;
        }

        @NotNull
        public final JsonProjectRoots copy(@NotNull List<JsonProjectRoot> roots) {
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            return new JsonProjectRoots(roots);
        }

        public static /* synthetic */ JsonProjectRoots copy$default(JsonProjectRoots jsonProjectRoots, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = jsonProjectRoots.roots;
            }
            return jsonProjectRoots.copy(list);
        }

        @NotNull
        public String toString() {
            return "JsonProjectRoots(roots=" + this.roots + ")";
        }

        public int hashCode() {
            return ((Object)this.roots).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JsonProjectRoots)) {
                return false;
            }
            JsonProjectRoots jsonProjectRoots = (JsonProjectRoots)other;
            return Intrinsics.areEqual(this.roots, jsonProjectRoots.roots);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J-\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonProjectRoots$JsonProjectRoot;", "", "debugName", "", "origin", "urls", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getDebugName", "()Ljava/lang/String;", "getOrigin", "getUrls", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared.generator"})
        public static final class JsonProjectRoot {
            @NotNull
            private final String debugName;
            @NotNull
            private final String origin;
            @NotNull
            private final List<String> urls;

            public JsonProjectRoot(@NotNull String debugName, @NotNull String origin, @NotNull List<String> urls) {
                Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
                Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
                Intrinsics.checkNotNullParameter(urls, (String)"urls");
                this.debugName = debugName;
                this.origin = origin;
                this.urls = urls;
            }

            @NotNull
            public final String getDebugName() {
                return this.debugName;
            }

            @NotNull
            public final String getOrigin() {
                return this.origin;
            }

            @NotNull
            public final List<String> getUrls() {
                return this.urls;
            }

            @NotNull
            public final String component1() {
                return this.debugName;
            }

            @NotNull
            public final String component2() {
                return this.origin;
            }

            @NotNull
            public final List<String> component3() {
                return this.urls;
            }

            @NotNull
            public final JsonProjectRoot copy(@NotNull String debugName, @NotNull String origin, @NotNull List<String> urls) {
                Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
                Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
                Intrinsics.checkNotNullParameter(urls, (String)"urls");
                return new JsonProjectRoot(debugName, origin, urls);
            }

            public static /* synthetic */ JsonProjectRoot copy$default(JsonProjectRoot jsonProjectRoot, String string, String string2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = jsonProjectRoot.debugName;
                }
                if ((n & 2) != 0) {
                    string2 = jsonProjectRoot.origin;
                }
                if ((n & 4) != 0) {
                    list = jsonProjectRoot.urls;
                }
                return jsonProjectRoot.copy(string, string2, list);
            }

            @NotNull
            public String toString() {
                return "JsonProjectRoot(debugName=" + this.debugName + ", origin=" + this.origin + ", urls=" + this.urls + ")";
            }

            public int hashCode() {
                int result = this.debugName.hashCode();
                result = result * 31 + this.origin.hashCode();
                result = result * 31 + ((Object)this.urls).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JsonProjectRoot)) {
                    return false;
                }
                JsonProjectRoot jsonProjectRoot = (JsonProjectRoot)other;
                if (!Intrinsics.areEqual((Object)this.debugName, (Object)jsonProjectRoot.debugName)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.origin, (Object)jsonProjectRoot.origin)) {
                    return false;
                }
                return Intrinsics.areEqual(this.urls, jsonProjectRoot.urls);
            }
        }
    }
}

