/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.CorePosixFilteringFileSystem;
import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import com.intellij.platform.core.nio.fs.RoutingAwareFileSystemProvider;
import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CorePosixFilteringFileSystemProvider
extends DelegatingFileSystemProvider<CorePosixFilteringFileSystemProvider, CorePosixFilteringFileSystem>
implements RoutingAwareFileSystemProvider {
    private final FileSystemProvider myFileSystemProvider;

    CorePosixFilteringFileSystemProvider(FileSystemProvider provider) {
        this.myFileSystemProvider = provider;
    }

    @Override
    public boolean canHandleRouting() {
        return this.myFileSystemProvider instanceof RoutingAwareFileSystemProvider && ((RoutingAwareFileSystemProvider)((Object)this.myFileSystemProvider)).canHandleRouting();
    }

    private static FileAttribute<?>[] filterAttrs(FileAttribute<?> ... attrs) {
        return (FileAttribute[])Arrays.stream(attrs).filter(attr -> !attr.name().startsWith("posix:")).toArray(FileAttribute[]::new);
    }

    @Override
    @NotNull
    public CorePosixFilteringFileSystem wrapDelegateFileSystem(@NotNull FileSystem delegateFs) {
        if (delegateFs == null) {
            CorePosixFilteringFileSystemProvider.$$$reportNull$$$0(0);
        }
        return new CorePosixFilteringFileSystem(this, delegateFs);
    }

    @Override
    @NotNull
    protected FileSystemProvider getDelegate(@Nullable Path path1, @Nullable Path path2) {
        FileSystemProvider fileSystemProvider = this.myFileSystemProvider;
        if (fileSystemProvider == null) {
            CorePosixFilteringFileSystemProvider.$$$reportNull$$$0(1);
        }
        return fileSystemProvider;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    protected Path toDelegatePath(@Nullable Path path) {
        return path;
    }

    @Override
    @Nullable
    protected Path fromDelegatePath(@Nullable Path path) {
        return path;
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return super.newFileChannel(path, options, CorePosixFilteringFileSystemProvider.filterAttrs(attrs));
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        return super.newAsynchronousFileChannel(path, options, executor, CorePosixFilteringFileSystemProvider.filterAttrs(attrs));
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return super.newByteChannel(path, options, CorePosixFilteringFileSystemProvider.filterAttrs(attrs));
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        super.createDirectory(dir, CorePosixFilteringFileSystemProvider.filterAttrs(attrs));
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        super.createSymbolicLink(link, target, CorePosixFilteringFileSystemProvider.filterAttrs(attrs));
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getName(), this.myFileSystemProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/core/nio/fs/CorePosixFilteringFileSystemProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/core/nio/fs/CorePosixFilteringFileSystemProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapDelegateFileSystem";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

