/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.util;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.util.popup.PopupItemPresentation;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import icons.CollaborationToolsIcons;
import java.awt.Color;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\fH\u0007J\u0016\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0018\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil;", "", "()V", "createIssueLabelLabel", "Lcom/intellij/ui/components/JBLabel;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "getPullRequestStateIcon", "Ljavax/swing/Icon;", "state", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "isDraft", "", "getPullRequestStateText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getRepositoryDisplayName", "allRepositories", "", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "repository", "alwaysShowOwner", "needToShowRepositoryOwner", "repos", "needToShowRepositoryServer", "SelectionPresenters", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHUIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHUIUtil.kt\norg/jetbrains/plugins/github/ui/util/GHUIUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1747#2,3:100\n1747#2,3:103\n*S KotlinDebug\n*F\n+ 1 GHUIUtil.kt\norg/jetbrains/plugins/github/ui/util/GHUIUtil\n*L\n91#1:100,3\n97#1:103,3\n*E\n"})
public final class GHUIUtil {
    @NotNull
    public static final GHUIUtil INSTANCE = new GHUIUtil();

    private GHUIUtil() {
    }

    @NotNull
    public final Icon getPullRequestStateIcon(@NotNull GHPullRequestState state2, boolean isDraft) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            Icon icon2 = GithubIcons.PullRequestDraft;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PullRequestDraft");
        } else {
            Icon icon3 = switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1 -> CollaborationToolsIcons.PullRequestClosed;
                case 2 -> GithubIcons.PullRequestMerged;
                case 3 -> CollaborationToolsIcons.PullRequestOpen;
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNull((Object)icon3);
            icon = icon3;
        }
        return icon;
    }

    @NotNull
    public final String getPullRequestStateText(@NotNull GHPullRequestState state2, boolean isDraft) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        if (isDraft) {
            String string2 = CollaborationToolsBundle.message((String)"review.details.review.state.draft", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = switch (WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1 -> CollaborationToolsBundle.message((String)"review.details.review.state.closed", (Object[])new Object[0]);
                case 2 -> CollaborationToolsBundle.message((String)"review.details.review.state.merged", (Object[])new Object[0]);
                case 3 -> CollaborationToolsBundle.message((String)"review.details.review.state.open", (Object[])new Object[0]);
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    @NotNull
    public final JBLabel createIssueLabelLabel(@NotNull GHLabel label) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        JBLabel $this$createIssueLabelLabel_u24lambda_u240 = jBLabel = new JBLabel(" " + label.getName() + " ", UIUtil.ComponentStyle.SMALL);
        boolean bl = false;
        $this$createIssueLabelLabel_u24lambda_u240.setBackground((Color)CollaborationToolsUIUtil.INSTANCE.getLabelBackground(label.getColor()));
        Color color = $this$createIssueLabelLabel_u24lambda_u240.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        $this$createIssueLabelLabel_u24lambda_u240.setForeground(CollaborationToolsUIUtil.INSTANCE.getLabelForeground(color));
        JBLabel jBLabel2 = jBLabel.andOpaque();
        Intrinsics.checkNotNullExpressionValue((Object)jBLabel2, (String)"andOpaque(...)");
        return jBLabel2;
    }

    @NlsSafe
    @NotNull
    public final String getRepositoryDisplayName(@NotNull Collection<GHRepositoryCoordinates> allRepositories, @NotNull GHRepositoryCoordinates repository, boolean alwaysShowOwner) {
        Intrinsics.checkNotNullParameter(allRepositories, (String)"allRepositories");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        boolean showServer = this.needToShowRepositoryServer(allRepositories);
        boolean showOwner = showServer || alwaysShowOwner ? true : this.needToShowRepositoryOwner(allRepositories);
        StringBuilder builder = new StringBuilder();
        if (showServer) {
            builder.append(repository.getServerPath().toUrl(false)).append("/");
        }
        if (showOwner) {
            builder.append(repository.getRepositoryPath().getOwner()).append("/");
        }
        builder.append(repository.getRepositoryPath().getRepository());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getRepositoryDisplayName$default(GHUIUtil gHUIUtil, Collection collection, GHRepositoryCoordinates gHRepositoryCoordinates, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return gHUIUtil.getRepositoryDisplayName(collection, gHRepositoryCoordinates, bl);
    }

    private final boolean needToShowRepositoryOwner(Collection<GHRepositoryCoordinates> repos) {
        boolean bl;
        block4: {
            if (repos.size() <= 1) {
                return false;
            }
            String firstOwner = ((GHRepositoryCoordinates)CollectionsKt.first((Iterable)repos)).getRepositoryPath().getOwner();
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHRepositoryCoordinates it = (GHRepositoryCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getRepositoryPath().getOwner(), (Object)firstOwner))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean needToShowRepositoryServer(Collection<GHRepositoryCoordinates> repos) {
        boolean bl;
        block4: {
            if (repos.size() <= 1) {
                return false;
            }
            GithubServerPath firstServer = ((GHRepositoryCoordinates)CollectionsKt.first((Iterable)repos)).getServerPath();
            Iterable $this$any$iv = repos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHRepositoryCoordinates it = (GHRepositoryCoordinates)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getServerPath(), (Object)firstServer))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00042\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fJ$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\u00042\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/ui/util/GHUIUtil$SelectionPresenters;", "", "()V", "Labels", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "Lcom/intellij/collaboration/ui/util/popup/PopupItemPresentation$Simple;", "PRReviewers", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "Users", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "intellij.vcs.github"})
    public static final class SelectionPresenters {
        @NotNull
        public static final SelectionPresenters INSTANCE = new SelectionPresenters();

        private SelectionPresenters() {
        }

        @NotNull
        public final Function1<GHPullRequestRequestedReviewer, PopupItemPresentation.Simple> PRReviewers(@NotNull IconsProvider<String> avatarIconsProvider) {
            Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
            return (Function1)new Function1<GHPullRequestRequestedReviewer, PopupItemPresentation.Simple>(avatarIconsProvider){
                final /* synthetic */ IconsProvider<String> $avatarIconsProvider;
                {
                    this.$avatarIconsProvider = $avatarIconsProvider;
                    super(1);
                }

                @NotNull
                public final PopupItemPresentation.Simple invoke(@NotNull GHPullRequestRequestedReviewer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new PopupItemPresentation.Simple(it.getShortName(), this.$avatarIconsProvider.getIcon((Object)it.getAvatarUrl(), 20), null);
                }
            };
        }

        @NotNull
        public final Function1<GHUser, PopupItemPresentation.Simple> Users(@NotNull IconsProvider<String> avatarIconsProvider) {
            Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
            return (Function1)new Function1<GHUser, PopupItemPresentation.Simple>(avatarIconsProvider){
                final /* synthetic */ IconsProvider<String> $avatarIconsProvider;
                {
                    this.$avatarIconsProvider = $avatarIconsProvider;
                    super(1);
                }

                @NotNull
                public final PopupItemPresentation.Simple invoke(@NotNull GHUser it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new PopupItemPresentation.Simple(it.getLogin(), this.$avatarIconsProvider.getIcon((Object)it.getAvatarUrl(), 20), null);
                }
            };
        }

        @NotNull
        public final Function1<GHLabel, PopupItemPresentation.Simple> Labels() {
            return Labels.1.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GHPullRequestState.values().length];
            try {
                nArray[GHPullRequestState.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestState.MERGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestState.OPEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

