/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.EditableComponentFactory;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.codereview.comment.CodeReviewCommentUIUtil;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageComponentFactory;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageType;
import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.collaboration.util.ComputedResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.InlineIconButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHCommitShort;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommitShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverterKt;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRDetailsFull;
import org.jetbrains.plugins.github.pullrequest.ui.emoji.GHReactionsComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.emoji.GHReactionsPickerComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemUIUtil;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineCommentViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.item.GHPRTimelineReviewViewModel;
import org.jetbrains.plugins.github.ui.util.GHHtmlPaneUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0019\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0003H\u0096\u0002J\u0014\u0010\u0016\u001a\u00020\u0004*\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\u0016\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001f\u0010\"\u001a\u00020#*\u00020\u00022\u0011\u0010$\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b&0%H\u0002R\u0018\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineItem;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "timelineVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModel;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineViewModel;)V", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "eventComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "htmlImageLoader", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "prAuthor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "createComponent", "commits", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestCommitShort;", "createReviewStatus", "review", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineReviewViewModel;", "invoke", "cs", "item", "comment", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/item/GHPRTimelineCommentViewModel;", "createHtmlPane", "Ljavax/swing/JEditorPane;", "text", "Lkotlinx/coroutines/flow/Flow;", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRTimelineItemComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineItemComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,233:1\n1284#2,3:234\n*S KotlinDebug\n*F\n+ 1 GHPRTimelineItemComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory\n*L\n110#1:234,3\n*E\n"})
public final class GHPRTimelineItemComponentFactory
implements Function2<CoroutineScope, GHPRTimelineItem, JComponent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRTimelineViewModel timelineVm;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final AsyncHtmlImageLoader htmlImageLoader;
    @NotNull
    private final GHUser ghostUser;
    @Nullable
    private final GHActor prAuthor;
    @NotNull
    private final GHPRTimelineEventComponentFactoryImpl eventComponentFactory;
    @NotNull
    private static final String COMMIT_HREF_PREFIX = "commit://";

    public GHPRTimelineItemComponentFactory(@NotNull Project project, @NotNull GHPRTimelineViewModel timelineVm2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)timelineVm2, (String)"timelineVm");
        this.project = project;
        this.timelineVm = timelineVm2;
        this.avatarIconsProvider = this.timelineVm.getAvatarIconsProvider();
        this.htmlImageLoader = this.timelineVm.getHtmlImageLoader();
        this.ghostUser = this.timelineVm.getGhostUser();
        Object object2 = ((ComputedResult)this.timelineVm.getDetailsVm().getDetails().getValue()).unbox-impl();
        this.prAuthor = object2 != null && (object2 = (GHPRDetailsFull)(Result.isFailure-impl((Object)(object = object2.unbox-impl())) ? null : object)) != null ? ((GHPRDetailsFull)object2).getAuthor() : null;
        this.eventComponentFactory = new GHPRTimelineEventComponentFactoryImpl(this.timelineVm);
    }

    @NotNull
    public JComponent invoke(@NotNull CoroutineScope cs, @NotNull GHPRTimelineItem item) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        GHPRTimelineItem gHPRTimelineItem = item;
        if (gHPRTimelineItem instanceof GHPRTimelineItem.Review) {
            jComponent = this.createComponent(cs, (GHPRTimelineReviewViewModel)((Object)item));
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Comment) {
            jComponent = this.createComponent(cs, (GHPRTimelineCommentViewModel)((Object)item));
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Commits) {
            jComponent = this.createComponent(this.project, ((GHPRTimelineItem.Commits)item).getCommits());
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Event) {
            JComponent jComponent2;
            try {
                jComponent2 = this.eventComponentFactory.createComponent(((GHPRTimelineItem.Event)item).getEvent());
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{e.getMessage()};
                String string = GithubBundle.message("cannot.display.item", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String body2 = string;
                GHActor gHActor = this.prAuthor;
                if (gHActor == null) {
                    gHActor = this.ghostUser;
                }
                jComponent2 = GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, gHActor, null, HtmlEditorPaneUtilKt.SimpleHtmlPane((String)body2), null, 16, null);
            }
            jComponent = jComponent2;
        } else if (gHPRTimelineItem instanceof GHPRTimelineItem.Unknown) {
            Object[] objectArray = new Object[]{((GHPRTimelineItem.Unknown)item).getTypename()};
            String string = GithubBundle.message("cannot.display.item", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String body3 = string;
            GHActor gHActor = this.prAuthor;
            if (gHActor == null) {
                gHActor = this.ghostUser;
            }
            jComponent = GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, gHActor, null, HtmlEditorPaneUtilKt.SimpleHtmlPane((String)body3), null, 16, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createComponent(Project project, List<GHPullRequestCommitShort> commits2) {
        GHActor gHActor;
        String string;
        Object object;
        void $this$fold$iv;
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)commits2), (Function1)createComponent.commitsPanels.1.INSTANCE), (Function1)((Function1)new Function1<GHCommitShort, String>(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull GHCommitShort it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                HtmlChunk[] htmlChunkArray = new HtmlChunk[]{HtmlChunk.link((String)("commit://" + it.getOid()), (String)it.getAbbreviatedOid()), HtmlChunk.nbsp(), HtmlChunk.raw((String)GHMarkdownToHtmlConverterKt.convertToHtml(it.getMessageHeadline(), this.$project))};
                HtmlBuilder builder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.p().children(htmlChunkArray));
                GHGitActor author = it.getAuthor();
                if (author != null) {
                    HtmlBuilder htmlBuilder;
                    GHUser gHUser = author.getUser();
                    if (gHUser == null) {
                        gHUser = GHPRTimelineItemComponentFactory.access$getGhostUser$p(this.this$0);
                    }
                    GHUser actor = gHUser;
                    Date date = author.getDate();
                    HtmlChunk.Element element = HtmlChunk.p();
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"p(...)");
                    HtmlChunk.Element $this$buildChildren$iv = element;
                    boolean $i$f$buildChildren = false;
                    HtmlBuilder $this$invoke_u24lambda_u240 = htmlBuilder = new HtmlBuilder();
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.append((HtmlChunk)HtmlChunk.link((String)actor.getUrl(), (String)actor.getPresentableName()));
                    if (date != null) {
                        $this$invoke_u24lambda_u240.append(HtmlChunk.nbsp());
                        $this$invoke_u24lambda_u240.append(DateFormatUtil.formatPrettyDateTime((Date)date));
                    }
                    HtmlChunk.Element element2 = htmlBuilder.wrapWith($this$buildChildren$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"wrapWith(...)");
                    HtmlChunk.Element chunk = element2;
                    builder.append((HtmlChunk)chunk);
                }
                return builder.toString();
            }
        })), (Function1)((Function1)new Function1<String, JEditorPane>(this){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final JEditorPane invoke(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                JEditorPane jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, (int)13, null);
                GHPRTimelineItemComponentFactory gHPRTimelineItemComponentFactory = this.this$0;
                JEditorPane $this$invoke_u24lambda_u240 = jEditorPane;
                boolean bl = false;
                HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)$this$invoke_u24lambda_u240, (String)text);
                HtmlEditorPaneUtilKt.onHyperlinkActivated((JEditorPane)$this$invoke_u24lambda_u240, (Function1)((Function1)new Function1<HyperlinkEvent, Unit>(gHPRTimelineItemComponentFactory){
                    final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull HyperlinkEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        String href = e.getDescription();
                        Intrinsics.checkNotNull((Object)href);
                        if (StringsKt.startsWith$default((String)href, (String)"commit://", (boolean)false, (int)2, null)) {
                            GHPRTimelineItemComponentFactory.access$getTimelineVm$p(this.this$0).showCommit(StringsKt.removePrefix((String)href, (CharSequence)"commit://"));
                            return;
                        }
                        GHHtmlPaneUtilKt.handleGithubHyperlink(e, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)GHPRTimelineItemComponentFactory.access$getTimelineVm$p(this.this$0)){

                            public final void invoke(long p0) {
                                ((GHPRTimelineViewModel)this.receiver).openPullRequestInfoAndTimeline(p0);
                            }
                        }));
                    }
                }));
                return jEditorPane;
            }
        }));
        JPanel initial$iv = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean $i$f$fold = false;
        JPanel accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void commitPane;
            JPanel jPanel;
            object = (JEditorPane)element$iv;
            JPanel panel2 = accumulator$iv;
            boolean bl = false;
            JPanel $this$createComponent_u24lambda_u241_u24lambda_u240 = jPanel = panel2;
            boolean bl2 = false;
            $this$createComponent_u24lambda_u241_u24lambda_u240.add((Component)commitPane);
            accumulator$iv = jPanel;
        }
        JPanel commitsPanels2 = accumulator$iv;
        int commitsCount = commits2.size();
        JPanel $this$createComponent_u24lambda_u242 = $i$f$fold = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean bl = false;
        if (commitsCount == 1) {
            string = GithubBundle.message("pull.request.timeline.commit.added", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{commitsCount};
            string = GithubBundle.message("pull.request.timeline.commits.added", objectArray);
        }
        object = string;
        Intrinsics.checkNotNull((Object)object);
        Object titleText = object;
        $this$createComponent_u24lambda_u242.add(HtmlEditorPaneUtilKt.SimpleHtmlPane((String)titleText));
        $this$createComponent_u24lambda_u242.add(StatusMessageComponentFactory.create$default((StatusMessageComponentFactory)StatusMessageComponentFactory.INSTANCE, (JComponent)commitsPanels2, null, (int)2, null));
        JPanel contentPanel = $i$f$fold;
        Object object2 = (GHPullRequestCommitShort)CollectionsKt.singleOrNull(commits2);
        if (object2 != null && (object2 = ((GHPullRequestCommitShort)object2).getCommit()) != null && (object2 = ((GHCommitShort)object2).getAuthor()) != null && (object2 = ((GHGitActor)object2).getUser()) != null) {
            gHActor = (GHActor)object2;
        } else {
            gHActor = this.prAuthor;
            if (gHActor == null) {
                gHActor = this.ghostUser;
            }
        }
        GHActor actor = gHActor;
        Object object3 = (GHPullRequestCommitShort)CollectionsKt.singleOrNull(commits2);
        return GHPRTimelineItemUIUtil.createTimelineItem$default(GHPRTimelineItemUIUtil.INSTANCE, this.avatarIconsProvider, actor, object3 != null && (object3 = ((GHPullRequestCommitShort)object3).getCommit()) != null && (object3 = ((GHCommitShort)object3).getAuthor()) != null ? ((GHGitActor)object3).getDate() : null, contentPanel, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createComponent(CoroutineScope $this$createComponent, GHPRTimelineCommentViewModel comment2) {
        JPanel jPanel;
        JPanel jPanel2;
        CoroutineScope cs = $this$createComponent;
        JEditorPane textPane2 = this.createHtmlPane($this$createComponent, (Flow<String>)((Flow)comment2.getBodyHtml()));
        JComponent content2 = EditableComponentFactory.INSTANCE.create(cs, (JComponent)textPane2, (Flow)comment2.getEditVm(), (Function2)createComponent.content.1.INSTANCE);
        JPanel $this$createComponent_u24lambda_u243 = jPanel2 = CollaborationToolsUIUtilKt.VerticalListPanel((int)4);
        boolean bl = false;
        $this$createComponent_u24lambda_u243.add(content2);
        $this$createComponent_u24lambda_u243.add(GHReactionsComponentFactory.INSTANCE.create(cs, comment2.getReactionsVm()));
        JPanel mainPanel2 = jPanel2;
        JPanel $this$createComponent_u24lambda_u245 = jPanel = CollaborationToolsUIUtilKt.HorizontalListPanel((int)8);
        boolean bl2 = false;
        if (comment2.getCanEdit()) {
            void $this$createComponent_u24lambda_u245_u24lambda_u244;
            InlineIconButton inlineIconButton;
            InlineIconButton inlineIconButton2 = inlineIconButton = CodeReviewCommentUIUtil.INSTANCE.createEditButton((Function1)new Function1<ActionEvent, Unit>(comment2){
                final /* synthetic */ GHPRTimelineCommentViewModel $comment;
                {
                    this.$comment = $comment;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$comment.editBody();
                }
            });
            JPanel jPanel3 = $this$createComponent_u24lambda_u245;
            boolean bl3 = false;
            SwingBindingsKt.bindDisabledIn((JComponent)((JComponent)$this$createComponent_u24lambda_u245_u24lambda_u244), (CoroutineScope)cs, (Flow)((Flow)comment2.isBusy()));
            jPanel3.add((Component)inlineIconButton);
        }
        if (comment2.getCanDelete()) {
            $this$createComponent_u24lambda_u245.add(CodeReviewCommentUIUtil.INSTANCE.createDeleteCommentIconButton((Function1)new Function1<ActionEvent, Unit>(comment2){
                final /* synthetic */ GHPRTimelineCommentViewModel $comment;
                {
                    this.$comment = $comment;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$comment.delete();
                }
            }));
        }
        if (comment2.getCanReact()) {
            $this$createComponent_u24lambda_u245.add((Component)CodeReviewCommentUIUtil.INSTANCE.createAddReactionButton((Function1)new Function1<ActionEvent, Unit>(comment2){
                final /* synthetic */ GHPRTimelineCommentViewModel $comment;
                {
                    this.$comment = $comment;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object object = it.getSource();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                    JComponent parentComponent = (JComponent)object;
                    GHReactionsPickerComponentFactory.INSTANCE.showPopup(this.$comment.getReactionsVm(), parentComponent);
                }
            }));
        }
        JPanel actionsPanel2 = jPanel;
        return GHPRTimelineItemUIUtil.INSTANCE.createTimelineItem(this.avatarIconsProvider, comment2.getAuthor(), comment2.getCreatedAt(), mainPanel2, actionsPanel2);
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createComponent(CoroutineScope $this$createComponent, GHPRTimelineReviewViewModel review) {
        JPanel jPanel;
        void $this$createComponent_u24lambda_u248_u24lambda_u247;
        InlineIconButton inlineIconButton;
        JPanel jPanel2;
        CoroutineScope cs = $this$createComponent;
        JEditorPane textPane2 = this.createHtmlPane($this$createComponent, (Flow<String>)((Flow)review.getBodyHtml()));
        JComponent content2 = EditableComponentFactory.wrapTextComponent$default((EditableComponentFactory)EditableComponentFactory.INSTANCE, (CoroutineScope)cs, (JComponent)textPane2, (Flow)((Flow)review.getEditVm()), null, (int)8, null);
        JPanel $this$createComponent_u24lambda_u246 = jPanel2 = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
        boolean bl = false;
        $this$createComponent_u24lambda_u246.add(content2);
        $this$createComponent_u24lambda_u246.add(this.createReviewStatus(review));
        JPanel contentPanel = jPanel2;
        JPanel $this$createComponent_u24lambda_u248 = $this$createComponent_u24lambda_u246 = CollaborationToolsUIUtilKt.HorizontalListPanel((int)8);
        boolean bl2 = false;
        InlineIconButton inlineIconButton2 = inlineIconButton = CodeReviewCommentUIUtil.INSTANCE.createEditButton((Function1)new Function1<ActionEvent, Unit>(review){
            final /* synthetic */ GHPRTimelineReviewViewModel $review;
            {
                this.$review = $review;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$review.editBody();
            }
        });
        JPanel jPanel3 = $this$createComponent_u24lambda_u248;
        boolean bl3 = false;
        SwingBindingsKt.bindVisibilityIn((JComponent)((JComponent)$this$createComponent_u24lambda_u248_u24lambda_u247), (CoroutineScope)cs, (Flow)((Flow)review.getCanEdit()));
        SwingBindingsKt.bindDisabledIn((JComponent)((JComponent)$this$createComponent_u24lambda_u248_u24lambda_u247), (CoroutineScope)cs, (Flow)((Flow)review.isBusy()));
        jPanel3.add((Component)inlineIconButton);
        JPanel actionsPanel2 = $this$createComponent_u24lambda_u246;
        JComponent reviewItem = GHPRTimelineItemUIUtil.INSTANCE.createTimelineItem(this.avatarIconsProvider, review.getAuthor(), review.getCreatedAt(), contentPanel, actionsPanel2);
        JPanel $this$createComponent_u24lambda_u249 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel((int)0);
        boolean bl4 = false;
        $this$createComponent_u24lambda_u249.add(reviewItem);
        SwingBindingsKt.bindChildIn$default((JPanel)$this$createComponent_u24lambda_u249, (CoroutineScope)cs, (Flow)((Flow)review.getThreads()), null, (Integer)0, (Function2)createComponent.1.1.INSTANCE, (int)4, null);
        return jPanel;
    }

    private final JEditorPane createHtmlPane(CoroutineScope $this$createHtmlPane, Flow<String> text) {
        Object object = this.htmlImageLoader;
        Object $this$createHtmlPane_u24lambda_u2410 = object = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, (AsyncHtmlImageLoader)object, null, (int)9, null);
        boolean bl = false;
        GHHtmlPaneUtilKt.addGithubHyperlinkListener((JEditorPane)$this$createHtmlPane_u24lambda_u2410, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)this.timelineVm){

            public final void invoke(long p0) {
                ((GHPRTimelineViewModel)this.receiver).openPullRequestInfoAndTimeline(p0);
            }
        }));
        SwingBindingsKt.bindTextIn((JEditorPane)$this$createHtmlPane_u24lambda_u2410, (CoroutineScope)$this$createHtmlPane, text);
        return object;
    }

    private final JComponent createReviewStatus(GHPRTimelineReviewViewModel review) {
        String string = switch (WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1 -> GithubBundle.message("pull.request.timeline.approved.changes", new Object[0]);
            case 2 -> GithubBundle.message("pull.request.timeline.requested.changes", new Object[0]);
            case 3 -> GithubBundle.message("pull.request.timeline.started.review", new Object[0]);
            case 4, 5 -> GithubBundle.message("pull.request.timeline.reviewed", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)string);
        String stateText = string;
        StatusMessageType stateType = switch (WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1 -> StatusMessageType.SUCCESS;
            case 2 -> StatusMessageType.ERROR;
            case 3 -> StatusMessageType.SECONDARY_INFO;
            case 4, 5 -> StatusMessageType.INFO;
            default -> throw new NoWhenBranchMatchedException();
        };
        return StatusMessageComponentFactory.INSTANCE.create((JComponent)HtmlEditorPaneUtilKt.SimpleHtmlPane((String)stateText), stateType);
    }

    public static final /* synthetic */ GHUser access$getGhostUser$p(GHPRTimelineItemComponentFactory $this) {
        return $this.ghostUser;
    }

    public static final /* synthetic */ GHPRTimelineViewModel access$getTimelineVm$p(GHPRTimelineItemComponentFactory $this) {
        return $this.timelineVm;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Companion;", "", "()V", "COMMIT_HREF_PREFIX", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GHPullRequestReviewState.values().length];
            try {
                nArray[GHPullRequestReviewState.APPROVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.CHANGES_REQUESTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.PENDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.COMMENTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GHPullRequestReviewState.DISMISSED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

