/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.util;

import com.intellij.collaboration.api.data.GraphQLRequestPagination;
import com.intellij.collaboration.api.dto.GraphQLCursorPageInfoDTO;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001#B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/github/api/util/GHGQLPagesLoader;", "T", "R", "", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "requestProducer", "Lkotlin/Function1;", "Lcom/intellij/collaboration/api/data/GraphQLRequestPagination;", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "supportsTimestampUpdates", "", "pageSize", "", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lkotlin/jvm/functions/Function1;ZI)V", "hasNext", "getHasNext", "()Z", "iterationDataRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/plugins/github/api/util/GHGQLPagesLoader$IterationData;", "kotlin.jvm.PlatformType", "extractPageInfo", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "result", "(Ljava/lang/Object;)Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "extractResult", "(Ljava/lang/Object;)Ljava/lang/Object;", "loadNext", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "update", "(Lcom/intellij/openapi/progress/ProgressIndicator;Z)Ljava/lang/Object;", "reset", "", "IterationData", "intellij.vcs.github"})
public abstract class GHGQLPagesLoader<T, R> {
    @NotNull
    private final GithubApiRequestExecutor executor;
    @NotNull
    private final Function1<GraphQLRequestPagination, GithubApiRequest.Post<T>> requestProducer;
    private final boolean supportsTimestampUpdates;
    private final int pageSize;
    @NotNull
    private final AtomicReference<IterationData> iterationDataRef;

    public GHGQLPagesLoader(@NotNull GithubApiRequestExecutor executor, @NotNull Function1<? super GraphQLRequestPagination, ? extends GithubApiRequest.Post<? extends T>> requestProducer, boolean supportsTimestampUpdates, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(requestProducer, (String)"requestProducer");
        this.executor = executor;
        this.requestProducer = requestProducer;
        this.supportsTimestampUpdates = supportsTimestampUpdates;
        this.pageSize = pageSize;
        this.iterationDataRef = new AtomicReference<IterationData>(new IterationData(true, null, null, 6, null));
    }

    public /* synthetic */ GHGQLPagesLoader(GithubApiRequestExecutor githubApiRequestExecutor, Function1 function1, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        this(githubApiRequestExecutor, function1, bl, n);
    }

    public final boolean getHasNext() {
        return this.iterationDataRef.get().getHasNext();
    }

    @Nullable
    public final synchronized R loadNext(@NotNull ProgressIndicator progressIndicator, boolean update) {
        GraphQLRequestPagination graphQLRequestPagination;
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        IterationData iterationData = this.iterationDataRef.get();
        if (update) {
            if (this.getHasNext() || !this.supportsTimestampUpdates) {
                return null;
            }
            graphQLRequestPagination = new GraphQLRequestPagination(iterationData.getTimestamp(), this.pageSize);
        } else {
            if (!this.getHasNext()) {
                return null;
            }
            graphQLRequestPagination = new GraphQLRequestPagination(iterationData.getCursor(), this.pageSize);
        }
        GraphQLRequestPagination pagination = graphQLRequestPagination;
        Date executionDate = new Date();
        Object response = this.executor.execute(progressIndicator, (GithubApiRequest)this.requestProducer.invoke((Object)pagination));
        GraphQLCursorPageInfoDTO page = this.extractPageInfo(response);
        IterationData nextIteration = page != null ? new IterationData(page, executionDate) : new IterationData(false, null, null);
        this.iterationDataRef.compareAndSet(iterationData, nextIteration);
        return this.extractResult(response);
    }

    public static /* synthetic */ Object loadNext$default(GHGQLPagesLoader gHGQLPagesLoader, ProgressIndicator progressIndicator, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadNext");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return gHGQLPagesLoader.loadNext(progressIndicator, bl);
    }

    public final void reset() {
        this.iterationDataRef.set(new IterationData(true, null, null, 6, null));
    }

    @Nullable
    protected abstract GraphQLCursorPageInfoDTO extractPageInfo(T var1);

    protected abstract R extractResult(T var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/util/GHGQLPagesLoader$IterationData;", "", "page", "Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;", "timestamp", "Ljava/util/Date;", "(Lcom/intellij/collaboration/api/dto/GraphQLCursorPageInfoDTO;Ljava/util/Date;)V", "hasNext", "", "cursor", "", "(ZLjava/util/Date;Ljava/lang/String;)V", "getCursor", "()Ljava/lang/String;", "getHasNext", "()Z", "getTimestamp", "()Ljava/util/Date;", "intellij.vcs.github"})
    private static final class IterationData {
        private final boolean hasNext;
        @Nullable
        private final Date timestamp;
        @Nullable
        private final String cursor;

        public IterationData(boolean hasNext, @Nullable Date timestamp, @Nullable String cursor) {
            this.hasNext = hasNext;
            this.timestamp = timestamp;
            this.cursor = cursor;
        }

        public /* synthetic */ IterationData(boolean bl, Date date, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                date = null;
            }
            if ((n & 4) != 0) {
                string = null;
            }
            this(bl, date, string);
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        @Nullable
        public final Date getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public final String getCursor() {
            return this.cursor;
        }

        public IterationData(@NotNull GraphQLCursorPageInfoDTO page, @NotNull Date timestamp) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            this(page.getHasNextPage(), timestamp, page.getEndCursor());
        }
    }
}

