/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features.correctness;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\"*\u0010\u0000\u001a\u001e\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"brackets", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "findTargetElements", "", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "currentChangedRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.ml.inline.completion.java"})
public final class JavaSuggestionEnricherKt {
    @NotNull
    private static final Map<IElementType, IElementType> brackets;

    @NotNull
    public static final List<PsiElement> findTargetElements(@NotNull PsiFile psiFile, @NotNull TextRange currentChangedRange) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)currentChangedRange, (String)"currentChangedRange");
        PsiElement psiElement2 = psiFile.findElementAt(currentChangedRange.getStartOffset());
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement startBoundaryElement = psiElement2;
        if (startBoundaryElement instanceof PsiWhiteSpace) {
            PsiElement psiElement3 = PsiTreeUtil.nextCodeLeaf((PsiElement)startBoundaryElement);
            if (psiElement3 == null) {
                return CollectionsKt.emptyList();
            }
            startBoundaryElement = psiElement3;
            PsiElement psiElement4 = PsiTreeUtil.getDeepestFirst((PsiElement)startBoundaryElement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getDeepestFirst(...)");
            startBoundaryElement = psiElement4;
        }
        if (currentChangedRange.getEndOffset() - 1 <= 0) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement5 = psiFile.findElementAt(currentChangedRange.getEndOffset() - 1);
        if (psiElement5 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement endBoundaryElement = psiElement5;
        if (endBoundaryElement instanceof PsiWhiteSpace) {
            PsiElement psiElement6 = PsiTreeUtil.prevCodeLeaf((PsiElement)endBoundaryElement);
            if (psiElement6 == null) {
                return CollectionsKt.emptyList();
            }
            endBoundaryElement = psiElement6;
            PsiElement psiElement7 = PsiTreeUtil.getDeepestLast((PsiElement)endBoundaryElement);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement7, (String)"getDeepestLast(...)");
            endBoundaryElement = psiElement7;
        }
        if (Intrinsics.areEqual((Object)startBoundaryElement, (Object)endBoundaryElement) ? (psiElement = startBoundaryElement.getParent()) == null : (psiElement = PsiTreeUtil.findCommonParent((PsiElement)startBoundaryElement, (PsiElement)endBoundaryElement)) == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement commonParent = psiElement;
        Object[] statements = null;
        if (commonParent instanceof PsiCodeBlock) {
            statements = ((PsiCodeBlock)commonParent).getStatements();
        } else if (commonParent instanceof PsiBlockStatement) {
            statements = ((PsiBlockStatement)commonParent).getCodeBlock().getStatements();
        }
        if (statements != null) {
            if (statements.length == 0) {
                return CollectionsKt.listOf((Object)commonParent);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)statements[0]), (PsiElement)startBoundaryElement, (boolean)false) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ArraysKt.last((Object[])statements)), (PsiElement)endBoundaryElement, (boolean)false)) {
                return CollectionsKt.listOf((Object)commonParent);
            }
        }
        PsiStatement startStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)startBoundaryElement, PsiStatement.class, (boolean)false);
        PsiStatement endStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)endBoundaryElement, PsiStatement.class, (boolean)false);
        if (startStatement != null && endStatement != null && Intrinsics.areEqual((Object)startStatement.getParent(), (Object)commonParent)) {
            List result = new ArrayList();
            PsiElement currentElement = (PsiElement)startStatement;
            while (true) {
                result.add(currentElement);
                if (PsiTreeUtil.isAncestor((PsiElement)currentElement, (PsiElement)((PsiElement)endStatement), (boolean)false) || currentElement.getNextSibling() == null) break;
            }
            return result;
        }
        Class[] classArray = new Class[]{PsiVariable.class, PsiStatement.class, PsiCodeBlock.class, PsiMember.class};
        PsiElement psiElement8 = PsiTreeUtil.getParentOfType((PsiElement)commonParent, (boolean)false, (Class[])classArray);
        if (psiElement8 == null) {
            psiElement8 = commonParent;
        }
        return CollectionsKt.listOf((Object)psiElement8);
    }

    public static final /* synthetic */ Map access$getBrackets$p() {
        return brackets;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JavaTokenType.RPARENTH, (Object)JavaTokenType.LPARENTH), TuplesKt.to((Object)JavaTokenType.RBRACE, (Object)JavaTokenType.LBRACE), TuplesKt.to((Object)JavaTokenType.RBRACKET, (Object)JavaTokenType.LBRACKET)};
        brackets = MapsKt.mutableMapOf((Pair[])pairArray);
    }
}

