/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.navigation;

import com.intellij.codeWithMe.ClientId;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.psi.ImplicitReferenceProvider;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.navigation.CurrentActionHolder;
import com.intellij.platform.lsp.impl.navigation.LspServerAndLocationLinks;
import com.intellij.platform.lsp.impl.navigation.LspSymbolReference;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/lsp/impl/navigation/LspImplicitReferenceProvider;", "Lcom/intellij/model/psi/ImplicitReferenceProvider;", "()V", "getImplicitReference", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/psi/PsiElement;", "offsetInElement", "", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspImplicitReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspImplicitReferenceProvider.kt\ncom/intellij/platform/lsp/impl/navigation/LspImplicitReferenceProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n40#2,3:191\n1603#3,9:194\n1855#3:203\n1856#3:205\n1612#3:206\n1360#3:207\n1446#3,5:208\n1747#3,3:213\n1#4:204\n*S KotlinDebug\n*F\n+ 1 LspImplicitReferenceProvider.kt\ncom/intellij/platform/lsp/impl/navigation/LspImplicitReferenceProvider\n*L\n48#1:191,3\n65#1:194,9\n65#1:203\n65#1:205\n65#1:206\n75#1:207\n75#1:208,5\n75#1:213,3\n65#1:204\n*E\n"})
public final class LspImplicitReferenceProvider
implements ImplicitReferenceProvider {
    @Nullable
    public PsiSymbolReference getImplicitReference(@NotNull PsiElement element, int offsetInElement) {
        boolean bl2;
        Object object42;
        Iterable iterable;
        Object object2;
        Iterator iterator;
        Object object3;
        Document document;
        PsiFile psiFile;
        block23: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiFile psiFile2 = element instanceof PsiFile ? (PsiFile)element : null;
            if (psiFile2 == null) {
                return null;
            }
            psiFile = psiFile2;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 instanceof VirtualFileWindow) {
                return null;
            }
            boolean bl3 = false;
            document = CurrentActionHolder.class;
            object3 = ApplicationManager.getApplication().getService(document);
            if (object3 == null) {
                throw new RuntimeException("Cannot find service " + document.getName() + " (classloader=" + document.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            if (!((CurrentActionHolder)object3).getRunningGoToDeclarationAction()) {
                return null;
            }
            Project project = ((PsiFile)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Collection<LspServerImpl> collection = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2);
            if (collection.isEmpty()) {
                return null;
            }
            Document document2 = FileDocumentManager.getInstance().getCachedDocument(virtualFile2);
            if (document2 == null) {
                return null;
            }
            document = document2;
            Iterable iterable2 = collection;
            boolean bl4 = false;
            Iterable iterable3 = iterable2;
            iterator = new ArrayList();
            boolean bl5 = false;
            Iterable iterable4 = iterable3;
            boolean bl6 = false;
            for (Object object2 : iterable4) {
                LspServerAndLocationLinks lspServerAndLocationLinks;
                List<LocationLink> list;
                Object t2 = object2;
                boolean bl7 = false;
                LspServerImpl lspServerImpl = (LspServerImpl)t2;
                boolean bl8 = false;
                if ((!lspServerImpl.supportsGotoDefinition$intellij_platform_lsp_impl() ? null : (!lspServerImpl.getDescriptor().getLspGoToDefinitionSupport() ? null : (!((Collection)(list = lspServerImpl.getRequestExecutor().getElementDefinitions(virtualFile2, offsetInElement))).isEmpty() ? new LspServerAndLocationLinks(lspServerImpl, list) : null))) == null) continue;
                lspServerAndLocationLinks = lspServerAndLocationLinks;
                boolean bl9 = false;
                iterator.add(lspServerAndLocationLinks);
            }
            object3 = (List)((Object)iterator);
            if (object3.isEmpty()) {
                return null;
            }
            iterable = (Iterable)object3;
            boolean bl10 = false;
            iterator = iterable;
            object42 = new ArrayList();
            boolean bl11 = false;
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                object2 = (LspServerAndLocationLinks)e2;
                boolean bl12 = false;
                object2 = ((LspServerAndLocationLinks)object2).getLocationLinks();
                CollectionsKt.addAll((Collection)object42, (Iterable)object2);
            }
            iterable = (List)object42;
            bl10 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl2 = false;
            } else {
                for (Object object42 : iterable) {
                    boolean bl13;
                    Range range;
                    LocationLink locationLink = (LocationLink)object42;
                    boolean bl14 = false;
                    Range range2 = range = locationLink.getOriginSelectionRange();
                    if (range2 == null) {
                        bl13 = false;
                    } else {
                        Intrinsics.checkNotNull((Object)range2);
                        Position position = locationLink.getOriginSelectionRange().getEnd();
                        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getEnd(...)");
                        Integer n2 = Lsp4jUtilKt.getOffsetInDocument(document, position);
                        if (n2 == null) {
                            bl13 = false;
                        } else {
                            int n3 = n2;
                            bl13 = n3 > offsetInElement;
                        }
                    }
                    if (!bl13) continue;
                    bl2 = true;
                    break block23;
                }
                bl2 = false;
            }
        }
        boolean bl15 = bl2;
        iterable = null;
        List list = new ArrayList();
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object42 = (LspServerAndLocationLinks)iterator.next();
            List list2 = new ArrayList();
            for (LocationLink locationLink : ((LspServerAndLocationLinks)object42).getLocationLinks()) {
                TextRange textRange;
                object2 = locationLink.getOriginSelectionRange();
                if (object2 != null) {
                    v9 = Lsp4jUtilKt.getRangeInDocument(document, (Range)object2);
                    if (v9 == null) {
                        continue;
                    }
                } else {
                    v9 = textRange = new TextRange(offsetInElement, offsetInElement);
                }
                if (bl15 && textRange.getEndOffset() <= offsetInElement) continue;
                Iterable iterable2 = iterable;
                iterable = iterable2 == null ? textRange : iterable2.union(textRange);
                list2.add(locationLink);
            }
            if (!(!((Collection)list2).isEmpty())) continue;
            list.add(new LspServerAndLocationLinks(((LspServerAndLocationLinks)object42).getLspServer(), list2));
        }
        if (iterable == null) {
            return null;
        }
        return new LspSymbolReference(psiFile, (TextRange)iterable, list);
    }
}

